/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.business.check;

import java.util.ArrayList;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.check.AbstractSingleCalcCheckAction;
import kd.macc.cad.common.check.CalcCheckContext;
import kd.macc.cad.common.check.CalcCheckDetailResultInfo;
import kd.macc.cad.common.check.CalcCheckHelper;
import kd.macc.cad.common.helper.OrgHelper;

public class AuxProdAllocCostDiffCheckAction
extends AbstractSingleCalcCheckAction {
    protected void doCheck() {
        CalcCheckContext context = this.getContext();
        DataSet mfgDataSet = CalcCheckHelper.getMfgDataSet((String)"B", (CalcCheckContext)context);
        DataSet nonProdDataSet = CalcCheckHelper.getNonProdDataSet((CalcCheckContext)context, (Long)5L);
        DataSet billDataSet = mfgDataSet.union(nonProdDataSet).groupBy(new String[]{"expNumber", "expName"}).sum("amount").finish();
        billDataSet = billDataSet.filter("amount != 0");
        DataSet auxDataSet = this.getAuxProdDataSet(context);
        DataSet auxDs = auxDataSet.leftJoin(billDataSet).on("expNumber", "expNumber").select(auxDataSet.getRowMeta().getFieldNames(), new String[]{"amount"}).finish().filter("auxamount != amount");
        DataSet billDs = billDataSet.leftJoin(auxDataSet).on("expNumber", "expNumber").select(billDataSet.getRowMeta().getFieldNames(), new String[]{"auxamount"}).finish().filter("auxamount != amount");
        billDataSet = billDs.union(auxDs).groupBy(new String[]{"expNumber", "expName"}).finish();
        if (billDataSet.isEmpty()) {
            return;
        }
        String checkDesc = ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u8f85\u52a9\u751f\u4ea7\u5206\u914d\u5355\u6570\u636e\u662f\u5426\u6b63\u786e\u3002", (String)"AuxProdAllocCostDiffCheckAction_0", (String)"macc-cad-business", (Object[])new Object[0]);
        String detailDesc = ResManager.loadKDString((String)"\u8f85\u52a9\u751f\u4ea7\u5206\u914d\u5355\u4e0b\uff0c\u201c%1$s/%2$s\u201d\u8d39\u7528\u5bfc\u5165\u4e0e\u6e90\u5355\u91d1\u989d\u4e0d\u4e00\u81f4\u3002", (String)"AuxProdAllocCostDiffCheckAction_2", (String)"macc-cad-business", (Object[])new Object[0]);
        for (Row next : billDataSet) {
            CalcCheckDetailResultInfo info = new CalcCheckDetailResultInfo();
            info.setCheckDetailResult(String.format(detailDesc, next.getString("expNumber"), next.getString("expName")));
            this.getSingleCheckContext().getCheckDetailResult().add(info);
        }
        this.getSingleCheckContext().setPass(false);
        this.getSingleCheckContext().setCheckResult(checkDesc);
    }

    private DataSet getAuxProdDataSet(CalcCheckContext context) {
        QFilter filter = new QFilter("org", "=", (Object)context.getOrgId());
        filter.and("costaccount", "=", (Object)context.getCostAccountId());
        filter.and("period", "=", (Object)context.getPeriodId());
        filter.and("appnum", "=", (Object)context.getAppNum());
        QFilter noPubFilter = new QFilter("publicaux", "=", (Object)false);
        QFilter pubFilter = new QFilter("publicaux", "=", (Object)true);
        pubFilter.and("allocstatus", "=", (Object)"2");
        if (!context.getManuOrgIds().isEmpty()) {
            Set centerIds = OrgHelper.getCenterIdsByManuOrgIds((Long)context.getOrgId(), new ArrayList(context.getManuOrgIds()), (String)context.getAppNum());
            filter.and("costcenter", "in", (Object)centerIds);
        }
        DataSet nonPubDataSet = QueryServiceHelper.queryDataSet((String)"AuxProdAllocCostDiffCheckAction_getAuxProdDataSet", (String)"cad_auxprodalloc", (String)"parallelentity.parexpenseitem.number as expNumber,parallelentity.parexpenseitem.name as expName,parallelentity.parallocamount as auxamount", (QFilter[])new QFilter[]{filter, noPubFilter}, null);
        filter.and("parallelentity.parallelsubentity.parsubcostcenter.orgduty.number", "!=", (Object)"5");
        DataSet pubDataSet = QueryServiceHelper.queryDataSet((String)"AuxProdAllocCostDiffCheckAction_getAuxProdDataSet_2", (String)"cad_auxprodalloc", (String)"parallelentity.parallelsubentity.parsubexpenseitem.number as expNumber,parallelentity.parallelsubentity.parsubexpenseitem.name as expName,parallelentity.parallelsubentity.parsubamt as auxamount", (QFilter[])new QFilter[]{filter, pubFilter}, null);
        return nonPubDataSet.union(pubDataSet).groupBy(new String[]{"expNumber", "expName"}).sum("auxamount").finish();
    }
}

