/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.business.check;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.business.check.PlannedOutPutContentDiffCheckAction;
import kd.macc.cad.business.numcheck.CollNumCheckHelper;
import kd.macc.cad.common.check.AbstractSingleCalcCheckAction;
import kd.macc.cad.common.check.CalcCheckContext;
import kd.macc.cad.common.constants.LogarithmParam;
import kd.macc.cad.common.helper.CostCenterHelper;
import kd.macc.cad.common.helper.InFilterHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.DateUtils;
import net.sf.json.JSONArray;

public abstract class BaseContentDiffCheckAction
extends AbstractSingleCalcCheckAction {
    protected static final Log logger = LogFactory.getLog(PlannedOutPutContentDiffCheckAction.class);

    protected void doCheck() {
        CalcCheckContext context = this.getContext();
        Long org = context.getOrgId();
        boolean orgEnableMultiFactory = OrgHelper.isOrgEnableMultiFactory((Long)org);
        boolean showBizOrg = false;
        ArrayList permProOrgsByAccOrg = new ArrayList(10);
        if (orgEnableMultiFactory && "sca".equals(context.getAppNum())) {
            permProOrgsByAccOrg.addAll(context.getManuOrgIds());
            showBizOrg = true;
        }
        LogarithmParam logarithmParam = new LogarithmParam();
        logarithmParam.setOrgId(org);
        logarithmParam.setAppnum(context.getAppNum());
        logarithmParam.setStartDate(context.getPeriodStartDate());
        logarithmParam.setEndDate(this.getPeriodEndDate(context.getPeriodEndDate()));
        logarithmParam.setBizorgIds(permProOrgsByAccOrg);
        logarithmParam.setShowBizOrg(showBizOrg);
        List costCenterIds = null;
        if (this.getContext().getParams().containsKey("checkCostcenterIds")) {
            costCenterIds = (List)this.getContext().getParams().get("checkCostcenterIds");
        } else {
            costCenterIds = CostCenterHelper.getCostCenterByOrg((Long)logarithmParam.getOrgId(), (Long[])new Long[]{4L});
            this.getContext().getParams().put("checkCostcenterIds", costCenterIds);
        }
        if (costCenterIds != null) {
            logarithmParam.setCostCenterIds(costCenterIds);
        }
        if (context.getCheckParamJs().get("costobjects") != null) {
            Set<Long> entryIds = null;
            String cachekey = "proMainbillIds";
            boolean isGetJoinSide = false;
            String checkType = this.getCheckBills()[0];
            if ("C".equals(checkType) || "B".equals(checkType)) {
                cachekey = "probillIds";
                isGetJoinSide = true;
            }
            if (this.getContext().getParams().containsKey(cachekey)) {
                entryIds = (Set<Long>)this.getContext().getParams().get(cachekey);
            } else {
                entryIds = this.getProbillIdsFromCostObject(context.getCheckParamJs().getJSONArray("costobjects"), org, isGetJoinSide);
                this.getContext().getParams().put(cachekey, entryIds);
            }
            logger.info("\u5de5\u5355\u6210\u672c\u5bf9\u8c61\u6570\u91cf:{}", (Object)(entryIds == null ? 0 : entryIds.size()));
            if (entryIds != null) {
                logarithmParam.getEntryIds().addAll(entryIds);
                if ("aca".equals(context.getAppNum()) || "sca".equals(context.getAppNum()) && "sca_wipcalwizards".equals(context.getTaskType())) {
                    logarithmParam.setEntryIdSearchType("1");
                }
                if (logarithmParam.getEntryIds().size() > 300000) {
                    logarithmParam.getEntryIds().clear();
                }
            }
        }
        this.setParam(logarithmParam);
        DataSet resultDs = CollNumCheckHelper.queryTotalNumDataSet(logarithmParam, this.getCheckBills());
        if (resultDs.isEmpty()) {
            return;
        }
        StringBuilder sb = this.checkResultDs(resultDs);
        if (sb.length() > 0) {
            logger.info("\u5bf9\u6570\u5b58\u5728\u5f02\u5e38\uff1a{}", (Object)sb.toString());
            String detailDesc = ResManager.loadKDString((String)"\u67e5\u770b\u8be6\u60c5", (String)"BaseContentDiffCheckAction_0", (String)"macc-cad-business", (Object[])new Object[0]);
            this.getSingleCheckContext().setPass(false);
            this.getSingleCheckContext().setCheckResult(detailDesc);
        }
    }

    private Date getPeriodEndDate(Date periodEnddate) {
        SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat sdf2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String endDateStr = sdf1.format(periodEnddate) + " 24:00:00";
        try {
            return sdf2.parse(endDateStr);
        }
        catch (Exception ex) {
            logger.error("\u8f6c\u6362\u65e5\u671f\u62a5\u9519", (Throwable)ex);
            return periodEnddate;
        }
    }

    protected abstract String[] getCheckBills();

    protected void setParam(LogarithmParam logarithmParam) {
    }

    private StringBuilder checkResultDs(DataSet resultDs) {
        StringBuilder sb = new StringBuilder();
        for (Row row : resultDs) {
            Double diffqty = row.getDouble("diffqty");
            Double diffsize = row.getDouble("diffsize");
            Long manuorg = row.getLong("manuorg");
            Date tardate = row.getDate("tarauditdate");
            Date srcdate = row.getDate("srcauditdate");
            String billTypeName = row.getString("billtypename");
            Double tarqty = row.getDouble("tarqty");
            Double tarsize = row.getDouble("tarsize");
            Double srcqty = row.getDouble("srcqty");
            Double srcsize = row.getDouble("srcsize");
            if (tardate != null && srcdate != null && this.dateCompare(srcdate, tardate)) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(String.format("billtypeName:%s,manuorg:%s,srcdate:%s,tardate:%s", billTypeName, manuorg, srcdate, tardate));
            }
            if (diffqty != null && diffqty != 0.0) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(String.format("billtypeName:%s,manuorg:%s,tarqty:%s,srcqty:%s,diffqty:%s", billTypeName, manuorg, tarqty, srcqty, diffqty));
            }
            if (diffsize == null || diffsize == 0.0) continue;
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(String.format("billtypeName:%s,manuorg:%s,tarsize:%s,srcsize:%s,diffsize:%s", billTypeName, manuorg, tarsize, srcsize, diffsize));
        }
        return sb;
    }

    private boolean dateCompare(Date srcDate, Date tarDate) {
        String srcDateStr = DateUtils.formatDate((Date)srcDate, (String)"yyyy-MM-dd HH:mm:ss");
        String tarDateStr = DateUtils.formatDate((Date)tarDate, (String)"yyyy-MM-dd HH:mm:ss");
        srcDate = DateUtils.parseDate((String)srcDateStr);
        return srcDate.after(tarDate = DateUtils.parseDate((String)tarDateStr));
    }

    private Set<Long> getProbillIdsFromCostObject(JSONArray costobjectIds, Long orgId, boolean isGetJoinSide) {
        HashSet<Long> entryIds = new HashSet<Long>(128);
        ArrayList ids = new ArrayList(costobjectIds);
        if (ids.isEmpty()) {
            return entryIds;
        }
        DataSet costObjects = null;
        List groupList = Lists.partition(ids, (int)200000);
        for (Object list : groupList) {
            QFilter idFilter = new QFilter("id", "in", list);
            DataSet ds = QueryServiceHelper.queryDataSet((String)"ColDiffRptBase.queryObj", (String)"cad_costobject", (String)"probill,productgroup,id", (QFilter[])idFilter.toArray(), null);
            if (costObjects == null) {
                costObjects = ds;
                continue;
            }
            costObjects = costObjects.union(ds);
        }
        if (costObjects == null) {
            return entryIds;
        }
        HashSet mainObjects = Sets.newHashSet();
        for (Row costObject : costObjects) {
            Long productgroup;
            Long proBill = costObject.getLong("probill");
            if (!CadEmptyUtils.isEmpty((Long)proBill)) {
                entryIds.add(proBill);
            }
            if (CadEmptyUtils.isEmpty((Long)(productgroup = costObject.getLong("productgroup")))) continue;
            mainObjects.add(costObject.getLong("id"));
        }
        if (!mainObjects.isEmpty() && isGetJoinSide) {
            QFilter filter = new QFilter("org", "=", (Object)orgId);
            filter.and("producttype", "!=", (Object)"C");
            DataSet costobjectDs = InFilterHelper.queryDataSetIn((String)"cad_costobject", (String)"probill", (QFilter)filter, (String)"mainproobj", new ArrayList(mainObjects));
            for (Row costObject : costobjectDs) {
                Long proBill = costObject.getLong("probill");
                if (CadEmptyUtils.isEmpty((Long)proBill)) continue;
                entryIds.add(proBill);
            }
        }
        return entryIds;
    }
}

