/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.business.check;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.cad.business.feealloc.MfgFeeBasicAllocService;
import kd.macc.cad.common.check.AbstractSingleCalcCheckAction;
import kd.macc.cad.common.check.CalcCheckContext;
import kd.macc.cad.common.check.CalcCheckDetailResultInfo;
import kd.macc.cad.common.check.CalcCheckHelper;
import kd.macc.cad.common.dto.MfgFeeAllocImportParam;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.utils.DataSetUtils;

public class BasicProdAllocCostDiffCheckAction
extends AbstractSingleCalcCheckAction {
    protected void doCheck() {
        CalcCheckContext context = this.getContext();
        HashMap mfgBillNosMap = Maps.newHashMapWithExpectedSize((int)10);
        HashMap nonBillNosMap = Maps.newHashMapWithExpectedSize((int)10);
        HashMap basicBillNosMap = Maps.newHashMapWithExpectedSize((int)10);
        HashMap auxBillNosMap = Maps.newHashMapWithExpectedSize((int)10);
        DataSet mfgDataSet = CalcCheckHelper.getMfgDataSet((String)"C", (CalcCheckContext)context, (Map)(this.isSca() ? mfgBillNosMap : null), (boolean)true);
        DataSet nonProdDataSet = CalcCheckHelper.getNonProdDataSet((CalcCheckContext)context, (Long)4L, (Map)(this.isSca() ? nonBillNosMap : null));
        DataSet auxProdDataSet = this.getAuxProdDataSet(context, this.isSca() ? auxBillNosMap : null);
        DataSet nonMfgDataSet = this.getBasicProdDataSet(context, "nonMfg", this.isSca() ? basicBillNosMap : null);
        DataSet basicAuxDataSet = this.getBasicProdDataSet(context, "aux", this.isSca() ? basicBillNosMap : null);
        DataSet basicStdDs = this.getBasicAllocStd(context);
        DataSet billDataSet = nonProdDataSet.union(mfgDataSet).union(auxProdDataSet).groupBy(new String[]{"centerId", "centerNumber", "centerName", "expenseitem", "expNumber", "expName"}).sum("amount").finish();
        billDataSet = billDataSet.join(basicStdDs).on("centerId", "costcenter").on("expenseitem", "expenseitem").select(billDataSet.getRowMeta().getFieldNames(), new String[0]).finish();
        DataSet basicDataSet = nonMfgDataSet.union(basicAuxDataSet);
        billDataSet = billDataSet.addField("0.0", "billamount");
        basicDataSet = basicDataSet.addField("0.0", "amount");
        DataSet resultDs = DataSetUtils.unionIfRowDiff((DataSet)billDataSet, (DataSet)basicDataSet);
        resultDs = resultDs.groupBy(new String[]{"centerId", "centerNumber", "centerName", "expenseitem", "expNumber", "expName"}).sum("amount").sum("billamount").finish();
        resultDs = resultDs.filter("amount != billamount");
        String checkDesc = ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u57fa\u672c\u751f\u4ea7\u5206\u914d\u5355\u6570\u636e\u662f\u5426\u6b63\u786e\u3002", (String)"BasicProdAllocCostDiffCheckAction_0", (String)"macc-cad-business", (Object[])new Object[0]);
        String detailDesc = ResManager.loadKDString((String)"\u57fa\u672c\u751f\u4ea7\u5206\u914d\u5355\u4e0b\uff0c\u201c%1$s/%2$s\u201d\u4e0b\u201c%3$s/%4$s\u201d\u8d39\u7528\u5bfc\u5165\u4e0e\u6e90\u5355\u91d1\u989d\u4e0d\u4e00\u81f4\u3002", (String)"BasicProdAllocCostDiffCheckAction_2", (String)"macc-cad-business", (Object[])new Object[0]);
        if (this.isSca()) {
            detailDesc = ResManager.loadKDString((String)"\u57fa\u672c\u751f\u4ea7\u5206\u914d\u5355\u4e0b\uff0c\u8d39\u7528\u9879\u76ee\u201c%1$s/%2$s\u201d\u5bfc\u5165\u91d1\u989d\u4e0e\u6e90\u5355\u91d1\u989d\u4e0d\u4e00\u81f4\u3002", (String)"BasicProdAllocCostDiffCheckAction_3", (String)"macc-cad-business", (Object[])new Object[0]);
        }
        if (!resultDs.isEmpty()) {
            for (Row next : resultDs) {
                CalcCheckDetailResultInfo info = new CalcCheckDetailResultInfo();
                info.setCostCenter(next.getLong("centerId"));
                if (this.isSca()) {
                    String mapKey = String.format("%s@%s", next.getLong("centerId"), next.getString("expNumber"));
                    StringBuilder desc = new StringBuilder(String.format(detailDesc, next.getString("expNumber"), next.getString("expName")));
                    desc.append(this.getAllocBillNoInfo(this.getCollStr((Collection)basicBillNosMap.get(mapKey)), "4"));
                    desc.append(this.getAllocBillNoInfo(this.getCollStr((Collection)mfgBillNosMap.get(mapKey)), "1"));
                    desc.append(this.getAllocBillNoInfo(this.getCollStr((Collection)nonBillNosMap.get(mapKey)), "2"));
                    desc.append(this.getAllocBillNoInfo(this.getCollStr((Collection)auxBillNosMap.get(mapKey)), "3"));
                    info.setCheckDetailResultNotCut(desc.toString());
                } else {
                    info.setCheckDetailResultNotCut(String.format(detailDesc, next.getString("centerNumber"), next.getString("centerName"), next.getString("expNumber"), next.getString("expName")));
                }
                this.getSingleCheckContext().getCheckDetailResult().add(info);
            }
        }
        if (this.getSingleCheckContext().getCheckDetailResult().isEmpty()) {
            return;
        }
        this.getSingleCheckContext().setPass(false);
        this.getSingleCheckContext().setCheckResult(checkDesc);
    }

    private DataSet getBasicAllocStd(CalcCheckContext context) {
        MfgFeeAllocImportParam importParam = new MfgFeeAllocImportParam();
        importParam.setOrg(context.getOrgId());
        importParam.setCostaccount(context.getCostAccountId());
        importParam.setEnableFactory(!context.getManuOrgIds().isEmpty());
        importParam.setAppnum(context.getAppNum());
        importParam.setPeriod(context.getPeriodId());
        importParam.setManuorg(new ArrayList(context.getManuOrgIds()));
        MfgFeeBasicAllocService allocService = new MfgFeeBasicAllocService();
        return allocService.getBasicAllocStd(importParam).select(new String[]{"costcenter", "expenseitem"}).distinct();
    }

    private String getAllocBillNoInfo(String billnos, String type) {
        if (StringUtils.isEmpty((String)billnos)) {
            return "";
        }
        if ("1".equals(type)) {
            return String.format(ResManager.loadKDString((String)"\u5236\u9020\u8d39\u7528\u5f52\u96c6\u5355\u5355\u53f7\uff1a[%s];", (String)"BasicProdAllocCostDiffCheckAction_4", (String)"macc-cad-business", (Object[])new Object[0]), billnos);
        }
        if ("2".equals(type)) {
            return String.format(ResManager.loadKDString((String)"\u975e\u751f\u4ea7\u5206\u914d\u5355\u5355\u53f7\uff1a[%s];", (String)"BasicProdAllocCostDiffCheckAction_5", (String)"macc-cad-business", (Object[])new Object[0]), billnos);
        }
        if ("3".equals(type)) {
            return String.format(ResManager.loadKDString((String)"\u8f85\u52a9\u751f\u4ea7\u5206\u914d\u5355\u5355\u53f7\uff1a[%s];", (String)"BasicProdAllocCostDiffCheckAction_6", (String)"macc-cad-business", (Object[])new Object[0]), billnos);
        }
        if ("4".equals(type)) {
            return String.format(ResManager.loadKDString((String)"\u57fa\u672c\u751f\u4ea7\u5206\u914d\u5355\u5355\u53f7\uff1a[%s];", (String)"BasicProdAllocCostDiffCheckAction_7", (String)"macc-cad-business", (Object[])new Object[0]), billnos);
        }
        return String.format(ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3\u5185\u5206\u914d\u5355\u5355\u53f7\uff1a[%s];", (String)"BasicProdAllocCostDiffCheckAction_8", (String)"macc-cad-business", (Object[])new Object[0]), billnos);
    }

    private DataSet getBasicProdDataSet(CalcCheckContext context, String type, Map<String, List<String>> basicBillNosMap) {
        QFilter filter = new QFilter("org", "=", (Object)context.getOrgId());
        filter.and("costaccount", "=", (Object)context.getCostAccountId());
        filter.and("period", "=", (Object)context.getPeriodId());
        filter.and("appnum", "=", (Object)context.getAppNum());
        if (!context.getManuOrgIds().isEmpty()) {
            Set centerIds = OrgHelper.getCenterIdsByManuOrgIds((Long)context.getOrgId(), new ArrayList(context.getManuOrgIds()), (String)context.getAppNum());
            filter.and("costcenter", "in", (Object)centerIds);
        }
        HashSet<String> types = new HashSet<String>(5);
        if (type.equals("aux")) {
            types.add("D");
            filter.and("sourcetype", "in", types);
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)"BasicProdAllocCostDiffCheckAction_getBasicProdDataSet", (String)"cad_basicalloc", (String)"billno,costcenter.id as centerId,costcenter.number as centerNumber,costcenter.name as centerName,comentity.comexpenseitem expenseitem,comentity.comexpenseitem.number as expNumber,comentity.comexpenseitem.name as expName,comentity.allocamount as billamount", (QFilter[])new QFilter[]{filter}, null);
            if (basicBillNosMap != null) {
                DataSet copyDs = dataSet.copy();
                for (Row row : copyDs) {
                    basicBillNosMap.computeIfAbsent(String.format("%s@%s", row.getLong("centerId"), row.getString("expNumber")), t -> new ArrayList()).add(row.getString("billno"));
                }
            }
            return dataSet.groupBy(new String[]{"centerId", "centerNumber", "centerName", "expenseitem", "expNumber", "expName"}).sum("billamount").finish();
        }
        types.add("B");
        types.add("C");
        filter.and("sourcetype", "in", types);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"BasicProdAllocCostDiffCheckAction_getBasicProdDataSet", (String)"cad_basicalloc", (String)"billno,costcenter.id as centerId,costcenter.number as centerNumber,costcenter.name as centerName,expenseitem,expenseitem.number as expNumber,expenseitem.name as expName,amount as billamount", (QFilter[])new QFilter[]{filter}, null);
        if (basicBillNosMap != null) {
            DataSet copyDs = dataSet.copy();
            for (Row row : copyDs) {
                basicBillNosMap.computeIfAbsent(String.format("%s@%s", row.getLong("centerId"), row.getString("expNumber")), t -> new ArrayList()).add(row.getString("billno"));
            }
        }
        return dataSet.groupBy(new String[]{"centerId", "centerNumber", "centerName", "expenseitem", "expNumber", "expName"}).sum("billamount").finish();
    }

    private DataSet getAuxProdDataSet(CalcCheckContext context, Map<String, List<String>> auxBillNosMap) {
        QFilter filter = new QFilter("org", "=", (Object)context.getOrgId());
        filter.and("costaccount", "=", (Object)context.getCostAccountId());
        filter.and("period", "=", (Object)context.getPeriodId());
        filter.and("appnum", "=", (Object)context.getAppNum());
        filter.and("allocstatus", "=", (Object)"2");
        filter.and("comentity.comsubentity.subcostcenter.orgduty.number", "=", (Object)"4");
        if (!context.getManuOrgIds().isEmpty()) {
            Set centerIds = OrgHelper.getCenterIdsByManuOrgIds((Long)context.getOrgId(), new ArrayList(context.getManuOrgIds()), (String)context.getAppNum());
            filter.and("comentity.comsubentity.subcostcenter", "in", (Object)centerIds);
        }
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"BasicProdAllocCostDiffCheckAction_getAuxProdDataSet", (String)"cad_auxprodalloc", (String)"billno,comentity.comsubentity.subcostcenter.id as centerId,comentity.comsubentity.subcostcenter.number as centerNumber,comentity.comsubentity.subcostcenter.name as centerName,comentity.comsubentity.subexpenseitem expenseitem,comentity.comsubentity.subexpenseitem.number as expNumber,comentity.comsubentity.subexpenseitem.name as expName,case when allocmethod ='mutual' or allocmethod='algebra' then comentity.comsubentity.suboutamt else comentity.comsubentity.subamt end amount", (QFilter[])new QFilter[]{filter}, null);
        if (auxBillNosMap != null) {
            DataSet copyDs = dataSet.copy();
            for (Row row : copyDs) {
                auxBillNosMap.computeIfAbsent(String.format("%s@%s", row.getLong("centerId"), row.getString("expNumber")), t -> new ArrayList()).add(row.getString("billno"));
            }
        }
        dataSet = dataSet.groupBy(new String[]{"centerId", "centerNumber", "centerName", "expenseitem", "expNumber", "expName"}).sum("amount").finish();
        return dataSet;
    }

    private boolean isSca() {
        return "sca".equals(this.getContext().getAppNum());
    }

    private String getCollStr(Collection<String> billNos) {
        if (billNos == null || billNos.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int seq = 0;
        for (String billno : billNos) {
            if (seq > 0) {
                sb.append(",");
            }
            sb.append(billno);
            ++seq;
        }
        return sb.toString();
    }
}

