/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.business.check;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.cad.business.feealloc.MfgFeeBasicAllocService;
import kd.macc.cad.common.check.AbstractSingleCalcCheckAction;
import kd.macc.cad.common.check.CalcCheckContext;
import kd.macc.cad.common.check.CalcCheckDetailResultInfo;
import kd.macc.cad.common.dto.MfgFeeAllocImportParam;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.DataSetUtils;

public class CenterInnerProdAllocCostDiffCheckAction
extends AbstractSingleCalcCheckAction {
    protected void doCheck() {
        CalcCheckContext context = this.getContext();
        HashMap mfgBillNosMap = Maps.newHashMapWithExpectedSize((int)10);
        HashMap nonBillNosMap = Maps.newHashMapWithExpectedSize((int)10);
        HashMap basicBillNosMap = Maps.newHashMapWithExpectedSize((int)10);
        HashMap auxBillNosMap = Maps.newHashMapWithExpectedSize((int)10);
        HashMap innerBillNosMap = Maps.newHashMapWithExpectedSize((int)10);
        DataSet innerProdDataSet = this.getInnerProdDataSet(context, this.isSca() ? innerBillNosMap : null).addField("0.0", "amount");
        DataSet mfgDataSet = CenterInnerProdAllocCostDiffCheckAction.getMfgDataSet("C", context, this.isSca() ? mfgBillNosMap : null);
        DataSet nonProdDataSet = CenterInnerProdAllocCostDiffCheckAction.getNonProdDataSet(context, 4L, this.isSca() ? nonBillNosMap : null).addField("0L", "costobject");
        DataSet auxProdDataSet = this.getAuxProdDataSet(context, this.isSca() ? auxBillNosMap : null).addField("0L", "costobject");
        DataSet srcResultDs = DataSetUtils.union((DataSet)mfgDataSet, (DataSet)nonProdDataSet);
        srcResultDs = DataSetUtils.union((DataSet)srcResultDs, (DataSet)auxProdDataSet);
        DataSet stdDs = this.getBasicAllocStd(context);
        srcResultDs = srcResultDs.leftJoin(stdDs).on("centerId", "costcenter").select(srcResultDs.getRowMeta().getFieldNames(), new String[]{"costcenter"}).finish().filter("costobject>0 or costcenter is null").select(new String[]{"centerId", "centerNumber", "centerName", "expId", "expNumber", "expName", "amount"});
        DataSet basicProdDataSet = this.getBasicProdDataSet(context, this.isSca() ? basicBillNosMap : null);
        srcResultDs = DataSetUtils.union((DataSet)srcResultDs, (DataSet)basicProdDataSet).addField("0.0", "inneramount");
        DataSet resultDs = DataSetUtils.union((DataSet)srcResultDs, (DataSet)innerProdDataSet);
        resultDs = resultDs.groupBy(new String[]{"centerId", "centerNumber", "centerName", "expId", "expNumber", "expName"}).sum("amount").sum("inneramount").finish();
        if ((resultDs = resultDs.filter("amount != inneramount")).isEmpty()) {
            return;
        }
        String checkDesc = ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u6210\u672c\u4e2d\u5fc3\u5185\u5206\u914d\u5355\u6570\u636e\u662f\u5426\u6b63\u786e\u3002", (String)"CenterInnerProdAllocCostDiffCheckAction_0", (String)"macc-cad-business", (Object[])new Object[0]);
        String detailDesc = ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3\u5185\u5206\u914d\u5355\u4e0b\uff0c\u201c%1$s/%2$s\u201d\u4e0b\u201c%3$s/%4$s\u201d\u8d39\u7528\u5bfc\u5165\u4e0e\u6e90\u5355\u91d1\u989d\u4e0d\u4e00\u81f4\u3002", (String)"CenterInnerProdAllocCostDiffCheckAction_2", (String)"macc-cad-business", (Object[])new Object[0]);
        if (this.isSca()) {
            detailDesc = ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3\u5185\u5206\u914d\u5355\u4e0b\uff0c\u8d39\u7528\u9879\u76ee\u201c%1$s/%2$s\u201d\u5bfc\u5165\u91d1\u989d\u4e0e\u6e90\u5355\u91d1\u989d\u4e0d\u4e00\u81f4\u3002", (String)"CenterInnerProdAllocCostDiffCheckAction_3", (String)"macc-cad-business", (Object[])new Object[0]);
        }
        for (Row next : resultDs) {
            CalcCheckDetailResultInfo info = new CalcCheckDetailResultInfo();
            info.setCostCenter(next.getLong("centerId"));
            String mapKey = String.format("%s@%s", next.getLong("centerId"), next.getString("expId"));
            if (this.isSca()) {
                StringBuilder desc = new StringBuilder(String.format(detailDesc, next.getString("expNumber"), next.getString("expName")));
                desc.append(this.getAllocBillNoInfo(this.getCollStr((Collection)innerBillNosMap.get(mapKey)), "5"));
                desc.append(this.getAllocBillNoInfo(this.getCollStr((Collection)mfgBillNosMap.get(mapKey)), "1"));
                desc.append(this.getAllocBillNoInfo(this.getCollStr((Collection)nonBillNosMap.get(mapKey)), "2"));
                desc.append(this.getAllocBillNoInfo(this.getCollStr((Collection)auxBillNosMap.get(mapKey)), "3"));
                desc.append(this.getAllocBillNoInfo(this.getCollStr((Collection)basicBillNosMap.get(mapKey)), "4"));
                info.setCheckDetailResultNotCut(desc.toString());
            } else {
                info.setCheckDetailResultNotCut(String.format(detailDesc, next.getString("centerNumber"), next.getString("centerName"), next.getString("expNumber"), next.getString("expName")));
            }
            this.getSingleCheckContext().getCheckDetailResult().add(info);
        }
        this.getSingleCheckContext().setPass(false);
        this.getSingleCheckContext().setCheckResult(checkDesc);
    }

    private DataSet getBasicAllocStd(CalcCheckContext context) {
        MfgFeeAllocImportParam importParam = new MfgFeeAllocImportParam();
        importParam.setOrg(context.getOrgId());
        importParam.setCostaccount(context.getCostAccountId());
        importParam.setEnableFactory(!context.getManuOrgIds().isEmpty());
        importParam.setAppnum(context.getAppNum());
        importParam.setPeriod(context.getPeriodId());
        importParam.setManuorg(new ArrayList(context.getManuOrgIds()));
        MfgFeeBasicAllocService allocService = new MfgFeeBasicAllocService();
        return allocService.getBasicAllocStd(importParam).select("costcenter").distinct();
    }

    private String getAllocBillNoInfo(String billnos, String type) {
        if (StringUtils.isEmpty((String)billnos)) {
            return "";
        }
        if ("1".equals(type)) {
            return String.format(ResManager.loadKDString((String)"\u5236\u9020\u8d39\u7528\u5f52\u96c6\u5355\u5355\u53f7\uff1a[%s];", (String)"CenterInnerProdAllocCostDiffCheckAction_4", (String)"macc-cad-business", (Object[])new Object[0]), billnos);
        }
        if ("2".equals(type)) {
            return String.format(ResManager.loadKDString((String)"\u975e\u751f\u4ea7\u5206\u914d\u5355\u5355\u53f7\uff1a[%s];", (String)"CenterInnerProdAllocCostDiffCheckAction_5", (String)"macc-cad-business", (Object[])new Object[0]), billnos);
        }
        if ("3".equals(type)) {
            return String.format(ResManager.loadKDString((String)"\u8f85\u52a9\u751f\u4ea7\u5206\u914d\u5355\u5355\u53f7\uff1a[%s];", (String)"CenterInnerProdAllocCostDiffCheckAction_6", (String)"macc-cad-business", (Object[])new Object[0]), billnos);
        }
        if ("4".equals(type)) {
            return String.format(ResManager.loadKDString((String)"\u57fa\u672c\u751f\u4ea7\u5206\u914d\u5355\u5355\u53f7\uff1a[%s];", (String)"CenterInnerProdAllocCostDiffCheckAction_7", (String)"macc-cad-business", (Object[])new Object[0]), billnos);
        }
        return String.format(ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3\u5185\u5206\u914d\u5355\u5355\u53f7\uff1a[%s];", (String)"CenterInnerProdAllocCostDiffCheckAction_8", (String)"macc-cad-business", (Object[])new Object[0]), billnos);
    }

    public static DataSet getNonProdDataSet(CalcCheckContext context, Long centerType, Map<String, List<String>> csBillNosMap) {
        QFilter filter = new QFilter("org", "=", (Object)context.getOrgId());
        filter.and("costaccount", "=", (Object)context.getCostAccountId());
        filter.and("period", "=", (Object)context.getPeriodId());
        filter.and("appnum", "=", (Object)context.getAppNum());
        filter.and("allocstatus", "=", (Object)"2");
        filter.and("entryentity.benefcostcenter.orgduty", "=", (Object)centerType);
        if (!context.getManuOrgIds().isEmpty()) {
            Set centerIds = OrgHelper.getCenterIdsByManuOrgIds((Long)context.getOrgId(), new ArrayList(context.getManuOrgIds()), (String)context.getAppNum());
            filter.and("costcenter", "in", (Object)centerIds);
        }
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"BasicProdAllocCostDiffCheckAction_getNonProdDataSet", (String)"cad_nonprodalloc", (String)"billno,entryentity.benefcostcenter.id as centerId,entryentity.benefcostcenter.number as centerNumber,entryentity.benefcostcenter.name as centerName,expenseitem.id as expId,expenseitem.number as expNumber,expenseitem.name as expName,entryentity.allocamt as amount", (QFilter[])new QFilter[]{filter}, null);
        if (csBillNosMap != null) {
            CenterInnerProdAllocCostDiffCheckAction.addBillNo(dataSet.copy(), csBillNosMap);
        }
        dataSet = dataSet.groupBy(new String[]{"centerId", "centerNumber", "centerName", "expId", "expNumber", "expName"}).sum("amount").finish();
        return dataSet;
    }

    public static DataSet getMfgDataSet(String allocType, CalcCheckContext context, Map<String, List<String>> csBillNosMap) {
        QFilter filter = new QFilter("org", "=", (Object)context.getOrgId());
        filter.and("costaccount", "=", (Object)context.getCostAccountId());
        filter.and("period", "=", (Object)context.getPeriodId());
        filter.and("allocmold", "=", (Object)allocType);
        filter.and("appnum", "=", (Object)context.getAppNum());
        if (!context.getManuOrgIds().isEmpty()) {
            Set centerIds = OrgHelper.getCenterIdsByManuOrgIds((Long)context.getOrgId(), new ArrayList(context.getManuOrgIds()), (String)context.getAppNum());
            filter.and("costcenter", "in", (Object)centerIds);
        }
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"queryBillDataSet", (String)"cad_mfgfeebill", (String)"billno,costobject,costcenter.id as centerId,costcenter.number as centerNumber,costcenter.name as centerName,expenseitem.id as expId,expenseitem.number as expNumber,expenseitem.name as expName,totalamount as amount", (QFilter[])new QFilter[]{filter}, null);
        if (csBillNosMap != null) {
            CenterInnerProdAllocCostDiffCheckAction.addBillNo(dataSet.copy(), csBillNosMap);
        }
        dataSet = dataSet.groupBy(new String[]{"costobject", "centerId", "centerNumber", "centerName", "expId", "expNumber", "expName"}).sum("amount").finish();
        return dataSet;
    }

    private DataSet getAuxProdDataSet(CalcCheckContext context, Map<String, List<String>> csBillNosMap) {
        QFilter filter = new QFilter("org", "=", (Object)context.getOrgId());
        filter.and("costaccount", "=", (Object)context.getCostAccountId());
        filter.and("period", "=", (Object)context.getPeriodId());
        filter.and("appnum", "=", (Object)context.getAppNum());
        filter.and("allocstatus", "=", (Object)"2");
        filter.and("comentity.comsubentity.subcostcenter.orgduty", "=", (Object)4L);
        if (!context.getManuOrgIds().isEmpty()) {
            Set centerIds = OrgHelper.getCenterIdsByManuOrgIds((Long)context.getOrgId(), new ArrayList(context.getManuOrgIds()), (String)context.getAppNum());
            filter.and("costcenter", "in", (Object)centerIds);
        }
        DataSet auxDataSet = QueryServiceHelper.queryDataSet((String)"CenterInnerProdAllocCostDiffCheckAction_getAuxProdDataSet", (String)"cad_auxprodalloc", (String)"billno,comentity.comsubentity.subcostcenter.id as centerId,comentity.comsubentity.subcostcenter.number as centerNumber,comentity.comsubentity.subcostcenter.name as centerName,comentity.comsubentity.subexpenseitem.id as expId,comentity.comsubentity.subexpenseitem.number as expNumber,comentity.comsubentity.subexpenseitem.name as expName,case when allocmethod ='mutual' or allocmethod='algebra' then comentity.comsubentity.suboutamt else comentity.comsubentity.subamt end amount", (QFilter[])new QFilter[]{filter}, null);
        if (csBillNosMap != null) {
            CenterInnerProdAllocCostDiffCheckAction.addBillNo(auxDataSet.copy(), csBillNosMap);
        }
        auxDataSet = auxDataSet.groupBy(new String[]{"centerId", "centerNumber", "centerName", "expId", "expNumber", "expName"}).sum("amount").finish();
        return auxDataSet;
    }

    private DataSet getBasicProdDataSet(CalcCheckContext context, Map<String, List<String>> csBillNosMap) {
        QFilter filter = new QFilter("org", "=", (Object)context.getOrgId());
        filter.and("costaccount", "=", (Object)context.getCostAccountId());
        filter.and("period", "=", (Object)context.getPeriodId());
        filter.and("appnum", "=", (Object)context.getAppNum());
        filter.and("allocstatus", "=", (Object)"2");
        Set centerIds = null;
        if (!context.getManuOrgIds().isEmpty()) {
            centerIds = OrgHelper.getCenterIdsByManuOrgIds((Long)context.getOrgId(), new ArrayList(context.getManuOrgIds()), (String)context.getAppNum());
        }
        QFilter mfgTypeFilter = new QFilter("srcbilltype", "=", (Object)"A");
        mfgTypeFilter.and("entryentity.entrycostcenter.orgduty", "=", (Object)4L);
        if (!CadEmptyUtils.isEmpty((Set)centerIds)) {
            mfgTypeFilter.and("entryentity.entrycostcenter", "in", (Object)centerIds);
        }
        DataSet mfgDataSet = QueryServiceHelper.queryDataSet((String)"CenterInnerProdAllocCostDiffCheckAction_getBasicProdDataSet", (String)"cad_basicalloc", (String)"billno,entryentity.entrycostcenter.id as centerId,entryentity.entrycostcenter.number as centerNumber,entryentity.entrycostcenter.name as centerName,entryentity.entryexpenseitem.id as expId,entryentity.entryexpenseitem.number as expNumber,entryentity.entryexpenseitem.name as expName,entryentity.entryamount as amount", (QFilter[])new QFilter[]{filter, mfgTypeFilter}, null);
        QFilter auxTypeFilter = new QFilter("srcbilltype", "=", (Object)"B");
        auxTypeFilter.and("comentity.comsubentity.subcostcenter.orgduty", "=", (Object)4L);
        if (!CadEmptyUtils.isEmpty((Set)centerIds)) {
            auxTypeFilter.and("comentity.comsubentity.subcostcenter", "in", (Object)centerIds);
        }
        DataSet auxDataSet = QueryServiceHelper.queryDataSet((String)"CenterInnerProdAllocCostDiffCheckAction_getBasicProdDataSet", (String)"cad_basicalloc", (String)"billno,comentity.comsubentity.subcostcenter.id as centerId,comentity.comsubentity.subcostcenter.number as centerNumber,comentity.comsubentity.subcostcenter.name as centerName,comentity.comsubentity.subcomexpenseitem.id as expId,comentity.comsubentity.subcomexpenseitem.number as expNumber,comentity.comsubentity.subcomexpenseitem.name as expName,comentity.comsubentity.subamt as amount", (QFilter[])new QFilter[]{filter, auxTypeFilter}, null);
        DataSet result = mfgDataSet.union(auxDataSet);
        if (csBillNosMap != null) {
            CenterInnerProdAllocCostDiffCheckAction.addBillNo(result.copy(), csBillNosMap);
        }
        result = result.groupBy(new String[]{"centerId", "centerNumber", "centerName", "expId", "expNumber", "expName"}).sum("amount").finish();
        return result;
    }

    private DataSet getInnerProdDataSet(CalcCheckContext context, Map<String, List<String>> csBillNosMap) {
        QFilter filter = new QFilter("org", "=", (Object)context.getOrgId());
        filter.and("costaccount", "=", (Object)context.getCostAccountId());
        filter.and("period", "=", (Object)context.getPeriodId());
        filter.and("appnum", "=", (Object)context.getAppNum());
        if (!context.getManuOrgIds().isEmpty()) {
            Set centerIds = OrgHelper.getCenterIdsByManuOrgIds((Long)context.getOrgId(), new ArrayList(context.getManuOrgIds()), (String)context.getAppNum());
            filter.and("benefcostcenter", "in", (Object)centerIds);
        }
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"CenterInnerProdAllocCostDiffCheckAction_getInnerProdDataSet", (String)"cad_mfgfeeallocco", (String)"billno,benefcostcenter.id as centerId,benefcostcenter.number as centerNumber,benefcostcenter.name as centerName,comexpentry.srcexpenseitem.id as expId,comexpentry.srcexpenseitem.number as expNumber,comexpentry.srcexpenseitem.name as expName,comexpentry.srcamt as inneramount,comexpentry.colsrctype as type", (QFilter[])new QFilter[]{filter}, null);
        if (csBillNosMap != null) {
            CenterInnerProdAllocCostDiffCheckAction.addBillNo(dataSet.copy(), csBillNosMap);
        }
        dataSet = dataSet.groupBy(new String[]{"centerId", "centerNumber", "centerName", "expId", "expNumber", "expName"}).sum("inneramount").finish();
        dataSet = dataSet.filter("inneramount<>0");
        return dataSet;
    }

    private boolean isSca() {
        return "sca".equals(this.getContext().getAppNum());
    }

    private static void addBillNo(DataSet ds, Map<String, List<String>> mfgBillNosMap) {
        DataSet resultDs = ds.select("billno,centerId,expId").distinct();
        for (Row row : resultDs) {
            mfgBillNosMap.computeIfAbsent(String.format("%s@%s", row.getLong("centerId"), row.getString("expId")), t -> new ArrayList()).add(row.getString("billno"));
        }
    }

    private String getCollStr(Collection<String> billNos) {
        if (billNos == null || billNos.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int seq = 0;
        for (String billno : billNos) {
            if (seq > 0) {
                sb.append(",");
            }
            sb.append(billno);
            ++seq;
        }
        return sb.toString();
    }
}

