/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.business.check;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.check.AbstractSingleCalcCheckAction;
import kd.macc.cad.common.check.CalcCheckContext;
import kd.macc.cad.common.check.CalcCheckDetailResultInfo;
import kd.macc.cad.common.enums.SysParamEnum;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.MfgfeeBillImportHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.SysParamHelper;

public class CenterManuCheckAction
extends AbstractSingleCalcCheckAction {
    protected void doCheck() {
        CalcCheckContext context = this.getContext();
        Long orgId = context.getOrgId();
        boolean enableMultiFactory = OrgHelper.isOrgEnableMultiFactory((Long)orgId);
        if (!enableMultiFactory) {
            return;
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
        paramMap.put(String.valueOf(context.getCostAccountId()), context.getPeriodId());
        paramMap.put("manuorg", context.getManuOrgId());
        paramMap.put("appnum", context.getAppNum());
        paramMap.put("operation", "check");
        List<Object> manuCenterIdList = this.getCostCenterIdList(context, "manuOrgType");
        List<Object> orgCenterIdList = this.getCostCenterIdList(context, "orgType");
        MfgfeeBillImportHelper.importMfgFeeBillBySys((Long)context.getOrgId(), Collections.singleton(context.getCostAccountId()), manuCenterIdList, paramMap, null);
        List manuList = (List)paramMap.get("checkResult");
        MfgfeeBillImportHelper.importMfgFeeBillBySys((Long)context.getOrgId(), Collections.singleton(context.getCostAccountId()), orgCenterIdList, paramMap, null);
        List orgList = (List)paramMap.get("checkResult");
        if (orgList != null && orgList.size() > 0) {
            HashSet<Long> orgCenter = new HashSet<Long>(16);
            HashSet<Long> manuCenter = new HashSet<Long>(16);
            for (DynamicObject dynamicObject : orgList) {
                orgCenter.add(dynamicObject.getLong("costcenter"));
            }
            for (DynamicObject dynamicObject : manuList) {
                manuCenter.add(dynamicObject.getLong("costcenter"));
            }
            orgCenter.removeAll(manuCenter);
            if (orgCenter.size() > 0) {
                DataSet dataSet = this.getCostCenterByIds(orgCenter);
                String checkDesc = ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u6210\u672c\u4e2d\u5fc3\u4e0e\u751f\u4ea7\u7ec4\u7ec7\u5bf9\u5e94\u8868\u3002", (String)"CenterManuCheckAction_0", (String)"macc-cad-business", (Object[])new Object[0]);
                String detailDesc = ResManager.loadKDString((String)"\u201c%1$s/%2$s\u201d\u672a\u7ef4\u62a4\u6210\u672c\u4e2d\u5fc3\u4e0e\u751f\u4ea7\u7ec4\u7ec7\u5bf9\u5e94\u8868\u3002", (String)"CenterManuCheckAction_2", (String)"macc-cad-business", (Object[])new Object[0]);
                for (Row next : dataSet) {
                    CalcCheckDetailResultInfo info = new CalcCheckDetailResultInfo();
                    info.setCostCenter(next.getLong("centerId"));
                    info.setCheckDetailResult(String.format(detailDesc, next.getString("centerNumber"), next.getString("centerName")));
                    this.getSingleCheckContext().getCheckDetailResult().add(info);
                }
                this.getSingleCheckContext().setPass(false);
                this.getSingleCheckContext().setCheckResult(checkDesc);
            }
        }
    }

    private List<Object> getCostCenterIdList(CalcCheckContext context, String manuType) {
        if ("manuOrgType".equals(manuType)) {
            List manuList = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)context.getOrgId(), (String)"cad_mfgfeebill", (String)context.getAppNum());
            Set centerIds = OrgHelper.getCenterIdsByManuOrgIds((Long)context.getOrgId(), (List)manuList, (String)context.getAppNum());
            return new ArrayList<Object>(centerIds);
        }
        return SysParamHelper.getSysParamCostCenter((String)String.valueOf(context.getOrgId()), (String)"mfgfeebilltype", (String)SysParamEnum.COMPTYPE_SYS.getValue(), (String)context.getAppNum());
    }

    private DataSet getCostCenterByIds(Set<Long> centerIds) {
        QFilter filter = new QFilter("id", "in", centerIds);
        return QueryServiceHelper.queryDataSet((String)"CenterManuCheckAction_getCostCenter", (String)"bos_costcenter", (String)"id as centerId,number as centerNumber,name as centerName", (QFilter[])new QFilter[]{filter}, null);
    }

    private DataSet getCostCenter(Long orgId) {
        QFilter filter = new QFilter("accountorg", "=", (Object)orgId);
        filter.and("enable", "=", (Object)true);
        return QueryServiceHelper.queryDataSet((String)"CenterManuCheckAction_getCostCenter", (String)"bos_costcenter", (String)"id as centerId,number as centerNumber,name as centerName", (QFilter[])new QFilter[]{filter}, null);
    }

    private DataSet getManuCenter(CalcCheckContext context) {
        Date nowTime = new Date();
        QFilter qFilter = new QFilter("org", "=", (Object)context.getOrgId());
        qFilter.and("billstatus", "=", (Object)"C");
        qFilter.and("effectdate", "<=", (Object)nowTime);
        qFilter.and("expdate", ">", (Object)nowTime);
        qFilter.and("appnum", "=", (Object)context.getAppNum());
        return QueryServiceHelper.queryDataSet((String)"CenterManuCheckAction_getManuCenter", (String)"cad_centermanuorg", (String)"entryentity.costcenter as costcenterid", (QFilter[])new QFilter[]{qFilter}, null);
    }
}

