/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.business.check;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.check.AbstractSingleCalcCheckAction;
import kd.macc.cad.common.check.CalcCheckContext;
import kd.macc.cad.common.check.CalcCheckDetailResultInfo;
import kd.macc.cad.common.check.CalcCheckHelper;
import kd.macc.cad.common.helper.CostCenterHelper;
import kd.macc.cad.common.helper.CostObjectHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.SysParamHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class CenterManuOrgCheckAction
extends AbstractSingleCalcCheckAction {
    public void doCheck() {
        CalcCheckContext context = this.getContext();
        boolean isOrgEnableMultiFactory = OrgHelper.isOrgEnableMultiFactory((Long)context.getOrgId());
        if (!isOrgEnableMultiFactory) {
            return;
        }
        Long[] orgDuty = new Long[]{4L, 5L};
        Set costCenterIds = CalcCheckHelper.getCostCenterByOrg((Long)context.getOrgId(), (Long[])orgDuty);
        Set centerIdsByManuOrgIds = CalcCheckHelper.getCenterIdsByManuOrgIds((Long)context.getOrgId(), new ArrayList(10), (String)this.getContext().getAppNum());
        costCenterIds.removeAll(centerIdsByManuOrgIds);
        Iterator iterator = costCenterIds.iterator();
        while (iterator.hasNext()) {
            Long costCenter = (Long)iterator.next();
            DynamicObjectCollection proBills = this.getProBill(context.getOrgId(), costCenter, context.getPeriodStartDate(), context.getPeriodEndDate(), context.getAppNum());
            if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)proBills)) continue;
            iterator.remove();
        }
        if (CadEmptyUtils.isEmpty((Set)costCenterIds)) {
            return;
        }
        QFilter qFilter = new QFilter("id", "in", (Object)costCenterIds);
        DynamicObjectCollection collect = QueryServiceHelper.query((String)"bos_costcenter", (String)"id, number, name", (QFilter[])qFilter.toArray());
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)collect)) {
            return;
        }
        String checkDesc = String.format(ResManager.loadKDString((String)"\u5b58\u5728%s\u4e2a\u6210\u672c\u4e2d\u5fc3\u672a\u7ef4\u62a4\u6210\u672c\u4e2d\u5fc3\u4e0e\u751f\u4ea7\u7ec4\u7ec7\u5bf9\u5e94\u8868\u3002", (String)"CenterManuOrgCheckAction_0", (String)"macc-cad-business", (Object[])new Object[0]), collect.size());
        String detailDesc = ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3\uff08\u7f16\u7801\uff1a%1$s\uff0c\u540d\u79f0\uff1a%2$s\uff09\u672a\u7ef4\u62a4\u6210\u672c\u4e2d\u5fc3\u4e0e\u751f\u4ea7\u7ec4\u7ec7\u5bf9\u5e94\u8868\u3002", (String)"CenterManuOrgCheckAction_2", (String)"macc-cad-business", (Object[])new Object[0]);
        for (DynamicObject coll : collect) {
            String number = coll.getString("number");
            String name = coll.getString("name");
            CalcCheckDetailResultInfo info = new CalcCheckDetailResultInfo();
            info.setCostCenter(Long.valueOf(coll.getLong("id")));
            info.setCheckDetailResult(String.format(detailDesc, number, name));
            this.getSingleCheckContext().getCheckDetailResult().add(info);
        }
        this.getSingleCheckContext().setCheckResult(checkDesc);
        this.getSingleCheckContext().setPass(false);
    }

    private DynamicObjectCollection getProBill(Long orgId, Long ccId, Date periodStartDate, Date periodEndDate, String appNum) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        List importScopeDate = SysParamHelper.getImportScopeDate((Long)orgId, (String)appNum);
        List workCenter = CostCenterHelper.getWorkCenter(Collections.singletonList(Long.valueOf(ccId == null ? "0" : ccId.toString())), (List)importScopeDate);
        List entryIds = CostCenterHelper.getOrderEntryIds((List)workCenter);
        List orgs = CostCenterHelper.getBosOrgs(Collections.singleton(Long.valueOf(ccId == null ? "0" : ccId.toString())), (List)importScopeDate);
        List adminOrgIds = CostCenterHelper.getAdminOrg(Collections.singleton(Long.valueOf(ccId == null ? "0" : ccId.toString())), (List)importScopeDate);
        QFilter wcOrOrgOrAoQF = CostObjectHelper.getWcOrOrgOrAoQFByWay((List)entryIds, (List)orgs, (List)adminOrgIds, (Boolean)true);
        QFilter subQF = new QFilter("treeentryentity.workcenter", "in", (Object)workCenter).and(new QFilter("transactiontype.isprocedure", "=", (Object)Boolean.FALSE));
        wcOrOrgOrAoQF = wcOrOrgOrAoQF == null ? subQF : wcOrOrgOrAoQF.or(subQF);
        filters.add(wcOrOrgOrAoQF);
        Set notNeedCollectBillBizIds = SysParamHelper.getNotNeedCollectBillBizIds((Long)Long.parseLong(orgId.toString()), (String)"cad_costobject", (String)"pom_mftorder", (String)"bizsettingentry.transactiontype.fbasedataid.id", (String)appNum);
        QFilter bizFilter = new QFilter("transactiontype", "not in", (Object)notNeedCollectBillBizIds);
        if (!CadEmptyUtils.isEmpty((Set)notNeedCollectBillBizIds)) {
            filters.add(bizFilter);
        }
        QFilter importTimeScope = new QFilter("treeentryentity.beginbookdate", ">=", (Object)periodStartDate);
        importTimeScope.and(new QFilter("treeentryentity.beginbookdate", "<=", (Object)periodEndDate));
        QFilter statusQf = new QFilter("treeentryentity.taskstatus", "!=", (Object)"A");
        filters.add(statusQf);
        String fields1 = "id, billno, billtype.billformid  AS billtype, org,treeentryentity.id AS nodeId, treeentryentity.pid AS pnodeId,treeentryentity.id AS entryId,treeentryentity.seq AS entryseq,treeentryentity.producttype AS producttype,treeentryentity.material.masterid AS material,treeentryentity.material.masterid.number AS materialNumber,treeentryentity.material.masterid.name AS materialName,treeentryentity.material.masterid.modelnum AS materialModelnum,treeentryentity.material.masterid.isenablematerialversion AS isenablematerialversion,treeentryentity.bomid.version AS bom,treeentryentity.bomid AS bomid,treeentryentity.auxproperty AS auxpty,treeentryentity.beginbookdate AS transmittime,treeentryentity.configuredcode AS configuredcode,treeentryentity.tracknumber AS tracknumber,'PB' AS sotype,transactiontype.isrework AS isrework";
        DynamicObjectCollection srcs = QueryServiceHelper.query((String)"pom_mftorder", (String)fields1, (QFilter[])filters.toArray(new QFilter[0]));
        filters.remove(wcOrOrgOrAoQF);
        wcOrOrgOrAoQF = CostObjectHelper.getWcOrOrgOrAoQFByWay((List)entryIds, (List)orgs, (List)adminOrgIds, (Boolean)false);
        if (wcOrOrgOrAoQF == null && (workCenter == null || workCenter.isEmpty())) {
            return srcs;
        }
        if (wcOrOrgOrAoQF == null && workCenter != null && !workCenter.isEmpty()) {
            return srcs;
        }
        filters.remove(bizFilter);
        notNeedCollectBillBizIds = SysParamHelper.getNotNeedCollectBillBizIds((Long)Long.parseLong(orgId.toString()), (String)"cad_costobject", (String)"om_mftorder", (String)"bizsettingentry.transactiontype.fbasedataid.id", (String)appNum);
        bizFilter = new QFilter("transactiontype", "not in", (Object)notNeedCollectBillBizIds);
        if (!CadEmptyUtils.isEmpty((Set)notNeedCollectBillBizIds)) {
            filters.add(bizFilter);
        }
        filters.add(wcOrOrgOrAoQF);
        String fields2 = "id, billno, billtype.billformid AS billtype, org,treeentryentity.id AS nodeId, treeentryentity.pid AS pnodeId,treeentryentity.id AS entryId,treeentryentity.seq AS entryseq,treeentryentity.producttype AS producttype,treeentryentity.material.masterid AS material,treeentryentity.material.masterid.number AS materialNumber,treeentryentity.material.masterid.name AS materialName,treeentryentity.material.masterid.modelnum AS materialModelnum,treeentryentity.material.masterid.isenablematerialversion AS isenablematerialversion,treeentryentity.bomid.version AS bom,treeentryentity.bomid AS bomid,treeentryentity.auxproperty AS auxpty,treeentryentity.beginbookdate AS transmittime,treeentryentity.configuredcode AS configuredcode,treeentryentity.tracknumber AS tracknumber,'WPB' AS sotype,transactiontype.isrework AS isrework";
        DynamicObjectCollection omsrcs = QueryServiceHelper.query((String)"om_mftorder", (String)fields2, (QFilter[])filters.toArray(new QFilter[0]));
        srcs.addAll((Collection)omsrcs);
        return srcs;
    }
}

