/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.business.check;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.check.AbstractSingleCalcCheckAction;
import kd.macc.cad.common.check.CalcCheckContext;
import kd.macc.cad.common.utils.TimeUtils;

public class CostAccountCloseCheckAction
extends AbstractSingleCalcCheckAction {
    protected void doCheck() {
        Map<String, Date> map;
        CalcCheckContext context = this.getContext();
        String splitSign = "@";
        QFilter qfCostAccount = new QFilter("id", "=", (Object)context.getCostAccountId());
        QFilter qfOrg = new QFilter("calorg", "=", (Object)context.getOrgId());
        QFilter qfEnable = new QFilter("enable", "=", (Object)Boolean.TRUE);
        String selectFields = "id,name,calorg,calsystem";
        DynamicObject costAccount = QueryServiceHelper.queryOne((String)"cal_bd_costaccount", (String)selectFields, (QFilter[])new QFilter[]{qfCostAccount, qfOrg, qfEnable});
        String key = costAccount.getString("calsystem") + splitSign + costAccount.getString("calorg");
        DynamicObjectCollection accSysColl = this.getAccountSys(context.getOrgId());
        HashSet<Long> ownerIds = new HashSet<Long>();
        HashMap<String, Date> curCloseAccount = new HashMap<String, Date>(16);
        accSysColl.forEach(p -> ownerIds.add(p.getLong("ownerid")));
        if (ownerIds.size() > 0 && (map = this.getCloseAccount(ownerIds)).size() > 0) {
            for (DynamicObject accSys : accSysColl) {
                Date closeDate = map.get(accSys.getString("ownerid"));
                if (closeDate == null) continue;
                curCloseAccount.put(accSys.getString("id") + splitSign + accSys.getString("calorgid"), closeDate);
            }
        }
        Date closeDate = (Date)curCloseAccount.get(key);
        Date periodEndDate = TimeUtils.getDayStartTime((Date)context.getPeriodEndDate());
        if (closeDate != null && TimeUtils.getDayStartTime((Date)closeDate).compareTo(periodEndDate) >= 0) {
            return;
        }
        String checkDesc = String.format(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u5f53\u671f\u5728\u5b58\u8d27\u6838\u7b97\u672a\u5173\u8d26\u3002", (String)"CostAccountCloseCheckAction_0", (String)"macc-cad-business", (Object[])new Object[0]), this.getPeriodName(context.getPeriodId()));
        this.getSingleCheckContext().setPass(false);
        this.getSingleCheckContext().setCheckResult(checkDesc);
    }

    private String getPeriodName(Long periodId) {
        QFilter qfId = new QFilter("id", "=", (Object)periodId);
        DynamicObject period = QueryServiceHelper.queryOne((String)"bd_period", (String)"name", (QFilter[])new QFilter[]{qfId});
        return period != null ? period.getString("name") : String.valueOf(periodId);
    }

    private Map<String, Date> getCloseAccount(Set<Long> owners) {
        QFilter qfOwner = new QFilter("owner", "in", owners);
        QFilter qfIsLeaf = new QFilter("isleaf", "=", (Object)Boolean.TRUE);
        DynamicObject[] infos = BusinessDataServiceHelper.load((String)"cal_closeaccounttable", (String)"owner,closedate", (QFilter[])new QFilter[]{qfOwner, qfIsLeaf});
        HashMap<String, Date> map = new HashMap<String, Date>(16);
        for (DynamicObject info : infos) {
            map.put(info.getDynamicObject("owner").getPkValue().toString(), info.getDate("closedate"));
        }
        return map;
    }

    private DynamicObjectCollection getAccountSys(Long orgId) {
        QFilter qfBizOrg = new QFilter("bizorgentry.bizorg", "<>", (Object)0L);
        QFilter qfBizAcctOrg = new QFilter("bizorgentry.bizacctorg", "=", (Object)orgId);
        String accountSysSelects = "id,bizorgentry.bizorg as ownerid,bizorgentry.bizacctorg as calorgid";
        return QueryServiceHelper.query((String)"bd_accountingsys", (String)accountSysSelects, (QFilter[])new QFilter[]{qfBizOrg, qfBizAcctOrg}, null);
    }
}

