/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.business.check;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.macc.cad.common.check.AbstractSingleCalcCheckAction;
import kd.macc.cad.common.check.CalcCheckContext;
import kd.macc.cad.common.check.CalcCheckDetailResultInfo;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class CostObjectConfTrackDiffCheckAction
extends AbstractSingleCalcCheckAction {
    private static Log LOGGER = LogFactory.getLog(CostObjectConfTrackDiffCheckAction.class);

    protected void doCheck() {
        this.getCostobjectList();
        if (CadEmptyUtils.isEmpty((List)this.getSingleCheckContext().getCheckDetailResult())) {
            return;
        }
        String checkDesc = String.format(ResManager.loadKDString((String)"\u5b58\u5728\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u914d\u7f6e\u53f7\uff0c\u8ddf\u8e2a\u53f7\u4e0e\u751f\u4ea7\u5de5\u5355\u5b58\u5728\u5dee\u5f02\u3002", (String)"CostObjectConfTrackDiffCheckAction_0", (String)"macc-cad-business", (Object[])new Object[0]), new Object[0]);
        this.getSingleCheckContext().setPass(false);
        this.getSingleCheckContext().setCheckResult(checkDesc);
    }

    private void getCostobjectList() {
        ArrayList costDynList = new ArrayList(10);
        CalcCheckContext context = this.getContext();
        ArrayList<Long> costObjectIdList = new ArrayList<Long>(10);
        QFilter filter = new QFilter("accountorg", "=", (Object)context.getOrgId());
        filter.and(new QFilter("bizdate", ">=", (Object)context.getPeriodStartDate()));
        filter.and(new QFilter("bizdate", "<=", (Object)context.getPeriodEndDate()));
        String algoxKey = ((Object)((Object)this)).getClass().getName() + ".doCheck";
        String selectFields = "costobject";
        DynamicObjectCollection planDsColl = QueryServiceHelper.query((String)algoxKey, (String)"cad_plannedoutputbill", (String)selectFields, (QFilter[])new QFilter[]{filter}, null);
        if (planDsColl != null) {
            for (DynamicObject dynamicObject : planDsColl) {
                costObjectIdList.add(dynamicObject.getLong("costobject"));
            }
            List costObjectIdSpilList = Lists.partition(costObjectIdList, (int)5000);
            costObjectIdSpilList.forEach(x -> {
                ArrayList<Long> proBillIdList = new ArrayList<Long>(10);
                HashMap<Long, DynamicObject> costDynMap = new HashMap<Long, DynamicObject>(16);
                DynamicObjectCollection costObjectDsColl = QueryServiceHelper.query((String)algoxKey, (String)"cad_costobject", (String)"costcenter,billno,probill,configuredcode,tracknumber", (QFilter[])new QFilter[]{new QFilter("id", "in", x)}, null);
                for (DynamicObject dynamicObject2 : costObjectDsColl) {
                    proBillIdList.add(dynamicObject2.getLong("probill"));
                    costDynList.add(dynamicObject2);
                }
                costDynMap.putAll(costDynList.stream().collect(Collectors.toMap(dynamicObject -> dynamicObject.getLong("probill"), dynamicObject -> dynamicObject, (key1, key2) -> key2)));
                Map<Long, DynamicObject> orderDynMap = this.getOrderDynList(proBillIdList);
                this.compareDiff(costDynMap, orderDynMap);
            });
        }
    }

    private Map<Long, DynamicObject> getOrderDynList(List<Long> proBillIdList) {
        ArrayList<DynamicObject> orderDynList = new ArrayList<DynamicObject>(10);
        HashSet sbentryToTrackStSets = Sets.newHashSetWithExpectedSize((int)10);
        DynamicObjectCollection orderDsColl = QueryServiceHelper.query((String)(((Object)((Object)this)).getClass().getName() + ".doCheck"), (String)"pom_mftorder", (String)"treeentryentity.id as probill,treeentryentity.configuredcode configuredcode,treeentryentity.tracknumber tracknumber,treeentryentity.material material,org manuorg", (QFilter[])new QFilter[]{new QFilter("treeentryentity.id", "in", proBillIdList)}, null);
        DynamicObjectCollection orderOmDsColl = QueryServiceHelper.query((String)(((Object)((Object)this)).getClass().getName() + ".doCheck"), (String)"om_mftorder", (String)"treeentryentity.id as probill,treeentryentity.configuredcode configuredcode,treeentryentity.tracknumber tracknumber,treeentryentity.material material,org manuorg", (QFilter[])new QFilter[]{new QFilter("treeentryentity.id", "in", proBillIdList)}, null);
        LOGGER.info("getOrderDynList--\u751f\u4ea7\u5de5\u5355\u957f\u5ea6:{}\uff0c\u59d4\u5916\u5de5\u5355\u957f\u5ea6\uff1a{}", (Object)orderDsColl.size(), (Object)orderOmDsColl.size());
        this.getOrderDynList(orderDynList, sbentryToTrackStSets, orderDsColl);
        this.getOrderDynList(orderDynList, sbentryToTrackStSets, orderOmDsColl);
        LOGGER.info("getOrderDynList--getOrderDynList0--size:{}", (Object)orderDynList.size());
        if (CollectionUtils.isNotEmpty(orderDynList)) {
            CostObjectConfTrackDiffCheckAction.setBillEnableTracknumber(orderDynList, sbentryToTrackStSets);
            CostObjectConfTrackDiffCheckAction.setBillEnableConfigcode(orderDynList, sbentryToTrackStSets);
        }
        LOGGER.info("getOrderDynList--getOrderDynList1--size:{}", (Object)orderDynList.size());
        return orderDynList.stream().collect(Collectors.toMap(dynamicObject -> dynamicObject.getLong("probill"), dynamicObject -> dynamicObject, (key1, key2) -> key2));
    }

    private void getOrderDynList(List<DynamicObject> orderDynList, Set<String> sbentryToTrackStSets, DynamicObjectCollection orderDsColl) {
        HashMap manuorgToStMap = Maps.newHashMapWithExpectedSize((int)10);
        if (orderDsColl != null) {
            for (DynamicObject dynamicObject : orderDsColl) {
                Long probill = dynamicObject.getLong("probill");
                Long material = dynamicObject.getLong("material");
                Long manuorgId = dynamicObject.getLong("manuorg");
                if (CadEmptyUtils.isEmpty((Long)material) || CadEmptyUtils.isEmpty((Long)probill) || CadEmptyUtils.isEmpty((Long)manuorgId)) continue;
                Long stOrgId = (Long)manuorgToStMap.get(manuorgId);
                if (stOrgId == null) {
                    stOrgId = OrgHelper.getInvOrgIdByProduce((Long)manuorgId);
                    manuorgToStMap.put(manuorgId, stOrgId);
                }
                if (CadEmptyUtils.isEmpty((Long)stOrgId)) continue;
                sbentryToTrackStSets.add(String.format("%s@%s@%s", material, probill, stOrgId));
                orderDynList.add(dynamicObject);
            }
            LOGGER.info("CostObjectConfTrackDiffCheckAction->doCheck->sbentryToTrackStSets:{}", sbentryToTrackStSets);
        }
    }

    private void compareDiff(Map<Long, DynamicObject> costDynMap, Map<Long, DynamicObject> orderDynMap) {
        LOGGER.info("\u672c\u671f\u8ba1\u5212\u5bf9\u5e94\u7684\u6210\u672c\u5bf9\u8c61\u914d\u7f6e\u53f7\u548c\u8ddf\u8e2a\u53f7\u662f\u5426\u53d1\u751f\u53d8\u66f4\u6bd4\u5bf9\u5f00\u59cb");
        if (!costDynMap.isEmpty() && !orderDynMap.isEmpty()) {
            costDynMap.forEach((x, y) -> {
                Long configuredcode = y.getLong("configuredcode");
                Long tracknumber = y.getLong("tracknumber");
                Long costcenter = y.getLong("costcenter");
                String billno = y.getString("billno");
                if (!orderDynMap.containsKey(x)) {
                    return;
                }
                if (configuredcode.longValue() != ((DynamicObject)orderDynMap.get(x)).getLong("configuredcode") || tracknumber.longValue() != ((DynamicObject)orderDynMap.get(x)).getLong("tracknumber")) {
                    String detailDesc = ResManager.loadKDString((String)"\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u201c%1$s\u201d\u4e0b\uff0c\u914d\u7f6e\u53f7\u201c%2$s\u201d\uff0c\u8ddf\u8e2a\u53f7\u201c%3$s\u201d\u4e0e\u751f\u4ea7\u5de5\u5355\u5b58\u5728\u5dee\u5f02\u3002", (String)"CostObjectConfTrackDiffCheckAction_1", (String)"macc-cad-business", (Object[])new Object[0]);
                    CalcCheckDetailResultInfo info = new CalcCheckDetailResultInfo();
                    info.setCostCenter(costcenter);
                    info.setCheckDetailResult(String.format(detailDesc, billno, configuredcode, tracknumber));
                    this.getSingleCheckContext().getCheckDetailResult().add(info);
                }
            });
        }
        LOGGER.info("\u672c\u671f\u8ba1\u5212\u5bf9\u5e94\u7684\u6210\u672c\u5bf9\u8c61\u914d\u7f6e\u53f7\u548c\u8ddf\u8e2a\u53f7\u662f\u5426\u53d1\u751f\u53d8\u66f4\u6bd4\u5bf9\u7ed3\u675f");
    }

    private static void setBillEnableTracknumber(List<DynamicObject> bills, Set<String> sbentryToTrackStSets) {
        if (sbentryToTrackStSets.isEmpty()) {
            return;
        }
        HashMap matTobizEntryIdMap = Maps.newHashMapWithExpectedSize((int)10);
        HashMap stToMaterials = Maps.newHashMapWithExpectedSize((int)10);
        for (String string : sbentryToTrackStSets) {
            String[] stringArray = string.split("@");
            if (stringArray.length < 3) continue;
            matTobizEntryIdMap.computeIfAbsent(String.format("%s@%s", stringArray[0], stringArray[2]), t -> new ArrayList()).add(Long.valueOf(stringArray[1]));
            stToMaterials.computeIfAbsent(Long.valueOf(stringArray[2]), t -> new HashSet(10)).add(Long.valueOf(stringArray[0]));
        }
        HashSet srcBillEntryKeys = Sets.newHashSetWithExpectedSize((int)10);
        for (Map.Entry entry : stToMaterials.entrySet()) {
            QFilter filter = new QFilter("manustrategy.noupdateinvdim.fbasedataid", "=", (Object)1297144009797647360L);
            filter.and("masterid", "in", entry.getValue());
            DynamicObjectCollection stockMaterialInfos = BaseDataServiceHelper.queryBaseData((String)"bd_materialinventoryinfo", (Long)((Long)entry.getKey()), (QFilter)filter, (String)"createorg,masterid material");
            for (DynamicObject dyn : stockMaterialInfos) {
                Long material = dyn.getLong("material");
                if (CadEmptyUtils.isEmpty((Long)material)) continue;
                String key = String.format("%s@%s", material, entry.getKey());
                srcBillEntryKeys.add(key);
            }
        }
        HashSet hashSet = Sets.newHashSetWithExpectedSize((int)10);
        for (Map.Entry entry : matTobizEntryIdMap.entrySet()) {
            if (!srcBillEntryKeys.contains(entry.getKey())) continue;
            hashSet.addAll((Collection)entry.getValue());
        }
        LOGGER.info("\u8ddf\u8e2a\u53f7\u9694\u79bb\u7ef4\u5ea6\u5904\u7406\uff0c\u9700\u8981\u6e05\u7406\u7684\u4e1a\u52a1\u5355\u636e\u5206\u5f55id\uff1a{}", (Object)hashSet);
        for (DynamicObject bill : bills) {
            long srcBillEntryId = bill.getLong("probill");
            if (!hashSet.contains(srcBillEntryId)) continue;
            bill.set("tracknumber", (Object)0L);
        }
    }

    private static void setBillEnableConfigcode(List<DynamicObject> bills, Set<String> sbentryToTrackStSets) {
        if (sbentryToTrackStSets.isEmpty()) {
            return;
        }
        HashMap matTobizEntryIdMap = Maps.newHashMapWithExpectedSize((int)10);
        HashMap stToMaterials = Maps.newHashMapWithExpectedSize((int)10);
        for (String string : sbentryToTrackStSets) {
            String[] stringArray = string.split("@");
            if (stringArray.length < 3) continue;
            matTobizEntryIdMap.computeIfAbsent(String.format("%s@%s", stringArray[0], stringArray[2]), t -> new ArrayList()).add(Long.valueOf(stringArray[1]));
            stToMaterials.computeIfAbsent(Long.valueOf(stringArray[2]), t -> new HashSet(10)).add(Long.valueOf(stringArray[0]));
        }
        HashSet srcBillEntryKeys = Sets.newHashSetWithExpectedSize((int)10);
        for (Map.Entry entry : stToMaterials.entrySet()) {
            QFilter filter = new QFilter("manustrategy.noupdateinvdim.fbasedataid", "=", (Object)1721649779361985536L);
            filter.and("masterid", "in", entry.getValue());
            DynamicObjectCollection stockMaterialInfos = BaseDataServiceHelper.queryBaseData((String)"bd_materialinventoryinfo", (Long)((Long)entry.getKey()), (QFilter)filter, (String)"createorg,masterid material");
            for (DynamicObject dyn : stockMaterialInfos) {
                Long material = dyn.getLong("material");
                if (CadEmptyUtils.isEmpty((Long)material)) continue;
                String key = String.format("%s@%s", material, entry.getKey());
                srcBillEntryKeys.add(key);
            }
        }
        HashSet hashSet = Sets.newHashSetWithExpectedSize((int)10);
        for (Map.Entry entry : matTobizEntryIdMap.entrySet()) {
            if (!srcBillEntryKeys.contains(entry.getKey())) continue;
            hashSet.addAll((Collection)entry.getValue());
        }
        LOGGER.info("\u914d\u7f6e\u53f7\u9694\u79bb\u7ef4\u5ea6\u5904\u7406\uff0c\u9700\u8981\u6e05\u7406\u7684\u4e1a\u52a1\u5355\u636e\u5206\u5f55id\uff1a{}", (Object)hashSet);
        for (DynamicObject bill : bills) {
            long srcBillEntryId = bill.getLong("probill");
            if (!hashSet.contains(srcBillEntryId)) continue;
            bill.set("configuredcode", (Object)0L);
        }
    }
}

