/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.business.check;

import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.macc.cad.common.check.AbstractSingleCalcCheckAction;
import kd.macc.cad.common.check.CalcCheckContext;
import kd.macc.cad.common.constants.LogarithmParam;
import kd.macc.cad.common.helper.CostCenterHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.LogarithmHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class CostObjectContentDiffCheckAction
extends AbstractSingleCalcCheckAction {
    protected void doCheck() {
        CalcCheckContext context = this.getContext();
        Long org = context.getOrgId();
        boolean orgEnableMultiFactory = OrgHelper.isOrgEnableMultiFactory((Long)org);
        List permProOrgsByAccOrg = new ArrayList(10);
        if (!orgEnableMultiFactory) {
            permProOrgsByAccOrg = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)context.getOrgId(), (String)"cad_costobjectlogarithm", (String)context.getAppNum());
        } else {
            permProOrgsByAccOrg.addAll(context.getManuOrgIds());
        }
        QFilter filter = new QFilter("org", "=", (Object)context.getOrgId());
        filter.and(new QFilter("billstatus", "=", (Object)"C"));
        filter.and(new QFilter("manuorg", "in", permProOrgsByAccOrg));
        filter.and(new QFilter("bookdate", ">=", (Object)context.getPeriodStartDate()));
        filter.and(new QFilter("bookdate", "<=", (Object)context.getPeriodEndDate()));
        if (!CadEmptyUtils.isEmpty((List)context.getCostCenterIds())) {
            filter.and(new QFilter("costcenter", "in", (Object)context.getCostCenterIds()));
        }
        filter.and(this.getCheckCostobjectQFilter(context, "id"));
        LogarithmParam logarithmParam = new LogarithmParam();
        logarithmParam.setOrgId(org);
        logarithmParam.setAppnum(context.getAppNum());
        logarithmParam.setStartDate(context.getPeriodStartDate());
        logarithmParam.setEndDate(context.getPeriodEndDate());
        logarithmParam.setBizorgIds(permProOrgsByAccOrg);
        List costCenterIds = CostCenterHelper.getCostCenterByOrg((Long)logarithmParam.getOrgId(), (Long[])new Long[]{4L});
        logarithmParam.setCostCenterIds(costCenterIds);
        DataSet dataSet = LogarithmHelper.getCostObjectLogarithm((LogarithmParam)logarithmParam, (QFilter)filter, (String)this.getAlgoKey("queryData"));
        if (!dataSet.isEmpty()) {
            String detailDesc = ResManager.loadKDString((String)"\u67e5\u770b\u8be6\u60c5", (String)"CostObjectContentDiffCheckAction_0", (String)"macc-cad-business", (Object[])new Object[0]);
            this.getSingleCheckContext().setPass(false);
            this.getSingleCheckContext().setCheckResult(detailDesc);
        }
    }
}

