/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.business.check;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.macc.cad.business.config.engine.filter.CollConfigFilterService;
import kd.macc.cad.business.config.service.CommonCollConfigService;
import kd.macc.cad.common.check.AbstractSingleCalcCheckAction;
import kd.macc.cad.common.check.CalcCheckContext;
import kd.macc.cad.common.check.CalcCheckDetailResultInfo;
import kd.macc.cad.common.helper.CostObjectHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.MfgfeeBillImportHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.SysParamHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class FactOutCostDiffCheckAction
extends AbstractSingleCalcCheckAction {
    private static final Log logger = LogFactory.getLog(MfgfeeBillImportHelper.class);
    private static final String[] RANGES = new String[]{"WIPCOMPELETE", "PRODUCTCOMPELETE", "WWGRK"};

    protected void doCheck() {
        CalcCheckContext context = this.getContext();
        if (!CadEmptyUtils.isEmpty((List)context.getCostCenterIds())) {
            return;
        }
        HashSet<Long> invOrgIds = new HashSet<Long>(10);
        boolean orgEnableMultiFactory = OrgHelper.isOrgEnableMultiFactory((Long)context.getOrgId());
        if (orgEnableMultiFactory) {
            for (Long manuOrgId : context.getManuOrgIds()) {
                List allToOrg = OrgUnitServiceHelper.getAllToOrg((String)"04", (String)"05", (Long)manuOrgId, (boolean)true);
                invOrgIds.addAll(allToOrg);
            }
        } else {
            List allToOrg = OrgUnitServiceHelper.getAllToOrg((String)"10", (String)"05", (Long)context.getOrgId(), (boolean)true);
            invOrgIds.addAll(allToOrg);
        }
        this.dealRoBills(context, invOrgIds);
    }

    private void dealRoBills(CalcCheckContext context, Set<Long> invOrgIds) {
        Set<String> billRanges = this.getInnerSys(context.getOrgId(), context.getAppNum());
        Boolean startCollConfigScheme = ImportServiceHelper.isStartCollConfigScheme();
        ArrayList<DynamicObject> validCollConfigList = new ArrayList();
        HashMap<Long, List<QFilter>> collConfigFilterMap = new HashMap(8);
        CollConfigFilterService collConfigFilterService = new CollConfigFilterService();
        Map costObjectRulesMap = CostObjectHelper.getCostObjectRulesMap((Long)context.getOrgId(), (List)context.getCostCenterIds());
        if (!CadEmptyUtils.isEmpty((Map)costObjectRulesMap) && !CadEmptyUtils.isEmpty(validCollConfigList = this.getValidCollConfigList(context, costObjectRulesMap))) {
            collConfigFilterMap = collConfigFilterService.getCollConfigFilterMap(validCollConfigList);
        }
        Iterator<String> iterator = billRanges.iterator();
        while (iterator.hasNext()) {
            String range;
            switch (range = iterator.next()) {
                case "WIPCOMPELETE": {
                    DataSet wgrkSourceBillDataSet = this.getWgrkSourceBill(context, invOrgIds, startCollConfigScheme, validCollConfigList, collConfigFilterMap);
                    if (wgrkSourceBillDataSet == null || wgrkSourceBillDataSet.isEmpty()) break;
                    this.dealCheckResult(context, wgrkSourceBillDataSet);
                    break;
                }
                case "WWGRK": {
                    DataSet wwWgrkSourceBillDataSet = this.getWwWgrkSourceBill(context, invOrgIds, startCollConfigScheme, validCollConfigList, collConfigFilterMap);
                    if (wwWgrkSourceBillDataSet == null || wwWgrkSourceBillDataSet.isEmpty()) break;
                    this.dealCheckResult(context, wwWgrkSourceBillDataSet);
                    break;
                }
                case "PRODUCTCOMPELETE": {
                    DataSet scrkSourceBillDataSet = this.getScrkSourceBill(context.getOrgId(), invOrgIds, context.getAppNum(), context.getPeriodStartDate(), context.getPeriodEndDate(), startCollConfigScheme, validCollConfigList, collConfigFilterMap);
                    if (scrkSourceBillDataSet == null || scrkSourceBillDataSet.isEmpty()) break;
                    this.dealCheckResult(context, scrkSourceBillDataSet);
                }
            }
        }
    }

    private Set<String> getInnerSys(Long orgId, String appNum) {
        HashSet<String> billRanges = new HashSet<String>();
        QFilter filter = new QFilter("accountorg", "=", (Object)orgId);
        filter.and(new QFilter("completetype", "=", (Object)"OBJECTRULE"));
        filter.and(new QFilter("appnum", "=", (Object)appNum));
        DynamicObjectCollection sysParams = QueryServiceHelper.query((String)"cad_sysparam", (String)"billrange", (QFilter[])new QFilter[]{filter});
        sysParams.forEach(p -> {
            String[] split;
            String billrange = p.getString("billrange");
            for (String s : split = billrange.split(",")) {
                if (CadEmptyUtils.isEmpty((String)s)) continue;
                billRanges.add(s);
            }
        });
        return billRanges;
    }

    private void dealCheckResult(CalcCheckContext context, DataSet sourceBillDataSet) {
        CalcCheckDetailResultInfo info;
        String detailDesc;
        String billno;
        Row row;
        DataSet resDataSet = sourceBillDataSet.copy();
        HashSet<Long> manuBillEntryIds = new HashSet<Long>(200);
        while (resDataSet.hasNext()) {
            Row row2 = resDataSet.next();
            manuBillEntryIds.add(row2.getLong("entryid"));
        }
        DataSet factOutPutDataSet = this.getFactOutPut(manuBillEntryIds, context);
        DataSet costRecordDataSet = this.getCostRecord(manuBillEntryIds, context.getCostAccountId(), context.getPeriodId());
        resDataSet = sourceBillDataSet.join(costRecordDataSet.copy(), JoinType.LEFT).on("id", "bizbillid").on("entryid", "bizbillentryid").select(sourceBillDataSet.getRowMeta().getFieldNames(), new String[]{"bizbillid"}).finish().distinct();
        resDataSet = resDataSet.join(factOutPutDataSet.copy(), JoinType.LEFT).on("id", "sourcebill").on("entryid", "sourcebillentry").select(resDataSet.getRowMeta().getFieldNames(), new String[]{"sourcebill"}).finish().distinct();
        DataSet noCostRecDataSet = resDataSet.filter("bizbillid is null and sourcebill is not null");
        DataSet noFactBillDataSet = resDataSet.filter("bizbillid is not null and sourcebill is null");
        DataSet noFactAndCostRecDataSet = resDataSet.filter("bizbillid is null and sourcebill is null");
        DataSet costDiffDataSet = factOutPutDataSet.join(costRecordDataSet, JoinType.INNER).on("sourcebill", "bizbillid").on("sourcebillentry", "bizbillentryid").on("element", "costelement").on("subelement", "costsubelement").select(factOutPutDataSet.getRowMeta().getFieldNames(), new String[]{"srcbillno", "unitstandardcost", "standardcost"}).finish();
        costDiffDataSet = costDiffDataSet.filter("unitstandardcost != stdprice or amount != standardcost");
        if (!noCostRecDataSet.isEmpty()) {
            while (noCostRecDataSet.hasNext()) {
                row = noCostRecDataSet.next();
                billno = row.getString("billno");
                detailDesc = ResManager.loadKDString((String)"\u6e90\u5355\u201c%s\u201d\u672a\u540c\u6b65\u5230\u5b58\u8d27\u6838\u7b97\u7684\u6838\u7b97\u6210\u672c\u8bb0\u5f55\u3002", (String)"FactOutCostDiffCheckAction_0", (String)"macc-cad-business", (Object[])new Object[0]);
                info = new CalcCheckDetailResultInfo();
                info.setCheckDetailResult(String.format(detailDesc, billno));
                this.getSingleCheckContext().getCheckDetailResult().add(info);
            }
        }
        if (!noFactBillDataSet.isEmpty()) {
            while (noFactBillDataSet.hasNext()) {
                row = noFactBillDataSet.next();
                billno = row.getString("billno");
                detailDesc = ResManager.loadKDString((String)"\u6e90\u5355\u201c%s\u201d\u672a\u5bfc\u5165\u5230\u5b8c\u5de5\u4ea7\u91cf\u5f52\u96c6\u5355\u3002", (String)"FactOutCostDiffCheckAction_1", (String)"macc-cad-business", (Object[])new Object[0]);
                info = new CalcCheckDetailResultInfo();
                info.setCheckDetailResult(String.format(detailDesc, billno));
                this.getSingleCheckContext().getCheckDetailResult().add(info);
            }
        }
        if (!noFactAndCostRecDataSet.isEmpty()) {
            while (noFactAndCostRecDataSet.hasNext()) {
                row = noFactAndCostRecDataSet.next();
                billno = row.getString("billno");
                detailDesc = ResManager.loadKDString((String)"\u6e90\u5355\u201c%s\u201d\u672a\u540c\u6b65\u5230\u5b58\u8d27\u6838\u7b97\u7684\u6838\u7b97\u6210\u672c\u8bb0\u5f55\u548c\u672a\u5bfc\u5165\u5230\u5b8c\u5de5\u4ea7\u91cf\u5f52\u96c6\u5355\u3002", (String)"FactOutCostDiffCheckAction_2", (String)"macc-cad-business", (Object[])new Object[0]);
                info = new CalcCheckDetailResultInfo();
                info.setCheckDetailResult(String.format(detailDesc, billno));
                this.getSingleCheckContext().getCheckDetailResult().add(info);
            }
        }
        if (!costDiffDataSet.isEmpty()) {
            HashSet<String> srcBillNos = new HashSet<String>(200);
            while (costDiffDataSet.hasNext()) {
                Row row3 = costDiffDataSet.next();
                String billno2 = row3.getString("srcbillno");
                if (srcBillNos.contains(billno2)) continue;
                String detailDesc2 = ResManager.loadKDString((String)"\u6e90\u5355\u201c%s\u201d\u4e2d\u7269\u6599\u7684\u6210\u672c\u4e0e\u5b58\u8d27\u4e0d\u4e00\u81f4\u3002", (String)"FactOutCostDiffCheckAction_3", (String)"macc-cad-business", (Object[])new Object[0]);
                CalcCheckDetailResultInfo info2 = new CalcCheckDetailResultInfo();
                info2.setCheckDetailResult(String.format(detailDesc2, billno2));
                this.getSingleCheckContext().getCheckDetailResult().add(info2);
                srcBillNos.add(billno2);
            }
            srcBillNos.clear();
        }
        if (CadEmptyUtils.isEmpty((List)this.getSingleCheckContext().getCheckDetailResult())) {
            return;
        }
        String checkDesc = ResManager.loadKDString((String)"\u5b8c\u5de5\u4ea7\u91cf\u5f52\u96c6\u5355\u7684\u6807\u51c6\u6210\u672c\u4e0e\u5b58\u8d27\u6838\u7b97\u5bf9\u6570\u5b58\u5728\u5dee\u5f02\u3002", (String)"FactOutCostDiffCheckAction_4", (String)"macc-cad-business", (Object[])new Object[0]);
        this.getSingleCheckContext().setCheckResult(checkDesc);
        this.getSingleCheckContext().setPass(false);
    }

    private DataSet getCostRecord(Set<Long> factSrcEntryIds, Long costAccount, Long period) {
        QFilter srcFilter = new QFilter("entry.bizbillentryid", "in", factSrcEntryIds);
        QFilter costAccountFilter = new QFilter("costaccount", "=", (Object)costAccount);
        QFilter periodFilter = new QFilter("period", "=", (Object)period);
        QFilter statusFilter = new QFilter("billstatus", "=", (Object)"C");
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getAlgoKey("dealRoBills"), (String)"cal_costrecord_subentity", (String)"billno srcbillno,bizbillid,entry.bizbillentryid bizbillentryid,entry.subentrycostelement.costelement costelement,entry.subentrycostelement.costsubelement costsubelement,entry.subentrycostelement.sub_unitstandardcost unitstandardcost,entry.subentrycostelement.sub_standardcost standardcost", (QFilter[])new QFilter[]{srcFilter, costAccountFilter, periodFilter, statusFilter}, null);
        return dataSet.groupBy(new String[]{"bizbillid", "bizbillentryid", "costelement", "costsubelement", "srcbillno"}).sum("unitstandardcost").sum("standardcost").finish();
    }

    private DataSet getFactOutPut(Set<Long> factSrcEntryIds, CalcCheckContext context) {
        QFilter srcFilter = new QFilter("sourcebillentry", "in", factSrcEntryIds);
        QFilter costAccountFilter = new QFilter("entrycost.costaccount", "=", (Object)context.getCostAccountId());
        QFilter periodFilter = new QFilter("entrycost.period", "=", (Object)context.getPeriodId());
        QFilter statusFilter = new QFilter("billstatus", "=", (Object)"C");
        if (context.getCheckParamJs().get("costobjects") != null && "sca".equals(context.getAppNum())) {
            costAccountFilter.and("entryentity.costobject", "in", context.getCheckParamJs().get("costobjects"));
        }
        DataSet factOutPutDataSet = QueryServiceHelper.queryDataSet((String)this.getAlgoKey("dealRoBills"), (String)"cad_factnedoutputbill", (String)"sourcebill,sourcebillentry,entrycost.element element,entrycost.subelement subelement,entrycost.stdprice stdprice,entrycost.amount amount", (QFilter[])new QFilter[]{srcFilter, costAccountFilter, periodFilter, statusFilter}, null);
        return factOutPutDataSet.groupBy(new String[]{"sourcebill", "sourcebillentry", "element", "subelement"}).sum("stdprice").sum("amount").finish();
    }

    private DataSet getWgrkSourceBill(CalcCheckContext context, Set<Long> invOrgIds, Boolean startCollConfigScheme, List<DynamicObject> validCollConfigList, Map<Long, List<QFilter>> collConfigFilterMap) {
        String selectProperties = "id,billno,billentry.id entryid";
        QFilter invOrgFilter = new QFilter("org", "in", invOrgIds);
        QFilter wgrkQf = new QFilter("billtype.billformid.number", "=", (Object)"im_mdc_mftmanuinbill");
        QFilter wgtkQf = new QFilter("billtype.billformid.number", "=", (Object)"im_mdc_mftreturnbill");
        Map notNeedCollectBillBizIdsMap = SysParamHelper.getNotNeedCollectBillBizIdsMap((Long)context.getOrgId(), (String)"cad_factnedoutputbill", (String)"im_mdc_mftmanuinbill", (String)"bizsettingentry.biztype.fbasedataid.id,bizsettingentry.invscheme.fbasedataid.id", (String)context.getAppNum());
        Set bizTypeIds = (Set)notNeedCollectBillBizIdsMap.get("bizsettingentry.biztype.fbasedataid.id");
        Set invSchemeIds = (Set)notNeedCollectBillBizIdsMap.get("bizsettingentry.invscheme.fbasedataid.id");
        if (!CadEmptyUtils.isEmpty((Set)bizTypeIds)) {
            wgrkQf.and(new QFilter("biztype", "not in", (Object)bizTypeIds));
        }
        if (!CadEmptyUtils.isEmpty((Set)invSchemeIds)) {
            wgrkQf.and(new QFilter("invscheme", "not in", (Object)invSchemeIds));
        }
        notNeedCollectBillBizIdsMap = SysParamHelper.getNotNeedCollectBillBizIdsMap((Long)context.getOrgId(), (String)"cad_factnedoutputbill", (String)"im_mdc_mftreturnbill", (String)"bizsettingentry.biztype.fbasedataid.id,bizsettingentry.invscheme.fbasedataid.id", (String)context.getAppNum());
        bizTypeIds = (Set)notNeedCollectBillBizIdsMap.get("bizsettingentry.biztype.fbasedataid.id");
        invSchemeIds = (Set)notNeedCollectBillBizIdsMap.get("bizsettingentry.invscheme.fbasedataid.id");
        if (startCollConfigScheme.booleanValue() && !CadEmptyUtils.isEmpty(validCollConfigList) && !CadEmptyUtils.isEmpty(collConfigFilterMap)) {
            for (DynamicObject config : validCollConfigList) {
                List<QFilter> qFilters;
                String sourceBill = config.getString("sourcebill.number");
                if ("im_mdc_mftmanuinbill".equals(sourceBill)) {
                    qFilters = collConfigFilterMap.get(config.getLong("id"));
                    if (CadEmptyUtils.isEmpty(qFilters)) continue;
                    for (QFilter qFilter : qFilters) {
                        wgrkQf.and(qFilter);
                    }
                    continue;
                }
                if (!"im_mdc_mftreturnbill".equals(sourceBill) || CadEmptyUtils.isEmpty(qFilters = collConfigFilterMap.get(config.getLong("id")))) continue;
                for (QFilter qFilter : qFilters) {
                    wgtkQf.and(qFilter);
                }
            }
        }
        if (!CadEmptyUtils.isEmpty((Set)bizTypeIds)) {
            wgtkQf.and(new QFilter("biztype", "not in", (Object)bizTypeIds));
        }
        if (!CadEmptyUtils.isEmpty((Set)invSchemeIds)) {
            wgtkQf.and(new QFilter("invscheme", "not in", (Object)invSchemeIds));
        }
        QFilter billTypeQf = wgrkQf.or(wgtkQf);
        QFilter billStatusQf = new QFilter("billstatus", "=", (Object)"C");
        QFilter bookDateQf = new QFilter("bookdate", ">=", (Object)context.getPeriodStartDate());
        bookDateQf.and(new QFilter("bookdate", "<=", (Object)context.getPeriodEndDate()));
        if ("sca".equals(context.getAppNum()) && context.getCheckParamJs().get("costobjects") != null) {
            Object costobjects = context.getCheckParamJs().get("costobjects");
            DynamicObjectCollection costObjectDOC = QueryServiceHelper.query((String)"cad_costobject", (String)"probill", (QFilter[])new QFilter("id", "in", costobjects).toArray());
            List probill = costObjectDOC.stream().map(s -> s.getLong("probill")).collect(Collectors.toList());
            billStatusQf.and("billentry.manuentryid", "in", probill);
        }
        return QueryServiceHelper.queryDataSet((String)this.getAlgoKey("getWgrkSourceBill"), (String)"im_mdc_mftmanuinbill", (String)selectProperties, (QFilter[])new QFilter[]{invOrgFilter, billStatusQf, bookDateQf, billTypeQf}, null);
    }

    public List<DynamicObject> getValidCollConfigList(CalcCheckContext context, Map<String, DynamicObject> rulesMap) {
        ArrayList<DynamicObject> values = new ArrayList<DynamicObject>(rulesMap.values());
        HashSet<Long> calcDimensionIds = new HashSet<Long>(10);
        values.forEach(p -> calcDimensionIds.add(p.getLong("costcalcdimension")));
        return CommonCollConfigService.getCollConfigs(context.getOrgId(), context.getCostAccountId(), calcDimensionIds, "cad_factnedoutputbill", context.getAppNum());
    }

    private DataSet getWwWgrkSourceBill(CalcCheckContext context, Set<Long> invOrgIds, Boolean startCollConfigScheme, List<DynamicObject> validCollConfigList, Map<Long, List<QFilter>> collConfigFilterMap) {
        String selectProperties = "id,billno,billentry.id entryid";
        QFilter invOrgFilter = new QFilter("org", "in", invOrgIds);
        Set notNeedCollectBillBizIds = SysParamHelper.getNotNeedCollectBillBizIds((Long)context.getOrgId(), (String)"cad_factnedoutputbill", (String)"im_mdc_omcmplinbill", (String)"bizsettingentry.invscheme.fbasedataid.id", (String)context.getAppNum());
        QFilter bizQf = null;
        if (!CadEmptyUtils.isEmpty((Set)notNeedCollectBillBizIds)) {
            bizQf = new QFilter("invscheme", "not in", (Object)notNeedCollectBillBizIds);
        }
        QFilter billStatusQf = new QFilter("billstatus", "=", (Object)"C");
        if (startCollConfigScheme.booleanValue() && !CadEmptyUtils.isEmpty(validCollConfigList) && !CadEmptyUtils.isEmpty(collConfigFilterMap)) {
            for (DynamicObject config : validCollConfigList) {
                List<QFilter> qFilters;
                String sourceBill = config.getString("sourcebill.number");
                if (!"im_mdc_omcmplinbill".equals(sourceBill) || CadEmptyUtils.isEmpty(qFilters = collConfigFilterMap.get(config.getLong("id")))) continue;
                for (QFilter qFilter : qFilters) {
                    billStatusQf.and(qFilter);
                }
            }
        }
        QFilter bookDateQf = new QFilter("bookdate", ">=", (Object)context.getPeriodStartDate());
        bookDateQf.and(new QFilter("bookdate", "<=", (Object)context.getPeriodEndDate()));
        if ("sca".equals(context.getAppNum()) && context.getCheckParamJs().get("costobjects") != null) {
            Object costobjects = context.getCheckParamJs().get("costobjects");
            DynamicObjectCollection costObjectDOC = QueryServiceHelper.query((String)"cad_costobject", (String)"probill", (QFilter[])new QFilter("id", "in", costobjects).toArray());
            List probill = costObjectDOC.stream().map(s -> s.getLong("probill")).collect(Collectors.toList());
            billStatusQf.and("billentry.manuentryid", "in", probill);
        }
        return QueryServiceHelper.queryDataSet((String)this.getAlgoKey("getWwWgrkSourceBill"), (String)"im_mdc_omcmplinbill", (String)selectProperties, (QFilter[])new QFilter[]{invOrgFilter, billStatusQf, bookDateQf, bizQf}, null);
    }

    private DataSet getScrkSourceBill(Long org, Set<Long> invOrgIds, String appNum, Date periodStartDate, Date periodEndDate, Boolean startCollConfigScheme, List<DynamicObject> validCollConfigList, Map<Long, List<QFilter>> collConfigFilterMap) {
        String selectProperties = "id,billno,billentry.id entryid";
        QFilter invOrgFilter = new QFilter("org", "in", invOrgIds);
        Map notNeedCollectBillBizIdsMap = SysParamHelper.getNotNeedCollectBillBizIdsMap((Long)org, (String)"cad_factnedoutputbill", (String)"im_productinbill", (String)"bizsettingentry.biztype.fbasedataid.id,bizsettingentry.invscheme.fbasedataid.id", (String)appNum);
        Set bizTypeIds = (Set)notNeedCollectBillBizIdsMap.get("bizsettingentry.biztype.fbasedataid.id");
        Set invSchemeIds = (Set)notNeedCollectBillBizIdsMap.get("bizsettingentry.invscheme.fbasedataid.id");
        QFilter bizQf = null;
        if (!CadEmptyUtils.isEmpty((Set)bizTypeIds)) {
            bizQf = new QFilter("biztype", "not in", (Object)bizTypeIds);
        }
        if (!CadEmptyUtils.isEmpty((Set)invSchemeIds)) {
            if (bizQf == null) {
                bizQf = new QFilter("invscheme", "not in", (Object)invSchemeIds);
            } else {
                bizQf.and(new QFilter("invscheme", "not in", (Object)invSchemeIds));
            }
        }
        QFilter billStatusQf = new QFilter("billstatus", "=", (Object)"C");
        if (startCollConfigScheme.booleanValue() && !CadEmptyUtils.isEmpty(validCollConfigList) && !CadEmptyUtils.isEmpty(collConfigFilterMap)) {
            for (DynamicObject config : validCollConfigList) {
                List<QFilter> qFilters;
                String sourceBill = config.getString("sourcebill.number");
                if (!"im_productinbill".equals(sourceBill) || CadEmptyUtils.isEmpty(qFilters = collConfigFilterMap.get(config.getLong("id")))) continue;
                for (QFilter qFilter : qFilters) {
                    billStatusQf.and(qFilter);
                }
            }
        }
        QFilter bookDateQf = new QFilter("bookdate", ">=", (Object)periodStartDate);
        bookDateQf.and(new QFilter("bookdate", "<=", (Object)periodEndDate));
        return QueryServiceHelper.queryDataSet((String)this.getAlgoKey("getScrkSourceBill"), (String)"im_productinbill", (String)selectProperties, (QFilter[])new QFilter[]{invOrgFilter, billStatusQf, bookDateQf, bizQf}, null);
    }
}

