/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.business.check;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.check.AbstractSingleCalcCheckAction;
import kd.macc.cad.common.check.CalcCheckContext;
import kd.macc.cad.common.check.CalcCheckDetailResultInfo;
import kd.macc.cad.common.helper.InFilterHelper;
import net.sf.json.JSONArray;

public class MatAllocCostDiffCheckAction
extends AbstractSingleCalcCheckAction {
    protected void doCheck() {
        CalcCheckDetailResultInfo info;
        Long sourceBillEntryId;
        CalcCheckContext context = this.getContext();
        if (context == null) {
            return;
        }
        DataSet matuseDataSet = this.getMatuseCollect(context);
        if (matuseDataSet.isEmpty()) {
            return;
        }
        HashMap matSrcBillNoMap = Maps.newHashMapWithExpectedSize((int)16);
        this.buildSrcBillNo(matuseDataSet, matSrcBillNoMap);
        DataSet costRecordDs = this.getCostRecord(context);
        DataSet unSynCostDs = matuseDataSet.filter("sourcebillentryid !=0").leftJoin(costRecordDs.copy()).on("sourcebillentryid", "entryid").select(matuseDataSet.getRowMeta().getFieldNames(), new String[]{"entryid"}).finish().filter("entryid is null");
        DataSet mataAllocDs = this.getMataAllocDs(context);
        DataSet matTallocDs = matuseDataSet.leftJoin(mataAllocDs.copy()).on("entryentityid", "matcollectid").select(matuseDataSet.getRowMeta().getFieldNames(), new String[]{"matcollectid"}).finish();
        DataSet allocNotSourceDs = matuseDataSet.rightJoin("sca".equals(context.getAppNum()) ? mataAllocDs : mataAllocDs.copy()).on("entryentityid", "matcollectid").select(new String[]{"entryentityid"}, new String[]{"costcenter", "billno"}).finish().filter("entryentityid is null");
        DataSet amountDs = null;
        if ("sca".equals(context.getAppNum())) {
            amountDs = costRecordDs.join(mataAllocDs).on("entryid", "matusesrcbillentryid").select(costRecordDs.getRowMeta().getFieldNames(), new String[]{"useamount", "costcenter", "matcollectid"}).finish();
            amountDs = amountDs.join(matuseDataSet).on("matcollectid", "entryentityid").select(amountDs.getRowMeta().getFieldNames(), new String[]{"sourcebilltype"}).finish();
            amountDs = amountDs.copy().select("entryid,sourcebilltype,costcenter,abs(actualcost-useamount) amt").filter("amt>0.1");
        }
        String checkDesc = ResManager.loadKDString((String)"\u6750\u6599\u8017\u7528\u5206\u914d\u5355\u4e0e\u5b58\u8d27\u6838\u7b97\u5bf9\u6570\u5b58\u5728\u5dee\u5f02\u3002", (String)"MatAllocCostDiffCheckAction_0", (String)"macc-cad-business", (Object[])new Object[0]);
        String unImpDesc = ResManager.loadKDString((String)"\u201c%1$s/%2$s\u201d\u672a\u5bfc\u5165\u5230\u6750\u6599\u8017\u7528\u5206\u914d\u5355\u3002", (String)"MatAllocCostDiffCheckAction_5", (String)"macc-cad-business", (Object[])new Object[0]);
        String unCostRecordDesc = ResManager.loadKDString((String)"\u201c%1$s/%2$s\u201d\u672a\u627e\u5230\u6838\u7b97\u6210\u672c\u8bb0\u5f55\u3002", (String)"MatAllocCostDiffCheckAction_14", (String)"macc-cad-business", (Object[])new Object[0]);
        String amtDesc = ResManager.loadKDString((String)"\u201c%1$s/%2$s\u201d\u7269\u6599\u7684\u6807\u51c6\u6210\u672c\u4e0e\u5b58\u8d27\u4e0d\u4e00\u81f4\u3002", (String)"MatAllocCostDiffCheckAction_6", (String)"macc-cad-business", (Object[])new Object[0]);
        HashSet<Long> noCostRecordEntryIdSet = new HashSet<Long>(16);
        if (!unSynCostDs.isEmpty()) {
            for (Row next : unSynCostDs) {
                sourceBillEntryId = next.getLong("sourcebillentryid");
                if (matSrcBillNoMap.get(sourceBillEntryId) == null) continue;
                noCostRecordEntryIdSet.add(sourceBillEntryId);
            }
        }
        if (!matTallocDs.isEmpty()) {
            for (Row next : matTallocDs) {
                String billNo;
                sourceBillEntryId = next.getLong("sourcebillentryid");
                if (matSrcBillNoMap.get(sourceBillEntryId) == null) continue;
                Long matcollectid = next.getLong("matcollectid");
                if (matcollectid == null) {
                    if (noCostRecordEntryIdSet.contains(sourceBillEntryId)) continue;
                    billNo = (String)matSrcBillNoMap.get(sourceBillEntryId);
                    info = new CalcCheckDetailResultInfo();
                    info.setCostCenter(next.getLong("costcenter"));
                    info.setCheckDetailResult(String.format(unImpDesc, billNo, next.getString("sourcebilltype")));
                    this.getSingleCheckContext().getCheckDetailResult().add(info);
                    continue;
                }
                if (!noCostRecordEntryIdSet.contains(sourceBillEntryId)) continue;
                billNo = (String)matSrcBillNoMap.get(sourceBillEntryId);
                info = new CalcCheckDetailResultInfo();
                info.setCostCenter(next.getLong("costcenter"));
                info.setCheckDetailResult(String.format(unCostRecordDesc, billNo, next.getString("sourcebilltype")));
                this.getSingleCheckContext().getCheckDetailResult().add(info);
            }
        }
        if (!allocNotSourceDs.isEmpty()) {
            String allocNotSourceDesc = ResManager.loadKDString((String)"\u201c%s\u201d\u672a\u627e\u5230\u5f52\u96c6\u5355\uff0c\u8bf7\u786e\u8ba4\u6750\u6599\u5f52\u96c6\u5355\u7684\u8bb0\u8d26\u65e5\u671f\u662f\u5426\u8c03\u6574\u3002", (String)"MatAllocCostDiffCheckAction_15", (String)"macc-cad-business", (Object[])new Object[0]);
            for (Row next : allocNotSourceDs) {
                String billNo = next.getString("billno");
                Long costcenter = next.getLong("costcenter");
                info = new CalcCheckDetailResultInfo();
                info.setCostCenter(costcenter);
                info.setCheckDetailResult(String.format(allocNotSourceDesc, billNo));
                this.getSingleCheckContext().getCheckDetailResult().add(info);
            }
        }
        if (amountDs != null) {
            Iterator iterator = amountDs.iterator();
            HashSet<String> infoString = new HashSet<String>();
            HashMap<String, Long> centerMap = new HashMap<String, Long>();
            while (iterator.hasNext()) {
                Row next = (Row)iterator.next();
                Long sourceBillEntryId2 = next.getLong("entryid");
                if (matSrcBillNoMap.get(sourceBillEntryId2) == null) continue;
                String billNo = (String)matSrcBillNoMap.get(sourceBillEntryId2);
                String key = String.format(amtDesc, billNo, next.getString("sourcebilltype"));
                centerMap.put(key, next.getLong("costcenter"));
                infoString.add(key);
            }
            for (String detail : infoString) {
                info = new CalcCheckDetailResultInfo();
                info.setCheckDetailResult(detail);
                info.setCostCenter((Long)centerMap.get(detail));
                this.getSingleCheckContext().getCheckDetailResult().add(info);
            }
        }
        if (!this.getSingleCheckContext().getCheckDetailResult().isEmpty()) {
            this.getSingleCheckContext().setPass(false);
            this.getSingleCheckContext().setCheckResult(checkDesc);
        }
    }

    private DataSet getMataAllocDs(CalcCheckContext context) {
        QFilter filter = new QFilter("org", "=", (Object)context.getOrgId());
        filter.and("costaccount", "=", (Object)context.getCostAccountId());
        filter.and("period", "=", (Object)context.getPeriodId());
        filter.and("appnum", "=", (Object)context.getAppNum());
        if (!context.getManuOrgIds().isEmpty()) {
            filter.and(new QFilter("manuorg", "in", (Object)context.getManuOrgIds()));
        }
        if (context.getCheckParamJs().get("costobjects") != null && "sca".equals(context.getAppNum())) {
            JSONArray costobjects = context.getCheckParamJs().getJSONArray("costobjects");
            if (costobjects != null && costobjects.size() > 200000) {
                DataSet dataSet = InFilterHelper.queryDataSetIn((String)"sca_matalloc", (String)"matcollect as matcollectid,costcenter,matusesrcbillentryid,useamount,billno", (QFilter)filter, (String)"entryentity.costobejctentry", new ArrayList(costobjects));
                return dataSet.groupBy(new String[]{"matcollectid", "billno", "costcenter", "matusesrcbillentryid", "useamount"}).finish();
            }
            filter.and("entryentity.costobejctentry", "in", context.getCheckParamJs().get("costobjects"));
        }
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"MatAllocCostDiffCheckAction_getMataAllocDs", (String)"sca_matalloc", (String)"matcollect as matcollectid,costcenter,matusesrcbillentryid,useamount,billno", (QFilter[])new QFilter[]{filter}, null);
        return dataSet.groupBy(new String[]{"matcollectid", "billno", "costcenter", "matusesrcbillentryid", "useamount"}).finish();
    }

    private DataSet getCostRecord(CalcCheckContext context) {
        QFilter filter = new QFilter("calorg", "=", (Object)context.getOrgId());
        filter.and("costaccount", "=", (Object)context.getCostAccountId());
        filter.and("bookdate", ">=", (Object)context.getPeriodStartDate());
        filter.and("bookdate", "<=", (Object)context.getPeriodEndDate());
        filter.and("calbilltype", "=", (Object)"OUT");
        filter.and("billstatus", "=", (Object)"C");
        DataSet result = QueryServiceHelper.queryDataSet((String)"MatAllocCostDiffCheckAction_getCostRecord", (String)"cal_costrecord_subentity", (String)"entry.bizbillentryid entryid,entry.actualcost as actualcost", (QFilter[])new QFilter[]{filter}, null);
        result = result.groupBy(new String[]{"entryid", "actualcost"}).finish();
        QFilter adjustFilter = new QFilter("calorg", "=", (Object)context.getOrgId());
        adjustFilter.and("costaccount", "=", (Object)context.getCostAccountId());
        adjustFilter.and("bookdate", ">=", (Object)context.getPeriodStartDate());
        adjustFilter.and("bookdate", "<=", (Object)context.getPeriodEndDate());
        adjustFilter.and("billstatus", "=", (Object)"C");
        DataSet adjustResult = QueryServiceHelper.queryDataSet((String)"MatAllocCostDiffCheckAction_getCostAdjust", (String)"cal_costadjust_subentity", (String)"entryentity.id entryid,entryentity.adjustamt as actualcost", (QFilter[])new QFilter[]{adjustFilter}, null);
        adjustResult = adjustResult.groupBy(new String[]{"entryid", "actualcost"}).finish();
        return result.union(adjustResult);
    }

    private DataSet getMatuseCollect(CalcCheckContext context) {
        QFilter filter = new QFilter("org", "=", (Object)context.getOrgId());
        if (!context.getManuOrgIds().isEmpty()) {
            filter.and(new QFilter("manuorg", "in", (Object)context.getManuOrgIds()));
        }
        filter.and("bookdate", ">=", (Object)context.getPeriodStartDate());
        filter.and("bookdate", "<=", (Object)context.getPeriodEndDate());
        filter.and("billstatus", "=", (Object)"C");
        filter.and("appnum", "=", (Object)context.getAppNum());
        String proget = ResManager.loadKDString((String)"\u751f\u4ea7\u9886\u6599\u5355", (String)"MatAllocCostDiffCheckAction_7", (String)"macc-cad-business", (Object[])new Object[0]);
        String proback = ResManager.loadKDString((String)"\u751f\u4ea7\u9000\u6599\u5355", (String)"MatAllocCostDiffCheckAction_8", (String)"macc-cad-business", (Object[])new Object[0]);
        String proadd = ResManager.loadKDString((String)"\u751f\u4ea7\u8865\u6599\u5355", (String)"MatAllocCostDiffCheckAction_9", (String)"macc-cad-business", (Object[])new Object[0]);
        String out = ResManager.loadKDString((String)"\u9886\u6599\u51fa\u5e93\u5355", (String)"MatAllocCostDiffCheckAction_10", (String)"macc-cad-business", (Object[])new Object[0]);
        String immdcomout = ResManager.loadKDString((String)"\u59d4\u5916\u9886\u6599\u5355", (String)"MatAllocCostDiffCheckAction_11", (String)"macc-cad-business", (Object[])new Object[0]);
        String immdcomerturn = ResManager.loadKDString((String)"\u59d4\u5916\u9000\u6599\u5355", (String)"MatAllocCostDiffCheckAction_12", (String)"macc-cad-business", (Object[])new Object[0]);
        String immdcomfeed = ResManager.loadKDString((String)"\u59d4\u5916\u8865\u6599\u5355", (String)"MatAllocCostDiffCheckAction_13", (String)"macc-cad-business", (Object[])new Object[0]);
        String entity = "aca_matusecollect";
        if (context.getAppNum().equals("sca")) {
            entity = "sca_matusecollect";
        }
        if (context.getCheckParamJs().get("costobjects") != null && "sca".equals(context.getAppNum())) {
            JSONArray costobjects = context.getCheckParamJs().getJSONArray("costobjects");
            if (costobjects != null && costobjects.size() > 200000) {
                return InFilterHelper.queryDataSetIn((String)entity, (String)("id,costcenter,entryentity.id as entryentityid,billno,source,entryentity.sourcebillentryid AS sourcebillentryid,case when source = 'SYSIMPORT_PROGET' then '" + proget + "' when source = 'SYSIMPORT_PROBACK' then '" + proback + "' when source = 'SYSIMPORT_PROADD' then '" + proadd + "' when source = 'SYSIMPORT_OUT' then '" + out + "' when source = 'SYSIMPORT_IMMDCOMOUT' then '" + immdcomout + "' when source = 'SYSIMPORT_IMMDCOMRETURN' then '" + immdcomerturn + "' when source = 'SYSIMPORT_IMMDCOMFEED' then '" + immdcomfeed + "' else source end sourcebilltype"), (QFilter)filter, (String)"entryentity.costobject", new ArrayList(costobjects));
            }
            filter.and("entryentity.costobject", "in", context.getCheckParamJs().get("costobjects"));
        }
        return QueryServiceHelper.queryDataSet((String)"MatAllocCostDiffCheckAction_getMatuseCollect", (String)entity, (String)("id,costcenter,entryentity.id as entryentityid,billno,source,entryentity.sourcebillentryid AS sourcebillentryid,case when source = 'SYSIMPORT_PROGET' then '" + proget + "' when source = 'SYSIMPORT_PROBACK' then '" + proback + "' when source = 'SYSIMPORT_PROADD' then '" + proadd + "' when source = 'SYSIMPORT_OUT' then '" + out + "' when source = 'SYSIMPORT_IMMDCOMOUT' then '" + immdcomout + "' when source = 'SYSIMPORT_IMMDCOMRETURN' then '" + immdcomerturn + "' when source = 'SYSIMPORT_IMMDCOMFEED' then '" + immdcomfeed + "' else source end sourcebilltype"), (QFilter[])new QFilter[]{filter}, null);
    }

    private void buildSrcBillNo(DataSet dataSet, Map<Long, String> sourceBillNoMap) {
        for (Row row : dataSet.copy()) {
            long srcBillEntryId = row.getLong("sourcebillentryid");
            String billNo = row.getString("billno");
            if (srcBillEntryId == 0L) continue;
            sourceBillNoMap.put(srcBillEntryId, billNo);
        }
    }
}

