/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.business.check;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.check.AbstractSingleCalcCheckAction;
import kd.macc.cad.common.check.CalcCheckContext;
import kd.macc.cad.common.check.CalcCheckDetailResultInfo;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class MfgFeeCollectAndAllocDiffCheckAction
extends AbstractSingleCalcCheckAction {
    String selectFields = "costcenter,costcenternumber,costcentername,expenseitem,expenseitemnumber,expenseitemname,currency,totalamount";

    protected void doCheck() {
        CalcCheckDetailResultInfo info;
        String expenseItemName;
        String expenseItemNumber;
        String costCenterName;
        String costCenterNumber;
        CalcCheckDetailResultInfo info2;
        String expenseItemName2;
        String expenseItemNumber2;
        String mapKey;
        Row row;
        String detailDesc;
        CalcCheckContext context = this.getContext();
        HashMap mfgBillNosMap = Maps.newHashMapWithExpectedSize((int)10);
        HashMap allocBillNosMap = Maps.newHashMapWithExpectedSize((int)10);
        QFilter commonFilter = this.getCommonFilter(context);
        QFilter appnumFilter = new QFilter("appnum", "=", (Object)context.getAppNum());
        QFilter confirmFilter = new QFilter("allocstatus", "=", (Object)"2");
        DataSet mfgFeeDataSet = QueryServiceHelper.queryDataSet((String)this.getAlgoKey("doCheck"), (String)"cad_mfgfeebill", (String)"billno,id,costcenter,costcenter.number costcenternumber,costcenter.name costcentername,expenseitem,expenseitem.number expenseitemnumber,expenseitem.name expenseitemname,totalamount,currency,allocmold", (QFilter[])new QFilter[]{commonFilter, appnumFilter}, null);
        if (this.isSca()) {
            this.addBillNo(mfgFeeDataSet.copy(), mfgBillNosMap);
        }
        DataSet nonProMfgDataSet = mfgFeeDataSet.filter("allocmold='A'");
        DataSet auxProMfgDataSet = mfgFeeDataSet.filter("allocmold='B'");
        DataSet proMfgDataSet = mfgFeeDataSet.filter("allocmold='C'");
        QFilter srcTypeFilter = new QFilter("srcbillentry.type", "=", (Object)"A");
        DataSet nonProAllocDataSet = QueryServiceHelper.queryDataSet((String)this.getAlgoKey("doCheck"), (String)"cad_nonprodalloc", (String)"billno,srcbillentry.srcbill as srcbillid,costcenter,costcenter.number as costcenternumber,costcenter.name as costcentername,expenseitem,expenseitem.number as expenseitemnumber,expenseitem.name as expenseitemname,amount as noproamount,currency, amount as totalamount", (QFilter[])new QFilter[]{commonFilter, srcTypeFilter, appnumFilter}, null);
        if (this.isSca()) {
            this.addBillNo(nonProAllocDataSet.copy(), allocBillNosMap);
        }
        DataSet nonProMfgAndAllocDataSet1 = nonProMfgDataSet.join(nonProAllocDataSet, JoinType.LEFT).on("id", "srcbillid").select(this.selectFields.split(","), new String[]{"srcbillid"}).finish();
        DataSet nonProMfgAndAllocDataSet2 = nonProMfgDataSet.join(nonProAllocDataSet, JoinType.RIGHT).on("id", "srcbillid").select(new String[]{"id"}, this.selectFields.split(",")).finish();
        nonProMfgAndAllocDataSet1 = nonProMfgAndAllocDataSet1.filter("srcbillid is null").select(this.selectFields);
        nonProMfgAndAllocDataSet2 = nonProMfgAndAllocDataSet2.filter("id is null").select(this.selectFields);
        DataSet nonProMfgAndAllocDataSet = nonProMfgAndAllocDataSet1.union(nonProMfgAndAllocDataSet2).distinct();
        nonProMfgAndAllocDataSet = nonProMfgAndAllocDataSet.groupBy(new String[]{"costcenter", "costcenternumber", "costcentername", "expenseitem", "expenseitemnumber", "expenseitemname"}).sum("totalamount").finish();
        nonProMfgAndAllocDataSet = nonProMfgAndAllocDataSet.filter("totalamount != 0");
        DataSet auxProAllocDataSet = QueryServiceHelper.queryDataSet((String)this.getAlgoKey("doCheck"), (String)"cad_auxprodalloc", (String)"billno,srcbillentry.srcbill as srcbillid,costcenter,costcenter.number costcenternumber,costcenter.name costcentername,parallelentity.parexpenseitem as expenseitem,parallelentity.parexpenseitem.number as expenseitemnumber,parallelentity.parexpenseitem.name as expenseitemname,currency,parallelentity.parallocamount as totalamount", (QFilter[])new QFilter[]{commonFilter, srcTypeFilter, appnumFilter}, null);
        if (this.isSca()) {
            this.addBillNo(auxProAllocDataSet.copy(), allocBillNosMap);
        }
        DataSet auxProMfgAndAllocDataSet1 = auxProMfgDataSet.join(auxProAllocDataSet, JoinType.LEFT).on("id", "srcbillid").select(this.selectFields.split(","), new String[]{"srcbillid"}).finish();
        DataSet auxProMfgAndAllocDataSet2 = auxProMfgDataSet.join(auxProAllocDataSet, JoinType.RIGHT).on("id", "srcbillid").select(new String[]{"id"}, this.selectFields.split(",")).finish();
        DataSet auxProMfgAndAllocDataSet = (auxProMfgAndAllocDataSet1 = auxProMfgAndAllocDataSet1.filter("srcbillid is null").select(this.selectFields)).union(auxProMfgAndAllocDataSet2 = auxProMfgAndAllocDataSet2.filter("id is null").select(this.selectFields)).distinct();
        DataSet auxCopyDs = auxProMfgAndAllocDataSet.copy();
        if (!auxCopyDs.isEmpty()) {
            HashSet costcenterIds = Sets.newHashSetWithExpectedSize((int)10);
            for (Row row2 : auxCopyDs) {
                costcenterIds.add(row2.getLong("costcenter"));
            }
            QFilter dutyFilter = new QFilter("entryentity.benefcostcenter", "in", (Object)costcenterIds);
            DataSet nonProdAlloc = QueryServiceHelper.queryDataSet((String)this.getAlgoKey("auxCheck"), (String)"cad_nonprodalloc", (String)"billno,entryentity.benefcostcenter costcenter,entryentity.benefcostcenter.number costcenternumber,entryentity.benefcostcenter.name costcentername,expenseitem,expenseitem.number as expenseitemnumber,expenseitem.name as expenseitemname,currency,entryentity.allocamt totalamount", (QFilter[])new QFilter[]{commonFilter, appnumFilter, confirmFilter, dutyFilter}, null);
            if (this.isSca()) {
                this.addBillNo(nonProdAlloc.copy(), allocBillNosMap);
            }
            auxProMfgAndAllocDataSet = auxProMfgAndAllocDataSet.union(nonProdAlloc.select(this.selectFields));
            auxProMfgAndAllocDataSet = auxProMfgAndAllocDataSet.groupBy(new String[]{"costcenter", "costcenternumber", "costcentername", "expenseitem", "expenseitemnumber", "expenseitemname"}).sum("totalamount").finish();
            auxProMfgAndAllocDataSet = auxProMfgAndAllocDataSet.filter("totalamount != 0");
        }
        DataSet basicProAllocDataSet = QueryServiceHelper.queryDataSet((String)this.getAlgoKey("doCheck"), (String)"cad_basicalloc", (String)"billno,srcbillentry.srcbill as srcbillid,costcenter,costcenter.number as costcenternumber,costcenter.name as costcentername,expenseitem,expenseitem.number as expenseitemnumber,expenseitem.name as expenseitemname,currency,amount as totalamount", (QFilter[])new QFilter[]{commonFilter, srcTypeFilter, appnumFilter}, null);
        if (this.isSca()) {
            this.addBillNo(basicProAllocDataSet.copy(), allocBillNosMap);
        }
        QFilter orgAndManuOrgFilter = this.getOrgAndManuOrgFilter(context);
        if (!CadEmptyUtils.isEmpty((List)context.getCostCenterIds())) {
            orgAndManuOrgFilter.and(new QFilter("benefcostcenter", "in", (Object)context.getCostCenterIds()));
        }
        orgAndManuOrgFilter.and(new QFilter("costaccount", "=", (Object)context.getCostAccountId()));
        orgAndManuOrgFilter.and(new QFilter("period", "=", (Object)context.getPeriodId()));
        QFilter srcTypeExFilter = new QFilter("srcexpentry.srctype", "=", (Object)"A");
        DataSet ccoAllocDataSet = QueryServiceHelper.queryDataSet((String)this.getAlgoKey("doCheck"), (String)"cad_mfgfeeallocco", (String)"billno,srcexpentry.expbillid as srcbillid,benefcostcenter as costcenter,benefcostcenter.number as costcenternumber,benefcostcenter.name as costcentername,srcexpentry.expenseitem expenseitem,srcexpentry.expenseitem.number as expenseitemnumber,srcexpentry.expenseitem.name as expenseitemname,currency,srcexpentry.colamt as totalamount", (QFilter[])new QFilter[]{orgAndManuOrgFilter, confirmFilter, srcTypeExFilter, appnumFilter}, null);
        if (this.isSca()) {
            this.addBillNo(ccoAllocDataSet.copy(), allocBillNosMap);
        }
        DataSet basicProAndCcoAllocDataSet = basicProAllocDataSet.union(ccoAllocDataSet);
        DataSet ccoMfgAndAllocDataSet1 = proMfgDataSet.join(basicProAndCcoAllocDataSet, JoinType.LEFT).on("id", "srcbillid").select(this.selectFields.split(","), new String[]{"srcbillid"}).finish();
        DataSet ccoMfgAndAllocDataSet2 = proMfgDataSet.join(basicProAndCcoAllocDataSet, JoinType.RIGHT).on("id", "srcbillid").select(new String[]{"id"}, this.selectFields.split(",")).finish();
        ccoMfgAndAllocDataSet1 = ccoMfgAndAllocDataSet1.filter("srcbillid is null").select(this.selectFields);
        ccoMfgAndAllocDataSet2 = ccoMfgAndAllocDataSet2.filter("id is null").select(this.selectFields);
        DataSet ccoMfgAndAllocDataSet = ccoMfgAndAllocDataSet1.union(ccoMfgAndAllocDataSet2);
        ccoMfgAndAllocDataSet = ccoMfgAndAllocDataSet.groupBy(new String[]{"costcenter", "costcenternumber", "costcentername", "expenseitem", "expenseitemnumber", "expenseitemname"}).sum("totalamount").finish();
        ccoMfgAndAllocDataSet = ccoMfgAndAllocDataSet.filter("totalamount != 0");
        String checkDesc = ResManager.loadKDString((String)"\u5f52\u96c6\u7684\u8d39\u7528\u4e0e\u5206\u914d\u5355\u5b58\u5728\u5dee\u5f02\u3002", (String)"MfgFeeCollectAndAllocDiffCheckAction_0", (String)"macc-cad-business", (Object[])new Object[0]);
        if (!nonProMfgAndAllocDataSet.isEmpty()) {
            if ("sca".equals(context.getAppNum())) {
                detailDesc = ResManager.loadKDString((String)"\u8d39\u7528\u9879\u76ee\u201c\u7f16\u7801\uff1a%1$s\uff0c\u540d\u79f0\uff1a%2$s\u201d\u5f52\u96c6\u7684\u8d39\u7528\u4e0e\u5206\u914d\u5355\u5b58\u5728\u5dee\u5f02\uff0c\u5f52\u96c6\u5355\u5355\u53f7\uff1a%3$s\u3001\u5206\u914d\u5355\u5355\u53f7\uff1a%4$s\u3002", (String)"MfgFeeCollectAndAllocDiffCheckAction_3", (String)"macc-cad-business", (Object[])new Object[0]);
                while (nonProMfgAndAllocDataSet.hasNext()) {
                    row = nonProMfgAndAllocDataSet.next();
                    mapKey = String.format("%s@%s", row.getLong("costcenter"), row.getLong("expenseitem"));
                    expenseItemNumber2 = row.getString("expenseitemnumber");
                    expenseItemName2 = row.getString("expenseitemname");
                    info2 = new CalcCheckDetailResultInfo();
                    info2.setCostCenter(row.getLong("costcenter"));
                    info2.setCheckDetailResultNotCut(String.format(detailDesc, expenseItemNumber2, expenseItemName2, this.getCollStr((Collection)mfgBillNosMap.get(mapKey)), this.getCollStr((Collection)allocBillNosMap.get(mapKey))));
                    this.getSingleCheckContext().getCheckDetailResult().add(info2);
                }
            } else {
                detailDesc = ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3\u201c\u7f16\u7801\uff1a%1$s\uff0c\u540d\u79f0\uff1a%2$s\u201d\u4e0b\uff0c\u8d39\u7528\u9879\u76ee\u201c\u7f16\u7801\uff1a%3$s\uff0c\u540d\u79f0\uff1a%4$s\u201d\u5f52\u96c6\u7684\u8d39\u7528\u4e0e\u5206\u914d\u5355\u5b58\u5728\u5dee\u5f02\u3002", (String)"MfgFeeCollectAndAllocDiffCheckAction_2", (String)"macc-cad-business", (Object[])new Object[0]);
                while (nonProMfgAndAllocDataSet.hasNext()) {
                    row = nonProMfgAndAllocDataSet.next();
                    costCenterNumber = row.getString("costcenternumber");
                    costCenterName = row.getString("costcentername");
                    expenseItemNumber = row.getString("expenseitemnumber");
                    expenseItemName = row.getString("expenseitemname");
                    info = new CalcCheckDetailResultInfo();
                    info.setCostCenter(row.getLong("costcenter"));
                    info.setCheckDetailResultNotCut(String.format(detailDesc, costCenterNumber, costCenterName, expenseItemNumber, expenseItemName));
                    this.getSingleCheckContext().getCheckDetailResult().add(info);
                }
            }
        }
        if (!auxProMfgAndAllocDataSet.isEmpty()) {
            if ("sca".equals(context.getAppNum())) {
                detailDesc = ResManager.loadKDString((String)"\u8d39\u7528\u9879\u76ee\u201c\u7f16\u7801\uff1a%1$s\uff0c\u540d\u79f0\uff1a%2$s\u201d\u5f52\u96c6\u7684\u8d39\u7528\u4e0e\u5206\u914d\u5355\u5b58\u5728\u5dee\u5f02\uff0c\u5f52\u96c6\u5355\u5355\u53f7\uff1a%3$s\u3001\u5206\u914d\u5355\u5355\u53f7\uff1a%4$s\u3002", (String)"MfgFeeCollectAndAllocDiffCheckAction_3", (String)"macc-cad-business", (Object[])new Object[0]);
                while (auxProMfgAndAllocDataSet.hasNext()) {
                    row = auxProMfgAndAllocDataSet.next();
                    mapKey = String.format("%s@%s", row.getLong("costcenter"), row.getLong("expenseitem"));
                    expenseItemNumber2 = row.getString("expenseitemnumber");
                    expenseItemName2 = row.getString("expenseitemname");
                    info2 = new CalcCheckDetailResultInfo();
                    info2.setCostCenter(row.getLong("costcenter"));
                    info2.setCheckDetailResultNotCut(String.format(detailDesc, expenseItemNumber2, expenseItemName2, this.getCollStr((Collection)mfgBillNosMap.get(mapKey)), this.getCollStr((Collection)allocBillNosMap.get(mapKey))));
                    this.getSingleCheckContext().getCheckDetailResult().add(info2);
                }
            } else {
                detailDesc = ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3\u201c\u7f16\u7801\uff1a%1$s\uff0c\u540d\u79f0\uff1a%2$s\u201d\u4e0b\uff0c\u8d39\u7528\u9879\u76ee\u201c\u7f16\u7801\uff1a%3$s\uff0c\u540d\u79f0\uff1a%4$s\u201d\u5f52\u96c6\u7684\u8d39\u7528\u4e0e\u5206\u914d\u5355\u5b58\u5728\u5dee\u5f02\u3002", (String)"MfgFeeCollectAndAllocDiffCheckAction_2", (String)"macc-cad-business", (Object[])new Object[0]);
                while (auxProMfgAndAllocDataSet.hasNext()) {
                    row = auxProMfgAndAllocDataSet.next();
                    costCenterNumber = row.getString("costcenternumber");
                    costCenterName = row.getString("costcentername");
                    expenseItemNumber = row.getString("expenseitemnumber");
                    expenseItemName = row.getString("expenseitemname");
                    info = new CalcCheckDetailResultInfo();
                    info.setCostCenter(row.getLong("costcenter"));
                    info.setCheckDetailResultNotCut(String.format(detailDesc, costCenterNumber, costCenterName, expenseItemNumber, expenseItemName));
                    this.getSingleCheckContext().getCheckDetailResult().add(info);
                }
            }
        }
        if (!ccoMfgAndAllocDataSet.isEmpty()) {
            if ("sca".equals(context.getAppNum())) {
                detailDesc = ResManager.loadKDString((String)"\u8d39\u7528\u9879\u76ee\u201c\u7f16\u7801\uff1a%1$s\uff0c\u540d\u79f0\uff1a%2$s\u201d\u5f52\u96c6\u7684\u8d39\u7528\u4e0e\u5206\u914d\u5355\u5b58\u5728\u5dee\u5f02\uff0c\u5f52\u96c6\u5355\u5355\u53f7\uff1a%3$s\u3001\u5206\u914d\u5355\u5355\u53f7\uff1a%4$s\u3002", (String)"MfgFeeCollectAndAllocDiffCheckAction_3", (String)"macc-cad-business", (Object[])new Object[0]);
                while (ccoMfgAndAllocDataSet.hasNext()) {
                    row = ccoMfgAndAllocDataSet.next();
                    mapKey = String.format("%s@%s", row.getLong("costcenter"), row.getLong("expenseitem"));
                    expenseItemNumber2 = row.getString("expenseitemnumber");
                    expenseItemName2 = row.getString("expenseitemname");
                    info2 = new CalcCheckDetailResultInfo();
                    info2.setCostCenter(row.getLong("costcenter"));
                    info2.setCheckDetailResultNotCut(String.format(detailDesc, expenseItemNumber2, expenseItemName2, this.getCollStr((Collection)mfgBillNosMap.get(mapKey)), this.getCollStr((Collection)allocBillNosMap.get(mapKey))));
                    this.getSingleCheckContext().getCheckDetailResult().add(info2);
                }
            } else {
                detailDesc = ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3\u201c\u7f16\u7801\uff1a%1$s\uff0c\u540d\u79f0\uff1a%2$s\u201d\u4e0b\uff0c\u8d39\u7528\u9879\u76ee\u201c\u7f16\u7801\uff1a%3$s\uff0c\u540d\u79f0\uff1a%4$s\u201d\u5f52\u96c6\u7684\u8d39\u7528\u4e0e\u5206\u914d\u5355\u5b58\u5728\u5dee\u5f02\u3002", (String)"MfgFeeCollectAndAllocDiffCheckAction_2", (String)"macc-cad-business", (Object[])new Object[0]);
                while (ccoMfgAndAllocDataSet.hasNext()) {
                    row = ccoMfgAndAllocDataSet.next();
                    costCenterNumber = row.getString("costcenternumber");
                    costCenterName = row.getString("costcentername");
                    expenseItemNumber = row.getString("expenseitemnumber");
                    expenseItemName = row.getString("expenseitemname");
                    info = new CalcCheckDetailResultInfo();
                    info.setCostCenter(row.getLong("costcenter"));
                    info.setCheckDetailResultNotCut(String.format(detailDesc, costCenterNumber, costCenterName, expenseItemNumber, expenseItemName));
                    this.getSingleCheckContext().getCheckDetailResult().add(info);
                }
            }
        }
        if (CadEmptyUtils.isEmpty((List)this.getSingleCheckContext().getCheckDetailResult())) {
            return;
        }
        this.getSingleCheckContext().setCheckResult(checkDesc);
        this.getSingleCheckContext().setPass(false);
    }

    private String getCollStr(Collection<String> billNos) {
        if (billNos == null || billNos.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int seq = 0;
        for (String billno : billNos) {
            if (seq > 0) {
                sb.append(",");
            }
            sb.append(billno);
            ++seq;
        }
        return sb.toString();
    }

    private boolean isSca() {
        return "sca".equals(this.getContext().getAppNum());
    }

    private void addBillNo(DataSet ds, Map<String, List<String>> mfgBillNosMap) {
        DataSet copyDs = ds.select("billno,costcenter,expenseitem").distinct();
        for (Row row : copyDs) {
            mfgBillNosMap.computeIfAbsent(String.format("%s@%s", row.getLong("costcenter"), row.getString("expenseitem")), t -> new ArrayList()).add(row.getString("billno"));
        }
    }
}

