/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.business.check;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.check.AbstractSingleCalcCheckAction;
import kd.macc.cad.common.check.CalcCheckContext;
import kd.macc.cad.common.check.CalcCheckDetailResultInfo;
import kd.macc.cad.common.helper.MfgfeeBillImportHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import org.apache.commons.lang3.StringUtils;

public class MfgFeeCollectAndSourceDiffCheckAction
extends AbstractSingleCalcCheckAction {
    private static final Log logger = LogFactory.getLog(MfgfeeBillImportHelper.class);

    protected void doCheck() {
        CalcCheckContext context = this.getContext();
        QFilter commonFilter = this.getCommonFilter(context);
        QFilter appnumFilter = new QFilter("appnum", "=", (Object)context.getAppNum());
        QFilter srcFilter = new QFilter("srcbilltype", "in", (Object)new String[]{"AP_BUS", "AP_FI", "VOUCHER"});
        srcFilter.and("sourcetype", "=", (Object)"SYS");
        QFilter qFilter = new QFilter("accountorg", "=", (Object)context.getOrgId());
        qFilter.and("status", "=", (Object)"C");
        qFilter.and("enable", "=", (Object)true);
        List costCenterIdList = QueryServiceHelper.queryPrimaryKeys((String)"bos_costcenter", (QFilter[])qFilter.toArray(), null, (int)-1);
        Long org = context.getOrgId();
        boolean orgEnableMultiFactory = OrgHelper.isOrgEnableMultiFactory((Long)org);
        if (!orgEnableMultiFactory) {
            costCenterIdList.add(0L);
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
        paramMap.put(String.valueOf(context.getCostAccountId()), context.getPeriodId());
        paramMap.put("manuorg", context.getManuOrgId());
        paramMap.put("appnum", context.getAppNum());
        paramMap.put("operation", "check");
        MfgfeeBillImportHelper.importMfgFeeBillBySys((Long)context.getOrgId(), Collections.singleton(context.getCostAccountId()), (List)costCenterIdList, paramMap, null);
        List checkResultList = (List)paramMap.get("checkResult");
        int deleteMfgBillSize = paramMap.get("deleteMfgBillIds") == null ? 0 : (Integer)paramMap.get("deleteMfgBillIds");
        DynamicObjectCollection mfgFeeBills = QueryServiceHelper.query((String)"cad_mfgfeebill", (String)"billno,org,costaccount,period,manuorg,costcenter,costcenter.number costcenternumber,expenseitem,expenseitem.number expenseitemnumber,expenseitem.name expenseitemname,totalamount,currency,srcbilltype", (QFilter[])new QFilter[]{commonFilter, srcFilter, appnumFilter});
        if (CadEmptyUtils.isEmpty((List)checkResultList) && CadEmptyUtils.isEmpty((DynamicObjectCollection)mfgFeeBills)) {
            return;
        }
        HashMap resMap = new HashMap(16);
        HashMap resBillBdMap = new HashMap(16);
        HashSet<Long> expenseItemIds = new HashSet<Long>(10);
        if (!CadEmptyUtils.isEmpty((List)checkResultList)) {
            checkResultList.forEach(mfgFeeBill -> {
                String key = mfgFeeBill.getString("org.id") + "@" + mfgFeeBill.getString("costaccount.id") + "@" + mfgFeeBill.getString("period") + "@" + (mfgFeeBill.getString("costcenter") == null ? "0" : mfgFeeBill.getString("costcenter")) + "@" + mfgFeeBill.getString("expenseitem") + mfgFeeBill.getString("srcbilltype");
                resMap.merge(key, mfgFeeBill.getBigDecimal("totalamount"), BigDecimal::add);
                expenseItemIds.add(mfgFeeBill.getLong("expenseitem"));
                StringBuilder sb = resBillBdMap.computeIfAbsent(key, t -> new StringBuilder());
                String srcbillnum = mfgFeeBill.getString("srcbillnum");
                if (sb.length() > 0 && !StringUtils.isEmpty((CharSequence)srcbillnum)) {
                    sb.append(",");
                }
                sb.append(srcbillnum);
            });
        }
        HashMap<String, BigDecimal> mfgMap = new HashMap<String, BigDecimal>(16);
        HashMap<String, StringBuilder> mfgBillBdMap = new HashMap<String, StringBuilder>(16);
        HashMap<String, MfgDyo> mfgDyoMap = new HashMap<String, MfgDyo>(16);
        for (Object mfgFeeBill2 : mfgFeeBills) {
            String string = mfgFeeBill2.getString("org") + "@" + mfgFeeBill2.getString("costaccount") + "@" + mfgFeeBill2.getString("period") + "@" + mfgFeeBill2.getString("costcenter") + "@" + mfgFeeBill2.getString("expenseitem") + mfgFeeBill2.getString("srcbilltype");
            mfgMap.merge(string, mfgFeeBill2.getBigDecimal("totalamount"), BigDecimal::add);
            MfgDyo mfgDyo = new MfgDyo();
            mfgDyo.setCcId(mfgFeeBill2.getLong("costcenter"));
            mfgDyo.setCcNumber(mfgFeeBill2.getString("costcenternumber"));
            mfgDyo.setExpNumber(mfgFeeBill2.getString("expenseitemnumber"));
            mfgDyo.setExpName(mfgFeeBill2.getString("expenseitemname"));
            mfgDyoMap.put(string, mfgDyo);
            StringBuilder sb = mfgBillBdMap.computeIfAbsent(string, t -> new StringBuilder());
            String srcbillnum = mfgFeeBill2.getString("billno");
            if (sb.length() > 0 && !StringUtils.isEmpty((CharSequence)srcbillnum)) {
                sb.append(",");
            }
            sb.append(srcbillnum);
        }
        HashSet<String> tipSet = new HashSet<String>(16);
        for (Map.Entry entry : mfgMap.entrySet()) {
            String detailDesc;
            BigDecimal resValue;
            String mfgKey = (String)entry.getKey();
            BigDecimal mfgValue = (BigDecimal)entry.getValue();
            if (CadEmptyUtils.isEmpty(resMap) || (resValue = (BigDecimal)resMap.get(mfgKey)) != null && mfgValue.compareTo(resValue) == 0 || resValue == null && mfgValue.compareTo(BigDecimal.ZERO) == 0) continue;
            MfgDyo mfgDyo = (MfgDyo)mfgDyoMap.get(mfgKey);
            String costCenterNumber = mfgDyo.getCcNumber();
            String expenseItemNumber = mfgDyo.getExpNumber();
            String expenseItemName = mfgDyo.getExpName();
            String tipKey = costCenterNumber + "@" + expenseItemNumber;
            if (tipSet.contains(tipKey)) continue;
            tipSet.add(tipKey);
            logger.info("\u5f52\u96c6\u8d39\u7528\u4e0e\u6e90\u5355\u5b58\u5728\u5dee\u5f02\uff1amfgKey\uff1a{}\uff0cmfgValue\uff1a{}\uff0cresValue\uff1a{}", new Object[]{mfgKey, mfgValue, resValue});
            CalcCheckDetailResultInfo info = new CalcCheckDetailResultInfo();
            info.setCostCenter(mfgDyo.getCcId());
            if ("sca".equals(context.getAppNum())) {
                detailDesc = ResManager.loadKDString((String)"\u8d39\u7528\u9879\u76ee\u201c\u7f16\u7801\uff1a%1$s\uff0c\u540d\u79f0\uff1a%2$s\u201d\u5f52\u96c6\u7684\u8d39\u7528\u4e0e\u6e90\u5355\u6570\u636e\u5b58\u5728\u5dee\u5f02\uff0c\u5f52\u96c6\u5355\u5355\u53f7\uff1a%3$s\u3001\u6e90\u5355\u5355\u53f7\uff1a%4$s\u3002", (String)"MfgFeeCollectAndSourceDiffCheckAction_3", (String)"macc-cad-business", (Object[])new Object[0]);
                StringBuilder resBd = (StringBuilder)resBillBdMap.get(mfgKey);
                String sourceNum = "";
                if (resBd != null) {
                    sourceNum = resBd.toString();
                }
                String mfgNum = "";
                StringBuilder mfgBd = (StringBuilder)mfgBillBdMap.get(mfgKey);
                if (mfgBd != null) {
                    mfgNum = mfgBd.toString();
                }
                info.setCheckDetailResultNotCut(String.format(detailDesc, expenseItemNumber, expenseItemName, mfgNum, sourceNum));
            } else {
                detailDesc = ResManager.loadKDString((String)"\u8d39\u7528\u9879\u76ee\u201c\u7f16\u7801\uff1a%1$s\uff0c\u540d\u79f0\uff1a%2$s\u201d\u5f52\u96c6\u7684\u8d39\u7528\u4e0e\u6e90\u5355\u6570\u636e\u5b58\u5728\u5dee\u5f02\u3002", (String)"MfgFeeCollectAndSourceDiffCheckAction_4", (String)"macc-cad-business", (Object[])new Object[0]);
                info.setCheckDetailResultNotCut(String.format(detailDesc, expenseItemNumber, expenseItemName));
            }
            this.getSingleCheckContext().getCheckDetailResult().add(info);
        }
        if (!CadEmptyUtils.isEmpty((List)checkResultList)) {
            Map<Long, DynamicObject> expenseItemInfoMap = this.getExpenseItemInfoMap(expenseItemIds);
            checkResultList.forEach(mfgFeeBill -> {
                String key = mfgFeeBill.getString("org.id") + "@" + mfgFeeBill.getString("costaccount.id") + "@" + mfgFeeBill.getString("period") + "@" + (mfgFeeBill.getString("costcenter") == null ? "0" : mfgFeeBill.getString("costcenter")) + "@" + mfgFeeBill.getString("expenseitem") + mfgFeeBill.getString("srcbilltype");
                if (mfgMap.containsKey(key)) {
                    return;
                }
                logger.info("\u6e90\u5355\u4e0e\u5f52\u96c6\u8d39\u7528\u5b58\u5728\u5dee\u5f02\uff1aresKey\uff1a{}\uff0cmfgValue\uff1a{}", (Object)key, (Object)mfgFeeBill.getBigDecimal("totalamount"));
                DynamicObject expenseItem = (DynamicObject)expenseItemInfoMap.get(mfgFeeBill.getLong("expenseitem"));
                String expenseItemNumber = expenseItem == null ? "" : expenseItem.getString("number");
                String expenseItemName = expenseItem == null ? "" : expenseItem.getString("name");
                CalcCheckDetailResultInfo info = new CalcCheckDetailResultInfo();
                info.setCostCenter(Long.valueOf(mfgFeeBill.getLong("costcenter")));
                if ("sca".equals(context.getAppNum())) {
                    String detailDesc = ResManager.loadKDString((String)"\u8d39\u7528\u9879\u76ee\u3010\u7f16\u53f7\uff1a%1$s\uff0c\u540d\u79f0\uff1a%2$s\u3011\u6e90\u5355\u6570\u636e\u4e0e\u5f52\u96c6\u7684\u8d39\u7528\u5b58\u5728\u5dee\u5f02\u3002\u6e90\u5355\u5355\u53f7\uff1a[%3$s]", (String)"MfgFeeCollectAndSourceDiffCheckAction_6", (String)"macc-cad-business", (Object[])new Object[0]);
                    StringBuilder resBd = (StringBuilder)resBillBdMap.get(key);
                    String sourceNum = "";
                    if (resBd != null) {
                        sourceNum = resBd.toString();
                    }
                    info.setCheckDetailResultNotCut(String.format(detailDesc, expenseItemNumber, expenseItemName, sourceNum));
                } else {
                    String detailDesc = ResManager.loadKDString((String)"\u8d39\u7528\u9879\u76ee\u3010\u7f16\u53f7\uff1a%1$s\uff0c\u540d\u79f0\uff1a%2$s\u3011\u6e90\u5355\u6570\u636e\u4e0e\u5f52\u96c6\u7684\u8d39\u7528\u5b58\u5728\u5dee\u5f02\u3002", (String)"MfgFeeCollectAndSourceDiffCheckAction_7", (String)"macc-cad-business", (Object[])new Object[0]);
                    info.setCheckDetailResultNotCut(String.format(detailDesc, expenseItemNumber, expenseItemName));
                }
                this.getSingleCheckContext().getCheckDetailResult().add(info);
                mfgMap.put(key, mfgFeeBill.getBigDecimal("totalamount"));
            });
        }
        if (CadEmptyUtils.isEmpty((List)this.getSingleCheckContext().getCheckDetailResult())) {
            return;
        }
        String checkDesc = ResManager.loadKDString((String)"\u5f52\u96c6\u7684\u8d39\u7528\u4e0e\u6e90\u5355\u6570\u636e\u5b58\u5728\u5dee\u5f02\u3002", (String)"MfgFeeCollectAndSourceDiffCheckAction_1", (String)"macc-cad-business", (Object[])new Object[0]);
        this.getSingleCheckContext().setCheckResult(checkDesc);
        this.getSingleCheckContext().setPass(false);
    }

    private Map<Long, DynamicObject> getExpenseItemInfoMap(Set<Long> expenseItemIds) {
        QFilter qFilter = new QFilter("expenseitem", "in", expenseItemIds);
        DynamicObjectCollection collect = QueryServiceHelper.query((String)"cad_subelementexpense", (String)"expenseitem, expenseitem.number number, expenseitem.name name", (QFilter[])qFilter.toArray());
        HashMap<Long, DynamicObject> costCenterMap = new HashMap<Long, DynamicObject>(16);
        collect.forEach(p -> costCenterMap.put(p.getLong("expenseitem"), (DynamicObject)p));
        return costCenterMap;
    }

    private Map<Long, DynamicObject> getCostCenterInfoMap(Set<Long> costCenterIds) {
        QFilter qFilter = new QFilter("id", "in", costCenterIds);
        DynamicObjectCollection collect = QueryServiceHelper.query((String)"bos_costcenter", (String)"id, number, name", (QFilter[])qFilter.toArray());
        HashMap<Long, DynamicObject> costCenterMap = new HashMap<Long, DynamicObject>(16);
        collect.forEach(p -> costCenterMap.put(p.getLong("id"), (DynamicObject)p));
        return costCenterMap;
    }

    public static class MfgDyo {
        private Long ccId;
        private String ccNumber;
        private String ccName;
        private String expNumber;
        private String expName;

        public Long getCcId() {
            return this.ccId;
        }

        public void setCcId(Long ccId) {
            this.ccId = ccId;
        }

        public String getCcNumber() {
            return this.ccNumber;
        }

        public void setCcNumber(String ccNumber) {
            this.ccNumber = ccNumber;
        }

        public String getCcName() {
            return this.ccName;
        }

        public void setCcName(String ccName) {
            this.ccName = ccName;
        }

        public String getExpNumber() {
            return this.expNumber;
        }

        public void setExpNumber(String expNumber) {
            this.expNumber = expNumber;
        }

        public String getExpName() {
            return this.expName;
        }

        public void setExpName(String expName) {
            this.expName = expName;
        }
    }
}

