/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.business.check;

import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.check.AbstractSingleCalcCheckAction;
import kd.macc.cad.common.check.CalcCheckContext;
import kd.macc.cad.common.check.CalcCheckDetailResultInfo;
import kd.macc.cad.common.check.CalcCheckHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.OrgHelper;

public class NnoProdAllocCostDiffCheckAction
extends AbstractSingleCalcCheckAction {
    protected void doCheck() {
        CalcCheckContext context = this.getContext();
        DataSet mfgDataSet = CalcCheckHelper.getMfgDataSet((String)"A", (CalcCheckContext)context);
        DataSet nonProdDataSet = this.getNonProdDataSet(context);
        DataSet resultDataSet = nonProdDataSet.leftJoin(mfgDataSet).on("centerNumber", "centerNumber").on("expNumber", "expNumber").select(nonProdDataSet.getRowMeta().getFieldNames(), new String[]{"amount"}).finish().filter("amount != nonamount");
        mfgDataSet = mfgDataSet.leftJoin(nonProdDataSet).on("centerNumber", "centerNumber").on("expNumber", "expNumber").select(mfgDataSet.getRowMeta().getFieldNames(), new String[]{"nonamount"}).finish().filter("amount != nonamount");
        resultDataSet = resultDataSet.union(mfgDataSet);
        if ((resultDataSet = resultDataSet.groupBy(new String[]{"centerId", "centerNumber", "centerName", "expNumber", "expName"}).finish()).isEmpty()) {
            return;
        }
        String checkDesc = ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u975e\u751f\u4ea7\u5206\u914d\u5355\u6570\u636e\u662f\u5426\u6b63\u786e\u3002", (String)"NnoProdAllocCostDiffCheckAction_0", (String)"macc-cad-business", (Object[])new Object[0]);
        String detailDesc = ResManager.loadKDString((String)"\u975e\u751f\u4ea7\u5206\u914d\u5355\u4e0b\uff0c\u201c%1$s/%2$s\u201d\u4e0b\u201c%3$s/%4$s\u201d\u8d39\u7528\u5bfc\u5165\u4e0e\u6e90\u5355\u91d1\u989d\u4e0d\u4e00\u81f4\u3002", (String)"NnoProdAllocCostDiffCheckAction_2", (String)"macc-cad-business", (Object[])new Object[0]);
        for (Row next : resultDataSet) {
            CalcCheckDetailResultInfo info = new CalcCheckDetailResultInfo();
            info.setCostCenter(next.getLong("centerId"));
            info.setCheckDetailResult(String.format(detailDesc, next.getString("centerNumber"), next.getString("centerName"), next.getString("expNumber"), next.getString("expName")));
            this.getSingleCheckContext().getCheckDetailResult().add(info);
        }
        this.getSingleCheckContext().setPass(false);
        this.getSingleCheckContext().setCheckResult(checkDesc);
    }

    private DataSet getNonProdDataSet(CalcCheckContext context) {
        QFilter filter = new QFilter("org", "=", (Object)context.getOrgId());
        filter.and("costaccount", "=", (Object)context.getCostAccountId());
        filter.and("period", "=", (Object)context.getPeriodId());
        filter.and("appnum", "=", (Object)context.getAppNum());
        if (!context.getManuOrgIds().isEmpty()) {
            List manuOrgIds = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)context.getOrgId(), (String)"cad_nonprodalloc", (String)context.getAppNum());
            Set centerIds = OrgHelper.getCenterIdsByManuOrgIds((Long)context.getOrgId(), (List)manuOrgIds, (String)context.getAppNum());
            filter.and("costcenter", "in", (Object)centerIds);
        }
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"NnoProdAllocCostDiffCheckAction_getNonProdDataSet", (String)"cad_nonprodalloc", (String)"costcenter.id as centerId,costcenter.number as centerNumber,costcenter.name as centerName,expenseitem,expenseitem.number as expNumber,expenseitem.name as expName,amount as nonamount", (QFilter[])new QFilter[]{filter}, null);
        dataSet = dataSet.groupBy(new String[]{"centerId", "centerNumber", "centerName", "expenseitem", "expNumber", "expName"}).sum("nonamount").finish();
        return dataSet;
    }
}

