/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.business.check;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.algox.calc.helper.BomRuleSettingStdCalcHelper;
import kd.macc.cad.common.check.AbstractSingleCalcCheckAction;
import kd.macc.cad.common.check.CalcCheckContext;
import kd.macc.cad.common.check.CalcCheckDetailResultInfo;
import kd.macc.cad.common.helper.CostTypeHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.DateUtils;

public class ProductStdCostCheckAction
extends AbstractSingleCalcCheckAction {
    public void doCheck() {
        CalcCheckContext context = this.getContext();
        QFilter filter = new QFilter("org", "=", (Object)context.getOrgId());
        filter.and("costaccount", "=", (Object)context.getCostAccountId());
        filter.and("tab", "=", (Object)"costaccounttabpage");
        filter.and("appnum", "=", (Object)context.getAppNum());
        DynamicObject sysParam = QueryServiceHelper.queryOne((String)"cad_sysparam", (String)"isupdatebyperiod", (QFilter[])new QFilter[]{filter});
        if (sysParam == null) {
            return;
        }
        DataSet materialRangesDataSet = this.getMaterialRangesDataSet(context);
        DataSet calcStaCostDataSet = this.getCalcStaCostDataSet(context);
        DataSet dataSet = materialRangesDataSet.join(calcStaCostDataSet, JoinType.INNER).on("keycol", "keycol").select(materialRangesDataSet.getRowMeta().getFieldNames(), new String[]{"ctnumber", "ctname", "count"}).finish();
        ArrayList<String> groupFields = new ArrayList<String>(Arrays.asList(dataSet.getRowMeta().getFieldNames()));
        groupFields.remove("count");
        dataSet = dataSet.groupBy(groupFields.toArray(new String[0])).sum("count").finish();
        dataSet = dataSet.filter("count > 1L");
        HashSet<String> keycols = new HashSet<String>(10);
        DataSet copyDataSet = dataSet.copy();
        while (copyDataSet.hasNext()) {
            Row row = copyDataSet.next();
            if (row == null) continue;
            keycols.add(row.getString("keycol"));
        }
        DataSet bomMatDataSetByKeyCol = BomRuleSettingStdCalcHelper.getBomMatDataSetByKeyCol(keycols);
        if (!(dataSet = dataSet.join(bomMatDataSetByKeyCol, JoinType.INNER).on("keycol", "keycol").select(dataSet.getRowMeta().getFieldNames(), new String[]{"auxproperty", "projectnum", "tracknumbernum", "configuredcodenum", "lot"}).finish()).isEmpty()) {
            String detailDesc = ResManager.loadKDString((String)"\u7269\u6599\u201c\u7f16\u7801\uff1a%1$s\uff0c\u540d\u79f0\uff1a%2$s\uff1b\u8f85\u52a9\u5c5e\u6027\uff1a%3$s\uff1b\u914d\u7f6e\u53f7\uff1a%4$s\uff1b\u8ddf\u8e2a\u53f7\uff1a%5$s\uff1b\u9879\u76ee\u53f7\uff1a%6$s\uff1b\u6279\u53f7\uff1a%7$s\u201d\u5728\u6210\u672c\u7c7b\u578b\u201c\u7f16\u7801\uff1a%8$s\uff0c\u540d\u79f0\uff1a%9$s\u201d\u4e0b\uff0c\u5f53\u671f\u5b58\u5728\u591a\u4e2a\u6807\u51c6\u6210\u672c\u3002", (String)"ProductStdCostCheckAction_3", (String)"macc-cad-business", (Object[])new Object[0]);
            String detailDesc1 = ResManager.loadKDString((String)"\u7269\u6599\u201c\u7f16\u7801\uff1a%1$s\uff0c\u540d\u79f0\uff1a%2$s\uff1b\u8f85\u52a9\u5c5e\u6027\uff1a%3$s\uff1b\u914d\u7f6e\u53f7\uff1a%4$s\uff1b\u8ddf\u8e2a\u53f7\uff1a%5$s\uff1b\u9879\u76ee\u53f7\uff1a%6$s\u201d\u5728\u6210\u672c\u7c7b\u578b\u201c\u7f16\u7801\uff1a%7$s\uff0c\u540d\u79f0\uff1a%8$s\u201d\u4e0b\uff0c\u5f53\u671f\u5b58\u5728\u591a\u4e2a\u6807\u51c6\u6210\u672c\u3002", (String)"ProductStdCostCheckAction_4", (String)"macc-cad-business", (Object[])new Object[0]);
            String detailDesc2 = ResManager.loadKDString((String)"\u7269\u6599\u201c\u7f16\u7801\uff1a%1$s\uff0c\u540d\u79f0\uff1a%2$s\uff1b\u8f85\u52a9\u5c5e\u6027\uff1a%3$s\uff1b\u914d\u7f6e\u53f7\uff1a%4$s\uff1b\u8ddf\u8e2a\u53f7\uff1a%5$s\u201d\u5728\u6210\u672c\u7c7b\u578b\u201c\u7f16\u7801\uff1a%6$s\uff0c\u540d\u79f0\uff1a%7$s\u201d\u4e0b\uff0c\u5f53\u671f\u5b58\u5728\u591a\u4e2a\u6807\u51c6\u6210\u672c\u3002", (String)"ProductStdCostCheckAction_5", (String)"macc-cad-business", (Object[])new Object[0]);
            String detailDesc3 = ResManager.loadKDString((String)"\u7269\u6599\u201c\u7f16\u7801\uff1a%1$s\uff0c\u540d\u79f0\uff1a%2$s\uff1b\u8f85\u52a9\u5c5e\u6027\uff1a%3$s\uff1b\u914d\u7f6e\u53f7\uff1a%4$s\u201d\u5728\u6210\u672c\u7c7b\u578b\u201c\u7f16\u7801\uff1a%5$s\uff0c\u540d\u79f0\uff1a%6$s\u201d\u4e0b\uff0c\u5f53\u671f\u5b58\u5728\u591a\u4e2a\u6807\u51c6\u6210\u672c\u3002", (String)"ProductStdCostCheckAction_6", (String)"macc-cad-business", (Object[])new Object[0]);
            String detailDesc4 = ResManager.loadKDString((String)"\u7269\u6599\u201c\u7f16\u7801\uff1a%1$s\uff0c\u540d\u79f0\uff1a%2$s\uff1b\u8f85\u52a9\u5c5e\u6027\uff1a%3$s\u201d\u5728\u6210\u672c\u7c7b\u578b\u201c\u7f16\u7801\uff1a%4$s\uff0c\u540d\u79f0\uff1a%5$s\u201d\u4e0b\uff0c\u5f53\u671f\u5b58\u5728\u591a\u4e2a\u6807\u51c6\u6210\u672c\u3002", (String)"ProductStdCostCheckAction_7", (String)"macc-cad-business", (Object[])new Object[0]);
            String detailDesc5 = ResManager.loadKDString((String)"\u7269\u6599\u201c%1$s\u201d\u5728\u6210\u672c\u7c7b\u578b\u201c%3$s\u201d\u4e0b\uff0c\u5f53\u671f\u5b58\u5728\u591a\u4e2a\u6807\u51c6\u6210\u672c\u3002", (String)"ProductStdCostCheckAction_2", (String)"macc-cad-business", (Object[])new Object[0]);
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                String number = row.getString("number");
                String name = row.getString("name");
                String ctnumber = row.getString("ctnumber");
                String ctname = row.getString("ctname");
                String auxproperty = row.getString("auxproperty");
                String projectnum = row.getString("projectnum");
                String tracknumbernum = row.getString("tracknumbernum");
                String configuredcodenum = row.getString("configuredcodenum");
                String lot = row.getString("lot");
                CalcCheckDetailResultInfo info = new CalcCheckDetailResultInfo();
                if (!(CadEmptyUtils.isEmpty((String)auxproperty) || CadEmptyUtils.isEmpty((String)configuredcodenum) || CadEmptyUtils.isEmpty((String)tracknumbernum) || CadEmptyUtils.isEmpty((String)projectnum) || CadEmptyUtils.isEmpty((String)lot))) {
                    info.setCheckDetailResult(String.format(detailDesc, number, name, auxproperty, configuredcodenum, tracknumbernum, projectnum, lot, ctnumber, ctname));
                } else if (!(CadEmptyUtils.isEmpty((String)auxproperty) || CadEmptyUtils.isEmpty((String)configuredcodenum) || CadEmptyUtils.isEmpty((String)tracknumbernum) || CadEmptyUtils.isEmpty((String)projectnum))) {
                    info.setCheckDetailResult(String.format(detailDesc1, number, name, auxproperty, configuredcodenum, tracknumbernum, projectnum, ctnumber, ctname));
                } else if (!(CadEmptyUtils.isEmpty((String)auxproperty) || CadEmptyUtils.isEmpty((String)configuredcodenum) || CadEmptyUtils.isEmpty((String)tracknumbernum))) {
                    info.setCheckDetailResult(String.format(detailDesc2, number, name, auxproperty, configuredcodenum, tracknumbernum, ctnumber, ctname));
                } else if (!CadEmptyUtils.isEmpty((String)auxproperty) && !CadEmptyUtils.isEmpty((String)configuredcodenum)) {
                    info.setCheckDetailResult(String.format(detailDesc3, number, name, auxproperty, configuredcodenum, ctnumber, ctname));
                } else if (!CadEmptyUtils.isEmpty((String)auxproperty)) {
                    info.setCheckDetailResult(String.format(detailDesc4, number, name, auxproperty, ctnumber, ctname));
                } else {
                    info.setCheckDetailResult(String.format(detailDesc5, number, name, ctnumber, ctname));
                }
                this.getSingleCheckContext().getCheckDetailResult().add(info);
            }
            String checkDesc = String.format(ResManager.loadKDString((String)"%s\u79cd\u7269\u6599\u5b58\u5728\u591a\u4e2a\u6807\u51c6\u6210\u672c\u3002", (String)"ProductStdCostCheckAction_1", (String)"macc-cad-business", (Object[])new Object[0]), this.getSingleCheckContext().getCheckDetailResult().size());
            this.getSingleCheckContext().setCheckResult(checkDesc);
            this.getSingleCheckContext().setPass(false);
        }
    }

    private DataSet getMaterialRangesDataSet(CalcCheckContext context) {
        QFilter orgFilter = this.getOrgCostCenterFilter(context.getOrgId(), context.getCostCenterIds(), new ArrayList(context.getManuOrgIds()));
        QFilter bookDateFilter = new QFilter("bookdate", ">=", (Object)context.getPeriodStartDate());
        bookDateFilter.and(new QFilter("bookdate", "<=", (Object)context.getPeriodEndDate()));
        QFilter costobjectFilter = this.getCheckCostobjectQFilter(context, "entryentity.costobject");
        DataSet factDataSet = QueryServiceHelper.queryDataSet((String)this.getAlgoKey("getMaterialRanges"), (String)"cad_factnedoutputbill", (String)"material,material.number number,material.name name,version,auxpty,keycol", (QFilter[])new QFilter[]{orgFilter, bookDateFilter, costobjectFilter}, null);
        QFilter periodFilter = new QFilter("period", "=", (Object)context.getPeriodId());
        QFilter costobjectFilter1 = this.getCheckCostobjectQFilter(context, "entryentity.costobejctentry");
        DataSet matallocDataSet = QueryServiceHelper.queryDataSet((String)this.getAlgoKey("getMaterialRanges"), (String)"sca_matalloc", (String)"material,material.number number,material.name name,matversion version,auxpty,keycol", (QFilter[])new QFilter[]{orgFilter, periodFilter, costobjectFilter1}, null);
        return factDataSet.union(matallocDataSet).distinct();
    }

    private DataSet getCalcStaCostDataSet(CalcCheckContext context) {
        HashSet<Long> costTypeSet = new HashSet<Long>();
        if (!CadEmptyUtils.isEmpty((Set)context.getManuOrgIds())) {
            for (Long manuorg : context.getManuOrgIds()) {
                Long costTypeId = CostTypeHelper.getCostTypeIdByManuOrgIdFromCal((Long)context.getCostAccountId(), (Long)context.getOrgId(), (Long)manuorg);
                if (CadEmptyUtils.isEmpty((Long)costTypeId)) continue;
                costTypeSet.add(costTypeId);
            }
        } else {
            Long costTypeId = CostTypeHelper.getCostTypeIdByManuOrgIdFromCal((Long)context.getCostAccountId(), (Long)context.getOrgId(), null);
            if (!CadEmptyUtils.isEmpty((Long)costTypeId)) {
                costTypeSet.add(costTypeId);
            }
        }
        QFilter costtypeFilter = new QFilter("costtype", "in", costTypeSet);
        QFilter periodFilter = ProductStdCostCheckAction.getPeriodQFilter(context.getPeriodStartDate(), context.getPeriodEndDate());
        DataSet calcEffDataSet = QueryServiceHelper.queryDataSet((String)this.getAlgoKey("getCalcStaCostDataSet"), (String)"cad_matcostinfo", (String)"material.masterid calcmatid,matversion calcmatverId,auxpty calcauxptyId,costtype.number ctnumber,costtype.name ctname,1L as count,keycol", (QFilter[])new QFilter[]{costtypeFilter, periodFilter}, null);
        return calcEffDataSet.groupBy(new String[]{"calcmatid", "calcmatverId", "calcauxptyId", "ctnumber", "ctname", "keycol"}).sum("count").finish().distinct();
    }

    private static QFilter getPeriodQFilter(Date startDate, Date endDate) {
        QFilter allFilters = QFilter.of((String)"effectdate != expdate", null);
        QFilter filter1 = allFilters.copy();
        QFilter filter2 = allFilters.copy();
        endDate = DateUtils.getLastSecond((Date)endDate, (int)-1);
        filter1.and(new QFilter("effectdate", "<=", (Object)startDate).and(new QFilter("expdate", ">", (Object)startDate)));
        filter2.and(new QFilter("effectdate", ">=", (Object)startDate).and(new QFilter("effectdate", "<", (Object)endDate)));
        return filter1.or(filter2);
    }
}

