/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.business.check;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.check.AbstractSingleCalcCheckAction;
import kd.macc.cad.common.check.CalcCheckDetailResultInfo;
import kd.macc.cad.common.check.CalcCheckHelper;
import kd.macc.cad.common.helper.CostTypeHelper;
import kd.macc.cad.common.helper.InFilterHelper;
import kd.macc.cad.common.helper.ResourceAbsorbHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import net.sf.json.JSONObject;

public class ResourceFactedAbsorbCheckAction
extends AbstractSingleCalcCheckAction {
    private static final Log logger = LogFactory.getLog(ResourceFactedAbsorbCheckAction.class);

    private QFilter getQFilterToArr(QFilter[] arr) {
        QFilter filter = null;
        for (QFilter f : arr) {
            if (filter == null) {
                filter = f;
                continue;
            }
            if (f == null) continue;
            filter.and(f);
        }
        return filter;
    }

    protected void doCheck() {
        CalcCheckDetailResultInfo info;
        Row row;
        Map hsCostTypeByOrg;
        HashSet<Long> manuOrgIds;
        String detailDesc;
        JSONObject checkParamJs = this.getContext().getCheckParamJs();
        QFilter orgAndCostCenterFilter = CalcCheckHelper.getOrgAndCostCenterFilter((JSONObject)checkParamJs);
        Object costObjectQf = null;
        ArrayList costObjectIds = null;
        if (checkParamJs.containsKey((Object)"costobjects") && checkParamJs.getJSONArray("costobjects") != null && checkParamJs.getJSONArray("costobjects").size() > 0) {
            costObjectIds = new ArrayList(checkParamJs.getJSONArray("costobjects"));
        }
        QFilter statusFilter = new QFilter("billstatus", "=", (Object)"C");
        QFilter appNumFilter = new QFilter("appnum", "=", (Object)"sca");
        Date[] periodDates = this.getPeriodStartAndEndTime(checkParamJs.getLong("period"));
        if (periodDates == null || periodDates.length != 2) {
            this.getSingleCheckContext().setPass(false);
            this.getSingleCheckContext().setCheckResult(ResManager.loadKDString((String)"\u672a\u627e\u5230\u671f\u95f4\u5f00\u59cb\u65e5\u671f\u7ed3\u675f\u65e5\u671f\u3002", (String)"ResourceFactedAbsorbCheckAction_0", (String)"macc-cad-business", (Object[])new Object[0]));
            return;
        }
        QFilter bookDateFilter = new QFilter("bookdate", ">=", (Object)periodDates[0]);
        bookDateFilter.and("bookdate", "<=", (Object)periodDates[1]);
        DataSet resourceDs = null;
        if (costObjectIds == null || costObjectIds.size() < 200000) {
            costObjectQf = costObjectIds == null ? null : new QFilter("entryentity.costobject", "in", costObjectIds);
            resourceDs = QueryServiceHelper.queryDataSet((String)"ResourceAb-Resource", (String)"sca_resourceuse", (String)"id,billno as resbillno,manuorg,costcenter,pricedate,bookdate,resource,workcenter,route,processseq,operationno,entryentity.material material,entryentity.auxpty auxpty", (QFilter[])new QFilter[]{orgAndCostCenterFilter, costObjectQf, statusFilter, appNumFilter, bookDateFilter}, null);
        } else {
            resourceDs = InFilterHelper.queryDataSetIn((String)"sca_resourceuse", (String)"id,billno as resbillno,manuorg,costcenter,pricedate,bookdate,resource,workcenter,route,processseq,operationno,entryentity.material material,entryentity.auxpty auxpty", (QFilter)this.getQFilterToArr(new QFilter[]{orgAndCostCenterFilter, statusFilter, appNumFilter, bookDateFilter}), (String)"entryentity.costobject", costObjectIds);
        }
        QFilter srcBillTypeFilter = new QFilter("srcbilltype", "=", (Object)"im_mdc_omcmplinbill");
        DataSet completionDs = null;
        if (costObjectIds == null || costObjectIds.size() < 200000) {
            costObjectQf = costObjectIds == null ? null : new QFilter("entryentity.costobject", "in", costObjectIds);
            completionDs = QueryServiceHelper.queryDataSet((String)"ResourceAb-WwCom", (String)"cad_factnedoutputbill", (String)"id,billno as facbillno,manuorg,costcenter,srcauditdate pricedate,bookdate,material,auxpty,configuredcode,tracknumber,project,lot", (QFilter[])new QFilter[]{orgAndCostCenterFilter, costObjectQf, statusFilter, appNumFilter, bookDateFilter, srcBillTypeFilter}, null);
        } else {
            completionDs = InFilterHelper.queryDataSetIn((String)"cad_factnedoutputbill", (String)"id,billno as facbillno,manuorg,costcenter,srcauditdate pricedate,bookdate,material,auxpty,configuredcode,tracknumber,project,lot", (QFilter)this.getQFilterToArr(new QFilter[]{orgAndCostCenterFilter, statusFilter, appNumFilter, bookDateFilter, srcBillTypeFilter}), (String)"entryentity.costobject", costObjectIds);
        }
        long costAccountId = checkParamJs.getLong("costaccount");
        long orgId = checkParamJs.getLong("org");
        long periodId = checkParamJs.getLong("period");
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter costAccountFilter = new QFilter("costaccount", "=", (Object)costAccountId);
        QFilter periodFilter = new QFilter("period", "=", (Object)periodId);
        DataSet resourceAbDs = null;
        if (costObjectIds == null || costObjectIds.size() < 200000) {
            costObjectQf = costObjectIds == null ? null : new QFilter("costobject", "in", costObjectIds);
            resourceAbDs = QueryServiceHelper.queryDataSet((String)"ResourceAb", (String)"sca_resourceabsorb", (String)"billno,costcenter abscostcenter,sourcetype,sourcebill srcId", (QFilter[])new QFilter[]{orgFilter, costAccountFilter, periodFilter, costObjectQf}, null);
        } else {
            resourceAbDs = InFilterHelper.queryDataSetIn((String)"sca_resourceabsorb", (String)"billno,costcenter abscostcenter,sourcetype,sourcebill srcId", (QFilter)this.getQFilterToArr(new QFilter[]{orgFilter, costAccountFilter, periodFilter}), (String)"costobject", costObjectIds);
        }
        DataSet resAbsDataSet = resourceAbDs.filter("sourcetype='R'");
        DataSet facAbsDataSet = resourceAbDs.filter("sourcetype='F'");
        DataSet resourceDs_Left = resourceDs.join(resAbsDataSet, JoinType.LEFT).on("id", "srcId").select(resourceDs.getRowMeta().getFieldNames(), new String[]{"billno", "abscostcenter"}).finish();
        DataSet resourceDs_Right = resourceDs.join(resAbsDataSet, JoinType.RIGHT).on("id", "srcId").select(new String[]{"billno", "abscostcenter"}, resourceDs.getRowMeta().getFieldNames()).finish();
        DataSet resNoGeneraAbsDs = resourceDs_Left.filter("billno is null");
        DataSet absNoResBillDs = resourceDs_Right.filter("id is null");
        DataSet factedDs_Left = completionDs.join(facAbsDataSet, JoinType.LEFT).on("id", "srcId").select(completionDs.getRowMeta().getFieldNames(), new String[]{"billno", "abscostcenter"}).finish();
        DataSet factedDs_Right = completionDs.join(facAbsDataSet, JoinType.RIGHT).on("id", "srcId").select(new String[]{"billno", "abscostcenter"}, completionDs.getRowMeta().getFieldNames()).finish();
        DataSet factNoGeneraAbsDs = factedDs_Left.filter("billno is null");
        DataSet absNoFactBillDs = factedDs_Right.filter("id is null");
        if (!resNoGeneraAbsDs.isEmpty()) {
            detailDesc = ResManager.loadKDString((String)"\u8d44\u6e90\u8017\u7528\u91cf\u5f52\u96c6\u5355\u201c%s\u201d\u672a\u751f\u6210\u8d39\u7528\u5438\u6536\u6210\u672c\u5355\u3002", (String)"ResourceFactedAbsorbCheckAction_1", (String)"macc-cad-business", (Object[])new Object[0]);
            manuOrgIds = new HashSet<Long>(10);
            Set<Long> resourceIds = this.getResourceManuOrgSet(resNoGeneraAbsDs.copy(), "resource", manuOrgIds);
            hsCostTypeByOrg = CostTypeHelper.getHsCostTypeByOrg((Long)this.getContext().getOrgId(), manuOrgIds);
            QFilter timeFilter = new QFilter("effectdate", "<=", (Object)periodDates[0]);
            timeFilter.and(new QFilter("expdate", "<=", (Object)periodDates[1]));
            HashSet costTypes = new HashSet(hsCostTypeByOrg.values());
            Map resourcePriceMap = ResourceAbsorbHelper.getResourceMap(costTypes, resourceIds, (QFilter)timeFilter);
            while (resNoGeneraAbsDs.hasNext()) {
                DynamicObject resourceByPriceRule;
                Row row2 = resNoGeneraAbsDs.next();
                Long manuorg = row2.getLong("manuorg");
                Long costType = (Long)hsCostTypeByOrg.get(manuorg);
                if (CadEmptyUtils.isEmpty((Long)costType) || (resourceByPriceRule = this.getResourceByPriceRule(costType, row2, resourcePriceMap)) == null) continue;
                CalcCheckDetailResultInfo info2 = new CalcCheckDetailResultInfo();
                info2.setCostCenter(row2.getLong("costcenter"));
                info2.setCheckDetailResult(String.format(detailDesc, row2.getString("resbillno")));
                this.getSingleCheckContext().getCheckDetailResult().add(info2);
            }
        }
        if (!factNoGeneraAbsDs.isEmpty()) {
            detailDesc = ResManager.loadKDString((String)"\u5b8c\u5de5\u4ea7\u91cf\u5f52\u96c6\u5355\u201c%s\u201d\u672a\u751f\u6210\u8d39\u7528\u5438\u6536\u6210\u672c\u5355\u3002", (String)"ResourceFactedAbsorbCheckAction_2", (String)"macc-cad-business", (Object[])new Object[0]);
            manuOrgIds = new HashSet(10);
            Set<Long> materialIds = this.getResourceManuOrgSet(factNoGeneraAbsDs.copy(), "material", manuOrgIds);
            hsCostTypeByOrg = CostTypeHelper.getHsCostTypeByOrg((Long)this.getContext().getOrgId(), manuOrgIds);
            Map<String, List<DynamicObject>> outSourcePriceMap = this.getOutSourcePriceMap(hsCostTypeByOrg, materialIds, periodDates);
            while (factNoGeneraAbsDs.hasNext()) {
                DynamicObject resourceByPriceRule;
                Row row3 = factNoGeneraAbsDs.next();
                Long manuorg = row3.getLong("manuorg");
                Long costType = (Long)hsCostTypeByOrg.get(manuorg);
                if (CadEmptyUtils.isEmpty((Long)costType) || (resourceByPriceRule = this.getOutSourceByPriceRule(costType, row3, outSourcePriceMap)) == null) continue;
                CalcCheckDetailResultInfo info3 = new CalcCheckDetailResultInfo();
                info3.setCostCenter(row3.getLong("costcenter"));
                info3.setCheckDetailResult(String.format(detailDesc, row3.getString("facbillno")));
                this.getSingleCheckContext().getCheckDetailResult().add(info3);
            }
        }
        if (!absNoResBillDs.isEmpty()) {
            detailDesc = ResManager.loadKDString((String)"\u8d39\u7528\u5438\u6536\u6210\u672c\u5355\u201c%s\u201d\u672a\u5339\u914d\u5230\u8d44\u6e90\u8017\u7528\u91cf\u5f52\u96c6\u5355\u3002", (String)"ResourceFactedAbsorbCheckAction_3", (String)"macc-cad-business", (Object[])new Object[0]);
            while (absNoResBillDs.hasNext()) {
                row = absNoResBillDs.next();
                info = new CalcCheckDetailResultInfo();
                info.setCostCenter(row.getLong("abscostcenter"));
                info.setCheckDetailResult(String.format(detailDesc, row.getString("billno")));
                this.getSingleCheckContext().getCheckDetailResult().add(info);
            }
        }
        if (!absNoFactBillDs.isEmpty()) {
            detailDesc = ResManager.loadKDString((String)"\u8d39\u7528\u5438\u6536\u6210\u672c\u5355\u201c%s\u201d\u672a\u5339\u914d\u5230\u5b8c\u5de5\u4ea7\u91cf\u5f52\u96c6\u5355\u3002", (String)"ResourceFactedAbsorbCheckAction_4", (String)"macc-cad-business", (Object[])new Object[0]);
            while (absNoFactBillDs.hasNext()) {
                row = absNoFactBillDs.next();
                info = new CalcCheckDetailResultInfo();
                info.setCostCenter(row.getLong("abscostcenter"));
                info.setCheckDetailResult(String.format(detailDesc, row.getString("billno")));
                this.getSingleCheckContext().getCheckDetailResult().add(info);
            }
        }
        if (CadEmptyUtils.isEmpty((List)this.getSingleCheckContext().getCheckDetailResult())) {
            return;
        }
        String checkDesc = ResManager.loadKDString((String)"\u5f53\u671f\u8d39\u7528\u5438\u6536\u6210\u672c\u5355\u6570\u636e\u5b58\u5728\u5dee\u5f02\u3002", (String)"ResourceFactedAbsorbCheckAction_5", (String)"macc-cad-business", (Object[])new Object[0]);
        this.getSingleCheckContext().setCheckResult(checkDesc);
        this.getSingleCheckContext().setPass(false);
    }

    private Set<Long> getResourceManuOrgSet(DataSet ds, String pro, Set<Long> manuOrgIds) {
        HashSet<Long> propLongSet = new HashSet<Long>(32);
        for (Row row : ds) {
            Long manuorg;
            Long propLong = row.getLong(pro);
            if (!CadEmptyUtils.isEmpty((Long)propLong)) {
                propLongSet.add(propLong);
            }
            if (CadEmptyUtils.isEmpty((Long)(manuorg = row.getLong("manuorg")))) continue;
            manuOrgIds.add(manuorg);
        }
        return propLongSet;
    }

    private Map<String, List<DynamicObject>> getOutSourcePriceMap(Map<Long, Long> hsCostTypeByOrg, Set<Long> materialIds, Date[] periodDates) {
        DynamicObject[] dynamicObjects;
        QFilter filter = new QFilter("costtype", "in", hsCostTypeByOrg.values());
        filter.and(new QFilter("material", "in", materialIds));
        QFilter timeFilter = new QFilter("effectdate", "<=", (Object)periodDates[0]);
        timeFilter.and(new QFilter("expdate", "<=", (Object)periodDates[1]));
        HashMap<String, List<DynamicObject>> resourceMap = new HashMap<String, List<DynamicObject>>(16);
        for (DynamicObject dynamicObject : dynamicObjects = BusinessDataServiceHelper.load((String)"cad_outsourceprice", (String)"billno,costtype,material,auxpty,configuredcode,tracknumber,project,lot,effectdate,expdate", (QFilter[])new QFilter[]{filter})) {
            String key = dynamicObject.getLong("costtype.id") + "@" + dynamicObject.getLong("material.id") + "@" + dynamicObject.getLong("auxpty.id") + "@" + dynamicObject.getLong("configuredcode.id") + "@" + dynamicObject.getLong("tracknumber.id") + "@" + dynamicObject.getLong("project.id") + "@" + dynamicObject.getString("lot");
            logger.info("\u8d44\u6e90\u8017\u7528\u91cf\u5f52\u96c6_\u83b7\u53d6\u81ea\u5236\u8d44\u6e90\u5bf9\u5e94key\u4e3a==>{}", (Object)key);
            resourceMap.computeIfAbsent(key, s -> new ArrayList()).add(dynamicObject);
        }
        return resourceMap;
    }

    private DynamicObject getOutSourceByPriceRule(Long costType, Row dynamicObject, Map<String, List<DynamicObject>> resultMap) {
        DynamicObject resourceObj;
        long material = dynamicObject.getLong("material");
        long auxpty = dynamicObject.getLong("auxpty");
        long configuredcode = dynamicObject.getLong("configuredcode");
        long tracknumber = dynamicObject.getLong("tracknumber");
        long project = dynamicObject.getLong("project");
        String lot = dynamicObject.getString("lot");
        String key = costType + "@" + material + "@" + auxpty + "@" + configuredcode + "@" + tracknumber + "@" + project + "@" + lot;
        if (resultMap.get(key) != null && (resourceObj = this.filterByTime(dynamicObject, resultMap.get(key))) != null) {
            return resourceObj;
        }
        return null;
    }

    private DynamicObject getResourceByPriceRule(Long costType, Row dynamicObject, Map<String, List<DynamicObject>> resultMap) {
        DynamicObject resourceObj;
        long workCenter = dynamicObject.get("workcenter") instanceof DynamicObject ? dynamicObject.getLong("workcenter.id") : dynamicObject.getLong("workcenter");
        long resource = dynamicObject.get("resource") instanceof DynamicObject ? dynamicObject.getLong("resource.id") : dynamicObject.getLong("resource");
        long route = dynamicObject.get("route") instanceof DynamicObject ? dynamicObject.getLong("route.id") : dynamicObject.getLong("route");
        String processseq = dynamicObject.getString("processseq");
        String operationno = dynamicObject.getString("operationno");
        String key = "zz@" + costType + "@" + resource + "@" + workCenter;
        if (resultMap.get(key) != null && (resourceObj = this.filterByTime(dynamicObject, resultMap.get(key))) != null) {
            return resourceObj;
        }
        key = "zz@" + costType + "@" + resource + "@" + 0;
        if (resultMap.get(key) != null && (resourceObj = this.filterByTime(dynamicObject, resultMap.get(key))) != null) {
            return resourceObj;
        }
        key = "wx@" + costType + "@" + resource + "@" + route + "@" + processseq + "@" + operationno;
        if (resultMap.get(key) != null && (resourceObj = this.filterByTime(dynamicObject, resultMap.get(key))) != null) {
            return resourceObj;
        }
        return null;
    }

    private DynamicObject filterByTime(Row targetObj, List<DynamicObject> matchObj) {
        Date matchDate = targetObj.getDate("pricedate") == null ? targetObj.getDate("bookdate") : targetObj.getDate("pricedate");
        for (DynamicObject dynamicObject : matchObj) {
            Date effectDate = dynamicObject.getDate("effectdate");
            Date expDate = dynamicObject.getDate("expdate");
            if (effectDate.compareTo(matchDate) > 0 || expDate.compareTo(matchDate) <= 0) continue;
            return dynamicObject;
        }
        return null;
    }
}

