/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.business.check;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.check.AbstractSingleCalcCheckAction;
import kd.macc.cad.common.check.CalcCheckDetailResultInfo;
import kd.macc.cad.common.check.CalcCheckHelper;
import kd.macc.cad.common.dto.ResourcePriceDto;
import kd.macc.cad.common.helper.CostTypeHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class ResourcePriceCheckAction
extends AbstractSingleCalcCheckAction {
    public void doCheck() {
        JSONObject checkParamJs = this.getContext().getCheckParamJs();
        Map<ResourcePriceDto, String> sourceInfos = this.getResourceUseId(checkParamJs);
        Long costTypeId = this.getCostType(checkParamJs);
        if (CadEmptyUtils.isEmpty((Long)costTypeId)) {
            this.getSingleCheckContext().setPass(false);
            this.getSingleCheckContext().setCheckResult(ResManager.loadKDString((String)"\u672a\u627e\u5230\u6210\u672c\u7c7b\u578b\u3002", (String)"ResourcePriceCheckAction_3", (String)"macc-cad-business", (Object[])new Object[0]));
            return;
        }
        this.getResourcePrice(costTypeId, sourceInfos);
        DynamicObject costType = BusinessDataServiceHelper.loadSingleFromCache((String)"cad_costtype", (String)"number,name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)costTypeId)});
        for (Map.Entry<ResourcePriceDto, String> entry : sourceInfos.entrySet()) {
            String detailErroDesc = ResManager.loadKDString((String)"\u8d44\u6e90\u201c\u7f16\u7801\uff1a%1$s\uff0c\u540d\u79f0\uff1a%2$s\u201d\u5728\u6210\u672c\u7c7b\u578b\u201c\u7f16\u7801\uff1a%3$s\uff0c\u540d\u79f0\uff1a%4$s\u201d\u4e0b\uff0c\u672a\u7ef4\u62a4\u81ea\u5236/\u5916\u534f\u8d44\u6e90\u6807\u51c6\u8d39\u7387\u4ef7\u76ee\u8868\u3002", (String)"ResourcePriceCheckAction_4", (String)"macc-cad-business", (Object[])new Object[0]);
            String[] resourceInfos = entry.getValue().split("@");
            CalcCheckDetailResultInfo info = new CalcCheckDetailResultInfo();
            info.setCostCenter(Long.valueOf(Long.parseLong(resourceInfos[2])));
            info.setCheckDetailResult(String.format(detailErroDesc, resourceInfos[0], resourceInfos[1], costType.getString("number"), costType.getString("name")));
            this.getSingleCheckContext().getCheckDetailResult().add(info);
        }
        String checkDesc = ResManager.loadKDString((String)"\u5b58\u5728\u8d44\u6e90\u6709\u8d44\u6e90\u8017\u7528\u5f52\u96c6\uff0c\u4f46\u662f\u6ca1\u6709\u8bbe\u7f6e\u81ea\u5236/\u5916\u534f\u8d44\u6e90\u6807\u51c6\u8d39\u7387\u4ef7\u76ee\u8868\u3002", (String)"ResourcePriceCheckAction_5", (String)"macc-cad-business", (Object[])new Object[0]);
        if (!CadEmptyUtils.isEmpty(sourceInfos)) {
            this.getSingleCheckContext().setPass(false);
        }
        this.getSingleCheckContext().setCheckResult(checkDesc);
    }

    private Long getCostType(JSONObject checkParamJs) {
        Long costTypeId = 0L;
        if (checkParamJs.containsKey((Object)"manuOrgIds") && checkParamJs.getJSONArray("manuOrgIds").size() > 0) {
            JSONArray manuOrgIds = checkParamJs.getJSONArray("manuOrgIds");
            for (Long manuorg : manuOrgIds) {
                costTypeId = CostTypeHelper.getCostTypeIdByManuOrgIdFromCal((Long)checkParamJs.getLong("costaccount"), (Long)checkParamJs.getLong("org"), (Long)manuorg);
            }
            return costTypeId;
        }
        return CostTypeHelper.getCostTypeIdByManuOrgIdFromCal((Long)checkParamJs.getLong("costaccount"), (Long)checkParamJs.getLong("org"), null);
    }

    private Map<ResourcePriceDto, String> getResourceUseId(JSONObject checkParamJs) {
        HashMap<ResourcePriceDto, String> resourcesMap = new HashMap<ResourcePriceDto, String>(16);
        QFilter orgAndCostCenterFilter = CalcCheckHelper.getOrgAndCostCenterFilter((JSONObject)checkParamJs);
        QFilter statusFilter = new QFilter("billstatus", "=", (Object)"C");
        QFilter appnumFilter = new QFilter("appnum", "=", (Object)"sca");
        QFilter resourceFilter = new QFilter("resource", ">", (Object)0);
        Object[] periodDates = this.getPeriodStartAndEndTime(checkParamJs.getLong("period"));
        if (!CadEmptyUtils.isEmpty((Object[])periodDates)) {
            QFilter bizDateFilter = new QFilter("bookdate", "<=", periodDates[1]);
            bizDateFilter.and(new QFilter("bookdate", ">=", periodDates[0]));
            orgAndCostCenterFilter.and(this.getCheckCostobjectQFilter(this.getContext(), "entryentity.costobject"));
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"kd.macc.cad.algox.check.checkitem.ResourcePriceCheckAction.getResourceUseId", (String)"sca_resourceuse", (String)"id,resource.masterid AS resourceid, resource.number AS resnumber, resource.name AS resname, costcenter, pricedate", (QFilter[])new QFilter[]{orgAndCostCenterFilter, statusFilter, appnumFilter, bizDateFilter, resourceFilter}, null);){
                while (dataSet.hasNext()) {
                    ResourcePriceDto resourcePriceDto;
                    Row row = dataSet.next();
                    long resourceId = row.getLong("resourceid");
                    Date priceDate = row.getDate("pricedate");
                    if (CadEmptyUtils.isEmpty((Long)resourceId) || priceDate == null || resourcesMap.containsKey(resourcePriceDto = new ResourcePriceDto(Long.valueOf(resourceId), priceDate))) continue;
                    String resuorceInfos = row.getString("resnumber") + "@" + row.getString("resname") + "@" + row.getString("costcenter");
                    resourcesMap.put(resourcePriceDto, resuorceInfos);
                }
            }
        }
        return resourcesMap;
    }

    private void getResourcePrice(Long costTypeId, Map<ResourcePriceDto, String> sourceInfos) {
        if (CadEmptyUtils.isEmpty((Long)costTypeId) || CadEmptyUtils.isEmpty(sourceInfos)) {
            return;
        }
        HashSet<Long> resourceIds = new HashSet<Long>(32);
        for (Map.Entry<ResourcePriceDto, String> resourcePriceInfoEntry : sourceInfos.entrySet()) {
            ResourcePriceDto resourcePriceDto = resourcePriceInfoEntry.getKey();
            Long resource = resourcePriceDto.getResource();
            if (CadEmptyUtils.isEmpty((Long)resource)) continue;
            resourceIds.add(resource);
        }
        this.getSelfPurchasePrice(costTypeId, sourceInfos, resourceIds, "cad_resourcerate");
        this.getSelfPurchasePrice(costTypeId, sourceInfos, resourceIds, "cad_resourceout");
    }

    private void getSelfPurchasePrice(Long costTypeId, Map<ResourcePriceDto, String> sourceInfos, Set<Long> resourceIds, String entity) {
        if (CadEmptyUtils.isEmpty((Long)costTypeId) || CadEmptyUtils.isEmpty(sourceInfos)) {
            return;
        }
        if (!CadEmptyUtils.isEmpty(resourceIds)) {
            QFilter filter = new QFilter("costtype", "=", (Object)costTypeId);
            filter.and(new QFilter("resource.masterid", "in", resourceIds));
            filter.and(new QFilter("billstatus", "=", (Object)"C"));
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"kd.macc.cad.algox.check.checkitem.ResourcePriceCheckAction.getResourcePrice", (String)entity, (String)"resource.masterid AS resourceid,effectdate,expdate", (QFilter[])new QFilter[]{filter}, null);){
                while (dataSet.hasNext()) {
                    Row row = dataSet.next();
                    Long resourceId = row.getLong("resourceid");
                    Date effectDate = row.getDate("effectdate");
                    Date expDate = row.getDate("expdate");
                    if (CadEmptyUtils.isEmpty((Long)resourceId) || effectDate == null || expDate == null) continue;
                    Iterator<ResourcePriceDto> iterator = sourceInfos.keySet().iterator();
                    while (iterator.hasNext()) {
                        boolean isEffective;
                        ResourcePriceDto resourcePriceDto = iterator.next();
                        Long resource = resourcePriceDto.getResource();
                        Date priceDate = resourcePriceDto.getPriceDate();
                        if (CadEmptyUtils.isEmpty((Long)resource) || priceDate == null) continue;
                        boolean bl = isEffective = priceDate.after(effectDate) && priceDate.before(expDate);
                        if (resourceId.compareTo(resource) != 0 || !isEffective) continue;
                        iterator.remove();
                    }
                }
            }
        }
    }
}

