/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.business.config.engine;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.macc.cad.business.config.engine.BillTransferResult;
import kd.macc.cad.business.config.engine.CollConifgContext;
import kd.macc.cad.business.config.engine.IBillTransfer;
import kd.macc.cad.business.config.service.CostConfigService;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public abstract class AbstractBillTransfer
implements IBillTransfer {
    protected CollConifgContext context;
    protected DynamicObject collConfig;
    protected String calMethod;
    protected String entryEntity;
    protected Map<Long, DynamicObject> srcIdTargetBillMap = Maps.newHashMap();
    protected DynamicObjectCollection fieldMappingEntryColl;
    protected DynamicObjectCollection ruleMappingEntryColl;
    protected Map<String, Set<String>> formulaFieldMap;
    protected Map<String, String> costCenterTypeAndSourceFieldMap = Maps.newHashMap();
    protected Map<Object, DynamicObject> periodIdMap = Maps.newHashMap();

    @Override
    public BillTransferResult doTransfer(DynamicObject[] bizBills, DynamicObject collConfigDyo, CollConifgContext context) {
        this.context = context;
        this.collConfig = collConfigDyo;
        this.calMethod = this.collConfig.getString("calmethod");
        this.fieldMappingEntryColl = collConfigDyo.getDynamicObjectCollection("fieldmapentity");
        this.ruleMappingEntryColl = collConfigDyo.getDynamicObjectCollection("costruleinfoentity");
        this.formulaFieldMap = CostConfigService.getFormulaFieldMap(this.collConfig);
        DynamicObject currentPeriodType = PeriodHelper.getCurrentPeriodType((Long)context.getParam().getCostAccountId());
        if (currentPeriodType != null) {
            Long periodType = Long.parseLong(currentPeriodType.getPkValue().toString());
            QFilter qFilter = new QFilter("periodtype.id", "=", (Object)periodType);
            this.periodIdMap = BusinessDataServiceHelper.loadFromCache((String)"bd_period", (QFilter[])qFilter.toArray());
        }
        this.setEntryEntity();
        BillTransferResult result = new BillTransferResult();
        for (DynamicObject bill : bizBills) {
            if (bill == null) continue;
            this.doTransfer(bill, result);
        }
        this.doTransferAfter(result);
        return result;
    }

    protected abstract void doTransfer(DynamicObject var1, BillTransferResult var2);

    protected void doTransferAfter(BillTransferResult result) {
    }

    private void setEntryEntity() {
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)this.fieldMappingEntryColl)) {
            return;
        }
        for (DynamicObject field : this.fieldMappingEntryColl) {
            String costField = field.getString("costfield");
            String sourceField = field.getString("sourcefield");
            if (!CadEmptyUtils.isEmpty((String)sourceField) && sourceField.contains(".")) {
                this.entryEntity = sourceField.split("\\.")[0];
            }
            if ("costcenter".equals(costField)) {
                String[] splits;
                for (String split : splits = sourceField.split(",")) {
                    if (ImportServiceHelper.workCenterFields.contains(split)) {
                        this.costCenterTypeAndSourceFieldMap.put(split, "mpdm_workcentre");
                        continue;
                    }
                    if (ImportServiceHelper.adminOrgFields.contains(split)) {
                        this.costCenterTypeAndSourceFieldMap.put(split, "bos_adminorg");
                        continue;
                    }
                    if (!ImportServiceHelper.orgFields.contains(split)) continue;
                    this.costCenterTypeAndSourceFieldMap.put(split, "bos_org");
                }
            }
            if (CadEmptyUtils.isEmpty((String)this.entryEntity) || CadEmptyUtils.isEmpty(this.costCenterTypeAndSourceFieldMap)) continue;
            break;
        }
    }
}

