/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.business.config.engine;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.business.config.costcenter.CostCenterRelationService;
import kd.macc.cad.business.config.engine.BillTransferResult;
import kd.macc.cad.business.config.engine.CollConifgContext;
import kd.macc.cad.business.config.engine.CollConifgParam;
import kd.macc.cad.business.config.engine.IBillTransfer;
import kd.macc.cad.business.config.engine.TransferResult;
import kd.macc.cad.business.config.engine.filter.CollConfigFilterService;
import kd.macc.cad.business.config.engine.formula.CollConfigFormulaService;
import kd.macc.cad.business.config.engine.helper.CollectEngineHelper;
import kd.macc.cad.business.config.engine.mapping.CollConfigMappingService;
import kd.macc.cad.business.config.service.CommonCollConfigService;
import kd.macc.cad.common.dto.CollectReport;
import kd.macc.cad.common.helper.AccountViewHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.MfgfeeBillImportHelper;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.helper.SysParamHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.MaterialPropHelper;

public class CollConfigEngine {
    private static final Log logger = LogFactory.getLog(CollConfigEngine.class);
    private CollConfigFilterService filterService;
    private CollConfigFormulaService formulaService;
    private CollConfigMappingService mappingService;
    private CostCenterRelationService costCenterRelationService;
    private List<DynamicObject> collConfigList;
    private CollConifgContext context;
    private Map<String, DynamicObject> rulesMap;

    private CollConfigEngine() {
    }

    public static CollConfigEngine buildEngine(Long calOrgId, Long costAccountId, Long curPeriodId, Long[] manuOrgIds, Long[] costCenterIds, String targetEntityType, Map<String, DynamicObject> rulesMap, String appnum) {
        CollConfigEngine engine = new CollConfigEngine();
        engine.filterService = new CollConfigFilterService();
        engine.formulaService = new CollConfigFormulaService();
        engine.mappingService = new CollConfigMappingService();
        engine.costCenterRelationService = new CostCenterRelationService();
        engine.rulesMap = rulesMap;
        engine.context = new CollConifgContext();
        CollConifgParam param = new CollConifgParam();
        param.setAppnum(appnum);
        param.setCalOrgId(calOrgId);
        param.setCostAccountId(costAccountId);
        param.setCurPeriodId(curPeriodId);
        param.setManuOrgIds(manuOrgIds);
        param.setCostCenterIds(costCenterIds);
        param.setTargetEntity(targetEntityType);
        engine.context.setParam(param);
        return engine;
    }

    public List<DynamicObject> getValidCollConfigList(Set<Long> allCollConfigIds) {
        if (this.collConfigList != null && this.collConfigList.size() > 0) {
            return this.collConfigList;
        }
        ArrayList<DynamicObject> values = new ArrayList<DynamicObject>(this.rulesMap.values());
        HashSet<Long> calcDimensionIds = new HashSet<Long>(10);
        values.forEach(p -> calcDimensionIds.add(p.getLong("costcalcdimension")));
        return CommonCollConfigService.getCollConfigs(this.context.getParam().getCalOrgId(), this.context.getParam().getCostAccountId(), calcDimensionIds, this.context.getParam().getTargetEntity(), this.context.getParam().getAppnum(), allCollConfigIds);
    }

    public TransferResult getTargetDynamicObject(CollectReport collectReport, List<Long> mftOrderEntryIds, Map<String, Object> collectParamMap) {
        return this.getTargetDynamicObject(collectReport, mftOrderEntryIds, collectParamMap, null);
    }

    public TransferResult getTargetDynamicObject(CollectReport collectReport, List<Long> mftOrderEntryIds, Map<String, Object> collectParamMap, Set<Long> allCollConfigIds) {
        Map<Long, Map<String, String>> collConfigRuleMappingMap;
        Map<Long, Map<String, String>> collSelectValueMappingMap;
        TransferResult transferResult = new TransferResult();
        this.collConfigList = this.getValidCollConfigList(allCollConfigIds);
        if (CadEmptyUtils.isEmpty(this.collConfigList)) {
            return transferResult;
        }
        Map<Long, Map<String, String>> collConfigMappingMap = this.mappingService.getCollConfigMappingMap(this.collConfigList);
        Map<DynamicObject, List<DynamicObject>> srcDynamicObjectMap = this.getSrcDynamicObjectList(collConfigMappingMap, collSelectValueMappingMap = this.mappingService.getCollSelectValueMappingMap(this.collConfigList), collConfigRuleMappingMap = this.mappingService.getCollConfigRuleMappingMap(this.collConfigList), collectReport, mftOrderEntryIds, collectParamMap);
        if (CadEmptyUtils.isEmpty(srcDynamicObjectMap)) {
            return transferResult;
        }
        IBillTransfer billTransfer = IBillTransfer.getTransferInstance(this.context.getParam().getTargetEntity(), this.context.getParam().getAppnum());
        for (Map.Entry<DynamicObject, List<DynamicObject>> srcDynamicObject : srcDynamicObjectMap.entrySet()) {
            DynamicObject config = srcDynamicObject.getKey();
            List<DynamicObject> resResults = srcDynamicObject.getValue();
            if (CadEmptyUtils.isEmpty(resResults)) {
                transferResult.getConfigSrcAndTargetBillMap().computeIfAbsent(config, p -> new HashMap());
                continue;
            }
            List listList = Lists.partition(resResults, (int)10000);
            for (List list : listList) {
                BillTransferResult result = billTransfer.doTransfer(list.toArray(new DynamicObject[0]), config, this.context);
                transferResult.getConfigSrcAndTargetBillMap().computeIfAbsent(config, p -> new HashMap()).putAll(result.getSrcAndTargetBillsMap());
            }
        }
        transferResult.getCollConfigMappingMap().putAll(collConfigMappingMap);
        transferResult.getCollConfigRuleMappingMap().putAll(collConfigRuleMappingMap);
        return transferResult;
    }

    public Map<DynamicObject, List<DynamicObject>> getSrcDynamicObjectList(Map<Long, Map<String, String>> collConfigMappingMap, Map<Long, Map<String, String>> collSelectValueMappingMap, Map<Long, Map<String, String>> collConfigRuleMappingMap, CollectReport collectReport, List<Long> mftOrderEntryIds, Map<String, Object> collectParamMap) {
        HashMap<DynamicObject, List<DynamicObject>> resultMap = new HashMap<DynamicObject, List<DynamicObject>>(16);
        Map<Long, List<QFilter>> collConfigFilterMap = this.filterService.getCollConfigFilterMap(this.collConfigList);
        List importScopeDate = SysParamHelper.getImportScopeDate((Long)this.context.getParam().getCalOrgId(), (String)this.context.getParam().getAppnum());
        Map<String, List<DynamicObject>> costCenterSourceDataMap = this.costCenterRelationService.getCostCenterSourceDataMap(this.context.getParam().getCostCenterIds(), importScopeDate);
        this.context.setCostCenterSourceDataMap(costCenterSourceDataMap);
        HashMap costCentersourceTypeDataMap = new HashMap(16);
        costCenterSourceDataMap.forEach((ccs, obj) -> {
            String[] srcDataStr = ccs.split("@");
            if (srcDataStr.length < 2) {
                return;
            }
            String sourceType = srcDataStr[0];
            Long sourceData = Long.parseLong(srcDataStr[1]);
            costCentersourceTypeDataMap.computeIfAbsent(sourceType, p -> new HashSet(10)).add(sourceData);
        });
        Boolean isOldUserForSysParamBizRange = ImportServiceHelper.isOldUserForSysParamBizRange();
        Map<String, List<Long>> billRangeMap = isOldUserForSysParamBizRange != false ? this.getBillRangeMap(this.context.getParam().getCalOrgId(), Arrays.asList(this.context.getParam().getCostCenterIds()), this.context.getParam().getTargetEntity(), this.context.getParam().getAppnum(), collectReport) : null;
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"cad_mfgfeebill");
        this.collConfigList.forEach(config -> {
            String selectFields;
            long configId = config.getLong("id");
            String targetBillEntity = config.getString("costbill.id");
            String sourceBillEntity = config.getString("sourcebill.id");
            Map fieldMappingMap = (Map)collConfigMappingMap.get(configId);
            Map selectValueMappingMap = (Map)collSelectValueMappingMap.get(configId);
            Map ruleMappingMap = (Map)collConfigRuleMappingMap.get(configId);
            if (isOldUserForSysParamBizRange.booleanValue() && billRangeMap != null && !billRangeMap.containsKey("norange")) {
                if (!billRangeMap.containsKey(sourceBillEntity)) {
                    logger.info("\u6e90\u5355\uff1a\u3010" + sourceBillEntity + "\u3011\uff0c\u4e0d\u5728\u76ee\u6807\u5355\u3010" + targetBillEntity + "\u3011\u8bbe\u7f6e\u7684\u5f52\u96c6\u5355\u636e\u8303\u56f4\u5185");
                    return;
                }
                List ccsIds = (List)billRangeMap.get(sourceBillEntity);
                if (CadEmptyUtils.isEmpty((List)ccsIds)) {
                    logger.info("\u6e90\u5355\uff1a\u3010" + sourceBillEntity + "\u3011\uff0c\u76ee\u6807\u5355\u3010" + targetBillEntity + "\u3011\uff0c\u6ca1\u6709\u9700\u8981\u5f52\u96c6\u7684\u6210\u672c\u4e2d\u5fc3");
                    return;
                }
                this.context.getParam().setCostCenterIds(ccsIds.toArray(new Long[0]));
            }
            List collConfigFilter = ImportServiceHelper.getSrcQFilters((Long)this.context.getParam().getCalOrgId(), Arrays.asList(this.context.getParam().getCostCenterIds()), this.context.getParam().getManuOrgIds() == null ? null : Arrays.asList(this.context.getParam().getManuOrgIds()), (DynamicObject)config, (Map)collConfigFilterMap, (Map)fieldMappingMap, (Map)selectValueMappingMap, (Map)costCentersourceTypeDataMap, (List)mftOrderEntryIds, (Map)collectParamMap, (Long)this.context.getParam().getCostAccountId(), (Long)this.context.getParam().getCurPeriodId(), (String)this.context.getParam().getAppnum(), this.context.getConfigProEntryIdWorkCenterMap(), (CollectReport)collectReport);
            if ("cad_mfgfeebill".equals(targetBillEntity)) {
                DynamicObject costAcount;
                long orgId;
                if ("gl_voucher".equals(sourceBillEntity)) {
                    DynamicObject accountBook = config.getDynamicObject("accountbook");
                    orgId = accountBook == null ? 0L : accountBook.getLong("org.id");
                    QFilter mfgVouCherQF = new QFilter("org", "in", (Object)orgId);
                    HashSet<Long> origAccountViewIds = new HashSet<Long>(16);
                    DynamicObjectCollection collection = config.getDynamicObjectCollection("accountviews");
                    for (DynamicObject dynamicObject : collection) {
                        origAccountViewIds.add(dynamicObject.getDynamicObject("fbasedataid").getLong("id"));
                    }
                    DynamicObject currentPeriod = PeriodHelper.getCurrentPeriod((Long)this.context.getParam().getCostAccountId());
                    Long currPeriodId = currentPeriod == null ? 0L : currentPeriod.getLong("id");
                    Set transAccountViewIds = MfgfeeBillImportHelper.tranAccountViewIds(origAccountViewIds, (Long)currPeriodId);
                    Set leafAccountViewIds = AccountViewHelper.getLeafAccountViewByIds((Set)transAccountViewIds);
                    logger.info("\u539f\u79d1\u76ee==>{},\u67e5\u8be2\u5230\u7684\u53f6\u5b50\u8282\u70b9\u79d1\u76ee==>{}", (Object)transAccountViewIds, (Object)leafAccountViewIds);
                    for (Map.Entry entry : fieldMappingMap.entrySet()) {
                        if (!"entries.assgrp".equals(entry.getValue())) continue;
                        if ("lot".equals(entry.getKey())) {
                            this.context.getFieldEntityMap().put((String)entry.getKey(), "bd_lot");
                            continue;
                        }
                        IDataEntityProperty property = dataEntityType.findProperty((String)entry.getKey());
                        if (!(property instanceof BasedataProp)) continue;
                        String baseEntityId = ((BasedataProp)property).getBaseEntityId();
                        this.context.getFieldEntityMap().put((String)entry.getKey(), baseEntityId);
                    }
                    HashSet entityNumSet = new HashSet(16);
                    QFilter accFilter = new QFilter("id", "in", (Object)leafAccountViewIds);
                    DataSet viewAsstactitemDs = QueryServiceHelper.queryDataSet((String)"getAccountViewAsstactitem", (String)"bd_accountview", (String)"checkitementry.asstactitem.valuetype as valuetype,checkitementry.asstactitem.valuesource.number AS entityNum", (QFilter[])new QFilter[]{accFilter}, null);
                    viewAsstactitemDs.forEach(s -> {
                        String valueType = s.getString("valuetype");
                        if ("2".equals(valueType)) {
                            entityNumSet.add("bos_assistantdata_detail");
                        } else {
                            entityNumSet.add(s.getString("entityNum"));
                        }
                    });
                    Map flexFieldMap = MfgfeeBillImportHelper.getFlexFieldMap((String[])entityNumSet.toArray(new String[0]));
                    this.context.getFlexFieldMap().putAll(flexFieldMap);
                    mfgVouCherQF.and(new QFilter("entries.account", "in", (Object)leafAccountViewIds));
                    mfgVouCherQF.and(new QFilter("period.id", "=", (Object)currPeriodId));
                    collConfigFilter.add(mfgVouCherQF);
                } else if ("ap_finapbill".equals(sourceBillEntity)) {
                    costAcount = config.getDynamicObject("costaccount");
                    orgId = costAcount == null ? 0L : costAcount.getLong("calorg.id");
                    QFilter mfgVouCherQF = new QFilter("org", "in", (Object)orgId);
                    String srcDataType = config.getString("srcdatatype");
                    if ("processfee".equals(srcDataType)) {
                        mfgVouCherQF.and("detailentry.expenseitem", "=", (Object)0L);
                    } else if ("freightfee".equals(srcDataType)) {
                        mfgVouCherQF.and("detailentry.expenseitem", "!=", (Object)0L);
                    }
                    collConfigFilter.add(mfgVouCherQF);
                } else if ("ap_busbill".equals(sourceBillEntity)) {
                    costAcount = config.getDynamicObject("costaccount");
                    orgId = costAcount == null ? 0L : costAcount.getLong("calorg.id");
                    QFilter mfgVouCherQF = new QFilter("org", "in", (Object)orgId);
                    String srcDataType = config.getString("srcdatatype");
                    if ("processfee".equals(srcDataType)) {
                        mfgVouCherQF.and("entry.e_expenseitem", "=", (Object)0L);
                    } else if ("freightfee".equals(srcDataType)) {
                        mfgVouCherQF.and("entry.e_expenseitem", "!=", (Object)0L);
                    }
                    collConfigFilter.add(mfgVouCherQF);
                }
            }
            if (CadEmptyUtils.isEmpty((String)(selectFields = CollectEngineHelper.getSrcSelectFields(config, fieldMappingMap, ruleMappingMap)))) {
                return;
            }
            logger.info("\u67e5\u8be2\u6e90\u5355\u8fc7\u6ee4\u6761\u4ef6\uff1a{}", (Object)collConfigFilter);
            DynamicObjectCollection resResults = QueryServiceHelper.query((String)sourceBillEntity, (String)selectFields, (QFilter[])collConfigFilter.toArray(new QFilter[0]));
            MaterialPropHelper.queryMaterialPropAndSet((DynamicObjectCollection)resResults, (String)selectFields);
            resultMap.computeIfAbsent((DynamicObject)config, cf -> new ArrayList()).addAll(resResults);
        });
        this.context.setOldUser(isOldUserForSysParamBizRange);
        this.context.setBillRangeMap(billRangeMap);
        return resultMap;
    }

    private Map<String, List<Long>> getBillRangeMap(Long accountOrg, List<Long> costCenters, String targetEntity, String appNum, CollectReport collectReport) {
        Map<String, List<Long>> billRangeMap = new HashMap<String, List<Long>>(16);
        if (CadEmptyUtils.isEmpty((String)targetEntity)) {
            return billRangeMap;
        }
        switch (targetEntity) {
            case "cad_plannedoutputbill": {
                if ("aca".equals(appNum)) {
                    billRangeMap = ImportServiceHelper.getInnerSys((Long)accountOrg, costCenters, (String)"plancollectrange", (String)appNum, (CollectReport)collectReport);
                    break;
                }
                billRangeMap.put("norange", new ArrayList());
                break;
            }
            case "cad_factnedoutputbill": {
                billRangeMap = ImportServiceHelper.getInnerSys((Long)accountOrg, costCenters, (String)"billrange", (String)appNum, (CollectReport)collectReport);
                break;
            }
            case "sca_matusecollect": 
            case "aca_matusecollect": {
                billRangeMap = ImportServiceHelper.getInnerSys((Long)accountOrg, costCenters, (String)"matcollectrange", (String)appNum, (CollectReport)collectReport);
                break;
            }
            case "sca_resourceuse": {
                billRangeMap = ImportServiceHelper.getInnerSys((Long)accountOrg, costCenters, (String)"resourcerange", (String)appNum, (CollectReport)collectReport);
                break;
            }
            default: {
                billRangeMap.put("norange", new ArrayList());
            }
        }
        return billRangeMap;
    }
}

