/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.business.config.engine;

import kd.bos.dataentity.entity.DynamicObject;
import kd.macc.cad.business.config.engine.AbstractBillTransfer;
import kd.macc.cad.business.config.engine.BillTransferResult;
import kd.macc.cad.business.config.engine.CollConifgContext;
import kd.macc.cad.business.config.transfer.CostObjectTransfer;
import kd.macc.cad.business.config.transfer.DiyCostDriverTransfer;
import kd.macc.cad.business.config.transfer.FactOutPutTransfer;
import kd.macc.cad.business.config.transfer.MatAllocTransfer;
import kd.macc.cad.business.config.transfer.MatUseTransfer;
import kd.macc.cad.business.config.transfer.MaterialsUseTransfer;
import kd.macc.cad.business.config.transfer.MfgFeeTransfer;
import kd.macc.cad.business.config.transfer.PlanFeeTransfer;
import kd.macc.cad.business.config.transfer.PlanOutPutTransfer;
import kd.macc.cad.business.config.transfer.PlanResourceTransfer;
import kd.macc.cad.business.config.transfer.ResourceUseTransfer;
import kd.macc.cad.business.config.transfer.WorkHoursFeeTransfer;
import kd.macc.cad.business.config.transfer.WorkQtyTransfer;

public interface IBillTransfer {
    public BillTransferResult doTransfer(DynamicObject[] var1, DynamicObject var2, CollConifgContext var3);

    public static IBillTransfer getTransferInstance(String targetEntity, String appNum) {
        AbstractBillTransfer billTransfer = null;
        switch (targetEntity) {
            case "cad_costobject": {
                billTransfer = new CostObjectTransfer();
                break;
            }
            case "cad_plannedoutputbill": {
                billTransfer = new PlanOutPutTransfer();
                break;
            }
            case "cad_factnedoutputbill": {
                billTransfer = new FactOutPutTransfer();
                break;
            }
            case "sca_matusecollect": 
            case "aca_matusecollect": {
                billTransfer = new MaterialsUseTransfer();
                break;
            }
            case "aca_matalloc": {
                if ("eca".equals(appNum)) {
                    billTransfer = new MatUseTransfer();
                    break;
                }
                if (!"aca".equals(appNum)) break;
                billTransfer = new MatAllocTransfer();
                break;
            }
            case "sca_resourceuse": {
                billTransfer = new ResourceUseTransfer();
                break;
            }
            case "eca_workhoursfee": {
                billTransfer = new WorkHoursFeeTransfer();
                break;
            }
            case "cad_mfgfeebill": {
                billTransfer = new MfgFeeTransfer();
                break;
            }
            case "sca_diycostdriver": {
                billTransfer = new DiyCostDriverTransfer();
                break;
            }
            case "sca_workqtycollec": {
                billTransfer = new WorkQtyTransfer();
                break;
            }
            case "cad_planfeebill": {
                billTransfer = new PlanFeeTransfer();
                break;
            }
            case "cad_planresource": {
                billTransfer = new PlanResourceTransfer();
                break;
            }
        }
        return billTransfer;
    }
}

