/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.business.config.engine.helper;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.macc.cad.business.config.service.CostConfigService;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class CollectEngineHelper {
    private static final String MFTORDER_SELECTFIELDS = ",treeentryentity.id AS nodeId, treeentryentity.pid AS pnodeId,treeentryentity.producttype AS producttype,treeentryentity.auxproperty AS auxpty,transactiontype.isprocedure AS isprocedure,transactiontype.isrework AS isrework,treeentryentity.planstatus AS planstatus,treeentryentity.bizstatus AS bizstatus,treeentryentity.taskstatus AS taskstatus,treeentryentity.closetime AS closetime,treeentryentity.closebookdate AS closebookdate";
    private static final String MFTMANUBILL_SELECTFIELDS = ",org AS invOrg,billentry.manubill AS manubill,billentry.manuentry AS manuentry";
    private static final String IMPRODUCEBILL_SELECTFIELDS = ",org AS invOrg,invscheme.number invschemenum";
    private static final String PROCESSREPORTBILL_SELECTFIELDS = ",sumentry.repsubentryentity.id as sonid,sumentry.repsubentryentity.seq as sonseq";
    private static final String GLVOUCHERBILL_SELECTFIELDS = ",vouchertype,entries.id AS voucherentry,entries.account.id AS accountId,entries.assgrp.id AS assgrpId,entries.assgrp.value AS assgrpValue,entries.account.dc AS dc,entries.debitlocal AS debitlocal,entries.creditlocal AS creditlocal";
    private static final String APFIBILL_SELECTFIELDS = ",detailentry.corebillno as corebillno,detailentry.corebillentryseq as corebillentryseq,detailentry.corebillid as corebillid,detailentry.corebillentryid as corebillentryid,detailentry.material as material";
    private static final String APBUSBILL_SELECTFIELDS = ",entry.e_corebillno as corebillno,entry.e_corebillentryseq as corebillentryseq,entry.corebillid as corebillid,entry.corebillentryid as corebillentryid,entry.e_material as material";

    public static String getSrcSelectFields(DynamicObject config, Map<String, String> fieldMappingMap, Map<String, String> ruleMappingMap) {
        if (config == null) {
            return null;
        }
        HashSet<String> srcFields = new HashSet<String>(10);
        String sourceBillEntity = config.getString("sourcebill.id");
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)sourceBillEntity);
        srcFields.add("id");
        if (sourceBillEntity.equals("cad_matcostinfo")) {
            srcFields.add("'' AS billno");
        } else if (mainEntityType.findProperty("billno") != null) {
            srcFields.add("billno");
        } else if (mainEntityType.findProperty("number") != null) {
            srcFields.add("number AS billno");
        } else {
            srcFields.add("'' AS billno");
        }
        if (mainEntityType.findProperty("bookdate") != null) {
            srcFields.add("bookdate");
        }
        if (mainEntityType.findProperty("auditdate") != null) {
            srcFields.add("auditdate");
        }
        if (sourceBillEntity.equals("cal_costadjust_subentity")) {
            srcFields.add("'" + sourceBillEntity + "' AS billtype ");
        } else if (mainEntityType.findProperty("billtype") != null && mainEntityType.findProperty("billtype").getPropertyType().getName().endsWith("DynamicObject")) {
            srcFields.add("billtype.billformid AS billtype ");
        } else if (mainEntityType.findProperty("docbilltype") != null && mainEntityType.findProperty("docbilltype").getPropertyType().getName().endsWith("DynamicObject")) {
            srcFields.add("docbilltype.billformid AS billtype ");
        } else {
            srcFields.add("'" + sourceBillEntity + "' AS billtype ");
        }
        if (mainEntityType.findProperty("bomid") != null) {
            IDataEntityProperty bomid = mainEntityType.findProperty("bomid");
            IDataEntityType parentType = bomid.getParent();
            String name = bomid.getName();
            if (!(parentType instanceof MainEntityType)) {
                String extendName = bomid.getParent().getExtendName();
                name = extendName + "." + name;
            }
            srcFields.add(name + " AS bomid");
            srcFields.add(name + ".version AS bomversion");
        }
        HashSet<String> values = new HashSet<String>(16);
        String entryEntity = "";
        String subEntryEntity = "";
        boolean hasBillEntry = false;
        for (Map.Entry<String, String> fieldMapping : fieldMappingMap.entrySet()) {
            String string = fieldMapping.getValue();
            if (string.startsWith("billentry.")) {
                hasBillEntry = true;
            }
            String[] splitValue = string.split(",");
            values.addAll(Arrays.asList(splitValue));
        }
        for (String value2 : values) {
            if (CadEmptyUtils.isEmpty((String)entryEntity) && value2.contains(".")) {
                entryEntity = value2.split("\\.")[0];
            }
            if (CadEmptyUtils.isEmpty((String)subEntryEntity) && value2.split("\\.").length >= 3) {
                String[] stringArray = value2.split("\\.");
                String subEntry = stringArray[1];
                Map allEntities = mainEntityType.getAllEntities();
                EntityType childreportentity = (EntityType)allEntities.get(subEntry);
                if (childreportentity != null && childreportentity.getParent() != null && entryEntity.equals(childreportentity.getParent().getName())) {
                    subEntryEntity = subEntry;
                }
            }
            if (!CadEmptyUtils.isEmpty((String)value2)) {
                srcFields.add(value2);
            }
            if (value2.endsWith("material.masterid") || value2.endsWith("material")) {
                if (!"material".equals(value2)) {
                    srcFields.add(value2 + " AS material");
                }
                srcFields.add("' ' AS materialNumber");
                srcFields.add("' ' AS materialName");
            }
            if (value2.endsWith("repactivity")) {
                srcFields.add(value2 + ".unit AS repactivityunit");
            }
            if (!"productworkshop".equals(value2)) continue;
            srcFields.add(value2 + ".workshoporg");
        }
        if (!CadEmptyUtils.isEmpty(ruleMappingMap)) {
            for (Map.Entry<String, String> ruleMapping : ruleMappingMap.entrySet()) {
                String string = (String)ruleMapping.getValue();
                if (CadEmptyUtils.isEmpty((String)string)) continue;
                srcFields.add(string);
            }
        }
        Map<String, Set<String>> formulaFieldMap = CostConfigService.getFormulaFieldMap(config);
        for (Map.Entry entry : formulaFieldMap.entrySet()) {
            srcFields.addAll((Collection)entry.getValue());
        }
        srcFields.remove(entryEntity);
        srcFields.remove(subEntryEntity);
        String selectFields = String.join((CharSequence)",", srcFields);
        selectFields = !CadEmptyUtils.isEmpty((String)entryEntity) ? selectFields + "," + entryEntity + ".id AS entryId," + entryEntity + ".seq AS entryseq" : selectFields + ",id AS entryId,1 AS entryseq";
        if (!CadEmptyUtils.isEmpty((String)subEntryEntity)) {
            selectFields = selectFields + "," + entryEntity + "." + subEntryEntity + ".id AS subentryId," + entryEntity + "." + subEntryEntity + ".seq AS subentryseq";
        }
        if ("om_mftorder".equals(sourceBillEntity) || "pom_mftorder".equals(sourceBillEntity)) {
            selectFields = selectFields + MFTORDER_SELECTFIELDS;
        } else if ("im_mdc_mftmanuinbill".equals(sourceBillEntity) || "im_mdc_mftreturnbill".equals(sourceBillEntity) || "im_mdc_omcmplinbill".equals(sourceBillEntity)) {
            selectFields = hasBillEntry ? selectFields + MFTMANUBILL_SELECTFIELDS : selectFields + ",org AS invOrg,'' AS manubill,'' AS manuentry";
        } else if ("im_productinbill".equals(sourceBillEntity)) {
            selectFields = selectFields + IMPRODUCEBILL_SELECTFIELDS;
        } else if ("sfc_processreportbill".equals(sourceBillEntity)) {
            selectFields = selectFields + PROCESSREPORTBILL_SELECTFIELDS;
        } else if ("gl_voucher".equals(sourceBillEntity)) {
            selectFields = selectFields + GLVOUCHERBILL_SELECTFIELDS;
        } else if ("ap_finapbill".equals(sourceBillEntity)) {
            selectFields = selectFields + APFIBILL_SELECTFIELDS;
        } else if ("ap_busbill".equals(sourceBillEntity)) {
            selectFields = selectFields + APBUSBILL_SELECTFIELDS;
        } else if (("im_materialreqoutbill".equals(sourceBillEntity) || "im_mdc_mftproorder".equals(sourceBillEntity) || "im_mdc_mftreturnorder".equals(sourceBillEntity) || "im_mdc_mftfeedorder".equals(sourceBillEntity) || "im_mdc_omoutbill".equals(sourceBillEntity) || "im_mdc_omreturnbill".equals(sourceBillEntity) || "im_mdc_omfeedbill".equals(sourceBillEntity)) && !selectFields.contains("billentry.isrework")) {
            selectFields = selectFields + ",billentry.isrework";
        }
        return selectFields;
    }
}

