/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.business.config.service;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import org.apache.commons.lang.time.DateFormatUtils;

public class CommonCollConfigService {
    private static final Log logger = LogFactory.getLog(CommonCollConfigService.class);

    public static List<DynamicObject> getCollConfigs(Long calOrgId, Long costAccountId, Set<Long> calcDimensionIds, String targetEntity, String appNum) {
        return CommonCollConfigService.getCollConfigs(calOrgId, costAccountId, calcDimensionIds, targetEntity, appNum, null);
    }

    public static List<DynamicObject> getCollConfigs(Long calOrgId, Long costAccountId, Set<Long> calcDimensionIds, String targetEntity, String appNum, Set<Long> allCollConfigIds) {
        return ImportServiceHelper.getCollConfigs((Long)calOrgId, (Long)costAccountId, calcDimensionIds, (String)targetEntity, (String)appNum, allCollConfigIds, null);
    }

    public static Boolean isHasCostObjectConfigScheme(Long calOrgId, Set<Long> calcDimensionIds, String targetEntity, String sourceEntity, String appNum) {
        List superiorOrgs = OrgUnitServiceHelper.getAllSuperiorOrgs((String)"10", (long)calOrgId);
        superiorOrgs.add(calOrgId);
        QFilter orgFilter = new QFilter("org", "in", (Object)superiorOrgs);
        orgFilter.and(new QFilter("costbill", "=", (Object)targetEntity));
        if (!CadEmptyUtils.isEmpty((String)sourceEntity)) {
            orgFilter.and(new QFilter("configinfoentity.sourcebill", "=", (Object)sourceEntity));
        }
        if (!CadEmptyUtils.isEmpty(calcDimensionIds)) {
            orgFilter.and(new QFilter("costcalcdimension", "in", calcDimensionIds));
        }
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        enableFilter.and(new QFilter("configinfoentity.usestatus", "=", (Object)"1"));
        QFilter appNumFilter = new QFilter("appnum", "=", (Object)appNum);
        return QueryServiceHelper.exists((String)"cad_costconfigplan", (QFilter[])new QFilter[]{orgFilter, enableFilter, appNumFilter});
    }

    public static String getBillInfoBySelectFields(DynamicObject bizBill, Set<String> selectFields) {
        if (bizBill == null || CadEmptyUtils.isEmpty(selectFields)) {
            return null;
        }
        String join = "@";
        StringBuilder sg = new StringBuilder();
        String entryEntityField = "";
        HashSet<String> entryFields = new HashSet<String>(16);
        for (String selectField : selectFields) {
            if ("costcenter".equals(selectField)) continue;
            if (selectField.contains(".")) {
                entryEntityField = selectField.split("\\.")[0];
                entryFields.add(selectField.split("\\.")[1]);
                continue;
            }
            if (bizBill.get(selectField) instanceof DynamicObject) {
                sg.append(bizBill.getString(selectField + ".id"));
                sg.append(join);
                continue;
            }
            if (bizBill.get(selectField) instanceof Date) {
                String srcDateStr = DateFormatUtils.format((Date)bizBill.getDate(selectField), (String)"yyyy-MM-dd HH:mm:ss.S");
                sg.append(srcDateStr);
                sg.append(join);
                continue;
            }
            sg.append(bizBill.get(selectField) == null ? "0" : bizBill.getString(selectField));
            sg.append(join);
        }
        if (CadEmptyUtils.isEmpty((String)entryEntityField) && CadEmptyUtils.isEmpty(entryFields)) {
            return sg.toString();
        }
        DynamicObjectCollection rows = bizBill.getDynamicObjectCollection(entryEntityField);
        for (DynamicObject row : rows) {
            for (String entryField : entryFields) {
                if (row.get(entryField) instanceof DynamicObject) {
                    sg.append(row.getString(entryField + ".id"));
                    sg.append(join);
                    continue;
                }
                if (row.get(entryField) instanceof Date) {
                    String srcDateStr = DateFormatUtils.format((Date)row.getDate(entryField), (String)"yyyy-MM-dd HH:mm:ss.S");
                    sg.append(srcDateStr);
                    sg.append(join);
                    continue;
                }
                String enntryVaue = row.getString(entryField);
                if (enntryVaue == null) {
                    sg.append("0");
                } else {
                    sg.append(enntryVaue);
                }
                sg.append(join);
            }
        }
        return sg.toString();
    }

    public static Map<String, String> getPresetCostFields(String entryEntity, String calMethod, Long calcDimension, String appNum) {
        QFilter filter = new QFilter("costbill", "=", (Object)entryEntity);
        filter.and(new QFilter("calmethod", "=", (Object)calMethod));
        if (!CadEmptyUtils.isEmpty((Long)calcDimension)) {
            filter.and(new QFilter("costcalcdimension", "=", (Object)calcDimension));
        }
        filter.and(new QFilter("preset", "=", (Object)Boolean.TRUE));
        filter.and(new QFilter("appnum", "=", (Object)appNum));
        DynamicObjectCollection configs = QueryServiceHelper.query((String)"cad_costcollectconfig", (String)"fieldmapentity.costfield costfield,fieldmapentity.costfieldname costfieldname", (QFilter[])new QFilter[]{filter}, (String)"fieldmapentity.seq asc");
        LinkedHashMap<String, String> costFiledsMap = new LinkedHashMap<String, String>(16);
        for (DynamicObject config : configs) {
            costFiledsMap.put(config.getString("costfield"), config.getString("costfieldname"));
        }
        return costFiledsMap;
    }

    public static String getPresetSourceFilter(String entryEntity, String srcEntryEntity, String calMethod, Long calcDimension, String appNum) {
        QFilter filter = new QFilter("costbill", "=", (Object)entryEntity);
        filter.and(new QFilter("sourcebill", "=", (Object)srcEntryEntity));
        filter.and(new QFilter("calmethod", "=", (Object)calMethod));
        filter.and(new QFilter("costcalcdimension", "=", (Object)calcDimension));
        filter.and(new QFilter("preset", "=", (Object)Boolean.TRUE));
        filter.and(new QFilter("appnum", "=", (Object)appNum));
        DynamicObject configFilter = QueryServiceHelper.queryOne((String)"cad_costcollectconfig", (String)"filter_tag", (QFilter[])new QFilter[]{filter});
        if (configFilter == null) {
            return null;
        }
        return configFilter.getString("filter_tag");
    }

    public static DynamicObjectCollection getPresetCostSourceFields(String entryEntity, String srcEntryEntity, String calMethod, Long calcDimension, String appNum) {
        QFilter filter = new QFilter("costbill", "=", (Object)entryEntity);
        filter.and(new QFilter("sourcebill", "=", (Object)srcEntryEntity));
        filter.and(new QFilter("calmethod", "=", (Object)calMethod));
        filter.and(new QFilter("costcalcdimension", "=", (Object)calcDimension));
        filter.and(new QFilter("preset", "=", (Object)Boolean.TRUE));
        filter.and(new QFilter("appnum", "=", (Object)appNum));
        DynamicObjectCollection configFileds = QueryServiceHelper.query((String)"cad_costcollectconfig", (String)"fieldmapentity.costfield costfield,fieldmapentity.costfieldname costfieldname,fieldmapentity.sourcefield sourcefield,fieldmapentity.sourcefieldname sourcefieldname", (QFilter[])new QFilter[]{filter}, (String)"fieldmapentity.seq asc");
        return configFileds;
    }

    public static Map<String, Object[]> getPresetCostObjectRuleFields(String entryEntity, String srcEntryEntity, String calMethod, Long calcDimension, String appNum) {
        QFilter filter = new QFilter("costbill", "=", (Object)entryEntity);
        filter.and(new QFilter("sourcebill", "=", (Object)srcEntryEntity));
        filter.and(new QFilter("calmethod", "=", (Object)calMethod));
        filter.and(new QFilter("preset", "=", (Object)Boolean.TRUE));
        filter.and(new QFilter("appnum", "=", (Object)appNum));
        DynamicObjectCollection configs = QueryServiceHelper.query((String)"cad_costcollectconfig", (String)"costruleinfoentity.costobjfield costobjfield,costruleinfoentity.srcbillfield srcbillfield,costruleinfoentity.srcbillname srcbillname", (QFilter[])new QFilter[]{filter});
        HashMap<String, Object[]> costSrcRuleFiledsMap = new HashMap<String, Object[]>(16);
        for (DynamicObject config : configs) {
            Object[] srcFiled = new Object[]{config.getString("srcbillfield"), config.getString("srcbillname")};
            costSrcRuleFiledsMap.put(config.getString("costobjfield"), srcFiled);
        }
        return costSrcRuleFiledsMap;
    }
}

