/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.business.config.service;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRFormula;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.formula.FormulaEngine;
import kd.bos.formula.excel.BinaryExpr;
import kd.bos.formula.excel.CompoundId;
import kd.bos.formula.excel.Expr;
import kd.bos.formula.excel.FunCall;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.macc.cad.business.config.engine.CollConifgContext;
import kd.macc.cad.business.config.plugin.ITargetBillTransfer;
import kd.macc.cad.business.config.plugin.ITargetBillTransferForEca;
import kd.macc.cad.common.helper.PermissionHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.EntityUtil;

public class CostConfigService {
    private static Log logger = LogFactory.getLog(CostConfigService.class);

    public static void delCostConfigByPlanBillIds(BeforeDoOperationEventArgs e, Long listOrgId, Set<Long> ids, IFormView view) {
        if (ids.size() != 1) {
            e.setCancel(true);
            String tips = ResManager.loadKDString((String)"\u5220\u9664\u65f6\u4ec5\u80fd\u9009\u62e9\u4e00\u5f20\u5355\u636e\u3002", (String)"CostConfigService_0", (String)"macc-cad-business", (Object[])new Object[0]);
            view.showTipNotification(tips);
            return;
        }
        QFilter filter = new QFilter("id", "in", ids);
        filter.and(new QFilter("preset", "=", (Object)Boolean.FALSE));
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"cad_costconfigplan", (String)"costbill,calmethod,costcalcdimension,preset,org,configinfoentity.costconfig as configid,configinfoentity.costconfig.number as confignumber", (QFilter[])new QFilter[]{filter});
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)dynamicObjects)) {
            return;
        }
        long org = ((DynamicObject)dynamicObjects.get(0)).getLong("org");
        if (org == 0L) {
            e.setCancel(true);
            String tips = ResManager.loadKDString((String)"\u5f53\u524d\u65b9\u6848\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"CostConfigService_1", (String)"macc-cad-business", (Object[])new Object[0]);
            view.showTipNotification(tips);
            return;
        }
        if (org != listOrgId) {
            e.setCancel(true);
            String tips = ResManager.loadKDString((String)"\u521b\u5efa\u7ec4\u7ec7\u4e0e\u67e5\u8be2\u7ec4\u7ec7\u4e0d\u4e00\u81f4\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"CostConfigService_2", (String)"macc-cad-business", (Object[])new Object[0]);
            view.showTipNotification(tips);
            return;
        }
        HashSet<Long> configIds = new HashSet<Long>(10);
        HashMap<Long, Set> isLockConfigsMap = new HashMap<Long, Set>(16);
        for (DynamicObject dynamicObject : dynamicObjects) {
            long configId = dynamicObject.getLong("configid");
            if (CadEmptyUtils.isEmpty((Long)configId)) continue;
            configIds.add(configId);
            Map lockInfo = PermissionHelper.getLockInfo((String)String.valueOf(configId), (String)"default_netctrl", (String)"cad_costcollectconfig");
            if (CadEmptyUtils.isEmpty((Map)lockInfo)) continue;
            isLockConfigsMap.computeIfAbsent(Long.parseLong(String.valueOf(lockInfo.get("userid"))), p -> new HashSet()).add(dynamicObject.getString("confignumber"));
        }
        configIds.remove(0L);
        if (!CadEmptyUtils.isEmpty(isLockConfigsMap)) {
            String tips = "";
            DynamicObjectCollection userInfos = QueryServiceHelper.query((String)"bos_usergroup_user", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "in", isLockConfigsMap.keySet())});
            HashMap<Long, String> userInfoMap = new HashMap<Long, String>(16);
            for (DynamicObject user : userInfos) {
                userInfoMap.put(user.getLong("id"), user.getString("name"));
            }
            for (Map.Entry lockConfig : isLockConfigsMap.entrySet()) {
                Long user = (Long)lockConfig.getKey();
                Set confgNums = (Set)lockConfig.getValue();
                String numberStr = "";
                for (String confgNum : confgNums) {
                    if (CadEmptyUtils.isEmpty((String)numberStr)) {
                        numberStr = "\u3010" + confgNum + "\u3011";
                        continue;
                    }
                    numberStr = numberStr + "\u3001\u3010" + confgNum + "\u3011";
                }
                if (CadEmptyUtils.isEmpty((String)tips)) {
                    tips = String.format(ResManager.loadKDString((String)"%1$s\u6b63\u5728\u7f16\u8f91\u914d\u7f6e\u5355%2$s\u3002", (String)"CostConfigService_7", (String)"macc-cad-business", (Object[])new Object[0]), userInfoMap.get(user), numberStr);
                    continue;
                }
                tips = tips + "\uff1b" + String.format(ResManager.loadKDString((String)"%1$s\u6b63\u5728\u7f16\u8f91\u914d\u7f6e\u5355%2$s\u3002", (String)"CostConfigService_7", (String)"macc-cad-business", (Object[])new Object[0]), userInfoMap.get(user), numberStr);
            }
            if (!CadEmptyUtils.isEmpty((String)tips)) {
                String showTips = String.format(ResManager.loadKDString((String)"%s\u5220\u9664\u5931\u8d25\u3002", (String)"CostConfigService_8", (String)"macc-cad-business", (Object[])new Object[0]), tips);
                e.setCancel(true);
                view.showTipNotification(showTips);
                return;
            }
        }
        if (configIds.isEmpty()) {
            return;
        }
        String costBill = ((DynamicObject)dynamicObjects.get(0)).getString("costbill");
        String calMethod = ((DynamicObject)dynamicObjects.get(0)).getString("calmethod");
        Long dimension = ((DynamicObject)dynamicObjects.get(0)).getLong("costcalcdimension");
        boolean configBillIsRef = CostConfigService.configBillIsRef(costBill, configIds);
        if (configBillIsRef) {
            e.setCancel(true);
            String tips = ResManager.loadKDString((String)"\u5f53\u524d\u914d\u7f6e\u5355\u5df2\u88ab\u5f15\u7528\uff0c\u5220\u9664\u5931\u8d25\u3002", (String)"CostConfigService_5", (String)"macc-cad-business", (Object[])new Object[0]);
            view.showTipNotification(tips);
        } else {
            long rootOrgId = OrgUnitServiceHelper.getRootOrgId();
            if (org == rootOrgId) {
                QFilter reFilter = new QFilter("org", "=", (Object)0L);
                reFilter.and("preset", "=", (Object)true);
                reFilter.and("costbill", "=", (Object)costBill);
                reFilter.and("calmethod", "=", (Object)calMethod);
                reFilter.and("costcalcdimension", "=", (Object)dimension);
                reFilter.and("appnum", "=", (Object)view.getFormShowParameter().getAppId());
                DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"cad_costconfigplan", (String)"id", (QFilter[])new QFilter[]{reFilter});
                if (dynamicObject != null) {
                    long id = dynamicObject.getLong("id");
                    MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"cad_costconfigplan");
                    DynamicObject result = BusinessDataServiceHelper.loadSingle((Object)id, (DynamicObjectType)mainEntityType);
                    result.set("org", (Object)rootOrgId);
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{result});
                }
            }
            EntityUtil.deleteBill(configIds, (String)"cad_costcollectconfig");
        }
    }

    public static Long copyConfigBill(long selOrg, long id) {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"cad_costcollectconfig");
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)id, (DynamicObjectType)mainEntityType);
        Date nowTime = new Date();
        if (dynamicObject != null) {
            long currUserId = RequestContext.get().getCurrUserId();
            CloneUtils cloneUtils = new CloneUtils(true, true);
            DynamicObject newDataEntity = (DynamicObject)cloneUtils.clone((IDataEntityBase)dynamicObject);
            String[] batchNumber = CodeRuleServiceHelper.getBatchNumber((String)"cad_costcollectconfig", (DynamicObject)newDataEntity, (String)RequestContext.get().getLoginOrg(), (int)1);
            newDataEntity.set("number", (Object)batchNumber);
            newDataEntity.set("creator", (Object)currUserId);
            newDataEntity.set("creator_id", (Object)currUserId);
            newDataEntity.set("createtime", (Object)nowTime);
            newDataEntity.set("modifier", (Object)currUserId);
            newDataEntity.set("modifier_id", (Object)currUserId);
            newDataEntity.set("modifytime", (Object)nowTime);
            newDataEntity.set("org", (Object)selOrg);
            newDataEntity.set("org_id", (Object)selOrg);
            newDataEntity.set("preset", (Object)false);
            newDataEntity.set("remark", null);
            Object[] save = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newDataEntity});
            DynamicObject[] result = (DynamicObject[])save;
            if (result.length > 0) {
                return result[0].getLong("id");
            }
        }
        return null;
    }

    public static void deleteEntry(IDataModel model, IFormView view, BeforeDoOperationEventArgs e) {
        DynamicObject costBill;
        Map<Long, String> configBillRefMap;
        DynamicObjectCollection configInfoEntity = model.getDataEntity(true).getDynamicObjectCollection("configinfoentity");
        EntryGrid entry = (EntryGrid)view.getControl("configinfoentity");
        if (CadEmptyUtils.isEmpty((int[])entry.getSelectRows())) {
            return;
        }
        ArrayList<Integer> selectRows = new ArrayList<Integer>(10);
        for (int selectRow : entry.getSelectRows()) {
            selectRows.add(selectRow);
        }
        HashSet<Long> configIds = new HashSet<Long>(10);
        HashMap<Long, Set> isLockConfigsMap = new HashMap<Long, Set>(10);
        for (DynamicObject dynamicObject : configInfoEntity) {
            if (!selectRows.contains(dynamicObject.getInt("seq") - 1)) continue;
            configIds.add(dynamicObject.getLong("costconfig.id"));
            Map lockInfo = PermissionHelper.getLockInfo((String)dynamicObject.getString("costconfig.id"), (String)"default_netctrl", (String)"cad_costcollectconfig");
            if (CadEmptyUtils.isEmpty((Map)lockInfo)) continue;
            isLockConfigsMap.computeIfAbsent(Long.parseLong(String.valueOf(lockInfo.get("userid"))), p -> new HashSet()).add(dynamicObject.getString("costconfig.number"));
        }
        configIds.remove(0L);
        if (!CadEmptyUtils.isEmpty(isLockConfigsMap)) {
            String tips = "";
            DynamicObjectCollection userInfos = QueryServiceHelper.query((String)"bos_usergroup_user", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "in", isLockConfigsMap.keySet())});
            HashMap<Long, String> userInfoMap = new HashMap<Long, String>(16);
            for (DynamicObject user : userInfos) {
                userInfoMap.put(user.getLong("id"), user.getString("name"));
            }
            for (Map.Entry lockConfig : isLockConfigsMap.entrySet()) {
                Long user = (Long)lockConfig.getKey();
                Set confgNums = (Set)lockConfig.getValue();
                String numberStr = "";
                for (String confgNum : confgNums) {
                    if (CadEmptyUtils.isEmpty((String)numberStr)) {
                        numberStr = "\u3010" + confgNum + "\u3011";
                        continue;
                    }
                    numberStr = numberStr + "\u3001\u3010" + confgNum + "\u3011";
                }
                if (CadEmptyUtils.isEmpty((String)tips)) {
                    tips = String.format(ResManager.loadKDString((String)"%1$s\u6b63\u5728\u7f16\u8f91\u914d\u7f6e\u5355%2$s\u3002", (String)"CostConfigService_7", (String)"macc-cad-business", (Object[])new Object[0]), userInfoMap.get(user), numberStr);
                    continue;
                }
                tips = tips + "\uff1b" + String.format(ResManager.loadKDString((String)"%1$s\u6b63\u5728\u7f16\u8f91\u914d\u7f6e\u5355%2$s\u3002", (String)"CostConfigService_7", (String)"macc-cad-business", (Object[])new Object[0]), userInfoMap.get(user), numberStr);
            }
            if (!CadEmptyUtils.isEmpty((String)tips)) {
                String showTips = String.format(ResManager.loadKDString((String)"%s\u5220\u9664\u5931\u8d25\u3002", (String)"CostConfigService_8", (String)"macc-cad-business", (Object[])new Object[0]), tips);
                e.setCancel(true);
                view.showTipNotification(showTips);
                return;
            }
        }
        if (!CadEmptyUtils.isEmpty(configBillRefMap = CostConfigService.getConfigBillRef((costBill = model.getDataEntity().getDynamicObject("costbill")) == null ? null : costBill.getString("id"), configIds))) {
            String numberStr = "";
            for (Map.Entry<Long, String> configBillRef : configBillRefMap.entrySet()) {
                String number = configBillRef.getValue();
                if (CadEmptyUtils.isEmpty((String)numberStr)) {
                    numberStr = "\u3010" + number + "\u3011";
                    continue;
                }
                numberStr = numberStr + "\u3001\u3010" + number + "\u3011";
            }
            e.setCancel(true);
            String tips = String.format(ResManager.loadKDString((String)"\u914d\u7f6e\u5355%s\u5df2\u88ab\u5f15\u7528\uff0c\u5220\u9664\u5931\u8d25\u3002", (String)"CostConfigService_6", (String)"macc-cad-business", (Object[])new Object[0]), numberStr);
            view.showTipNotification(tips);
            return;
        }
        view.getPageCache().put("deleteConfigId", SerializationUtils.toJsonString(configIds));
    }

    public static void realDeleteEntry(IFormView view) {
        IPageCache pageCache = view.getPageCache();
        String deleteConfigIdStr = pageCache.get("deleteConfigId");
        if (CadEmptyUtils.isEmpty((String)deleteConfigIdStr)) {
            return;
        }
        Set delConfigIdSet = (Set)SerializationUtils.fromJsonString((String)deleteConfigIdStr, Set.class);
        if (CadEmptyUtils.isEmpty((Set)delConfigIdSet)) {
            return;
        }
        EntityUtil.deleteBill((Set)delConfigIdSet, (String)"cad_costcollectconfig");
        pageCache.put("deleteConfigId", null);
    }

    public static boolean configBillIsRef(String sourceBillId, Set<Long> ids) {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)sourceBillId);
        DataEntityPropertyCollection properties = mainEntityType.getProperties();
        boolean configIdExist = false;
        for (IDataEntityProperty property : properties) {
            String name = property.getName();
            if (!"collconfig".equals(name)) continue;
            configIdExist = true;
            break;
        }
        if (!configIdExist) {
            return configIdExist;
        }
        QFilter idFilter = new QFilter("collconfig", "in", ids);
        return QueryServiceHelper.exists((String)sourceBillId, (QFilter[])new QFilter[]{idFilter});
    }

    public static Map<Long, String> getConfigBillRef(String sourceBillId, Set<Long> ids) {
        HashMap<Long, String> configBillRefMap = new HashMap<Long, String>(16);
        if (CadEmptyUtils.isEmpty((String)sourceBillId) || CadEmptyUtils.isEmpty(ids)) {
            return configBillRefMap;
        }
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)sourceBillId);
        DataEntityPropertyCollection properties = mainEntityType.getProperties();
        boolean configIdExist = false;
        for (IDataEntityProperty property : properties) {
            String name = property.getName();
            if (!"collconfig".equals(name)) continue;
            configIdExist = true;
            break;
        }
        if (configIdExist) {
            QFilter idFilter = new QFilter("collconfig", "in", ids);
            DynamicObjectCollection configRefDyos = QueryServiceHelper.query((String)sourceBillId, (String)"collconfig.id collconfig,collconfig.number collconfignumber", (QFilter[])new QFilter[]{idFilter});
            for (DynamicObject configRefDyo : configRefDyos) {
                configBillRefMap.put(configRefDyo.getLong("collconfig"), configRefDyo.getString("collconfignumber"));
            }
        }
        return configBillRefMap;
    }

    public static Object execExcelFormula(DynamicObject bizBill, String formulaStr, Set<String> formulaFields) {
        HashMap<String, Object> variableMap = new HashMap<String, Object>(16);
        if (bizBill == null || CadEmptyUtils.isEmpty((String)formulaStr) || CadEmptyUtils.isEmpty(formulaFields)) {
            return null;
        }
        CRFormula formulaObj = (CRFormula)SerializationUtils.fromJsonString((String)formulaStr, CRFormula.class);
        String expression = formulaObj.getExpression();
        for (String formulaField : formulaFields) {
            variableMap.put(formulaField, bizBill.get(formulaField));
        }
        return FormulaEngine.execExcelFormula((String)expression, variableMap);
    }

    public static Map<String, Set<String>> getFormulaFieldMap(DynamicObject config) {
        HashMap<String, Set<String>> fieldsMap = new HashMap<String, Set<String>>(16);
        if (config == null) {
            return fieldsMap;
        }
        DynamicObjectCollection mappingEntryEntity = config.getDynamicObjectCollection("fieldmapentity");
        for (DynamicObject mapping : mappingEntryEntity) {
            String formula = mapping.getString("formula");
            if (!"1".equals(mapping.getString("selectvalue")) || CadEmptyUtils.isEmpty((String)formula)) continue;
            Set<String> formulaField = CostConfigService.getFormulaField(formula);
            fieldsMap.computeIfAbsent(mapping.getString("costfield"), p -> new HashSet()).addAll(formulaField);
        }
        return fieldsMap;
    }

    public static Set<String> getFormulaField(String formulaStrJson) {
        HashSet<String> fields = new HashSet<String>(16);
        if (CadEmptyUtils.isEmpty((String)formulaStrJson)) {
            return fields;
        }
        CRFormula formula = (CRFormula)SerializationUtils.fromJsonString((String)formulaStrJson, CRFormula.class);
        String expression = formula.getExpression();
        Expr expr = FormulaEngine.parseFormula((String)expression);
        if (expr instanceof BinaryExpr) {
            Set<String> formulaFieldByBinaryExpr = CostConfigService.getFormulaFieldByBinaryExpr(expr);
            fields.addAll(formulaFieldByBinaryExpr);
        } else if (expr instanceof FunCall) {
            Object[] params = ((FunCall)expr).getParams();
            if (CadEmptyUtils.isEmpty((Object[])params)) {
                return fields;
            }
            for (Object param : params) {
                if (param instanceof CompoundId) {
                    fields.add(((CompoundId)param).toString());
                    continue;
                }
                if (!(param instanceof BinaryExpr)) continue;
                Set<String> formulaFieldByBinaryExpr = CostConfigService.getFormulaFieldByBinaryExpr((Expr)param);
                fields.addAll(formulaFieldByBinaryExpr);
            }
        }
        return fields;
    }

    private static Set<String> getFormulaFieldByBinaryExpr(Expr expr) {
        HashSet<String> fields = new HashSet<String>(16);
        if (expr == null) {
            return fields;
        }
        if (expr instanceof CompoundId) {
            fields.add(((CompoundId)expr).toString());
            return fields;
        }
        if (expr instanceof BinaryExpr) {
            BinaryExpr binaryExpr = (BinaryExpr)expr;
            if (binaryExpr.getLeft() instanceof CompoundId) {
                fields.add(((CompoundId)binaryExpr.getLeft()).toString());
            }
            if (binaryExpr.getRight() instanceof CompoundId) {
                fields.add(((CompoundId)binaryExpr.getRight()).toString());
            } else if (binaryExpr.getRight() instanceof BinaryExpr) {
                return CostConfigService.getFormulaFieldByBinaryExpr(binaryExpr.getRight());
            }
        }
        return fields;
    }

    public static DynamicObject getCostCenterBySrcBill(DynamicObject bizBill, String sourceField, Map<String, List<DynamicObject>> costCenterSourceDataMap, Object srcCostCenterSourceData, String sourceDateFiled, Map<String, String> costCenterTypeAndSourceFieldMap) {
        String[] splitCostCenterField;
        DynamicObject costCenter = null;
        if (CadEmptyUtils.isEmpty((String)sourceField)) {
            return null;
        }
        for (String splitCostCenter : splitCostCenterField = sourceField.split(",")) {
            if (CadEmptyUtils.isEmpty((String)splitCostCenter)) continue;
            if (splitCostCenter.contains("costcenter")) {
                Object costCenterId;
                Object object = costCenterId = bizBill.get(splitCostCenter) == null ? Long.valueOf(0L) : bizBill.get(splitCostCenter);
                if (!CadEmptyUtils.isEmpty((String)String.valueOf(costCenterId))) {
                    costCenter = BusinessDataServiceHelper.loadSingleFromCache((Object)costCenterId, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bos_costcenter"));
                }
            } else {
                if (splitCostCenter.contains("workcenter") && srcCostCenterSourceData != null) {
                    Date bizDate = bizBill.getDate(sourceDateFiled);
                    List<DynamicObject> costCenterSourceList = costCenterSourceDataMap.get("mpdm_workcentre@" + srcCostCenterSourceData);
                    costCenter = CostConfigService.getCostCenterBySrcBillDate(bizDate, costCenterSourceList);
                }
                if (costCenter != null) {
                    return costCenter;
                }
                costCenter = CostConfigService.getCostCenter(bizBill, splitCostCenter, costCenterSourceDataMap, sourceDateFiled, costCenterTypeAndSourceFieldMap);
            }
            if (costCenter == null) continue;
            return costCenter;
        }
        return null;
    }

    private static DynamicObject getCostCenter(DynamicObject bizBill, String costCenterField, Map<String, List<DynamicObject>> costCenterSourceDataMap, String sourceDateFiled, Map<String, String> costCenterTypeAndSourceFieldMap) {
        DynamicObject costCenter = null;
        Object srcCostCenterSourceData = null;
        if (bizBill == null || CadEmptyUtils.isEmpty(costCenterSourceDataMap) || CadEmptyUtils.isEmpty((String)costCenterField)) {
            return costCenter;
        }
        srcCostCenterSourceData = "productworkshop".equals(costCenterField) ? bizBill.get(costCenterField + ".workshoporg") : bizBill.get(costCenterField);
        if (!CadEmptyUtils.isEmpty(costCenterTypeAndSourceFieldMap) && costCenterTypeAndSourceFieldMap.containsKey(costCenterField)) {
            String srcType = costCenterTypeAndSourceFieldMap.get(costCenterField);
            Date bizDate = bizBill.getDate(sourceDateFiled);
            List<DynamicObject> costCenterSourceList = costCenterSourceDataMap.get(srcType + "@" + srcCostCenterSourceData);
            costCenter = CostConfigService.getCostCenterBySrcBillDate(bizDate, costCenterSourceList);
        } else {
            List<DynamicObject> costCenterSourceList;
            Date bizDate = bizBill.getDate(sourceDateFiled);
            costCenter = CostConfigService.getCostCenterBySrcBillDate(bizDate, costCenterSourceList = costCenterSourceDataMap.get("mpdm_workcentre@" + srcCostCenterSourceData));
            if (costCenter == null) {
                costCenterSourceList = costCenterSourceDataMap.get("bos_adminorg@" + srcCostCenterSourceData);
                costCenter = CostConfigService.getCostCenterBySrcBillDate(bizDate, costCenterSourceList);
            }
            if (costCenter == null) {
                costCenterSourceList = costCenterSourceDataMap.get("bos_org@" + srcCostCenterSourceData);
                costCenter = CostConfigService.getCostCenterBySrcBillDate(bizDate, costCenterSourceList);
            }
        }
        return costCenter;
    }

    public static DynamicObject getCostCenterBySrcBillDate(Date bizDate, List<DynamicObject> costCenterSourceList) {
        DynamicObject costCenter = null;
        if (bizDate == null || CadEmptyUtils.isEmpty(costCenterSourceList)) {
            return null;
        }
        for (DynamicObject costCenterSource : costCenterSourceList) {
            if (costCenterSource.getDate("effectdate").getTime() > bizDate.getTime() || costCenterSource.getDate("expdate").getTime() <= bizDate.getTime()) continue;
            costCenter = costCenterSource.getDynamicObject("costcenter");
            break;
        }
        return costCenter;
    }

    public static DynamicObject doTransferForPlugin(DynamicObject bizBill, DynamicObject collConfig, DynamicObjectCollection fieldMappingEntryColl) {
        String policyclass = collConfig.getString("plugin");
        if (CadEmptyUtils.isEmpty((String)policyclass)) {
            return null;
        }
        try {
            Class<?> transferClass = Class.forName(policyclass);
            ITargetBillTransfer transfer = (ITargetBillTransfer)transferClass.newInstance();
            return transfer.getTargetBill(bizBill, collConfig, fieldMappingEntryColl);
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u63d2\u4ef6-\u6e90\u5355\u8f6c\u6362\u4e3a\u76ee\u6807\u5355\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    public static DynamicObject doTransferForPluginForEca(DynamicObject bizBill, DynamicObject collConfig, DynamicObjectCollection fieldMappingEntryColl, CollConifgContext context) {
        String policyclass = collConfig.getString("plugin");
        if (CadEmptyUtils.isEmpty((String)policyclass)) {
            return null;
        }
        try {
            Class<?> transferClass = Class.forName(policyclass);
            ITargetBillTransferForEca transfer = (ITargetBillTransferForEca)transferClass.newInstance();
            return transfer.getTargetBill(bizBill, collConfig, fieldMappingEntryColl, context);
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u63d2\u4ef6-\u6e90\u5355\u8f6c\u6362\u4e3a\u76ee\u6807\u5355\u5931\u8d25", (Throwable)e);
            return null;
        }
    }
}

