/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.business.config.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.macc.cad.business.config.service.CommonCollConfigService;
import kd.macc.cad.common.dto.CollectReport;
import kd.macc.cad.common.enums.CollectStatus;
import kd.macc.cad.common.enums.CostObjectEnum;
import kd.macc.cad.common.utils.CadBgParamUtils;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.servicehelper.CostObjectServiceHelper;

public class CostObjectService {
    private static final Log logger = LogFactory.getLog(CostObjectService.class);
    private static final String EXISTCBCOLLECT = "existCBCollect";

    public static Map<Long, String> getDimensionAndRuleMap() {
        HashMap<Long, String> dimensionAndRuleMap = new HashMap<Long, String>(16);
        QFilter filter = new QFilter("enable", "=", (Object)"1");
        DynamicObjectCollection objs = QueryServiceHelper.query((String)"cad_costcalcdimension", (String)"id,calcrule", (QFilter[])new QFilter[]{filter});
        for (DynamicObject obj : objs) {
            dimensionAndRuleMap.put(obj.getLong("id"), obj.getString("calcrule"));
        }
        return dimensionAndRuleMap;
    }

    public static void generateCostObject(Long org, List<Long> costCenterIds, List<Long> manuOrgIds, Set<Long> calcDimensionIds, String appNum, CollectReport collectReport) {
        CostObjectService.generateCostObject(org, costCenterIds, manuOrgIds, calcDimensionIds, appNum, collectReport, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void generateCostObject(Long org, List<Long> costCenterIds, List<Long> manuOrgIds, Set<Long> calcDimensionIds, String appNum, CollectReport collectReport, List<Long> mftorderentryids) {
        try (TraceSpan span = Tracer.create((String)"CostObjectService", (String)"CostObjectService.generateCostObject");){
            if (!CommonCollConfigService.isHasCostObjectConfigScheme(org, calcDimensionIds, "cad_costobject", null, appNum).booleanValue()) {
                collectReport.logReportDetail(ResManager.loadKDString((String)"\u81ea\u52a8\u751f\u6210\u6210\u672c\u6838\u7b97\u5bf9\u8c61", (String)"CostObjectService_0", (String)"macc-cad-business", (Object[])new Object[0]));
                collectReport.logCheckDesc(ResManager.loadKDString((String)"\u5f53\u524d\u6838\u7b97\u7ec4\u7ec7\u4e0b\u672a\u627e\u5230\u5bf9\u5e94\u7684\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u914d\u7f6e\u65b9\u6848\uff0c\u8bf7\u914d\u7f6e\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u914d\u7f6e\u65b9\u6848\u3002", (String)"CostObjectService_1", (String)"macc-cad-business", (Object[])new Object[0]));
                return;
            }
            logger.info("\u81ea\u52a8\u751f\u6210\u6210\u672c\u6838\u7b97\u5bf9\u8c61-\u9700\u8981\u751f\u6210\u6210\u672c\u6838\u7b97\u5bf9\u8c61");
            Map resultInfo = Maps.newHashMapWithExpectedSize((int)8);
            String lockId = "GenerateCostObject@" + org;
            try {
                Throwable throwable;
                DLock dLock;
                block41: {
                    block42: {
                        dLock = DLock.create((String)lockId);
                        throwable = null;
                        if (dLock.tryLock()) break block41;
                        collectReport.logReportDetail(ResManager.loadKDString((String)"\u81ea\u52a8\u751f\u6210\u6210\u672c\u6838\u7b97\u5bf9\u8c61", (String)"CostObjectService_0", (String)"macc-cad-business", (Object[])new Object[0]));
                        collectReport.logCheckDesc(ResManager.loadKDString((String)"\u81ea\u52a8\u751f\u6210\u6210\u672c\u6838\u7b97\u5bf9\u8c61-\u5b58\u5728\u9501", (String)"CostObjectService_2", (String)"macc-cad-business", (Object[])new Object[0]));
                        logger.info("\u81ea\u52a8\u751f\u6210\u6210\u672c\u6838\u7b97\u5bf9\u8c61-\u5b58\u5728\u9501");
                        if (dLock == null) return;
                        if (throwable == null) break block42;
                        try {
                            dLock.close();
                            return;
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                            return;
                        }
                    }
                    dLock.close();
                    return;
                }
                try {
                    collectReport.logReportDetail(ResManager.loadKDString((String)"\u8c03\u7528\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u5f15\u5165\u670d\u52a1\u751f\u6210\u6210\u672c\u6838\u7b97\u5bf9\u8c61", (String)"CostObjectService_3", (String)"macc-cad-business", (Object[])new Object[0]));
                    resultInfo = (Map)CostObjectServiceHelper.importCostObject(mftorderentryids, (Long)org, costCenterIds, manuOrgIds, (String)appNum, null);
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    throw throwable4;
                }
                finally {
                    if (dLock != null) {
                        if (throwable != null) {
                            try {
                                dLock.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            dLock.close();
                        }
                    }
                }
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                logger.info("\u81ea\u52a8\u751f\u6210\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u5931\u8d25\uff0c\u539f\u56e0\uff1a{}", resultInfo.get("msg"));
            }
            String error = (String)resultInfo.get("error");
            if (!CadEmptyUtils.isEmpty((String)error)) {
                collectReport.logCheckDesc(String.format(ResManager.loadKDString((String)"\u8c03\u7528\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u5bfc\u5165\u670d\u52a1\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s\u3002", (String)"CostObjectService_4", (String)"macc-cad-business", (Object[])new Object[0]), resultInfo.get("error")));
                collectReport.logStatusChange(CollectStatus.FAILURE, "");
            } else if (resultInfo.get("successQty") == null || "0".equals(resultInfo.get("successQty"))) {
                collectReport.logCheckDesc(ResManager.loadKDString((String)"\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u5747\u5df2\u751f\u6210\uff0c\u4e0d\u518d\u81ea\u52a8\u751f\u6210\u3002", (String)"CostObjectService_5", (String)"macc-cad-business", (Object[])new Object[0]));
            } else {
                collectReport.logCheckDesc(String.format(ResManager.loadKDString((String)"\u8c03\u7528\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u5bfc\u5165\u670d\u52a1\u751f\u6210\u6210\u672c\u6838\u7b97\u5bf9\u8c61%s\u4e2a\u3002", (String)"CostObjectService_6", (String)"macc-cad-business", (Object[])new Object[0]), resultInfo.get("successQty")));
            }
            logger.info("\u8c03\u7528\u81ea\u52a8\u751f\u6210\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u670d\u52a1\uff0c\u8fd4\u56de\u7ed3\u679c:{}", (Object)SerializationUtils.toJsonString(resultInfo));
            return;
        }
    }

    public static void autoGenerateCostobject(Long acctOrgId, List<Long> costCenterIds, List<Long> manuOrgs, CollectReport collectReport, String appnum, Set<Long> manuIds) {
        if (manuIds.isEmpty()) {
            return;
        }
        String existCBCollect = CadBgParamUtils.getCadBgParamForString((String)EXISTCBCOLLECT, (String)"false");
        if (!"true".equals(existCBCollect)) {
            List splitLists = Lists.partition(new ArrayList<Long>(manuIds), (int)100000);
            QFilter orgFilter = new QFilter("org", "=", (Object)acctOrgId);
            ArrayList<Long> existIds = new ArrayList<Long>(10);
            for (List list : splitLists) {
                QFilter idFilter = new QFilter("probill", "in", (Object)list);
                DataSet costObjectDs = QueryServiceHelper.queryDataSet((String)"costobject", (String)"cad_costobject", (String)"probill", (QFilter[])new QFilter[]{orgFilter, idFilter}, null);
                for (Row row : costObjectDs) {
                    existIds.add(row.getLong("probill"));
                }
            }
            HashSet<Long> needGIds = new HashSet<Long>(manuIds);
            needGIds.removeAll(existIds);
            if (needGIds.isEmpty()) {
                return;
            }
        }
        CostObjectService.generateCostObject(acctOrgId, costCenterIds, manuOrgs, null, appnum, collectReport, new ArrayList<Long>(manuIds));
    }

    public static boolean containNotOrderTypeRule(Long accountOrgId, Map<String, List<Long>> costCenterByRules) {
        for (String key : costCenterByRules.keySet()) {
            if (key.equals(String.valueOf(accountOrgId).concat(CostObjectEnum.BIZTYPE_RO.getValue()))) continue;
            return true;
        }
        return false;
    }
}

