/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.business.config.transfer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.macc.cad.business.config.engine.AbstractBillTransfer;
import kd.macc.cad.business.config.engine.BillTransferResult;
import kd.macc.cad.business.config.service.CostConfigService;
import kd.macc.cad.common.enums.CostObjectEnum;
import kd.macc.cad.common.helper.CostObjectHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import org.apache.commons.lang3.StringUtils;

public class CostObjectTransfer
extends AbstractBillTransfer {
    private static Log logger = LogFactory.getLog(CostObjectTransfer.class);

    @Override
    public void doTransferAfter(BillTransferResult result) {
        super.doTransferAfter(result);
        Map<DynamicObject, DynamicObject> srcMap = result.getSrcAndTargetBillsMap();
        Set<DynamicObject> probills = srcMap.keySet();
        Collection<DynamicObject> costobjects = srcMap.values();
        if ("sca".equals(this.context.getParam().getAppnum())) {
            HashSet sbentryToTrackStSets = Sets.newHashSetWithExpectedSize((int)10);
            ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(10);
            HashMap manuorgToStMap = Maps.newHashMapWithExpectedSize((int)10);
            for (DynamicObject costobjectDyn : costobjects) {
                if (costobjectDyn == null) continue;
                Long trackNumber = costobjectDyn.getLong("tracknumber");
                Long configuredCode = costobjectDyn.getLong("configuredcode");
                if (CadEmptyUtils.isEmpty((Long)trackNumber) && CadEmptyUtils.isEmpty((Long)configuredCode)) continue;
                Long material = costobjectDyn.getLong("material");
                Long bizId = costobjectDyn.getLong("probill");
                Long manuorgId = costobjectDyn.getLong("manuorg");
                if (CadEmptyUtils.isEmpty((Long)material) || CadEmptyUtils.isEmpty((Long)bizId) || CadEmptyUtils.isEmpty((Long)manuorgId)) continue;
                Long stOrgId = (Long)manuorgToStMap.get(manuorgId);
                if (stOrgId == null) {
                    stOrgId = OrgHelper.getInvOrgIdByProduce((Long)manuorgId);
                    manuorgToStMap.put(manuorgId, stOrgId);
                }
                if (CadEmptyUtils.isEmpty((Long)stOrgId)) continue;
                sbentryToTrackStSets.add(String.format("%s@%s@%s", material, bizId, stOrgId));
                list.add(costobjectDyn);
            }
            logger.info("CostObjectTransfer->doTransferAfter->sbentryToTrackStSets:{}", (Object)sbentryToTrackStSets);
            this.setBillEnableTracknumber(list, sbentryToTrackStSets);
            this.setBillEnableConfigcode(list, sbentryToTrackStSets);
        }
        this.setProductTypeJoinToSide(costobjects, probills);
        this.dealAuxptyVeison(costobjects);
    }

    private void setProductTypeJoinToSide(Collection<DynamicObject> costobjects, Collection<DynamicObject> probills) {
        String productType;
        String val = "0";
        QFilter filter = new QFilter("key", "=", (Object)"isProductTJoinToSide");
        DynamicObject param = QueryServiceHelper.queryOne((String)"cad_bgparam", (String)"value", (QFilter[])new QFilter[]{filter});
        if (param != null) {
            val = param.getString("value");
        }
        if (!"1".equals(val)) {
            return;
        }
        logger.info("\u6210\u672c\u5bf9\u8c61\u5f15\u5165\u65f6\u8bbe\u7f6e\u8054\u4ea7\u54c1\u4e3a\u526f\u4ea7\u54c1\u5904\u7406");
        for (DynamicObject costobjectDyn : costobjects) {
            productType = costobjectDyn.getString("producttype");
            if (!"A".equals(productType)) continue;
            costobjectDyn.set("producttype", (Object)"B");
        }
        for (DynamicObject dyn : probills) {
            productType = dyn.getString("producttype");
            if (!"A".equals(productType)) continue;
            dyn.set("producttype", (Object)"B");
        }
    }

    private void setBillEnableTracknumber(List<DynamicObject> bills, Set<String> sbentryToTrackStSets) {
        if (sbentryToTrackStSets.isEmpty()) {
            return;
        }
        HashMap matTobizEntryIdMap = Maps.newHashMapWithExpectedSize((int)10);
        HashMap stToMaterials = Maps.newHashMapWithExpectedSize((int)10);
        for (String string : sbentryToTrackStSets) {
            String[] stringArray = string.split("@");
            if (stringArray.length < 3) continue;
            matTobizEntryIdMap.computeIfAbsent(String.format("%s@%s", stringArray[0], stringArray[2]), t -> new ArrayList()).add(Long.valueOf(stringArray[1]));
            stToMaterials.computeIfAbsent(Long.valueOf(stringArray[2]), t -> new HashSet(10)).add(Long.valueOf(stringArray[0]));
        }
        HashSet srcBillEntryKeys = Sets.newHashSetWithExpectedSize((int)10);
        for (Map.Entry entry : stToMaterials.entrySet()) {
            QFilter filter = new QFilter("manustrategy.noupdateinvdim.fbasedataid", "=", (Object)1297144009797647360L);
            filter.and("masterid", "in", entry.getValue());
            DynamicObjectCollection stockMaterialInfos = BaseDataServiceHelper.queryBaseData((String)"bd_materialinventoryinfo", (Long)((Long)entry.getKey()), (QFilter)filter, (String)"createorg,masterid material");
            for (DynamicObject dyn : stockMaterialInfos) {
                Long material = dyn.getLong("material");
                if (CadEmptyUtils.isEmpty((Long)material)) continue;
                String key = String.format("%s@%s", material, entry.getKey());
                srcBillEntryKeys.add(key);
            }
        }
        HashSet hashSet = Sets.newHashSetWithExpectedSize((int)10);
        for (Map.Entry entry : matTobizEntryIdMap.entrySet()) {
            if (!srcBillEntryKeys.contains(entry.getKey())) continue;
            hashSet.addAll((Collection)entry.getValue());
        }
        logger.info("\u8ddf\u8e2a\u53f7\u9694\u79bb\u7ef4\u5ea6\u5904\u7406\uff0c\u9700\u8981\u6e05\u7406\u7684\u4e1a\u52a1\u5355\u636e\u5206\u5f55id\uff1a{}", (Object)hashSet);
        for (DynamicObject bill : bills) {
            long srcBillEntryId = bill.getLong("probill");
            if (!hashSet.contains(srcBillEntryId)) continue;
            String noupdatecostfields = bill.getString("noupdatecostfields");
            if (StringUtils.isEmpty((CharSequence)noupdatecostfields)) {
                bill.set("noupdatecostfields", (Object)"{\"setnull\":[\"tracknumber\"]}");
                continue;
            }
            Set<String> nullFields = CostObjectTransfer.getNotUpdateFields(noupdatecostfields);
            nullFields.add("tracknumber");
            JSONObject jsonObj = new JSONObject();
            jsonObj.put("setnull", nullFields);
            bill.set("noupdatecostfields", (Object)jsonObj.toJSONString());
        }
    }

    private static Set<String> getNotUpdateFields(String noupdatecalfields) {
        if (StringUtils.isEmpty((CharSequence)noupdatecalfields)) {
            return new HashSet<String>(10);
        }
        JSONObject jsonObj = JSON.parseObject((String)noupdatecalfields);
        JSONArray arr = jsonObj.getJSONArray("setnull");
        if (arr == null || arr.isEmpty()) {
            return new HashSet<String>(10);
        }
        HashSet nullFields = Sets.newHashSetWithExpectedSize((int)10);
        for (int i = 0; i < arr.size(); ++i) {
            nullFields.add(arr.getString(i));
        }
        return nullFields;
    }

    private void setBillEnableConfigcode(List<DynamicObject> bills, Set<String> sbentryToTrackStSets) {
        if (sbentryToTrackStSets.isEmpty()) {
            return;
        }
        HashMap matTobizEntryIdMap = Maps.newHashMapWithExpectedSize((int)10);
        HashMap stToMaterials = Maps.newHashMapWithExpectedSize((int)10);
        for (String string : sbentryToTrackStSets) {
            String[] stringArray = string.split("@");
            if (stringArray.length < 3) continue;
            matTobizEntryIdMap.computeIfAbsent(String.format("%s@%s", stringArray[0], stringArray[2]), t -> new ArrayList()).add(Long.valueOf(stringArray[1]));
            stToMaterials.computeIfAbsent(Long.valueOf(stringArray[2]), t -> new HashSet(10)).add(Long.valueOf(stringArray[0]));
        }
        HashSet srcBillEntryKeys = Sets.newHashSetWithExpectedSize((int)10);
        for (Map.Entry entry : stToMaterials.entrySet()) {
            QFilter filter = new QFilter("manustrategy.noupdateinvdim.fbasedataid", "=", (Object)1721649779361985536L);
            filter.and("masterid", "in", entry.getValue());
            DynamicObjectCollection stockMaterialInfos = BaseDataServiceHelper.queryBaseData((String)"bd_materialinventoryinfo", (Long)((Long)entry.getKey()), (QFilter)filter, (String)"createorg,masterid material");
            for (DynamicObject dyn : stockMaterialInfos) {
                Long material = dyn.getLong("material");
                if (CadEmptyUtils.isEmpty((Long)material)) continue;
                String key = String.format("%s@%s", material, entry.getKey());
                srcBillEntryKeys.add(key);
            }
        }
        HashSet hashSet = Sets.newHashSetWithExpectedSize((int)10);
        for (Map.Entry entry : matTobizEntryIdMap.entrySet()) {
            if (!srcBillEntryKeys.contains(entry.getKey())) continue;
            hashSet.addAll((Collection)entry.getValue());
        }
        logger.info("\u914d\u7f6e\u53f7\u9694\u79bb\u7ef4\u5ea6\u5904\u7406\uff0c\u9700\u8981\u6e05\u7406\u7684\u4e1a\u52a1\u5355\u636e\u5206\u5f55id\uff1a{}", (Object)hashSet);
        for (DynamicObject bill : bills) {
            long srcBillEntryId = bill.getLong("probill");
            if (!hashSet.contains(srcBillEntryId)) continue;
            String noupdatecostfields = bill.getString("noupdatecostfields");
            if (StringUtils.isEmpty((CharSequence)noupdatecostfields)) {
                bill.set("noupdatecostfields", (Object)"{\"setnull\":[\"configuredcode\"]}");
                continue;
            }
            Set<String> nullFields = CostObjectTransfer.getNotUpdateFields(noupdatecostfields);
            nullFields.add("configuredcode");
            JSONObject jsonObj = new JSONObject();
            jsonObj.put("setnull", nullFields);
            bill.set("noupdatecostfields", (Object)jsonObj.toJSONString());
        }
    }

    @Override
    protected void doTransfer(DynamicObject bizBill, BillTransferResult result) {
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)this.fieldMappingEntryColl)) {
            return;
        }
        String policyclass = this.collConfig.getString("plugin");
        if (!CadEmptyUtils.isEmpty((String)policyclass)) {
            DynamicObject targetBill = CostConfigService.doTransferForPlugin(bizBill, this.collConfig, this.fieldMappingEntryColl);
            result.getSrcAndTargetBillsMap().put(bizBill, targetBill);
            return;
        }
        String sourceDateField = "";
        for (DynamicObject field : this.fieldMappingEntryColl) {
            String costField = field.getString("costfield");
            if (!"bookdate".equals(costField)) continue;
            sourceDateField = field.getString("sourcefield");
            break;
        }
        DynamicObject costObject = BusinessDataServiceHelper.newDynamicObject((String)"cad_costobject");
        String sourceBillEntity = this.collConfig.getString("sourcebill.id");
        for (DynamicObject field : this.fieldMappingEntryColl) {
            String selectvalue;
            String costField = field.getString("costfield");
            String sourceField = field.getString("sourcefield");
            switch (selectvalue = field.getString("selectvalue")) {
                case "0": {
                    if ("costcenter".equals(costField)) {
                        if (("pom_mftorder".equals(sourceBillEntity) || "om_mftorder".equals(sourceBillEntity)) && bizBill.getBoolean("isprocedure")) {
                            Map<Long, Long> proEntryIdWorkCenterMap = this.context.getConfigProEntryIdWorkCenterMap().get(this.collConfig);
                            Long srcCostCenterSourceData = null;
                            if (!CadEmptyUtils.isEmpty(proEntryIdWorkCenterMap) && (srcCostCenterSourceData = proEntryIdWorkCenterMap.get(bizBill.getLong("entryId"))) == null) {
                                srcCostCenterSourceData = proEntryIdWorkCenterMap.get(bizBill.getLong("pnodeId"));
                            }
                            DynamicObject costCenter = CostConfigService.getCostCenterBySrcBill(bizBill, sourceField, this.context.getCostCenterSourceDataMap(), srcCostCenterSourceData, sourceDateField, this.costCenterTypeAndSourceFieldMap);
                            costObject.set(costField, (Object)costCenter);
                            break;
                        }
                        DynamicObject costCenter = CostConfigService.getCostCenterBySrcBill(bizBill, sourceField, this.context.getCostCenterSourceDataMap(), null, sourceDateField, this.costCenterTypeAndSourceFieldMap);
                        costObject.set(costField, (Object)costCenter);
                        break;
                    }
                    if ("srcbillnumber".equals(costField)) {
                        costObject.set(costField, bizBill.get(sourceField));
                        costObject.set("srcbillrow", bizBill.get("entryseq"));
                        break;
                    }
                    if ("bomversion".equals(costField)) {
                        if (sourceField.contains("bomid")) {
                            costObject.set(costField, bizBill.get("bomversion"));
                            break;
                        }
                        costObject.set(costField, bizBill.get(sourceField));
                        break;
                    }
                    costObject.set(costField, bizBill.get(sourceField));
                    break;
                }
                case "1": {
                    String formulaStr = field.getString("formula");
                    if (CadEmptyUtils.isEmpty((String)formulaStr)) break;
                    Set formulaFields = (Set)this.formulaFieldMap.get(costField);
                    Object value = null;
                    try {
                        value = CostConfigService.execExcelFormula(bizBill, formulaStr, formulaFields);
                    }
                    catch (Exception e) {
                        HashMap<String, String> msg = new HashMap<String, String>(2);
                        msg.put("tip", String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u201c%1$s\u201d\u53d6\u503c\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u8ba1\u7b97\u516c\u5f0f\u662f\u5426\u6b63\u786e\uff0c\u9519\u8bef\u4fe1\u606f\uff1a%2$s\u3002", (String)"CostObjectTransfer_1", (String)"macc-cad-business", (Object[])new Object[0]), costField, e));
                        result.getErrorMsgList().add(msg);
                        return;
                    }
                    if (value == null) break;
                    costObject.set(costField, value);
                    break;
                }
                case "2": {
                    if ("costcenter".equals(costField)) {
                        costObject.set(costField, field.get("sourcedata"));
                        break;
                    }
                    costObject.set(costField, field.get("sourcedata_id"));
                }
            }
        }
        if ("bd_project".equals(sourceBillEntity)) {
            costObject.set("projectnumber", bizBill.get("id"));
        }
        if ("bd_tracknumber".equals(sourceBillEntity)) {
            costObject.set("tracknumber", bizBill.get("id"));
        }
        if ("bd_configuredcode".equals(sourceBillEntity)) {
            costObject.set("configuredcode", bizBill.get("id"));
        }
        if (CostObjectEnum.BIZTYPE_SP.getValue().equals(this.collConfig.getString("calmethod"))) {
            costObject.set("probill", (Object)0L);
        } else {
            costObject.set("probill", bizBill.get("entryId"));
        }
        costObject.set("billstatus", (Object)"C");
        costObject.set("srcbilltype", (Object)bizBill.getString("billtype"));
        costObject.set("collconfig", (Object)this.collConfig.getLong("id"));
        if ("pom_mftorder".equals(sourceBillEntity)) {
            costObject.set("isoutsource", (Object)Boolean.FALSE);
            costObject.set("isrework", (Object)bizBill.getBoolean("isrework"));
        }
        if ("om_mftorder".equals(sourceBillEntity) && CostObjectEnum.BIZTYPE_RO.getValue().equals(this.collConfig.getString("calmethod"))) {
            costObject.set("isoutsource", (Object)Boolean.TRUE);
            costObject.set("isrework", (Object)bizBill.getBoolean("isrework"));
        }
        result.getSrcAndTargetBillsMap().put(bizBill, costObject);
    }

    public void dealAuxptyVeison(Collection<DynamicObject> costobjects) {
        HashSet<Long> materialIds = new HashSet<Long>(10);
        for (DynamicObject useMaterial : costobjects) {
            if (useMaterial == null || CadEmptyUtils.isEmpty((Long)useMaterial.getLong("material"))) continue;
            materialIds.add(useMaterial.getLong("material"));
        }
        if (CadEmptyUtils.isEmpty(materialIds)) {
            return;
        }
        QFilter idQf = new QFilter("id", "in", materialIds);
        DynamicObjectCollection matObj = QueryServiceHelper.query((String)"bd_material", (String)"id,masterid,number,name,modelnum,isenablematerialversion,isuseauxpty", (QFilter[])new QFilter[]{idQf});
        HashMap<Long, DynamicObject> matObjMap = new HashMap<Long, DynamicObject>(10);
        for (DynamicObject row : matObj) {
            HashMap<String, Boolean> propMap = new HashMap<String, Boolean>(2);
            propMap.put("isenablematerialversion", row.getBoolean("isenablematerialversion"));
            propMap.put("isuseauxpty", row.getBoolean("isuseauxpty"));
            this.context.getMatPropMap().put(row.get("id"), propMap);
            matObjMap.put(row.getLong("id"), row);
        }
        Map materialMap = CostObjectHelper.getAssistMap(materialIds, (Long)this.context.getParam().getCalOrgId());
        HashMap<String, Long> auxptyMap = new HashMap<String, Long>(10);
        for (DynamicObject costobject : costobjects) {
            costobject.set("bomversion", (Object)0L);
            if (!CadEmptyUtils.isEmpty((Long)costobject.getLong("auxpty"))) {
                this.setAuxpty(costobject, costobject.get("material"), costobject.getLong("auxpty"), this.context.getMatPropMap(), auxptyMap, materialMap);
            }
            if (!matObjMap.containsKey(costobject.getLong("material"))) continue;
            costobject.set("material", matObjMap.get(costobject.getLong("material")));
        }
    }

    private void setVersion(DynamicObject row, Object materialId, Map<Object, Map<String, Boolean>> matPropMap) {
        if (materialId == null) {
            return;
        }
        Map<String, Boolean> matProp = null;
        if (matPropMap.containsKey(materialId)) {
            matProp = matPropMap.get(materialId);
        }
        if (matProp != null) {
            if (!matProp.get("isenablematerialversion").booleanValue()) {
                row.set("bomversion", (Object)0L);
            }
        } else {
            row.set("bomversion", (Object)0L);
        }
    }

    private void setAuxpty(DynamicObject row, Object materialId, Long auxptyId, Map<Object, Map<String, Boolean>> matPropMap, Map<String, Long> auxptyMap, Map<Long, Boolean> materialMap) {
        if (materialId == null) {
            return;
        }
        String key = String.format("%s@%s", materialId, auxptyId);
        if (auxptyMap.containsKey(key)) {
            row.set("auxpty", (Object)auxptyMap.get(key));
            return;
        }
        Map<String, Boolean> matProp = null;
        if (matPropMap.containsKey(materialId)) {
            matProp = matPropMap.get(materialId);
        }
        if (matProp != null) {
            Long effectCostAuxpty = 0L;
            if (!matProp.get("isuseauxpty").booleanValue()) {
                row.set("auxpty", (Object)0L);
                auxptyMap.put(key, effectCostAuxpty);
            } else {
                DynamicObject matObj = CostObjectHelper.getMaterialById((Long)Long.parseLong(materialId.toString()));
                DynamicObject auxpty = BusinessDataServiceHelper.loadSingleFromCache((Object)auxptyId, (String)"bd_flexauxprop");
                effectCostAuxpty = CostObjectHelper.getEffectCostAuxptyNew((DynamicObject)matObj, (DynamicObject)auxpty, materialMap, (String)this.collConfig.getString("calmethod"));
                auxptyMap.put(key, effectCostAuxpty);
                row.set("auxpty", (Object)effectCostAuxpty);
            }
        } else {
            row.set("auxpty", (Object)0L);
        }
    }
}

