/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.business.config.transfer;

import java.util.Date;
import java.util.HashMap;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.macc.cad.business.config.engine.AbstractBillTransfer;
import kd.macc.cad.business.config.engine.BillTransferResult;
import kd.macc.cad.business.config.engine.CollConifgParam;
import kd.macc.cad.business.config.service.CostConfigService;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class DiyCostDriverTransfer
extends AbstractBillTransfer {
    @Override
    protected void doTransfer(DynamicObject bizBill, BillTransferResult result) {
        String policyclass = this.collConfig.getString("plugin");
        if (!CadEmptyUtils.isEmpty((String)policyclass)) {
            DynamicObject targetBill = CostConfigService.doTransferForPlugin(bizBill, this.collConfig, this.fieldMappingEntryColl);
            result.getSrcAndTargetBillsMap().put(bizBill, targetBill);
            return;
        }
        String sourceDateField = "";
        for (Object field : this.fieldMappingEntryColl) {
            String costField = field.getString("costfield");
            if (!"bookdate".equals(costField)) continue;
            sourceDateField = field.getString("sourcefield");
            break;
        }
        DynamicObject diyCostDriverBill = BusinessDataServiceHelper.newDynamicObject((String)"sca_diycostdriver");
        for (DynamicObject field : this.fieldMappingEntryColl) {
            String costField = field.getString("costfield");
            String sourceField = field.getString("sourcefield");
            String selectValue = field.getString("selectvalue");
            if (costField == null) continue;
            switch (selectValue) {
                case "0": {
                    if (costField.contains(".")) {
                        String entryEntity = costField.split("\\.")[0];
                        String entryField = costField.split("\\.")[1];
                        DynamicObjectCollection entryObjects = diyCostDriverBill.getDynamicObjectCollection(entryEntity);
                        DynamicObject row = CadEmptyUtils.isEmpty((DynamicObjectCollection)entryObjects) ? entryObjects.addNew() : (DynamicObject)entryObjects.get(0);
                        if ("costobject".equals(entryField)) {
                            DynamicObject costObject = null;
                            if (bizBill.get(sourceField) != null) {
                                costObject = BusinessDataServiceHelper.loadSingleFromCache((Object)bizBill.get(sourceField), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cad_costobject"));
                            }
                            if (costObject != null && "C".equals(costObject.getString("billstatus"))) {
                                row.set(entryField, (Object)costObject);
                                row.set(entryField + "_id", (Object)costObject);
                                break;
                            }
                            row.set(entryField, null);
                            break;
                        }
                        if (costField.contains("costcenter")) {
                            DynamicObject costCenter = CostConfigService.getCostCenterBySrcBill(bizBill, sourceField, this.context.getCostCenterSourceDataMap(), null, sourceDateField, this.costCenterTypeAndSourceFieldMap);
                            row.set(entryField, (Object)costCenter);
                            break;
                        }
                        if (costField.contains("materialgroup")) {
                            Object matGroupId = bizBill.get(sourceField) == null ? Long.valueOf(0L) : bizBill.get(sourceField);
                            DynamicObject matGroup = BusinessDataServiceHelper.loadSingleFromCache((Object)matGroupId, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_materialgroup"));
                            if (matGroup != null) {
                                row.set(entryField, (Object)matGroup);
                                row.set(entryField + "_id", (Object)matGroup);
                                break;
                            }
                            row.set(entryField, null);
                            break;
                        }
                        if (costField.contains("matnum") || costField.contains("material")) {
                            Object matId = bizBill.get(sourceField) == null ? Long.valueOf(0L) : bizBill.get(sourceField);
                            DynamicObject mat = BusinessDataServiceHelper.loadSingleFromCache((Object)matId, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_material"));
                            if (mat != null) {
                                row.set(entryField, (Object)mat);
                                row.set(entryField + "_id", (Object)mat);
                                break;
                            }
                            row.set(entryField, null);
                            break;
                        }
                        if (costField.contains("auxpty")) {
                            Object auxptyId = bizBill.get(sourceField) == null ? Long.valueOf(0L) : bizBill.get(sourceField);
                            DynamicObject auxpty = BusinessDataServiceHelper.loadSingleFromCache((Object)auxptyId, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_flexauxprop"));
                            if (auxpty != null) {
                                row.set(entryField, (Object)auxpty);
                                row.set(entryField + "_id", (Object)auxpty);
                                break;
                            }
                            row.set(entryField, null);
                            break;
                        }
                        row.set(entryField, bizBill.get(sourceField));
                        break;
                    }
                    if (costField.contains("costcenter")) {
                        DynamicObject costCenter = CostConfigService.getCostCenterBySrcBill(bizBill, sourceField, this.context.getCostCenterSourceDataMap(), null, sourceDateField, this.costCenterTypeAndSourceFieldMap);
                        diyCostDriverBill.set(costField, (Object)costCenter);
                        break;
                    }
                    if (costField.contains("manuorg")) {
                        Object manuOrdId;
                        Object object = manuOrdId = bizBill.get(sourceField) == null ? Long.valueOf(0L) : bizBill.get(sourceField);
                        if (manuOrdId == null || Long.parseLong(String.valueOf(manuOrdId)) == 0L) {
                            diyCostDriverBill.set(costField, null);
                            break;
                        }
                        DynamicObject manuOrg = BusinessDataServiceHelper.loadSingleFromCache((Object)manuOrdId, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bos_org"));
                        if (manuOrg != null) {
                            diyCostDriverBill.set(costField, (Object)manuOrg);
                            diyCostDriverBill.set(costField + "_id", (Object)manuOrg.getLong("id"));
                            break;
                        }
                        diyCostDriverBill.set(costField, null);
                        break;
                    }
                    diyCostDriverBill.set(costField, bizBill.get(sourceField));
                    break;
                }
                case "1": {
                    DynamicObject row;
                    DynamicObjectCollection entryObjects;
                    String entryField;
                    String entryEntity;
                    String formulaStr = field.getString("formula");
                    if (CadEmptyUtils.isEmpty((String)formulaStr)) break;
                    Set formulaFields = (Set)this.formulaFieldMap.get(costField);
                    Object value = null;
                    try {
                        value = CostConfigService.execExcelFormula(bizBill, formulaStr, formulaFields);
                    }
                    catch (Exception e) {
                        HashMap<String, String> msg = new HashMap<String, String>(2);
                        msg.put("tip", String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u201c%1$s\u201d\u6839\u636e\u8ba1\u7b97\u516c\u5f0f\u53d6\u503c\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u8ba1\u7b97\u516c\u5f0f\u662f\u5426\u6b63\u786e\uff0c\u9519\u8bef\u4fe1\u606f\uff1a%2$s\u3002", (String)"DiyCostDriverTransfer_0", (String)"macc-cad-business", (Object[])new Object[0]), costField, e));
                        result.getErrorMsgList().add(msg);
                        return;
                    }
                    if (value == null) break;
                    if (costField.contains(".")) {
                        entryEntity = costField.split("\\.")[0];
                        entryField = costField.split("\\.")[1];
                        entryObjects = diyCostDriverBill.getDynamicObjectCollection(entryEntity);
                        row = CadEmptyUtils.isEmpty((DynamicObjectCollection)entryObjects) ? entryObjects.addNew() : (DynamicObject)entryObjects.get(0);
                        row.set(entryField, value);
                        break;
                    }
                    diyCostDriverBill.set(costField, value);
                    break;
                }
                case "2": {
                    DynamicObject row;
                    DynamicObjectCollection entryObjects;
                    String entryField;
                    String entryEntity;
                    if ("costcenter".equals(costField)) {
                        diyCostDriverBill.set(costField, field.get("sourcedata"));
                        break;
                    }
                    if (costField != null && costField.contains(".")) {
                        entryEntity = costField.split("\\.")[0];
                        entryField = costField.split("\\.")[1];
                        entryObjects = diyCostDriverBill.getDynamicObjectCollection(entryEntity);
                        row = CadEmptyUtils.isEmpty((DynamicObjectCollection)entryObjects) ? entryObjects.addNew() : (DynamicObject)entryObjects.get(0);
                        if ("benefcostcenter".equals(entryField)) {
                            DynamicObject costCenter = null;
                            if (field.get("sourcedata") != null) {
                                costCenter = BusinessDataServiceHelper.loadSingleFromCache((Object)field.get("sourcedata_id"), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bos_costcenter"));
                            }
                            row.set(entryField, costCenter);
                            break;
                        }
                        row.set(entryField, field.get("sourcedata"));
                        break;
                    }
                    diyCostDriverBill.set(costField, field.get("sourcedata_id"));
                }
            }
        }
        CollConifgParam collConifgParam = this.context.getParam();
        diyCostDriverBill.set("appnum", (Object)collConifgParam.getAppnum());
        diyCostDriverBill.set("costdriver", this.collConfig.get("costdriver"));
        diyCostDriverBill.set("materialgroupstd", this.collConfig.get("materialgroupstd"));
        diyCostDriverBill.set("billstatus", (Object)"A");
        diyCostDriverBill.set("effectstatus", (Object)"A");
        diyCostDriverBill.set("creator", (Object)RequestContext.get().getUserId());
        diyCostDriverBill.set("createtime", (Object)new Date());
        diyCostDriverBill.set("modifier", (Object)RequestContext.get().getUserId());
        diyCostDriverBill.set("modifytime", (Object)new Date());
        diyCostDriverBill.set("auditor", (Object)RequestContext.get().getUserId());
        diyCostDriverBill.set("auditdate", (Object)new Date());
        diyCostDriverBill.set("org_id", (Object)collConifgParam.getCalOrgId());
        long costAccountId = collConifgParam.getCostAccountId();
        diyCostDriverBill.set("costaccount_id", (Object)costAccountId);
        diyCostDriverBill.set("sourcetype", (Object)"SYS");
        diyCostDriverBill.set("collconfig", (Object)this.collConfig.getLong("id"));
        result.getSrcAndTargetBillsMap().put(bizBill, diyCostDriverBill);
    }
}

