/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.business.config.transfer;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.business.config.engine.AbstractBillTransfer;
import kd.macc.cad.business.config.engine.BillTransferResult;
import kd.macc.cad.business.config.service.CostConfigService;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.DateUtils;

public class FactOutPutTransfer
extends AbstractBillTransfer {
    private static Log logger = LogFactory.getLog(FactOutPutTransfer.class);

    @Override
    public void doTransferAfter(BillTransferResult result) {
        super.doTransferAfter(result);
        Map<DynamicObject, DynamicObject> srcMap = result.getSrcAndTargetBillsMap();
        Collection<DynamicObject> factDyns = srcMap.values();
        this.setProductTypeJoinToSide(factDyns);
    }

    private void setProductTypeJoinToSide(Collection<DynamicObject> factDyns) {
        String val = "0";
        QFilter filter = new QFilter("key", "=", (Object)"isProductTJoinToSide");
        DynamicObject param = QueryServiceHelper.queryOne((String)"cad_bgparam", (String)"value", (QFilter[])new QFilter[]{filter});
        if (param != null) {
            val = param.getString("value");
        }
        if (!"1".equals(val)) {
            return;
        }
        logger.info("\u5b8c\u5de5\u4ea7\u91cf\u5f52\u96c6\u5f15\u5165\u65f6\u8bbe\u7f6e\u8054\u4ea7\u54c1\u4e3a\u526f\u4ea7\u54c1\u5904\u7406");
        for (DynamicObject dyn : factDyns) {
            String productType = dyn.getString("producttype");
            if (!"A".equals(productType)) continue;
            dyn.set("producttype", (Object)"B");
        }
    }

    @Override
    protected void doTransfer(DynamicObject bizBill, BillTransferResult result) {
        String policyclass = this.collConfig.getString("plugin");
        if (!CadEmptyUtils.isEmpty((String)policyclass)) {
            DynamicObject targetBill = CostConfigService.doTransferForPlugin(bizBill, this.collConfig, this.fieldMappingEntryColl);
            result.getSrcAndTargetBillsMap().put(bizBill, targetBill);
            return;
        }
        String sourceDateField = "";
        for (DynamicObject field : this.fieldMappingEntryColl) {
            String costField = field.getString("costfield");
            if (!"bookdate".equals(costField)) continue;
            sourceDateField = field.getString("sourcefield");
            break;
        }
        DynamicObject factOutPut = BusinessDataServiceHelper.newDynamicObject((String)"cad_factnedoutputbill");
        factOutPut.set("id", (Object)ID.genLongId());
        String sourceBillEntity = this.collConfig.getString("sourcebill.id");
        for (DynamicObject field : this.fieldMappingEntryColl) {
            String selectvalue;
            String costField = field.getString("costfield");
            String sourceField = field.getString("sourcefield");
            switch (selectvalue = field.getString("selectvalue")) {
                case "0": {
                    if (costField != null && costField.contains(".")) {
                        String entryEtity = costField.split("\\.")[0];
                        String entryField = costField.split("\\.")[1];
                        DynamicObjectCollection entryObjects = factOutPut.getDynamicObjectCollection(entryEtity);
                        DynamicObject row = null;
                        row = CadEmptyUtils.isEmpty((DynamicObjectCollection)entryObjects) ? entryObjects.addNew() : (DynamicObject)entryObjects.get(0);
                        if ("costobject".equals(entryField)) {
                            Object costObjectId = bizBill.get(sourceField) == null ? Long.valueOf(0L) : bizBill.get(sourceField);
                            DynamicObject costObject = BusinessDataServiceHelper.loadSingleFromCache((Object)costObjectId, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cad_costobject"));
                            if (costObject != null && "C".equals(costObject.getString("billstatus"))) {
                                row.set(costField, (Object)costObject);
                                row.set(costField + "_id", (Object)costObject);
                                break;
                            }
                            row.set(costField, null);
                            break;
                        }
                        row.set(entryField, bizBill.get(sourceField));
                        break;
                    }
                    if ("costcenter".equals(costField)) {
                        DynamicObject costCenter = CostConfigService.getCostCenterBySrcBill(bizBill, sourceField, this.context.getCostCenterSourceDataMap(), null, sourceDateField, this.costCenterTypeAndSourceFieldMap);
                        Map<String, List<Long>> billRangeMap = this.context.getBillRangeMap();
                        Boolean isOldUser = this.context.isOldUser();
                        if (isOldUser.booleanValue()) {
                            List<Long> ccsIds = billRangeMap.get(sourceBillEntity);
                            if (costCenter != null && !ccsIds.contains(costCenter.getLong("id"))) {
                                logger.info("\u6210\u672c\u4e2d\u5fc3ID\uff1a{}\uff0c\u4e0d\u5f52\u96c6\u6e90\u5355\u7c7b\u578b\u4e3a{}\u7684\u5355\u636e", (Object)costCenter.getLong("id"), (Object)sourceBillEntity);
                                return;
                            }
                        }
                        factOutPut.set(costField, (Object)costCenter);
                        factOutPut.set(costField + "_id", (Object)(costCenter == null ? 0L : costCenter.getLong("id")));
                        break;
                    }
                    if ("material".equals(costField)) {
                        factOutPut.set(costField, bizBill.get(sourceField));
                        factOutPut.set(costField + "_id", bizBill.get(sourceField));
                        break;
                    }
                    factOutPut.set(costField, bizBill.get(sourceField));
                    break;
                }
                case "1": {
                    DynamicObjectCollection entryObjects;
                    String entryField;
                    String entryEtity;
                    String formulaStr = field.getString("formula");
                    if (CadEmptyUtils.isEmpty((String)formulaStr)) break;
                    Set formulaFields = (Set)this.formulaFieldMap.get(costField);
                    Object value = null;
                    try {
                        value = CostConfigService.execExcelFormula(bizBill, formulaStr, formulaFields);
                    }
                    catch (Exception e) {
                        HashMap<String, String> msg = new HashMap<String, String>(2);
                        msg.put("tip", String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u201c%1$s\u201d\u53d6\u503c\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u8ba1\u7b97\u516c\u5f0f\u662f\u5426\u6b63\u786e\uff0c\u9519\u8bef\u4fe1\u606f\uff1a%2$s\u3002", (String)"FactOutPutTransfer_1", (String)"macc-cad-business", (Object[])new Object[0]), costField, e));
                        result.getErrorMsgList().add(msg);
                        return;
                    }
                    if (value == null) break;
                    if (costField != null && costField.contains(".")) {
                        entryEtity = costField.split("\\.")[0];
                        entryField = costField.split("\\.")[1];
                        entryObjects = factOutPut.getDynamicObjectCollection(entryEtity);
                        DynamicObject row = null;
                        row = CadEmptyUtils.isEmpty((DynamicObjectCollection)entryObjects) ? entryObjects.addNew() : (DynamicObject)entryObjects.get(0);
                        row.set(entryField, value);
                        break;
                    }
                    factOutPut.set(costField, value);
                    break;
                }
                case "2": {
                    DynamicObjectCollection entryObjects;
                    String entryField;
                    String entryEtity;
                    if (costField != null && costField.contains(".")) {
                        entryEtity = costField.split("\\.")[0];
                        entryField = costField.split("\\.")[1];
                        entryObjects = factOutPut.getDynamicObjectCollection(entryEtity);
                        DynamicObject row = null;
                        row = CadEmptyUtils.isEmpty((DynamicObjectCollection)entryObjects) ? entryObjects.addNew() : (DynamicObject)entryObjects.get(0);
                        if ("costobject".equals(entryField)) {
                            row.set(costField, field.get("sourcedata"));
                            break;
                        }
                        row.set(entryField, field.get("sourcedata_id"));
                        break;
                    }
                    if ("costcenter".equals(costField)) {
                        Map<String, List<Long>> billRangeMap = this.context.getBillRangeMap();
                        Boolean isOldUser = this.context.isOldUser();
                        if (isOldUser.booleanValue()) {
                            List<Long> ccsIds = billRangeMap.get(sourceBillEntity);
                            long costCenterId = field.getLong("sourcedata_id");
                            if (field.get("sourcedata") != null && !ccsIds.contains(costCenterId)) {
                                logger.info("\u6210\u672c\u4e2d\u5fc3ID\uff1a{}\uff0c\u4e0d\u5f52\u96c6\u6e90\u5355\u7c7b\u578b\u4e3a{}\u7684\u5355\u636e", (Object)costCenterId, (Object)sourceBillEntity);
                                return;
                            }
                        }
                        factOutPut.set(costField, field.get("sourcedata"));
                        break;
                    }
                    factOutPut.set(costField, field.get("sourcedata_id"));
                }
            }
        }
        factOutPut.set("appnum", (Object)this.context.getParam().getAppnum());
        factOutPut.set("sourcebill", bizBill.get("id"));
        factOutPut.set("sourcebillentry", bizBill.get("entryId"));
        factOutPut.set("org_id", (Object)this.context.getParam().getCalOrgId());
        factOutPut.set("org", (Object)this.context.getParam().getCalOrgId());
        factOutPut.set("billstatus", (Object)"C");
        factOutPut.set("collconfig", (Object)this.collConfig.getLong("id"));
        factOutPut.set("billno", (Object)bizBill.getString("billno").concat("-").concat(bizBill.getString("entryseq")).concat("-").concat(bizBill.getString("entryId").substring(bizBill.getString("entryId").length() - 5)));
        if (bizBill.containsProperty("invOrg")) {
            factOutPut.set("invorg", (Object)bizBill.getLong("invOrg"));
        }
        factOutPut.set("srcbilltype", (Object)bizBill.getString("billtype"));
        if (factOutPut.get("nsrcauditdate") == null) {
            factOutPut.set("nsrcauditdate", (Object)bizBill.getDate("auditdate"));
        }
        factOutPut.set("completetype", (Object)"CONFIG");
        if ("im_mdc_mftmanuinbill".equals(sourceBillEntity) || "im_mdc_mftreturnbill".equals(sourceBillEntity) || "im_mdc_omcmplinbill".equals(sourceBillEntity) || "im_productinbill".equals(sourceBillEntity)) {
            factOutPut.set("srcauditdate", (Object)DateUtils.getPriceDate((Date)bizBill.getDate("auditdate"), (Date)bizBill.getDate("bookdate")));
        }
        result.getSrcAndTargetBillsMap().put(bizBill, factOutPut);
    }
}

