/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.business.config.transfer;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.business.config.engine.AbstractBillTransfer;
import kd.macc.cad.business.config.engine.BillTransferResult;
import kd.macc.cad.business.config.service.CostConfigService;
import kd.macc.cad.common.helper.CostObjectHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class MatAllocTransfer
extends AbstractBillTransfer {
    private Log logger = LogFactory.getLog(MatAllocTransfer.class);

    @Override
    protected void doTransfer(DynamicObject bizBill, BillTransferResult result) {
        if (bizBill == null) {
            return;
        }
        String policyclass = this.collConfig.getString("plugin");
        if (!CadEmptyUtils.isEmpty((String)policyclass)) {
            DynamicObject targetBill = CostConfigService.doTransferForPlugin(bizBill, this.collConfig, this.fieldMappingEntryColl);
            result.getSrcAndTargetBillsMap().put(bizBill, targetBill);
            return;
        }
        String entity = "aca_matalloc";
        String sourceDateField = "";
        for (DynamicObject field : this.fieldMappingEntryColl) {
            String costField = field.getString("costfield");
            if (!"bizdate".equals(costField)) continue;
            sourceDateField = field.getString("sourcefield");
            break;
        }
        DynamicObject matAllocBill = BusinessDataServiceHelper.newDynamicObject((String)entity);
        Boolean isSetVersionAuxpty = false;
        String sourceBillEntity = this.collConfig.getString("sourcebill.id");
        Map<Long, Boolean> materalMap = this.getMateralMap(bizBill);
        block13: for (DynamicObject field : this.fieldMappingEntryColl) {
            String selectvalue;
            String costField = field.getString("costfield");
            String sourceField = field.getString("sourcefield");
            switch (selectvalue = field.getString("selectvalue")) {
                case "0": {
                    if (costField != null && costField.contains(".")) {
                        String entryField = costField.split("\\.")[1];
                        DynamicObject row = matAllocBill;
                        isSetVersionAuxpty = false;
                        if ("im_materialreqoutbill".equals(sourceBillEntity) || "im_mdc_mftproorder".equals(sourceBillEntity) || "im_mdc_mftreturnorder".equals(sourceBillEntity) || "im_mdc_mftfeedorder".equals(sourceBillEntity) || "im_mdc_omoutbill".equals(sourceBillEntity) || "im_mdc_omreturnbill".equals(sourceBillEntity) || "im_mdc_omfeedbill".equals(sourceBillEntity)) {
                            row.set("isrework", (Object)bizBill.getBoolean("billentry.isrework"));
                        }
                        row.set("sourcebillid", bizBill.get("id"));
                        row.set("sourcebillentryid", bizBill.get("entryId"));
                        if ("costobject".equals(entryField)) {
                            Object costObjectId = bizBill.get(sourceField) == null ? Long.valueOf(0L) : bizBill.get(sourceField);
                            DynamicObject costObject = null;
                            if (!CadEmptyUtils.isEmpty((String)String.valueOf(costObjectId))) {
                                costObject = BusinessDataServiceHelper.loadSingleFromCache((Object)costObjectId, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cad_costobject"));
                            }
                            if (costObject != null && "C".equals(costObject.getString("billstatus"))) {
                                row.set(costField, (Object)costObject);
                            } else {
                                row.set(costField, null);
                            }
                        } else if ("material".equals(entryField)) {
                            row.set(entryField, bizBill.get(sourceField));
                            row.set(entryField + "_id", bizBill.get(sourceField));
                        } else {
                            row.set(entryField, bizBill.get(sourceField));
                        }
                        if (isSetVersionAuxpty.booleanValue() || row.get("material") == null || row.get("auxpty") == null) continue block13;
                        this.setVersionAuxpty(row, row.get("material"), row.get("auxpty"), this.context.getMatPropMap(), materalMap);
                        isSetVersionAuxpty = true;
                        break;
                    }
                    if ("costcenter".equals(costField)) {
                        DynamicObject costCenter = CostConfigService.getCostCenterBySrcBill(bizBill, sourceField, this.context.getCostCenterSourceDataMap(), null, sourceDateField, this.costCenterTypeAndSourceFieldMap);
                        Map<String, List<Long>> billRangeMap = this.context.getBillRangeMap();
                        Boolean isOldUser = this.context.isOldUser();
                        if (isOldUser.booleanValue()) {
                            List<Long> ccsIds = billRangeMap.get(sourceBillEntity);
                            if (costCenter != null && !ccsIds.contains(costCenter.getLong("id"))) {
                                this.logger.info("\u6210\u672c\u4e2d\u5fc3ID\uff1a{}\uff0c\u4e0d\u5f52\u96c6\u6e90\u5355\u7c7b\u578b\u4e3a{}\u7684\u5355\u636e", (Object)costCenter.getLong("id"), (Object)sourceBillEntity);
                                return;
                            }
                        }
                        matAllocBill.set(costField, (Object)costCenter);
                        break;
                    }
                    matAllocBill.set(costField, bizBill.get(sourceField));
                    break;
                }
                case "1": {
                    DynamicObjectCollection entryObjects;
                    String entryField;
                    String entryEntity;
                    String formulaStr = field.getString("formula");
                    if (CadEmptyUtils.isEmpty((String)formulaStr)) break;
                    Set formulaFields = (Set)this.formulaFieldMap.get(costField);
                    Object value = null;
                    try {
                        value = CostConfigService.execExcelFormula(bizBill, formulaStr, formulaFields);
                    }
                    catch (Exception e) {
                        HashMap<String, String> msg = new HashMap<String, String>(2);
                        msg.put("tip", String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u201c%1$s\u201d\u6839\u636e\u8ba1\u7b97\u516c\u5f0f\u53d6\u503c\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u8ba1\u7b97\u516c\u5f0f\u662f\u5426\u6b63\u786e\uff0c\u9519\u8bef\u4fe1\u606f\uff1a%2$s\u3002", (String)"MatAllocTransfer_0", (String)"macc-cad-business", (Object[])new Object[0]), costField, e));
                        result.getErrorMsgList().add(msg);
                        return;
                    }
                    if (value == null) break;
                    if (costField != null && costField.contains(".")) {
                        entryEntity = costField.split("\\.")[0];
                        entryField = costField.split("\\.")[1];
                        entryObjects = matAllocBill.getDynamicObjectCollection(entryEntity);
                        DynamicObject row = !CadEmptyUtils.isEmpty((DynamicObjectCollection)entryObjects) ? (DynamicObject)entryObjects.get(0) : entryObjects.addNew();
                        row.set("sourcebillid", bizBill.get("id"));
                        row.set("sourcebillentryid", bizBill.get("entryId"));
                        row.set(entryField, value);
                        break;
                    }
                    matAllocBill.set(costField, value);
                    break;
                }
                case "2": {
                    DynamicObjectCollection entryObjects;
                    String entryField;
                    String entryEntity;
                    if (costField != null && costField.contains(".")) {
                        entryEntity = costField.split("\\.")[0];
                        entryField = costField.split("\\.")[1];
                        entryObjects = matAllocBill.getDynamicObjectCollection(entryEntity);
                        DynamicObject row = !CadEmptyUtils.isEmpty((DynamicObjectCollection)entryObjects) ? (DynamicObject)entryObjects.get(0) : entryObjects.addNew();
                        isSetVersionAuxpty = false;
                        row.set("sourcebillid", bizBill.get("id"));
                        row.set("sourcebillentryid", bizBill.get("entryId"));
                        if ("costobject".equals(entryField)) {
                            row.set(entryField, field.get("sourcedata"));
                        } else {
                            row.set(entryField, field.get("sourcedata_id"));
                        }
                        if (isSetVersionAuxpty.booleanValue() || row.get("material") == null || row.get("auxpty") == null) continue block13;
                        this.setVersionAuxpty(row, row.get("material"), row.get("auxpty"), this.context.getMatPropMap(), materalMap);
                        break;
                    }
                    if ("costcenter".equals(costField)) {
                        Map<String, List<Long>> billRangeMap = this.context.getBillRangeMap();
                        Boolean isOldUser = this.context.isOldUser();
                        if (isOldUser.booleanValue()) {
                            List<Long> ccsIds = billRangeMap.get(sourceBillEntity);
                            long costCenterId = field.getLong("sourcedata_id");
                            if (field.get("sourcedata") != null && !ccsIds.contains(costCenterId)) {
                                this.logger.info("\u6210\u672c\u4e2d\u5fc3ID\uff1a{}\uff0c\u4e0d\u5f52\u96c6\u6e90\u5355\u7c7b\u578b\u4e3a{}\u7684\u5355\u636e", (Object)costCenterId, (Object)sourceBillEntity);
                                return;
                            }
                        }
                        matAllocBill.set(costField, field.get("sourcedata"));
                        break;
                    }
                    matAllocBill.set(costField, field.get("sourcedata_id"));
                    break;
                }
            }
        }
        matAllocBill.set("appnum", (Object)this.context.getParam().getAppnum());
        matAllocBill.set("sourcebillentryid", bizBill.get("entryId"));
        matAllocBill.set("org_id", (Object)this.context.getParam().getCalOrgId());
        matAllocBill.set("org", (Object)this.context.getParam().getCalOrgId());
        matAllocBill.set("collconfig", (Object)this.collConfig.getLong("id"));
        matAllocBill.set("billno", (Object)bizBill.getString("billno").concat("-").concat(bizBill.getString("entryseq")));
        matAllocBill.set("srcbilltype", (Object)bizBill.getString("billtype"));
        if (matAllocBill.get("nsrcauditdate") == null) {
            matAllocBill.set("nsrcauditdate", (Object)bizBill.getDate("auditdate"));
        }
        result.getSrcAndTargetBillsMap().put(bizBill, matAllocBill);
    }

    private Map<Long, Boolean> getMateralMap(DynamicObject bizBill) {
        HashSet<Long> materialIds = new HashSet<Long>(10);
        for (DynamicObject field : this.fieldMappingEntryColl) {
            String selectvalue;
            String costField = field.getString("costfield");
            String sourceField = field.getString("sourcefield");
            switch (selectvalue = field.getString("selectvalue")) {
                case "0": 
                case "2": {
                    String entryField;
                    if (costField == null || !costField.contains(".") || !"material".equals(entryField = costField.split("\\.")[1])) break;
                    materialIds.add(bizBill.getLong(sourceField));
                }
            }
        }
        Map materialMap = CostObjectHelper.getAssistMap(materialIds, (Long)this.context.getParam().getCalOrgId());
        return materialMap;
    }

    private void setVersionAuxpty(DynamicObject row, Object materialId, Object auxptyId, Map<Object, Map<String, Boolean>> matPropMap, Map<Long, Boolean> materalMap) {
        DynamicObject matObj;
        if (materialId == null) {
            return;
        }
        Map<String, Boolean> matProp = null;
        if (matPropMap.containsKey(materialId)) {
            matProp = matPropMap.get(materialId);
        } else {
            QFilter idQf = new QFilter("id", "=", materialId);
            matObj = QueryServiceHelper.queryOne((String)"bd_material", (String)"isenablematerialversion,isuseauxpty", (QFilter[])new QFilter[]{idQf});
            if (matObj != null) {
                HashMap<String, Boolean> propMap = new HashMap<String, Boolean>(2);
                propMap.put("isenablematerialversion", matObj.getBoolean("isenablematerialversion"));
                propMap.put("isuseauxpty", matObj.getBoolean("isuseauxpty"));
                matPropMap.put(materialId, propMap);
                matProp = propMap;
            }
        }
        if (matProp != null) {
            Long effectCostAuxpty = 0L;
            if (!matProp.get("isenablematerialversion").booleanValue()) {
                row.set("matversion", (Object)0L);
            }
            if (!matProp.get("isuseauxpty").booleanValue()) {
                row.set("auxpty", (Object)0L);
            } else {
                matObj = CostObjectHelper.getMaterialById((Long)Long.parseLong(materialId.toString()));
                Long auxId = auxptyId == null ? 0L : Long.parseLong(auxptyId.toString());
                DynamicObject auxpty = BusinessDataServiceHelper.loadSingleFromCache((Object)auxId, (String)"bd_flexauxprop");
                effectCostAuxpty = CostObjectHelper.getEffectCostAuxptyNew((DynamicObject)matObj, (DynamicObject)auxpty, materalMap, (String)this.collConfig.getString("calmethod"));
                row.set("auxpty", (Object)effectCostAuxpty);
            }
        } else {
            row.set("matversion", (Object)0L);
            row.set("auxpty", (Object)0L);
        }
    }
}

