/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.business.config.transfer;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.business.config.engine.AbstractBillTransfer;
import kd.macc.cad.business.config.engine.BillTransferResult;
import kd.macc.cad.business.config.service.CostConfigService;
import kd.macc.cad.common.helper.CostObjectHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class MatUseTransfer
extends AbstractBillTransfer {
    private static final Log logger = LogFactory.getLog(MatUseTransfer.class);

    @Override
    protected void doTransfer(DynamicObject bizBill, BillTransferResult result) {
        logger.info("\u6750\u6599\u8017\u7528\u8f6c\u6362");
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)this.fieldMappingEntryColl)) {
            logger.info("fieldMappingEntryColl = \u7a7a");
            return;
        }
        String policyclass = this.collConfig.getString("plugin");
        logger.info("policyclass = {}", (Object)policyclass);
        if (!CadEmptyUtils.isEmpty((String)policyclass)) {
            DynamicObject targetBill = CostConfigService.doTransferForPluginForEca(bizBill, this.collConfig, this.fieldMappingEntryColl, this.context);
            result.getSrcAndTargetBillsMap().put(bizBill, targetBill);
            return;
        }
        String sourceDateField = "";
        for (DynamicObject field : this.fieldMappingEntryColl) {
            String costField = field.getString("costfield");
            if (!"bizdate".equals(costField)) continue;
            sourceDateField = field.getString("sourcefield");
            break;
        }
        DynamicObject matAlloc = BusinessDataServiceHelper.newDynamicObject((String)"aca_matalloc");
        for (DynamicObject field : this.fieldMappingEntryColl) {
            String selectvalue;
            String costField = field.getString("costfield");
            String sourceField = field.getString("sourcefield");
            switch (selectvalue = field.getString("selectvalue")) {
                case "0": {
                    if ("costcenter".equals(costField)) {
                        DynamicObject costCenter = CostConfigService.getCostCenterBySrcBill(bizBill, sourceField, this.context.getCostCenterSourceDataMap(), null, sourceDateField, this.costCenterTypeAndSourceFieldMap);
                        matAlloc.set(costField, (Object)costCenter);
                        break;
                    }
                    if ("material".equals(costField)) {
                        matAlloc.set(costField, bizBill.get(sourceField));
                        matAlloc.set(costField + "_id", bizBill.get(sourceField));
                        break;
                    }
                    matAlloc.set(costField, bizBill.get(sourceField));
                    break;
                }
                case "1": {
                    String formulaStr = field.getString("formula");
                    if (CadEmptyUtils.isEmpty((String)formulaStr)) break;
                    Set formulaFields = (Set)this.formulaFieldMap.get(costField);
                    Object value = null;
                    try {
                        value = CostConfigService.execExcelFormula(bizBill, formulaStr, formulaFields);
                    }
                    catch (Exception e) {
                        HashMap<String, String> msg = new HashMap<String, String>(2);
                        msg.put("tip", String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u201c%1$s\u201d\u6839\u636e\u8ba1\u7b97\u516c\u5f0f\u53d6\u503c\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u8ba1\u7b97\u516c\u5f0f\u662f\u5426\u6b63\u786e\u3002\u9519\u8bef\u4fe1\u606f\uff1a%2$s\u3002", (String)"MatUseTransfer_1", (String)"macc-cad-business", (Object[])new Object[0]), costField, e));
                        result.getErrorMsgList().add(msg);
                        return;
                    }
                    if (value == null) break;
                    matAlloc.set(costField, value);
                    break;
                }
                case "2": {
                    if ("costcenter".equals(costField)) {
                        matAlloc.set(costField, field.get("sourcedata"));
                        break;
                    }
                    matAlloc.set(costField, field.get("sourcedata_id"));
                    break;
                }
            }
        }
        matAlloc.set("billno", (Object)bizBill.getString("billno").concat("-").concat(bizBill.getString("entryseq")));
        matAlloc.set("period", (Object)this.context.getParam().getCurPeriodId());
        logger.info("MatAllcoProp.MATCOLLECT = {}", (Object)bizBill.getLong("id"));
        matAlloc.set("matcollect", (Object)bizBill.getLong("id"));
        matAlloc.set("matusesrcbillentryid", (Object)bizBill.getLong("entryId"));
        result.getSrcAndTargetBillsMap().put(bizBill, matAlloc);
    }

    @Override
    public void doTransferAfter(BillTransferResult result) {
        super.doTransferAfter(result);
        Map<DynamicObject, DynamicObject> srcMap = result.getSrcAndTargetBillsMap();
        Collection<DynamicObject> materials = srcMap.values();
        HashSet<Long> materialIds = new HashSet<Long>(10);
        for (DynamicObject useMaterial : materials) {
            if (CadEmptyUtils.isEmpty((Long)useMaterial.getLong("material")) || CadEmptyUtils.isEmpty((Long)useMaterial.getLong("auxpty")) && CadEmptyUtils.isEmpty((Long)useMaterial.getLong("matversion"))) continue;
            materialIds.add(useMaterial.getLong("material"));
        }
        if (CadEmptyUtils.isEmpty(materialIds)) {
            return;
        }
        QFilter idQf = new QFilter("id", "in", materialIds);
        DataSet matObj = QueryServiceHelper.queryDataSet((String)"materials", (String)"bd_material", (String)"id,isenablematerialversion,isuseauxpty", (QFilter[])new QFilter[]{idQf}, null);
        for (Row row : matObj) {
            HashMap<String, Boolean> propMap = new HashMap<String, Boolean>(2);
            propMap.put("isenablematerialversion", row.getBoolean("isenablematerialversion"));
            propMap.put("isuseauxpty", row.getBoolean("isuseauxpty"));
            this.context.getMatPropMap().put(row.get("id"), propMap);
        }
        Map materialMap = CostObjectHelper.getAssistMap(materialIds, (Long)this.context.getParam().getCalOrgId());
        HashMap<String, Long> auxptyMap = new HashMap<String, Long>(10);
        for (DynamicObject useMaterial : materials) {
            if (!CadEmptyUtils.isEmpty((Long)useMaterial.getLong("matversion"))) {
                this.setVersion(useMaterial, useMaterial.get("material"), this.context.getMatPropMap());
            }
            if (CadEmptyUtils.isEmpty((Long)useMaterial.getLong("auxpty"))) continue;
            this.setAuxpty(useMaterial, useMaterial.get("material"), useMaterial.getLong("auxpty"), this.context.getMatPropMap(), auxptyMap, materialMap);
        }
    }

    private void setVersion(DynamicObject row, Object materialId, Map<Object, Map<String, Boolean>> matPropMap) {
        if (materialId == null) {
            return;
        }
        Map<String, Boolean> matProp = null;
        if (matPropMap.containsKey(materialId)) {
            matProp = matPropMap.get(materialId);
        }
        if (matProp != null) {
            if (!matProp.get("isenablematerialversion").booleanValue()) {
                row.set("matversion", (Object)0L);
            }
        } else {
            row.set("matversion", (Object)0L);
        }
    }

    private void setAuxpty(DynamicObject row, Object materialId, Long auxptyId, Map<Object, Map<String, Boolean>> matPropMap, Map<String, Long> auxptyMap, Map<Long, Boolean> materialMap) {
        if (materialId == null) {
            return;
        }
        String key = String.format("%s@%s", materialId, auxptyId);
        if (auxptyMap.containsKey(key)) {
            row.set("auxpty", (Object)auxptyMap.get(key));
            return;
        }
        Map<String, Boolean> matProp = null;
        if (matPropMap.containsKey(materialId)) {
            matProp = matPropMap.get(materialId);
        }
        if (matProp != null) {
            Long effectCostAuxpty = 0L;
            if (!matProp.get("isuseauxpty").booleanValue()) {
                row.set("auxpty", (Object)0L);
                auxptyMap.put(key, effectCostAuxpty);
            } else {
                DynamicObject matObj = CostObjectHelper.getMaterialById((Long)Long.parseLong(materialId.toString()));
                DynamicObject auxpty = BusinessDataServiceHelper.loadSingleFromCache((Object)auxptyId, (String)"bd_flexauxprop");
                effectCostAuxpty = CostObjectHelper.getEffectCostAuxptyNew((DynamicObject)matObj, (DynamicObject)auxpty, materialMap, (String)this.collConfig.getString("calmethod"));
                auxptyMap.put(key, effectCostAuxpty);
                row.set("auxpty", (Object)effectCostAuxpty);
            }
        } else {
            row.set("auxpty", (Object)0L);
        }
    }
}

