/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.business.config.transfer;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.business.config.engine.AbstractBillTransfer;
import kd.macc.cad.business.config.engine.BillTransferResult;
import kd.macc.cad.business.config.service.CostConfigService;
import kd.macc.cad.common.helper.CostObjectHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.DateUtils;

public class MaterialsUseTransfer
extends AbstractBillTransfer {
    private Log logger = LogFactory.getLog(MaterialsUseTransfer.class);

    @Override
    protected void doTransfer(DynamicObject bizBill, BillTransferResult result) {
        if (bizBill == null) {
            return;
        }
        String policyclass = this.collConfig.getString("plugin");
        if (!CadEmptyUtils.isEmpty((String)policyclass)) {
            DynamicObject targetBill = CostConfigService.doTransferForPlugin(bizBill, this.collConfig, this.fieldMappingEntryColl);
            result.getSrcAndTargetBillsMap().put(bizBill, targetBill);
            return;
        }
        String entity = "sca_matusecollect";
        if ("aca".equals(this.context.getParam().getAppnum())) {
            entity = "aca_matusecollect";
        }
        String sourceDateField = "";
        for (DynamicObject field : this.fieldMappingEntryColl) {
            String costField = field.getString("costfield");
            if (!"bookdate".equals(costField)) continue;
            sourceDateField = field.getString("sourcefield");
            break;
        }
        DynamicObject materialBill = BusinessDataServiceHelper.newDynamicObject((String)entity);
        String sourceBillEntity = this.collConfig.getString("sourcebill.id");
        for (DynamicObject field : this.fieldMappingEntryColl) {
            String selectvalue;
            String costField = field.getString("costfield");
            String sourceField = field.getString("sourcefield");
            switch (selectvalue = field.getString("selectvalue")) {
                case "0": {
                    if (costField != null && costField.contains(".")) {
                        String entryEntity = costField.split("\\.")[0];
                        String entryField = costField.split("\\.")[1];
                        DynamicObjectCollection entryObjects = materialBill.getDynamicObjectCollection(entryEntity);
                        DynamicObject row = !CadEmptyUtils.isEmpty((DynamicObjectCollection)entryObjects) ? (DynamicObject)entryObjects.get(0) : entryObjects.addNew();
                        if ("im_materialreqoutbill".equals(sourceBillEntity) || "im_mdc_mftproorder".equals(sourceBillEntity) || "im_mdc_mftreturnorder".equals(sourceBillEntity) || "im_mdc_mftfeedorder".equals(sourceBillEntity) || "im_mdc_omoutbill".equals(sourceBillEntity) || "im_mdc_omreturnbill".equals(sourceBillEntity) || "im_mdc_omfeedbill".equals(sourceBillEntity)) {
                            row.set("isrework", (Object)bizBill.getBoolean("billentry.isrework"));
                        }
                        row.set("sourcebillentryid", bizBill.get("entryId"));
                        if ("costobject".equals(entryField)) {
                            Object costObjectId = bizBill.get(sourceField) == null ? Long.valueOf(0L) : bizBill.get(sourceField);
                            DynamicObject costObject = null;
                            if (!CadEmptyUtils.isEmpty((String)String.valueOf(costObjectId))) {
                                costObject = BusinessDataServiceHelper.loadSingleFromCache((Object)costObjectId, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cad_costobject"));
                            }
                            if (costObject != null && "C".equals(costObject.getString("billstatus"))) {
                                row.set(costField, (Object)costObject);
                                break;
                            }
                            row.set(costField, null);
                            break;
                        }
                        if ("material".equals(entryField)) {
                            row.set(entryField, bizBill.get(sourceField));
                            row.set(entryField + "_id", bizBill.get(sourceField));
                            break;
                        }
                        row.set(entryField, bizBill.get(sourceField));
                        break;
                    }
                    if ("costcenter".equals(costField)) {
                        DynamicObject costCenter = CostConfigService.getCostCenterBySrcBill(bizBill, sourceField, this.context.getCostCenterSourceDataMap(), null, sourceDateField, this.costCenterTypeAndSourceFieldMap);
                        Map<String, List<Long>> billRangeMap = this.context.getBillRangeMap();
                        Boolean isOldUser = this.context.isOldUser();
                        if (isOldUser.booleanValue()) {
                            List<Long> ccsIds = billRangeMap.get(sourceBillEntity);
                            if (costCenter != null && !ccsIds.contains(costCenter.getLong("id"))) {
                                this.logger.info("\u6210\u672c\u4e2d\u5fc3ID\uff1a{}\uff0c\u4e0d\u5f52\u96c6\u6e90\u5355\u7c7b\u578b\u4e3a{}\u7684\u5355\u636e", (Object)costCenter.getLong("id"), (Object)sourceBillEntity);
                                return;
                            }
                        }
                        materialBill.set(costField, (Object)costCenter);
                        break;
                    }
                    materialBill.set(costField, bizBill.get(sourceField));
                    break;
                }
                case "1": {
                    DynamicObjectCollection entryObjects;
                    String entryField;
                    String entryEntity;
                    String formulaStr = field.getString("formula");
                    if (CadEmptyUtils.isEmpty((String)formulaStr)) break;
                    Set formulaFields = (Set)this.formulaFieldMap.get(costField);
                    Object value = null;
                    try {
                        value = CostConfigService.execExcelFormula(bizBill, formulaStr, formulaFields);
                    }
                    catch (Exception e) {
                        HashMap<String, String> msg = new HashMap<String, String>(2);
                        msg.put("tip", String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u201c%1$s\u201d\u53d6\u503c\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u8ba1\u7b97\u516c\u5f0f\u662f\u5426\u6b63\u786e\uff0c\u9519\u8bef\u4fe1\u606f\uff1a%2$s\u3002", (String)"MaterialsUseTransfer_1", (String)"macc-cad-business", (Object[])new Object[0]), costField, e));
                        result.getErrorMsgList().add(msg);
                        return;
                    }
                    if (value == null) break;
                    if (costField != null && costField.contains(".")) {
                        entryEntity = costField.split("\\.")[0];
                        entryField = costField.split("\\.")[1];
                        entryObjects = materialBill.getDynamicObjectCollection(entryEntity);
                        DynamicObject row = !CadEmptyUtils.isEmpty((DynamicObjectCollection)entryObjects) ? (DynamicObject)entryObjects.get(0) : entryObjects.addNew();
                        row.set("sourcebillentryid", bizBill.get("entryId"));
                        row.set(entryField, value);
                        break;
                    }
                    materialBill.set(costField, value);
                    break;
                }
                case "2": {
                    DynamicObjectCollection entryObjects;
                    String entryField;
                    String entryEntity;
                    if (costField != null && costField.contains(".")) {
                        entryEntity = costField.split("\\.")[0];
                        entryField = costField.split("\\.")[1];
                        entryObjects = materialBill.getDynamicObjectCollection(entryEntity);
                        DynamicObject row = !CadEmptyUtils.isEmpty((DynamicObjectCollection)entryObjects) ? (DynamicObject)entryObjects.get(0) : entryObjects.addNew();
                        row.set("sourcebillentryid", bizBill.get("entryId"));
                        if ("costobject".equals(entryField)) {
                            row.set(entryField, field.get("sourcedata"));
                            break;
                        }
                        row.set(entryField, field.get("sourcedata_id"));
                        break;
                    }
                    if ("costcenter".equals(costField)) {
                        Map<String, List<Long>> billRangeMap = this.context.getBillRangeMap();
                        Boolean isOldUser = this.context.isOldUser();
                        if (isOldUser.booleanValue()) {
                            List<Long> ccsIds = billRangeMap.get(sourceBillEntity);
                            long costCenterId = field.getLong("sourcedata_id");
                            if (field.get("sourcedata") != null && !ccsIds.contains(costCenterId)) {
                                this.logger.info("\u6210\u672c\u4e2d\u5fc3ID\uff1a{}\uff0c\u4e0d\u5f52\u96c6\u6e90\u5355\u7c7b\u578b\u4e3a{}\u7684\u5355\u636e", (Object)costCenterId, (Object)sourceBillEntity);
                                return;
                            }
                        }
                        materialBill.set(costField, field.get("sourcedata"));
                        break;
                    }
                    materialBill.set(costField, field.get("sourcedata_id"));
                    break;
                }
            }
        }
        materialBill.set("appnum", (Object)this.context.getParam().getAppnum());
        materialBill.set("sourcebillid", bizBill.get("id"));
        materialBill.set("org_id", (Object)this.context.getParam().getCalOrgId());
        materialBill.set("org", (Object)this.context.getParam().getCalOrgId());
        materialBill.set("billstatus", (Object)"C");
        materialBill.set("collconfig", (Object)this.collConfig.getLong("id"));
        materialBill.set("billno", (Object)bizBill.getString("billno").concat("-").concat(bizBill.getString("entryseq")));
        materialBill.set("srcbilltype", (Object)bizBill.getString("billtype"));
        if (materialBill.get("nsrcauditdate") == null) {
            materialBill.set("nsrcauditdate", (Object)bizBill.getDate("auditdate"));
        }
        materialBill.set("source", (Object)"CONFIG");
        if ("im_materialreqoutbill".equals(sourceBillEntity) || "im_mdc_mftproorder".equals(sourceBillEntity) || "im_mdc_mftreturnorder".equals(sourceBillEntity) || "im_mdc_mftfeedorder".equals(sourceBillEntity) || "im_mdc_omoutbill".equals(sourceBillEntity) || "im_mdc_omreturnbill".equals(sourceBillEntity) || "im_mdc_omfeedbill".equals(sourceBillEntity)) {
            materialBill.set("srcauditdate", (Object)DateUtils.getPriceDate((Date)bizBill.getDate("auditdate"), (Date)bizBill.getDate("bookdate")));
        }
        result.getSrcAndTargetBillsMap().put(bizBill, materialBill);
    }

    @Override
    public void doTransferAfter(BillTransferResult result) {
        super.doTransferAfter(result);
        Map<DynamicObject, DynamicObject> srcMap = result.getSrcAndTargetBillsMap();
        Collection<DynamicObject> materials = srcMap.values();
        HashSet<Long> materialIds = new HashSet<Long>(10);
        for (DynamicObject useMaterial : materials) {
            DynamicObject row;
            DynamicObjectCollection entryentity = useMaterial.getDynamicObjectCollection("entryentity");
            if (entryentity == null || entryentity.isEmpty() || CadEmptyUtils.isEmpty((Long)(row = (DynamicObject)entryentity.get(0)).getLong("material")) || CadEmptyUtils.isEmpty((Long)row.getLong("auxpty")) && CadEmptyUtils.isEmpty((Long)row.getLong("matversion"))) continue;
            materialIds.add(row.getLong("material"));
        }
        if (CadEmptyUtils.isEmpty(materialIds)) {
            return;
        }
        QFilter idQf = new QFilter("id", "in", materialIds);
        DataSet matObj = QueryServiceHelper.queryDataSet((String)"materials", (String)"bd_material", (String)"id,isenablematerialversion,isuseauxpty", (QFilter[])new QFilter[]{idQf}, null);
        for (DynamicObject row : matObj) {
            HashMap<String, Boolean> propMap = new HashMap<String, Boolean>(2);
            propMap.put("isenablematerialversion", row.getBoolean("isenablematerialversion"));
            propMap.put("isuseauxpty", row.getBoolean("isuseauxpty"));
            this.context.getMatPropMap().put(row.get("id"), propMap);
        }
        Map materialMap = CostObjectHelper.getAssistMap(materialIds, (Long)this.context.getParam().getCalOrgId());
        HashMap<String, Long> auxptyMap = new HashMap<String, Long>(10);
        for (DynamicObject useMaterial : materials) {
            DynamicObject row;
            DynamicObjectCollection entryentity = useMaterial.getDynamicObjectCollection("entryentity");
            if (entryentity == null || entryentity.isEmpty() || CadEmptyUtils.isEmpty((Long)(row = (DynamicObject)entryentity.get(0)).getLong("material"))) continue;
            if (!CadEmptyUtils.isEmpty((Long)row.getLong("matversion"))) {
                this.setVersion(row, row.get("material"), this.context.getMatPropMap());
            }
            if (CadEmptyUtils.isEmpty((Long)row.getLong("auxpty"))) continue;
            this.setAuxpty(row, row.get("material"), row.getLong("auxpty"), this.context.getMatPropMap(), auxptyMap, materialMap);
        }
    }

    private void setVersion(DynamicObject row, Object materialId, Map<Object, Map<String, Boolean>> matPropMap) {
        if (materialId == null) {
            return;
        }
        Map<String, Boolean> matProp = null;
        if (matPropMap.containsKey(materialId)) {
            matProp = matPropMap.get(materialId);
        }
        if (matProp != null) {
            if (!matProp.get("isenablematerialversion").booleanValue()) {
                row.set("matversion", (Object)0L);
            }
        } else {
            row.set("matversion", (Object)0L);
        }
    }

    private void setAuxpty(DynamicObject row, Object materialId, Long auxptyId, Map<Object, Map<String, Boolean>> matPropMap, Map<String, Long> auxptyMap, Map<Long, Boolean> materialMap) {
        if (materialId == null) {
            return;
        }
        String key = String.format("%s@%s", materialId, auxptyId);
        if (auxptyMap.containsKey(key)) {
            row.set("auxpty", (Object)auxptyMap.get(key));
            return;
        }
        Map<String, Boolean> matProp = null;
        if (matPropMap.containsKey(materialId)) {
            matProp = matPropMap.get(materialId);
        }
        if (matProp != null) {
            Long effectCostAuxpty = 0L;
            if (!matProp.get("isuseauxpty").booleanValue()) {
                row.set("auxpty", (Object)0L);
                auxptyMap.put(key, effectCostAuxpty);
            } else {
                DynamicObject matObj = CostObjectHelper.getMaterialById((Long)Long.parseLong(materialId.toString()));
                DynamicObject auxpty = BusinessDataServiceHelper.loadSingleFromCache((Object)auxptyId, (String)"bd_flexauxprop");
                effectCostAuxpty = CostObjectHelper.getEffectCostAuxptyNew((DynamicObject)matObj, (DynamicObject)auxpty, materialMap, (String)this.collConfig.getString("calmethod"));
                auxptyMap.put(key, effectCostAuxpty);
                row.set("auxpty", (Object)effectCostAuxpty);
            }
        } else {
            row.set("auxpty", (Object)0L);
        }
    }
}

