/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.business.config.transfer;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.business.config.engine.AbstractBillTransfer;
import kd.macc.cad.business.config.engine.BillTransferResult;
import kd.macc.cad.business.config.engine.CollConifgParam;
import kd.macc.cad.business.config.service.CostConfigService;
import kd.macc.cad.common.enums.SysParamEnum;
import kd.macc.cad.common.helper.MfgfeeBillImportHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class MfgFeeTransfer
extends AbstractBillTransfer {
    @Override
    protected void doTransfer(DynamicObject bizBill, BillTransferResult result) {
        String amountTypes;
        String policyclass = this.collConfig.getString("plugin");
        if (!CadEmptyUtils.isEmpty((String)policyclass)) {
            DynamicObject targetBill = CostConfigService.doTransferForPlugin(bizBill, this.collConfig, this.fieldMappingEntryColl);
            result.getSrcAndTargetBillsMap().put(bizBill, targetBill);
            return;
        }
        String sourceDateField = "";
        for (DynamicObject field : this.fieldMappingEntryColl) {
            String costField = field.getString("costfield");
            if (!"bookdate".equals(costField)) continue;
            sourceDateField = field.getString("sourcefield");
            break;
        }
        Map<String, List<String>> flexFieldMap = this.context.getFlexFieldMap();
        Map<String, String> fieldEntityMap = this.context.getFieldEntityMap();
        DynamicObject mfgFeeBill = BusinessDataServiceHelper.newDynamicObject((String)"cad_mfgfeebill");
        String sourceBillEntity = this.collConfig.getString("sourcebill.id");
        Map<String, List<DynamicObject>> costCenterSourceDataMap = this.context.getCostCenterSourceDataMap();
        LinkedHashMap vAssgrpValueMap = new LinkedHashMap(16);
        Boolean hasAmountField = false;
        block13: for (DynamicObject field : this.fieldMappingEntryColl) {
            String costField = field.getString("costfield");
            String[] sourceField = field.getString("sourcefield");
            String selectValue = field.getString("selectvalue");
            if ("totalamount".equals(costField)) {
                hasAmountField = true;
            }
            switch (selectValue) {
                case "0": {
                    if ("entries.assgrp".equals(sourceField)) {
                        vAssgrpValueMap.clear();
                        String assgrpValue = bizBill.getString("assgrpValue");
                        if (StringUtils.isEmpty((CharSequence)assgrpValue)) continue block13;
                        vAssgrpValueMap = (LinkedHashMap)SerializationUtils.fromJsonString((String)assgrpValue, Map.class);
                        String entityNum = fieldEntityMap.get(costField);
                        List<String> flexFields = flexFieldMap.get(entityNum);
                        long assgrpValueId = MfgfeeBillImportHelper.getFlexFieldValue(flexFields, (LinkedHashMap)vAssgrpValueMap);
                        if ("costcenter".equals(costField)) {
                            DynamicObject costCenter;
                            Date bizDate = bizBill.getDate(sourceDateField);
                            if (CadEmptyUtils.isEmpty((Long)assgrpValueId)) {
                                long adminOrgId;
                                flexFields = flexFieldMap.get("mpdm_workcentre");
                                long workCenterId = MfgfeeBillImportHelper.getFlexFieldValue(flexFields, (LinkedHashMap)vAssgrpValueMap);
                                List<DynamicObject> costCenterSourceList = costCenterSourceDataMap.get("mpdm_workcentre@" + workCenterId);
                                costCenter = CostConfigService.getCostCenterBySrcBillDate(bizDate, costCenterSourceList);
                                if (CadEmptyUtils.isEmpty((DynamicObject)costCenter)) {
                                    flexFields = flexFieldMap.get("bos_adminorg");
                                    adminOrgId = MfgfeeBillImportHelper.getFlexFieldValue(flexFields, (LinkedHashMap)vAssgrpValueMap);
                                    costCenterSourceList = costCenterSourceDataMap.get("bos_adminorg@" + adminOrgId);
                                    costCenter = CostConfigService.getCostCenterBySrcBillDate(bizDate, costCenterSourceList);
                                }
                                if (CadEmptyUtils.isEmpty((DynamicObject)costCenter)) {
                                    flexFields = flexFieldMap.get("bos_org");
                                    adminOrgId = MfgfeeBillImportHelper.getFlexFieldValue(flexFields, (LinkedHashMap)vAssgrpValueMap);
                                    costCenterSourceList = costCenterSourceDataMap.get("bos_org@" + adminOrgId);
                                    costCenter = CostConfigService.getCostCenterBySrcBillDate(bizDate, costCenterSourceList);
                                }
                            } else {
                                costCenter = BusinessDataServiceHelper.loadSingleFromCache((Object)assgrpValueId, (String)"bos_costcenter");
                            }
                            mfgFeeBill.set(costField, (Object)costCenter);
                            break;
                        }
                        if ("lot".equals(costField)) {
                            if (CadEmptyUtils.isEmpty((Long)assgrpValueId)) continue block13;
                            DynamicObject bdLot = BusinessDataServiceHelper.loadSingleFromCache((Object)assgrpValueId, (String)"bd_lot", (String)"number");
                            mfgFeeBill.set(costField, (Object)(bdLot == null ? "" : bdLot.getString("number")));
                            break;
                        }
                        mfgFeeBill.set(costField, (Object)assgrpValueId);
                        break;
                    }
                    if ("costcenter".equals(costField)) {
                        DynamicObject costCenter = CostConfigService.getCostCenterBySrcBill(bizBill, (String)sourceField, costCenterSourceDataMap, null, sourceDateField, this.costCenterTypeAndSourceFieldMap);
                        mfgFeeBill.set(costField, (Object)costCenter);
                        break;
                    }
                    mfgFeeBill.set(costField, bizBill.get((String)sourceField));
                    break;
                }
                case "1": {
                    String formulaStr = field.getString("formula");
                    if (CadEmptyUtils.isEmpty((String)formulaStr)) break;
                    Set formulaFields = (Set)this.formulaFieldMap.get(costField);
                    Object value = null;
                    try {
                        value = CostConfigService.execExcelFormula(bizBill, formulaStr, formulaFields);
                    }
                    catch (Exception e) {
                        HashMap<String, String> msg = new HashMap<String, String>(2);
                        msg.put("tip", String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u201c%1$s\u201d\u53d6\u503c\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u8ba1\u7b97\u516c\u5f0f\u662f\u5426\u6b63\u786e\uff0c\u9519\u8bef\u4fe1\u606f\uff1a%2$s\u3002", (String)"MfgFeeTransfer_1", (String)"macc-cad-business", (Object[])new Object[0]), costField, e));
                        result.getErrorMsgList().add(msg);
                        return;
                    }
                    if (value == null) break;
                    mfgFeeBill.set(costField, value);
                    break;
                }
                case "2": {
                    if ("costcenter".equals(costField)) {
                        mfgFeeBill.set(costField, field.get("sourcedata"));
                        break;
                    }
                    mfgFeeBill.set(costField, field.get("sourcedata_id"));
                }
            }
        }
        if (!hasAmountField.booleanValue() && !CadEmptyUtils.isEmpty((String)(amountTypes = this.collConfig.getString("expenseitemamt")))) {
            String[] amountTypeArr = amountTypes.split(",");
            ArrayList<String> amountTypeList = new ArrayList<String>();
            for (String amountType : amountTypeArr) {
                if (StringUtils.isEmpty((CharSequence)amountType)) continue;
                amountTypeList.add(amountType);
            }
            BigDecimal voucherDcAmount = MfgfeeBillImportHelper.getVoucherDcAmount((DynamicObject)bizBill, amountTypeList);
            mfgFeeBill.set("totalamount", (Object)voucherDcAmount);
        }
        CollConifgParam collConifgParam = this.context.getParam();
        mfgFeeBill.set("appnum", (Object)collConifgParam.getAppnum());
        mfgFeeBill.set("billstatus", (Object)"A");
        mfgFeeBill.set("source", (Object)SysParamEnum.COMPTYPE_SYS.getValue());
        mfgFeeBill.set("creator", (Object)RequestContext.get().getUserId());
        mfgFeeBill.set("createtime", (Object)new Date());
        mfgFeeBill.set("modifier", (Object)RequestContext.get().getUserId());
        mfgFeeBill.set("modifytime", (Object)new Date());
        mfgFeeBill.set("org", (Object)collConifgParam.getCalOrgId());
        long costAccountId = collConifgParam.getCostAccountId();
        mfgFeeBill.set("costaccount", (Object)costAccountId);
        mfgFeeBill.set("impschid", (Object)this.collConfig.getLong("id"));
        mfgFeeBill.set("srcbillid", (Object)bizBill.getLong("id"));
        if (bizBill.containsProperty("billno")) {
            mfgFeeBill.set("srcbillnum", (Object)bizBill.getString("billno"));
        } else if (bizBill.containsProperty("number")) {
            mfgFeeBill.set("srcbillnum", (Object)bizBill.getString("number"));
        }
        long srcBillEntryId = 0L;
        String voucherEntry = "";
        if (bizBill.containsProperty("voucherentry")) {
            voucherEntry = bizBill.getString("voucherentry");
        } else if (bizBill.containsProperty("subentryId")) {
            srcBillEntryId = bizBill.getLong("subentryId");
        } else if (bizBill.containsProperty("entryId")) {
            srcBillEntryId = bizBill.getLong("entryId");
        }
        if (bizBill.containsProperty("accountId")) {
            mfgFeeBill.set("account", (Object)bizBill.getLong("accountId"));
        }
        mfgFeeBill.set("voucherentry", (Object)voucherEntry);
        mfgFeeBill.set("srcbillentryid", (Object)srcBillEntryId);
        mfgFeeBill.set("srcbilltype", (Object)sourceBillEntity);
        mfgFeeBill.set("sourcetype", (Object)"CONFIG");
        mfgFeeBill.set("collconfig", (Object)this.collConfig.getLong("id"));
        String srcDataType = this.collConfig.getString("srcdatatype");
        if ("processfee".equals(srcDataType)) {
            mfgFeeBill.set("outsourcetype", (Object)"A");
        } else if ("freightfee".equals(srcDataType)) {
            mfgFeeBill.set("outsourcetype", (Object)"B");
        }
        result.getSrcAndTargetBillsMap().put(bizBill, mfgFeeBill);
    }

    @Override
    protected void doTransferAfter(BillTransferResult result) {
        super.doTransferAfter(result);
        Map<DynamicObject, DynamicObject> srcAndTargetBillsMap = result.getSrcAndTargetBillsMap();
        if (CadEmptyUtils.isEmpty(srcAndTargetBillsMap)) {
            return;
        }
        String billType = "";
        Long org = 0L;
        for (Map.Entry<DynamicObject, DynamicObject> dynamicObjectEntry : srcAndTargetBillsMap.entrySet()) {
            DynamicObject srcBill = dynamicObjectEntry.getKey();
            DynamicObject targetBill = dynamicObjectEntry.getValue();
            if (CadEmptyUtils.isEmpty((String)billType) && srcBill != null) {
                billType = srcBill.getString("billtype");
            }
            if (CadEmptyUtils.isEmpty((Long)org) && targetBill != null) {
                org = targetBill.getLong("org");
            }
            if (CadEmptyUtils.isEmpty((String)billType) || CadEmptyUtils.isEmpty((Long)org)) continue;
            break;
        }
        if ("ap_finapbill".equals(billType) || "ap_busbill".equals(billType)) {
            HashMap<String, Long> billNoSeqMftOrderEntryIdMap = new HashMap<String, Long>();
            Map<Long, DynamicObject> mftorderEntryIdCostObjectMap = this.getMftorderEntryIdCostObjectMap(org, srcAndTargetBillsMap, billNoSeqMftOrderEntryIdMap);
            for (Map.Entry<DynamicObject, DynamicObject> dynamicObjectEntry : srcAndTargetBillsMap.entrySet()) {
                DynamicObject srcBill = dynamicObjectEntry.getKey();
                DynamicObject targetBill = dynamicObjectEntry.getValue();
                String orderObjKey = srcBill.getString("corebillno") + "@" + srcBill.getString("corebillentryseq");
                if (!billNoSeqMftOrderEntryIdMap.containsKey(orderObjKey)) continue;
                Long mftOrderEntryId = (Long)billNoSeqMftOrderEntryIdMap.get(orderObjKey);
                targetBill.set("costobject", (Object)mftorderEntryIdCostObjectMap.get(mftOrderEntryId));
            }
        }
    }

    private Map<Long, DynamicObject> getMftorderEntryIdCostObjectMap(Long org, Map<DynamicObject, DynamicObject> srcAndTargetBillsMap, Map<String, Long> billNoSeqMftOrderEntryIdMap) {
        String key;
        HashMap<Long, DynamicObject> mftorderEntryIdCostObjectMap = new HashMap<Long, DynamicObject>(50);
        HashSet<Long> srcBillIds = new HashSet<Long>(50);
        HashSet<Long> seqIds = new HashSet<Long>(50);
        for (Map.Entry<DynamicObject, DynamicObject> dynamicObjectEntry : srcAndTargetBillsMap.entrySet()) {
            DynamicObject srcBill = dynamicObjectEntry.getKey();
            DynamicObject targetBill = dynamicObjectEntry.getValue();
            Object costobject = targetBill.get("costobject");
            if (costobject != null) {
                return mftorderEntryIdCostObjectMap;
            }
            srcBillIds.add(srcBill.getLong("corebillid"));
            seqIds.add(srcBill.getLong("corebillentryid"));
        }
        QFilter outFilter = new QFilter("id", "in", srcBillIds);
        outFilter.and("billentry.id", "in", seqIds);
        outFilter.and("billstatus", "=", (Object)"C");
        DynamicObjectCollection omMftOrderDynamicObj = QueryServiceHelper.query((String)"pm_purorderbill", (String)"billno,billentry.seq as seq,billentry.mftorderentryseq as omseq,billentry.mftordernumber as ombillno,billentry.mftorderid ombillid,billentry.mftorderentryid ombillentryid", (QFilter[])outFilter.toArray());
        QFilter pomFilter = new QFilter("id", "in", srcBillIds);
        pomFilter.and("billentry.id", "in", seqIds);
        pomFilter.and("billstatus", "=", (Object)"C");
        DynamicObjectCollection pomMftOrderDynamicObj = QueryServiceHelper.query((String)"pm_om_purorderbill", (String)"billno as billno,billentry.seq as seq,billentry.mftorderentryseq as pomseq,billentry.mftordernumber as pombillno,billentry.mftorderid pombillid,billentry.mftorderentryid pombillentryid", (QFilter[])pomFilter.toArray());
        HashSet<Long> objSrcBillEntryIds = new HashSet<Long>(50);
        for (DynamicObject dynamicObject : omMftOrderDynamicObj) {
            key = dynamicObject.getString("billno") + "@" + dynamicObject.getString("seq");
            long omBillEntryId = dynamicObject.getLong("ombillentryid");
            billNoSeqMftOrderEntryIdMap.put(key, omBillEntryId);
            objSrcBillEntryIds.add(omBillEntryId);
        }
        for (DynamicObject dynamicObject : pomMftOrderDynamicObj) {
            key = dynamicObject.getString("billno") + "@" + dynamicObject.getString("seq");
            long pomBillEntryId = dynamicObject.getLong("pombillentryid");
            billNoSeqMftOrderEntryIdMap.put(key, pomBillEntryId);
            objSrcBillEntryIds.add(pomBillEntryId);
        }
        QFilter filter = new QFilter("billstatus", "=", (Object)"C");
        filter.and("org", "=", (Object)org);
        filter.and("probill", "in", objSrcBillEntryIds);
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"cad_costobject", (String)"id,probill,srcbillnumber,srcbillrow,costcenter,costcenter.orgduty.number AS orgduty,isoutsource", (QFilter[])filter.toArray());
        if (dynamicObjects != null && dynamicObjects.size() > 0) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                long proBillEntryId = dynamicObject.getLong("probill");
                mftorderEntryIdCostObjectMap.put(proBillEntryId, dynamicObject);
            }
        }
        return mftorderEntryIdCostObjectMap;
    }
}

