/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.business.config.transfer;

import java.util.Date;
import java.util.HashMap;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.macc.cad.business.config.engine.AbstractBillTransfer;
import kd.macc.cad.business.config.engine.BillTransferResult;
import kd.macc.cad.business.config.engine.CollConifgParam;
import kd.macc.cad.business.config.service.CostConfigService;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class PlanFeeTransfer
extends AbstractBillTransfer {
    @Override
    protected void doTransfer(DynamicObject bizBill, BillTransferResult result) {
        String policyclass = this.collConfig.getString("plugin");
        if (!CadEmptyUtils.isEmpty((String)policyclass)) {
            DynamicObject targetBill = CostConfigService.doTransferForPlugin(bizBill, this.collConfig, this.fieldMappingEntryColl);
            result.getSrcAndTargetBillsMap().put(bizBill, targetBill);
            return;
        }
        String sourceDateField = "";
        for (DynamicObject field : this.fieldMappingEntryColl) {
            String costField = field.getString("costfield");
            if (!"bookdate".equals(costField)) continue;
            sourceDateField = field.getString("sourcefield");
            break;
        }
        DynamicObject mfgFeeBill = BusinessDataServiceHelper.newDynamicObject((String)"cad_planfeebill");
        String sourceBillEntity = this.collConfig.getString("sourcebill.id");
        for (DynamicObject field : this.fieldMappingEntryColl) {
            String selectValue;
            String costField = field.getString("costfield");
            String sourceField = field.getString("sourcefield");
            switch (selectValue = field.getString("selectvalue")) {
                case "0": {
                    if ("costcenter".equals(costField)) {
                        DynamicObject costCenter = CostConfigService.getCostCenterBySrcBill(bizBill, sourceField, this.context.getCostCenterSourceDataMap(), null, sourceDateField, this.costCenterTypeAndSourceFieldMap);
                        mfgFeeBill.set(costField, (Object)costCenter);
                        break;
                    }
                    mfgFeeBill.set(costField, bizBill.get(sourceField));
                    break;
                }
                case "1": {
                    String formulaStr = field.getString("formula");
                    if (CadEmptyUtils.isEmpty((String)formulaStr)) break;
                    Set formulaFields = (Set)this.formulaFieldMap.get(costField);
                    Object value = null;
                    try {
                        value = CostConfigService.execExcelFormula(bizBill, formulaStr, formulaFields);
                    }
                    catch (Exception e) {
                        HashMap<String, String> msg = new HashMap<String, String>(2);
                        msg.put("tip", String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u3010%1$s\u3011\u6839\u636e\u8ba1\u7b97\u516c\u5f0f\u53d6\u503c\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u8ba1\u7b97\u516c\u5f0f\u662f\u5426\u6b63\u786e\u3002\u9519\u8bef\u4fe1\u606f\uff1a%2$s", (String)"PlanFeeTransfer_0", (String)"macc-cad-business", (Object[])new Object[0]), costField, e));
                        result.getErrorMsgList().add(msg);
                        return;
                    }
                    if (value == null) break;
                    mfgFeeBill.set(costField, value);
                    break;
                }
                case "2": {
                    if ("costcenter".equals(costField)) {
                        mfgFeeBill.set(costField, field.get("sourcedata"));
                        break;
                    }
                    mfgFeeBill.set(costField, field.get("sourcedata_id"));
                }
            }
        }
        CollConifgParam collConifgParam = this.context.getParam();
        mfgFeeBill.set("appnum", (Object)collConifgParam.getAppnum());
        mfgFeeBill.set("billstatus", (Object)"A");
        mfgFeeBill.set("creator", (Object)RequestContext.get().getUserId());
        mfgFeeBill.set("createtime", (Object)new Date());
        mfgFeeBill.set("modifier", (Object)RequestContext.get().getUserId());
        mfgFeeBill.set("modifytime", (Object)new Date());
        mfgFeeBill.set("org", (Object)collConifgParam.getCalOrgId());
        long costAccountId = collConifgParam.getCostAccountId();
        mfgFeeBill.set("costaccount", (Object)costAccountId);
        mfgFeeBill.set("srcbillid", (Object)bizBill.getLong("id"));
        mfgFeeBill.set("srcbilltype", (Object)sourceBillEntity);
        mfgFeeBill.set("sourcetype", (Object)"SYS");
        result.getSrcAndTargetBillsMap().put(bizBill, mfgFeeBill);
    }
}

