/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.business.config.transfer;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.macc.cad.business.config.engine.AbstractBillTransfer;
import kd.macc.cad.business.config.engine.BillTransferResult;
import kd.macc.cad.business.config.service.CostConfigService;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class PlanOutPutTransfer
extends AbstractBillTransfer {
    private Log logger = LogFactory.getLog(PlanOutPutTransfer.class);

    @Override
    protected void doTransfer(DynamicObject bizBill, BillTransferResult result) {
        String policyclass = this.collConfig.getString("plugin");
        if (!CadEmptyUtils.isEmpty((String)policyclass)) {
            DynamicObject targetBill = CostConfigService.doTransferForPlugin(bizBill, this.collConfig, this.fieldMappingEntryColl);
            result.getSrcAndTargetBillsMap().put(bizBill, targetBill);
            return;
        }
        String sourceDateField = "";
        for (DynamicObject field : this.fieldMappingEntryColl) {
            String costField = field.getString("costfield");
            if (!"bizdate".equals(costField)) continue;
            sourceDateField = field.getString("sourcefield");
            break;
        }
        DynamicObject plannedOutPut = BusinessDataServiceHelper.newDynamicObject((String)"cad_plannedoutputbill");
        String sourceBillEntity = this.collConfig.getString("sourcebill.id");
        block13: for (DynamicObject field : this.fieldMappingEntryColl) {
            String selectvalue;
            String costField = field.getString("costfield");
            String sourceField = field.getString("sourcefield");
            switch (selectvalue = field.getString("selectvalue")) {
                case "0": {
                    if ("costcenter".equals(costField)) {
                        DynamicObject costCenter;
                        if (("pom_mftorder".equals(sourceBillEntity) || "om_mftorder".equals(sourceBillEntity)) && bizBill.getBoolean("isprocedure")) {
                            Map<Long, Long> proEntryIdWorkCenterMap = this.context.getConfigProEntryIdWorkCenterMap().get(this.collConfig);
                            Long srcCostCenterSourceData = null;
                            if (!CadEmptyUtils.isEmpty(proEntryIdWorkCenterMap) && (srcCostCenterSourceData = proEntryIdWorkCenterMap.get(bizBill.getLong("entryId"))) == null) {
                                srcCostCenterSourceData = proEntryIdWorkCenterMap.get(bizBill.getLong("pnodeId"));
                            }
                            DynamicObject costCenter2 = CostConfigService.getCostCenterBySrcBill(bizBill, sourceField, this.context.getCostCenterSourceDataMap(), srcCostCenterSourceData, sourceDateField, this.costCenterTypeAndSourceFieldMap);
                            plannedOutPut.set(costField, (Object)costCenter2);
                        } else {
                            costCenter = CostConfigService.getCostCenterBySrcBill(bizBill, sourceField, this.context.getCostCenterSourceDataMap(), null, sourceDateField, this.costCenterTypeAndSourceFieldMap);
                            plannedOutPut.set(costField, (Object)costCenter);
                        }
                        costCenter = (DynamicObject)plannedOutPut.get(costField);
                        Map<String, List<Long>> billRangeMap = this.context.getBillRangeMap();
                        Boolean isOldUser = this.context.isOldUser();
                        if (!"aca".equals(this.context.getParam().getAppnum()) || !isOldUser.booleanValue()) continue block13;
                        List<Long> ccsIds = billRangeMap.get(sourceBillEntity);
                        if (costCenter == null || ccsIds.contains(costCenter.getLong("id"))) continue block13;
                        this.logger.info("\u6210\u672c\u4e2d\u5fc3ID\uff1a{}\uff0c\u4e0d\u5f52\u96c6\u6e90\u5355\u7c7b\u578b\u4e3a{}\u7684\u5355\u636e", (Object)costCenter.getLong("id"), (Object)sourceBillEntity);
                        return;
                    }
                    if ("costobject".equals(costField)) {
                        Object costObjectId = bizBill.get(sourceField) == null ? Long.valueOf(0L) : bizBill.get(sourceField);
                        DynamicObject costObject = BusinessDataServiceHelper.loadSingleFromCache((Object)costObjectId, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cad_costobject"));
                        if (costObject != null && "C".equals(costObject.getString("billstatus"))) {
                            plannedOutPut.set(costField, (Object)costObject);
                            break;
                        }
                        plannedOutPut.set(costField, null);
                        break;
                    }
                    if ("material".equals(costField)) {
                        plannedOutPut.set(costField, bizBill.get(sourceField));
                        plannedOutPut.set(costField + "_id", bizBill.get(sourceField));
                        break;
                    }
                    plannedOutPut.set(costField, bizBill.get(sourceField));
                    break;
                }
                case "1": {
                    String formulaStr = field.getString("formula");
                    if (CadEmptyUtils.isEmpty((String)formulaStr)) break;
                    Set formulaFields = (Set)this.formulaFieldMap.get(costField);
                    Object value = null;
                    try {
                        value = CostConfigService.execExcelFormula(bizBill, formulaStr, formulaFields);
                    }
                    catch (Exception e) {
                        HashMap<String, String> msg = new HashMap<String, String>(2);
                        msg.put("tip", String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u201c%1$s\u201d\u53d6\u503c\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u8ba1\u7b97\u516c\u5f0f\u662f\u5426\u6b63\u786e\uff0c\u9519\u8bef\u4fe1\u606f\uff1a%2$s\u3002", (String)"PlanOutPutTransfer_1", (String)"macc-cad-business", (Object[])new Object[0]), costField, e));
                        result.getErrorMsgList().add(msg);
                        return;
                    }
                    if (value == null) break;
                    plannedOutPut.set(costField, value);
                    break;
                }
                case "2": {
                    if ("costcenter".equals(costField)) {
                        plannedOutPut.set(costField, field.get("sourcedata"));
                        break;
                    }
                    if ("costobject".equals(costField)) {
                        Map<String, List<Long>> billRangeMap = this.context.getBillRangeMap();
                        Boolean isOldUser = this.context.isOldUser();
                        if ("aca".equals(this.context.getParam().getAppnum()) && isOldUser.booleanValue()) {
                            List<Long> ccsIds = billRangeMap.get(sourceBillEntity);
                            long costCenterId = field.getLong("sourcedata_id");
                            if (field.get("sourcedata") != null && !ccsIds.contains(costCenterId)) {
                                this.logger.info("\u6210\u672c\u4e2d\u5fc3ID\uff1a{}\uff0c\u4e0d\u5f52\u96c6\u6e90\u5355\u7c7b\u578b\u4e3a{}\u7684\u5355\u636e", (Object)costCenterId, (Object)sourceBillEntity);
                                return;
                            }
                        }
                        plannedOutPut.set(costField, field.get("sourcedata"));
                        break;
                    }
                    plannedOutPut.set(costField, field.get("sourcedata_id"));
                }
            }
        }
        plannedOutPut.set("accountorg", (Object)this.context.getParam().getCalOrgId());
        plannedOutPut.set("accountorg_id", (Object)this.context.getParam().getCalOrgId());
        plannedOutPut.set("appnum", (Object)this.context.getParam().getAppnum());
        plannedOutPut.set("sourcebill", bizBill.get("id"));
        plannedOutPut.set("sourcebillentry", bizBill.get("entryId"));
        plannedOutPut.set("billstatus", (Object)"C");
        plannedOutPut.set("collconfig", (Object)this.collConfig.getLong("id"));
        String entrySeq = bizBill.getString("entryseq");
        if (CadEmptyUtils.isEmpty((String)entrySeq)) {
            plannedOutPut.set("billno", (Object)bizBill.getString("billno").concat("-").concat("1"));
        } else {
            plannedOutPut.set("billno", (Object)bizBill.getString("billno").concat("-").concat(entrySeq));
        }
        plannedOutPut.set("srcbilltype", (Object)bizBill.getString("billtype"));
        plannedOutPut.set("source", (Object)"10");
        if ("pom_mftorder".equals(sourceBillEntity) || "om_mftorder".equals(sourceBillEntity)) {
            if ("C".equals(bizBill.getString("planstatus")) && "C".equals(bizBill.getString("bizstatus"))) {
                plannedOutPut.set("closeuser", (Object)RequestContext.get().getCurrUserId());
                plannedOutPut.set("closestyle", (Object)"0");
                plannedOutPut.set("closestatu", (Object)"1");
            } else if ("C".equals(bizBill.getString("planstatus")) && !"C".equals(bizBill.getString("bizstatus"))) {
                plannedOutPut.set("closeuser", (Object)0L);
                plannedOutPut.set("closestyle", (Object)" ");
                plannedOutPut.set("closedatetime", null);
                plannedOutPut.set("closestatu", (Object)"0");
            }
        }
        result.getSrcAndTargetBillsMap().put(bizBill, plannedOutPut);
    }
}

