/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.business.config.transfer;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.macc.cad.business.config.engine.AbstractBillTransfer;
import kd.macc.cad.business.config.engine.BillTransferResult;
import kd.macc.cad.business.config.service.CostConfigService;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.DateUtils;
import org.apache.commons.lang3.StringUtils;

public class PlanResourceTransfer
extends AbstractBillTransfer {
    private Log logger = LogFactory.getLog(PlanResourceTransfer.class);

    @Override
    protected void doTransfer(DynamicObject bizBill, BillTransferResult result) {
        String policyclass = this.collConfig.getString("plugin");
        if (!CadEmptyUtils.isEmpty((String)policyclass)) {
            DynamicObject targetBill = CostConfigService.doTransferForPlugin(bizBill, this.collConfig, this.fieldMappingEntryColl);
            result.getSrcAndTargetBillsMap().put(bizBill, targetBill);
            return;
        }
        String sourceDateField = "";
        for (Object field : this.fieldMappingEntryColl) {
            String costField = field.getString("costfield");
            if (!"bizdate".equals(costField)) continue;
            sourceDateField = field.getString("sourcefield");
            break;
        }
        String entryName = "";
        for (Object field : this.fieldMappingEntryColl) {
            String sourceField;
            String[] fieldNames;
            String costField = field.getString("costfield");
            if (!"resource".equals(costField) || (fieldNames = StringUtils.split((String)(sourceField = field.getString("sourcefield")), (String)".")).length <= 2) continue;
            entryName = "true";
            break;
        }
        DynamicObject resourceBill = BusinessDataServiceHelper.newDynamicObject((String)"cad_planresource");
        for (DynamicObject field : this.fieldMappingEntryColl) {
            String costField = field.getString("costfield");
            String sourceField = field.getString("sourcefield");
            String selectvalue = field.getString("selectvalue");
            switch (selectvalue) {
                case "0": {
                    if ("costcenter".equals(costField)) {
                        DynamicObject costCenter = CostConfigService.getCostCenterBySrcBill(bizBill, sourceField, this.context.getCostCenterSourceDataMap(), null, sourceDateField, this.costCenterTypeAndSourceFieldMap);
                        resourceBill.set(costField, (Object)costCenter);
                        break;
                    }
                    if ("resource".equals(costField) || "resourceunit".equals(costField)) {
                        resourceBill.set(costField, bizBill.get(sourceField));
                        resourceBill.set(costField + "_id", bizBill.get(sourceField));
                        break;
                    }
                    resourceBill.set(costField, bizBill.get(sourceField));
                    break;
                }
                case "1": {
                    DynamicObject row;
                    DynamicObjectCollection entryObjects;
                    String entryField;
                    String entryEtity;
                    String formulaStr = field.getString("formula");
                    if (CadEmptyUtils.isEmpty((String)formulaStr)) break;
                    Set formulaFields = (Set)this.formulaFieldMap.get(costField);
                    Object value = null;
                    try {
                        value = CostConfigService.execExcelFormula(bizBill, formulaStr, formulaFields);
                    }
                    catch (Exception e) {
                        HashMap<String, String> msg = new HashMap<String, String>(2);
                        msg.put("tip", String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u201c%1$s\u201d\u53d6\u503c\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u8ba1\u7b97\u516c\u5f0f\u662f\u5426\u6b63\u786e\uff0c\u9519\u8bef\u4fe1\u606f\uff1a%2$s\u3002", (String)"PlanResourceTransfer_1", (String)"macc-cad-business", (Object[])new Object[0]), costField, e));
                        result.getErrorMsgList().add(msg);
                        return;
                    }
                    if (value == null) break;
                    if (costField != null && costField.contains(".")) {
                        entryEtity = costField.split("\\.")[0];
                        entryField = costField.split("\\.")[1];
                        entryObjects = resourceBill.getDynamicObjectCollection(entryEtity);
                        row = null;
                        row = CadEmptyUtils.isEmpty((DynamicObjectCollection)entryObjects) ? entryObjects.addNew() : (DynamicObject)entryObjects.get(0);
                        row.set(entryField, value);
                        break;
                    }
                    resourceBill.set(costField, value);
                    break;
                }
                case "2": {
                    DynamicObject row;
                    DynamicObjectCollection entryObjects;
                    String entryField;
                    String entryEtity;
                    if (costField != null && costField.contains(".")) {
                        entryEtity = costField.split("\\.")[0];
                        entryField = costField.split("\\.")[1];
                        entryObjects = resourceBill.getDynamicObjectCollection(entryEtity);
                        row = null;
                        row = CadEmptyUtils.isEmpty((DynamicObjectCollection)entryObjects) ? entryObjects.addNew() : (DynamicObject)entryObjects.get(0);
                        if ("costobject".equals(entryField)) {
                            row.set(costField, field.get("sourcedata"));
                            break;
                        }
                        row.set(entryField, field.get("sourcedata_id"));
                        break;
                    }
                    if ("costcenter".equals(costField)) {
                        resourceBill.set(costField, field.get("sourcedata"));
                        break;
                    }
                    resourceBill.set(costField, field.get("sourcedata_id"));
                }
            }
        }
        resourceBill.set("appnum", (Object)this.context.getParam().getAppnum());
        resourceBill.set("srcbillid", bizBill.get("id"));
        Long srcEntryId = null;
        if (!CadEmptyUtils.isEmpty((String)entryName) && bizBill.containsProperty("subentryId")) {
            srcEntryId = bizBill.getLong("subentryId");
        }
        if (srcEntryId == null) {
            srcEntryId = bizBill.containsProperty("entryId") ? Long.valueOf(bizBill.getLong("entryId")) : Long.valueOf(bizBill.getLong("id"));
        }
        resourceBill.set("srcentryid", srcEntryId);
        Integer seq = null;
        String entrySeq = bizBill.containsProperty("entryseq") ? bizBill.getString("entryseq") : "";
        String subEntrySeq = bizBill.containsProperty("subentryseq") ? bizBill.getString("subentryseq") : "";
        seq = !CadEmptyUtils.isEmpty((String)subEntrySeq) ? Integer.valueOf(Integer.parseInt(subEntrySeq)) : Integer.valueOf(Integer.parseInt(entrySeq));
        result.getEntryIdAndSeqMap().put(srcEntryId, seq);
        Date bizDate = resourceBill.getDate("bizdate");
        for (Map.Entry entry : this.periodIdMap.entrySet()) {
            DynamicObject period = (DynamicObject)entry.getValue();
            if (!DateUtils.compareDate((Date)bizDate, (Date)period.getDate("begindate")) || !DateUtils.compareDate((Date)period.getDate("enddate"), (Date)bizDate)) continue;
            resourceBill.set("period", entry.getKey());
            resourceBill.set("period_id", entry.getKey());
            break;
        }
        resourceBill.set("srcentryid", (Object)srcEntryId);
        resourceBill.set("org_id", (Object)this.context.getParam().getCalOrgId());
        resourceBill.set("org", (Object)this.context.getParam().getCalOrgId());
        resourceBill.set("costaccount_id", (Object)this.context.getParam().getCostAccountId());
        resourceBill.set("costaccount", (Object)this.context.getParam().getCostAccountId());
        resourceBill.set("planscheme_id", (Object)this.context.getParam().getPlanSchemeId());
        resourceBill.set("planscheme", (Object)this.context.getParam().getPlanSchemeId());
        resourceBill.set("billstatus", (Object)"A");
        resourceBill.set("collconfig", (Object)this.collConfig.getLong("id"));
        resourceBill.set("srcbilltype", (Object)bizBill.getString("billtype"));
        resourceBill.set("srcbillnum", (Object)bizBill.getString("billno"));
        resourceBill.set("sourcetype", (Object)"CONFIG");
        result.getSrcAndTargetBillsMap().put(bizBill, resourceBill);
    }
}

