/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.business.config.transfer;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.macc.cad.business.config.engine.AbstractBillTransfer;
import kd.macc.cad.business.config.engine.BillTransferResult;
import kd.macc.cad.business.config.service.CostConfigService;
import kd.macc.cad.common.enums.CostObjectEnum;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.DateUtils;
import org.apache.commons.lang3.StringUtils;

public class ResourceUseTransfer
extends AbstractBillTransfer {
    private Log logger = LogFactory.getLog(ResourceUseTransfer.class);

    @Override
    protected void doTransfer(DynamicObject bizBill, BillTransferResult result) {
        String policyclass = this.collConfig.getString("plugin");
        Map<Long, Long> manuToMaterialMap = this.context.getManuToMaterialMap();
        if (!CadEmptyUtils.isEmpty((String)policyclass)) {
            DynamicObject targetBill = CostConfigService.doTransferForPlugin(bizBill, this.collConfig, this.fieldMappingEntryColl);
            result.getSrcAndTargetBillsMap().put(bizBill, targetBill);
            return;
        }
        String sourceDateField = "";
        for (Object field : this.fieldMappingEntryColl) {
            String costField = field.getString("costfield");
            if (!"bookdate".equals(costField)) continue;
            sourceDateField = field.getString("sourcefield");
            break;
        }
        String entryName = "";
        for (DynamicObject field : this.fieldMappingEntryColl) {
            String sourceField;
            String[] fieldNames;
            String costField = field.getString("costfield");
            if (!"resource".equals(costField) || (fieldNames = StringUtils.split((String)(sourceField = field.getString("sourcefield")), (String)".")).length <= 2) continue;
            entryName = "true";
            break;
        }
        DynamicObject resourceBill = BusinessDataServiceHelper.newDynamicObject((String)"sca_resourceuse");
        String sourceBillEntity = this.collConfig.getString("sourcebill.id");
        for (DynamicObject field : this.fieldMappingEntryColl) {
            String selectvalue;
            String costField = field.getString("costfield");
            String sourceField = field.getString("sourcefield");
            switch (selectvalue = field.getString("selectvalue")) {
                case "0": {
                    if (costField != null && costField.contains(".")) {
                        String entryEtity = costField.split("\\.")[0];
                        String entryField = costField.split("\\.")[1];
                        DynamicObjectCollection entryObjects = resourceBill.getDynamicObjectCollection(entryEtity);
                        DynamicObject row = null;
                        row = CadEmptyUtils.isEmpty((DynamicObjectCollection)entryObjects) ? entryObjects.addNew() : (DynamicObject)entryObjects.get(0);
                        if ("costobject".equals(entryField)) {
                            Object costObjectId = bizBill.get(sourceField) == null ? Long.valueOf(0L) : bizBill.get(sourceField);
                            DynamicObject costObject = BusinessDataServiceHelper.loadSingleFromCache((Object)costObjectId, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cad_costobject"));
                            if (costObject != null && "C".equals(costObject.getString("billstatus"))) {
                                row.set(costField, (Object)costObject);
                                break;
                            }
                            row.set(costField, null);
                            break;
                        }
                        if ("workhour".equals(entryField)) {
                            if (sourceField.contains("repactivity")) {
                                row.set(entryField, bizBill.get("repactivityunit"));
                                break;
                            }
                            row.set(entryField, bizBill.get(sourceField));
                            row.set(entryField + "_id", bizBill.get(sourceField));
                            break;
                        }
                        if ("material".equals(entryField)) {
                            if (sourceBillEntity.equals("sfc_reportresource_adjust") && CostObjectEnum.BIZTYPE_PZ.getValue().equals(this.collConfig.getString("calmethod")) && sourceField.equals("sumentry.manufactureentryid")) {
                                row.set(entryField, (Object)manuToMaterialMap.get(bizBill.get(sourceField)));
                                row.set(entryField + "_id", (Object)manuToMaterialMap.get(bizBill.get(sourceField)));
                                break;
                            }
                            row.set(entryField, bizBill.get(sourceField));
                            row.set(entryField + "_id", bizBill.get(sourceField));
                            break;
                        }
                        row.set(entryField, bizBill.get(sourceField));
                        break;
                    }
                    if ("costcenter".equals(costField)) {
                        DynamicObject costCenter = CostConfigService.getCostCenterBySrcBill(bizBill, sourceField, this.context.getCostCenterSourceDataMap(), null, sourceDateField, this.costCenterTypeAndSourceFieldMap);
                        Map<String, List<Long>> billRangeMap = this.context.getBillRangeMap();
                        Boolean isOldUser = this.context.isOldUser();
                        if (isOldUser.booleanValue()) {
                            List<Long> ccsIds = billRangeMap.get(sourceBillEntity);
                            if (costCenter != null && !ccsIds.contains(costCenter.getLong("id"))) {
                                this.logger.info("\u6210\u672c\u4e2d\u5fc3ID\uff1a{}\uff0c\u4e0d\u5f52\u96c6\u6e90\u5355\u7c7b\u578b\u4e3a{}\u7684\u5355\u636e", (Object)costCenter.getLong("id"), (Object)sourceBillEntity);
                                return;
                            }
                        }
                        resourceBill.set(costField, (Object)costCenter);
                        break;
                    }
                    if ("resource".equals(costField)) {
                        resourceBill.set(costField, bizBill.get(sourceField));
                        resourceBill.set(costField + "_id", bizBill.get(sourceField));
                        break;
                    }
                    resourceBill.set(costField, bizBill.get(sourceField));
                    break;
                }
                case "1": {
                    DynamicObjectCollection entryObjects;
                    String entryField;
                    String entryEtity;
                    String formulaStr = field.getString("formula");
                    if (CadEmptyUtils.isEmpty((String)formulaStr)) break;
                    Set formulaFields = (Set)this.formulaFieldMap.get(costField);
                    Object value = null;
                    try {
                        value = CostConfigService.execExcelFormula(bizBill, formulaStr, formulaFields);
                    }
                    catch (Exception e) {
                        HashMap<String, String> msg = new HashMap<String, String>(2);
                        msg.put("tip", String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u201c%1$s\u201d\u53d6\u503c\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u8ba1\u7b97\u516c\u5f0f\u662f\u5426\u6b63\u786e\uff0c\u9519\u8bef\u4fe1\u606f\uff1a%2$s\u3002", (String)"ResourceUseTransfer_1", (String)"macc-cad-business", (Object[])new Object[0]), costField, e));
                        result.getErrorMsgList().add(msg);
                        return;
                    }
                    if (value == null) break;
                    if (costField != null && costField.contains(".")) {
                        entryEtity = costField.split("\\.")[0];
                        entryField = costField.split("\\.")[1];
                        entryObjects = resourceBill.getDynamicObjectCollection(entryEtity);
                        DynamicObject row = null;
                        row = CadEmptyUtils.isEmpty((DynamicObjectCollection)entryObjects) ? entryObjects.addNew() : (DynamicObject)entryObjects.get(0);
                        row.set(entryField, value);
                        break;
                    }
                    resourceBill.set(costField, value);
                    break;
                }
                case "2": {
                    DynamicObjectCollection entryObjects;
                    String entryField;
                    String entryEtity;
                    if (costField != null && costField.contains(".")) {
                        entryEtity = costField.split("\\.")[0];
                        entryField = costField.split("\\.")[1];
                        entryObjects = resourceBill.getDynamicObjectCollection(entryEtity);
                        DynamicObject row = null;
                        row = CadEmptyUtils.isEmpty((DynamicObjectCollection)entryObjects) ? entryObjects.addNew() : (DynamicObject)entryObjects.get(0);
                        if ("costobject".equals(entryField)) {
                            row.set(costField, field.get("sourcedata"));
                            break;
                        }
                        row.set(entryField, field.get("sourcedata_id"));
                        break;
                    }
                    if ("costcenter".equals(costField)) {
                        Map<String, List<Long>> billRangeMap = this.context.getBillRangeMap();
                        Boolean isOldUser = this.context.isOldUser();
                        if (isOldUser.booleanValue()) {
                            List<Long> ccsIds = billRangeMap.get(sourceBillEntity);
                            long costCenterId = field.getLong("sourcedata_id");
                            if (field.get("sourcedata") != null && !ccsIds.contains(costCenterId)) {
                                this.logger.info("\u6210\u672c\u4e2d\u5fc3ID\uff1a{}\uff0c\u4e0d\u5f52\u96c6\u6e90\u5355\u7c7b\u578b\u4e3a{}\u7684\u5355\u636e", (Object)costCenterId, (Object)sourceBillEntity);
                                return;
                            }
                        }
                        resourceBill.set(costField, field.get("sourcedata"));
                        break;
                    }
                    resourceBill.set(costField, field.get("sourcedata_id"));
                    if (!"resource".equals(costField)) break;
                    resourceBill.set(costField + "_id", field.get("sourcedata_id"));
                }
            }
        }
        resourceBill.set("appnum", (Object)this.context.getParam().getAppnum());
        resourceBill.set("srcbillid", bizBill.get("id"));
        Object srcEntryId = null;
        if (!CadEmptyUtils.isEmpty((String)entryName) && bizBill.containsProperty("subentryId")) {
            srcEntryId = bizBill.get("subentryId");
        }
        if (srcEntryId == null) {
            srcEntryId = bizBill.containsProperty("entryId") ? bizBill.get("entryId") : bizBill.get("id");
        }
        resourceBill.set("srcentryid", srcEntryId);
        resourceBill.set("org_id", (Object)this.context.getParam().getCalOrgId());
        resourceBill.set("org", (Object)this.context.getParam().getCalOrgId());
        resourceBill.set("billstatus", (Object)"C");
        resourceBill.set("collconfig", (Object)this.collConfig.getLong("id"));
        String enTrySeq = bizBill.containsProperty("entryseq") ? bizBill.getString("entryseq") : "";
        String subEnTrySeq = bizBill.containsProperty("subentryseq") ? bizBill.getString("subentryseq") : "";
        resourceBill.set("billno", (Object)bizBill.getString("billno").concat("-").concat(enTrySeq).concat("-").concat(subEnTrySeq));
        resourceBill.set("srcbilltype", (Object)bizBill.getString("billtype"));
        resourceBill.set("source", (Object)"CONFIG");
        if (resourceBill.get("nsrcauditdate") == null) {
            resourceBill.set("nsrcauditdate", (Object)bizBill.getDate("auditdate"));
        }
        if ("pom_mftorderreport".equals(sourceBillEntity) || "om_processreport".equals(sourceBillEntity) || "sfc_reportresource_adjust".equals(sourceBillEntity) || "sfc_processreportbill".equals(sourceBillEntity)) {
            resourceBill.set("pricedate", (Object)DateUtils.getPriceDate((Date)bizBill.getDate("auditdate"), (Date)bizBill.getDate("bookdate")));
        }
        result.getSrcAndTargetBillsMap().put(bizBill, resourceBill);
    }
}

