/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.business.config.transfer;

import java.util.HashMap;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.macc.cad.business.config.engine.AbstractBillTransfer;
import kd.macc.cad.business.config.engine.BillTransferResult;
import kd.macc.cad.business.config.service.CostConfigService;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class WorkHoursFeeTransfer
extends AbstractBillTransfer {
    @Override
    protected void doTransfer(DynamicObject bizBill, BillTransferResult result) {
        String policyclass = this.collConfig.getString("plugin");
        if (!CadEmptyUtils.isEmpty((String)policyclass)) {
            DynamicObject targetBill = CostConfigService.doTransferForPlugin(bizBill, this.collConfig, this.fieldMappingEntryColl);
            result.getSrcAndTargetBillsMap().put(bizBill, targetBill);
            return;
        }
        String sourceDateField = "";
        for (DynamicObject field : this.fieldMappingEntryColl) {
            String costField = field.getString("costfield");
            if (!"bookdate".equals(costField)) continue;
            sourceDateField = field.getString("sourcefield");
            break;
        }
        DynamicObject workHoursFee = BusinessDataServiceHelper.newDynamicObject((String)"eca_workhoursfee");
        DynamicObjectCollection entryentity = workHoursFee.getDynamicObjectCollection("entryentity");
        DynamicObject entry = entryentity.addNew();
        for (DynamicObject field : this.fieldMappingEntryColl) {
            String selectvalue;
            String costField = field.getString("costfield");
            String sourceField = field.getString("sourcefield");
            switch (selectvalue = field.getString("selectvalue")) {
                case "0": {
                    if ("costcenter".equals(costField)) {
                        DynamicObject costCenter = CostConfigService.getCostCenterBySrcBill(bizBill, sourceField, this.context.getCostCenterSourceDataMap(), null, sourceDateField, this.costCenterTypeAndSourceFieldMap);
                        workHoursFee.set(costField, (Object)costCenter);
                        break;
                    }
                    if ("material".equals(costField)) {
                        workHoursFee.set(costField, bizBill.get(sourceField));
                        workHoursFee.set(costField + "_id", bizBill.get(sourceField));
                        break;
                    }
                    if (costField.startsWith("entryentity")) {
                        String fileName = costField.replace("entryentity.", "");
                        entry.set(fileName, bizBill.get(sourceField));
                        break;
                    }
                    workHoursFee.set(costField, bizBill.get(sourceField));
                    break;
                }
                case "1": {
                    String fileName;
                    String formulaStr = field.getString("formula");
                    if (CadEmptyUtils.isEmpty((String)formulaStr)) break;
                    Set formulaFields = (Set)this.formulaFieldMap.get(costField);
                    Object value = null;
                    try {
                        value = CostConfigService.execExcelFormula(bizBill, formulaStr, formulaFields);
                    }
                    catch (Exception e) {
                        HashMap<String, String> msg = new HashMap<String, String>(2);
                        msg.put("tip", String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u201c%1$s\u201d\u53d6\u503c\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u8ba1\u7b97\u516c\u5f0f\u662f\u5426\u6b63\u786e\uff0c\u9519\u8bef\u4fe1\u606f\uff1a%2$s\u3002", (String)"WorkHoursFeeTransfer_1", (String)"macc-cad-business", (Object[])new Object[0]), costField, e));
                        result.getErrorMsgList().add(msg);
                        return;
                    }
                    if (value == null) break;
                    if (costField.startsWith("entryentity")) {
                        fileName = costField.replace("entryentity.", "");
                        entry.set(fileName, value);
                        break;
                    }
                    workHoursFee.set(costField, value);
                    break;
                }
                case "2": {
                    String fileName;
                    if (costField.startsWith("entryentity")) {
                        fileName = costField.replace("entryentity.", "");
                        workHoursFee.set(fileName, field.get("sourcedata_id"));
                        break;
                    }
                    workHoursFee.set(costField, field.get("sourcedata_id"));
                }
            }
        }
        workHoursFee.set("sourceid", bizBill.get("id"));
        workHoursFee.set("sourcebillentry", bizBill.get("entryId"));
        workHoursFee.set("sonbillentry", bizBill.get("sonid"));
        workHoursFee.set("billstatus", (Object)"C");
        workHoursFee.set("billno", (Object)bizBill.getString("billno").concat("-").concat(bizBill.getString("entryseq")).concat("-").concat(bizBill.getString("sonseq")));
        result.getSrcAndTargetBillsMap().put(bizBill, workHoursFee);
    }
}

