/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.business.config.transfer;

import java.util.Date;
import java.util.HashMap;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.macc.cad.business.config.engine.AbstractBillTransfer;
import kd.macc.cad.business.config.engine.BillTransferResult;
import kd.macc.cad.business.config.engine.CollConifgParam;
import kd.macc.cad.business.config.service.CostConfigService;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class WorkQtyTransfer
extends AbstractBillTransfer {
    @Override
    protected void doTransfer(DynamicObject bizBill, BillTransferResult result) {
        String policyclass = this.collConfig.getString("plugin");
        if (!CadEmptyUtils.isEmpty((String)policyclass)) {
            DynamicObject targetBill = CostConfigService.doTransferForPlugin(bizBill, this.collConfig, this.fieldMappingEntryColl);
            result.getSrcAndTargetBillsMap().put(bizBill, targetBill);
            return;
        }
        String sourceDateField = "";
        for (Object field : this.fieldMappingEntryColl) {
            String costField = field.getString("costfield");
            if (!"bizdate".equals(costField)) continue;
            sourceDateField = field.getString("sourcefield");
            break;
        }
        DynamicObject workQtyBill = BusinessDataServiceHelper.newDynamicObject((String)"sca_workqtycollec");
        for (DynamicObject field : this.fieldMappingEntryColl) {
            String costField = field.getString("costfield");
            String sourceField = field.getString("sourcefield");
            String selectValue = field.getString("selectvalue");
            if (costField == null) continue;
            switch (selectValue) {
                case "0": {
                    if (costField.contains(".")) {
                        String entryEntity = costField.split("\\.")[0];
                        String entryField = costField.split("\\.")[1];
                        DynamicObjectCollection entryObjects = workQtyBill.getDynamicObjectCollection(entryEntity);
                        DynamicObject row = CadEmptyUtils.isEmpty((DynamicObjectCollection)entryObjects) ? entryObjects.addNew() : (DynamicObject)entryObjects.get(0);
                        if ("costobject".equals(entryField)) {
                            Object costObjectId = bizBill.get(sourceField) == null ? Long.valueOf(0L) : bizBill.get(sourceField);
                            DynamicObject costObject = BusinessDataServiceHelper.loadSingleFromCache((Object)costObjectId, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cad_costobject"));
                            if (costObject != null && "C".equals(costObject.getString("billstatus"))) {
                                row.set(entryField, (Object)costObject);
                                row.set(entryField + "_id", (Object)costObject);
                                break;
                            }
                            row.set(entryField, null);
                            break;
                        }
                        if (costField.contains("costcenter")) {
                            DynamicObject costCenter = CostConfigService.getCostCenterBySrcBill(bizBill, sourceField, this.context.getCostCenterSourceDataMap(), null, sourceDateField, this.costCenterTypeAndSourceFieldMap);
                            row.set(entryField, (Object)costCenter);
                            break;
                        }
                        if (costField.contains("material")) {
                            Object matId = bizBill.get(sourceField) == null ? Long.valueOf(0L) : bizBill.get(sourceField);
                            DynamicObject mat = BusinessDataServiceHelper.loadSingleFromCache((Object)matId, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_material"));
                            if (mat != null) {
                                row.set(entryField, (Object)mat);
                                row.set(entryField + "_id", (Object)mat);
                                break;
                            }
                            row.set(entryField, null);
                            break;
                        }
                        row.set(entryField, bizBill.get(sourceField));
                        break;
                    }
                    if (costField.contains("costcenter")) {
                        DynamicObject costCenter = CostConfigService.getCostCenterBySrcBill(bizBill, sourceField, this.context.getCostCenterSourceDataMap(), null, sourceDateField, this.costCenterTypeAndSourceFieldMap);
                        workQtyBill.set(costField, (Object)costCenter);
                        break;
                    }
                    if (costField.contains("manuorg")) {
                        Object manuOrdId;
                        Object object = manuOrdId = bizBill.get(sourceField) == null ? Long.valueOf(0L) : bizBill.get(sourceField);
                        if (manuOrdId == null || Long.parseLong(String.valueOf(manuOrdId)) == 0L) {
                            workQtyBill.set(costField, null);
                            break;
                        }
                        DynamicObject manuOrg = BusinessDataServiceHelper.loadSingleFromCache((Object)manuOrdId, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bos_org"));
                        if (manuOrg != null) {
                            workQtyBill.set(costField, (Object)manuOrg);
                            workQtyBill.set(costField + "_id", (Object)manuOrg.getLong("id"));
                            break;
                        }
                        workQtyBill.set(costField, null);
                        break;
                    }
                    if (costField.equals("costdriver")) {
                        Object costDriverId;
                        Object object = costDriverId = bizBill.get(sourceField) == null ? Long.valueOf(0L) : bizBill.get(sourceField);
                        if (costDriverId == null || Long.parseLong(String.valueOf(costDriverId)) == 0L) {
                            workQtyBill.set(costField, null);
                            break;
                        }
                        DynamicObject costDriver = BusinessDataServiceHelper.loadSingleFromCache((Object)costDriverId, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cad_costdriver"));
                        if (costDriver != null) {
                            workQtyBill.set(costField, (Object)costDriver);
                            workQtyBill.set(costField + "_id", (Object)costDriver.getLong("id"));
                            break;
                        }
                        workQtyBill.set(costField, null);
                        break;
                    }
                    workQtyBill.set(costField, bizBill.get(sourceField));
                    break;
                }
                case "1": {
                    String formulaStr = field.getString("formula");
                    if (CadEmptyUtils.isEmpty((String)formulaStr)) break;
                    Set formulaFields = (Set)this.formulaFieldMap.get(costField);
                    Object value = null;
                    try {
                        value = CostConfigService.execExcelFormula(bizBill, formulaStr, formulaFields);
                    }
                    catch (Exception e) {
                        HashMap<String, String> msg = new HashMap<String, String>(2);
                        msg.put("tip", String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u201c%1$s\u201d\u6839\u636e\u8ba1\u7b97\u516c\u5f0f\u53d6\u503c\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u8ba1\u7b97\u516c\u5f0f\u662f\u5426\u6b63\u786e\uff0c\u9519\u8bef\u4fe1\u606f\uff1a%2$s\u3002", (String)"WorkQtyTransfer_0", (String)"macc-cad-business", (Object[])new Object[0]), costField, e));
                        result.getErrorMsgList().add(msg);
                        return;
                    }
                    if (value == null) break;
                    workQtyBill.set(costField, value);
                    break;
                }
                case "2": {
                    if ("costcenter".equals(costField)) {
                        workQtyBill.set(costField, field.get("sourcedata"));
                        break;
                    }
                    workQtyBill.set(costField, field.get("sourcedata_id"));
                }
            }
        }
        CollConifgParam collConifgParam = this.context.getParam();
        workQtyBill.set("appnum", (Object)collConifgParam.getAppnum());
        workQtyBill.set("workactivity", this.collConfig.get("workactivity"));
        workQtyBill.set("costdriver", this.collConfig.get("costdriver"));
        workQtyBill.set("billstatus", (Object)"C");
        workQtyBill.set("creator", (Object)RequestContext.get().getUserId());
        workQtyBill.set("createtime", (Object)new Date());
        workQtyBill.set("modifier", (Object)RequestContext.get().getUserId());
        workQtyBill.set("modifytime", (Object)new Date());
        workQtyBill.set("auditor", (Object)RequestContext.get().getUserId());
        workQtyBill.set("auditdate", (Object)new Date());
        workQtyBill.set("org_id", (Object)collConifgParam.getCalOrgId());
        workQtyBill.set("sourcetype", (Object)"SYS");
        workQtyBill.set("collconfig", (Object)this.collConfig.getLong("id"));
        result.getSrcAndTargetBillsMap().put(bizBill, workQtyBill);
    }
}

