/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.business.feealloc;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlParameter;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.MulComboProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.field.ComboItem;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.macc.cad.algox.utils.CadEmptyUtils;
import kd.macc.cad.common.dto.MfgFeeAllocImportParam;
import kd.macc.cad.common.dto.ProgressParamDto;
import kd.macc.cad.common.enums.MfgFeeAllocTypeEnum;
import kd.macc.cad.common.enums.ScaAllocEnum;
import kd.macc.cad.common.helper.CostAccountHelper;
import kd.macc.cad.common.helper.CostCloseAccountHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.helper.PlanFeeAllocHelper;
import kd.macc.cad.common.helper.ProgressHelper;
import kd.macc.cad.common.output.ExecuteResult;
import kd.macc.cad.common.utils.DateUtils;

public class MfgFeeAllocBase {
    private static final Log logger = LogFactory.getLog(MfgFeeAllocBase.class);
    private static final String ALGO_KEY_CLASS_NAME = MfgFeeAllocBase.class.getCanonicalName();
    private static final String EXPIRE_UPDATE_SQL = "update %s set forgid = ?,fbillstatus=? where fid = ?";
    private static final String EXPIRE_UPDATE_REPORT_SQL = "update %s set forgid = ? where fid = ?";
    private static final String UPDATE_CONFIRM_SQL = "update %s set fallocstatus=?,fmodifierid=?,fmodifytime=?,fbillstatus=? where fid = ?";
    protected static final List<String> SYS_ALLOC_DIM = Lists.newArrayList((Object[])new String[]{"projectnumber", "tracknumber", "lot"});

    public DataSet getMfgCollocBills(MfgFeeAllocImportParam importDto, MfgFeeAllocTypeEnum allocType) {
        return this.getMfgCollocBills(importDto, allocType, false);
    }

    public String getComboName(Map<String, String> comboNameMap, String allocDim) {
        if (comboNameMap.containsKey(allocDim)) {
            return comboNameMap.get(allocDim);
        }
        MainEntityType allocStdEntityType = EntityMetadataCache.getDataEntityType((String)"sca_overheadallotcost");
        IDataEntityProperty allocDimProperty = allocStdEntityType.findProperty("allocdim");
        List comboItems = new ArrayList();
        if (allocDimProperty != null) {
            comboItems = ((MulComboProp)allocDimProperty).getComboItems();
        }
        String comboName = "";
        for (ValueMapItem combo : comboItems) {
            comboNameMap.put(combo.getValue(), combo.getName().getLocaleValue());
            if (!combo.getValue().equals(allocDim)) continue;
            comboName = combo.getName().getLocaleValue();
        }
        return comboName;
    }

    public void buildAllocDim(MfgFeeAllocImportParam importParam) {
        QFilter filter = new QFilter("org", "=", (Object)importParam.getOrg());
        filter.and("appnum", "=", (Object)importParam.getAppnum());
        filter.and("billstatus", "=", (Object)"C");
        String allocType = "";
        switch (importParam.getEntityType()) {
            case "cad_basicalloc": {
                allocType = MfgFeeAllocTypeEnum.BASIXPROD.getValue();
                break;
            }
            case "cad_nonprodalloc": {
                allocType = MfgFeeAllocTypeEnum.NONPROD.getValue();
                break;
            }
            case "cad_auxprodalloc": {
                allocType = MfgFeeAllocTypeEnum.AUXPROD.getValue();
            }
        }
        if (!CadEmptyUtils.isEmpty((String)allocType)) {
            filter.and("allocmold", "=", (Object)allocType);
        }
        String allocDimEntity = "cad_mfgfeeallocco".equals(importParam.getEntityType()) ? "sca_overheadallotcost" : "sca_mfgfeeallocstdnew";
        DataSet allocStdDs = QueryServiceHelper.queryDataSet((String)"getCostCenterAllocDim", (String)allocDimEntity, (String)"allocdim", (QFilter[])new QFilter[]{filter}, null);
        HashSet allocDimSet = new HashSet(6);
        allocStdDs.forEach(s -> {
            String[] split;
            String allocDim = s.getString("allocdim");
            if (!CadEmptyUtils.isEmpty((String)allocDim) && (split = allocDim.split(",")) != null && split.length > 1) {
                for (String arr : split) {
                    if (CadEmptyUtils.isEmpty((String)arr)) continue;
                    allocDimSet.add(arr);
                }
            }
        });
        importParam.setAllocDimSet(allocDimSet);
        StringBuilder sb = new StringBuilder();
        allocDimSet.forEach(s -> sb.append((String)s).append(","));
        importParam.setAllocDim(sb.toString());
    }

    public String getMfgEntity(boolean actMfg, String entity) {
        if ("cad_plannonprodalloc".equals(entity) || "cad_nonprodalloc".equals(entity)) {
            return actMfg ? "cad_nonprodalloc" : "cad_plannonprodalloc";
        }
        if ("cad_planauxprodalloc".equals(entity) || "cad_auxprodalloc".equals(entity)) {
            return actMfg ? "cad_auxprodalloc" : "cad_planauxprodalloc";
        }
        if ("cad_planbasicalloc".equals(entity) || "cad_basicalloc".equals(entity)) {
            return actMfg ? "cad_basicalloc" : "cad_planbasicalloc";
        }
        return entity;
    }

    public boolean isPlanMfg(String entity) {
        return "cad_plannonprodalloc".equals(entity) || "cad_planauxprodalloc".equals(entity) || "cad_planbasicalloc".equals(entity) || "cad_planfeebill".equals(entity);
    }

    public QFilter getImportParamFilter(MfgFeeAllocImportParam importDto, String costcenterField) {
        QFilter filter = new QFilter("org", "=", (Object)importDto.getOrg());
        filter.and("costaccount", "=", (Object)importDto.getCostaccount());
        filter.and("period", "=", (Object)importDto.getPeriod());
        if (importDto.isEnableFactory()) {
            filter.and(costcenterField, "in", (Object)importDto.getCostCenterIds());
        }
        filter.and("appnum", "=", (Object)importDto.getAppnum());
        filter.and("planscheme", "=", (Object)importDto.getPlanscheme());
        if (StringUtils.isEmpty((CharSequence)importDto.getAppnum())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u5e94\u7528\u6807\u8bc6", (String)"MfgFeeAllocBase_0", (String)"macc-cad-business", (Object[])new Object[0]));
        }
        return filter;
    }

    public DataSet getMfgCollocBills(MfgFeeAllocImportParam importDto, MfgFeeAllocTypeEnum allocType, Boolean isGetCostobject) {
        String algoKey = ALGO_KEY_CLASS_NAME + ".getMfgCollocBills()";
        QFilter filter = this.getImportParamFilter(importDto, "costcenter");
        if (!isGetCostobject.booleanValue() && StringUtils.equals((CharSequence)allocType.getValue(), (CharSequence)MfgFeeAllocTypeEnum.BASIXPROD.getValue()) && !"cad_planbasicalloc".equals(importDto.getEntityType())) {
            filter.and("costobject", "=", (Object)0L);
        }
        filter.and("allocmold", "=", (Object)allocType.getValue());
        DataSet mfgfeebillList = !importDto.isActMfg() ? QueryServiceHelper.queryDataSet((String)algoKey, (String)"cad_planfeebill", (String)"id,billno,org,costaccount,manuorg,period,costcenter,expenseitem,totalamount,currency,currency.amtprecision amtprecision,'feebill' type,0 costobject,0 material,0 productgroup", (QFilter[])filter.toArray(), null) : QueryServiceHelper.queryDataSet((String)algoKey, (String)"cad_mfgfeebill", (String)(importDto.getAllocDim() + "id,billno,org,costaccount,manuorg,period,costcenter,expenseitem,totalamount,currency,currency.amtprecision amtprecision,'feebill' type,costobject,costobject.material material,productgroup"), (QFilter[])filter.toArray(), null);
        return mfgfeebillList;
    }

    public DataSet getNonProdBills(MfgFeeAllocImportParam importDto, MfgFeeAllocTypeEnum allocType) {
        String algoKey = ALGO_KEY_CLASS_NAME + ".getNonProdBills()";
        QFilter filter = this.getImportParamFilter(importDto, "entryentity.benefcostcenter");
        filter.and("allocstatus", "=", (Object)ScaAllocEnum.ALLOCSTATUS_CONFIRM.getValue());
        if (allocType == MfgFeeAllocTypeEnum.AUXPROD) {
            filter.and("entryentity.benefcostcenter.orgduty", "=", (Object)5L);
        } else if (allocType == MfgFeeAllocTypeEnum.BASIXPROD) {
            filter.and("entryentity.benefcostcenter.orgduty", "=", (Object)4L);
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u53ea\u80fd\u5bfc\u5165\u8f85\u52a9\u751f\u4ea7\u548c\u57fa\u672c\u751f\u4ea7\u7c7b\u578b\u7684\u6570\u636e\u3002", (String)"MfgFeeAllocBase_1", (String)"macc-cad-business", (Object[])new Object[0]));
        }
        return QueryServiceHelper.queryDataSet((String)algoKey, (String)this.getMfgEntity(importDto.isActMfg(), "cad_nonprodalloc"), (String)(importDto.getAllocDim() + "id,billno,org,costaccount,manuorg,period,entryentity.benefcostcenter costcenter,expenseitem,entryentity.allocamt totalamount,currency,currency.amtprecision amtprecision,'nonprod' type,0 costobject,0 material,0 productgroup"), (QFilter[])filter.toArray(), null);
    }

    public boolean isBillGenVounums(List<MfgFeeAllocImportParam> importDtos, String entityName) {
        for (MfgFeeAllocImportParam importDto : importDtos) {
            if (!this.isBillGenVounums(importDto, entityName)) continue;
            return true;
        }
        return false;
    }

    public boolean isBillGenVounums(MfgFeeAllocImportParam importDto, String entityName) {
        QFilter filter = new QFilter("org", "=", (Object)importDto.getOrg());
        filter.and("costaccount", "=", (Object)importDto.getCostaccount());
        filter.and("period", "=", (Object)importDto.getPeriod());
        if (importDto.isEnableFactory()) {
            filter.and("manuorg", "in", (Object)importDto.getManuorg());
        }
        filter.and("appnum", "=", (Object)importDto.getAppnum());
        filter.and("planscheme", "=", (Object)importDto.getPlanscheme());
        filter.and("vouchernum", "!=", (Object)" ");
        return QueryServiceHelper.exists((String)this.getMfgEntity(importDto.isActMfg(), entityName), (QFilter[])filter.toArray());
    }

    public boolean isBillHasData(List<MfgFeeAllocImportParam> importDtos, String entityName) {
        for (MfgFeeAllocImportParam importDto : importDtos) {
            if (!this.isBillHasData(importDto, entityName)) continue;
            return true;
        }
        return false;
    }

    public boolean isBillHasData(MfgFeeAllocImportParam importDto, String entityName) {
        return this.isBillHasData(importDto, entityName, "");
    }

    public boolean isBillHasData(MfgFeeAllocImportParam importDto, String entityName, String allocStatus) {
        String[] stringArray;
        if (StringUtils.isEmpty((CharSequence)allocStatus)) {
            stringArray = new String[]{};
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = allocStatus;
        }
        return this.isBillHasData(importDto, entityName, stringArray);
    }

    public boolean isBillHasData(MfgFeeAllocImportParam importDto, String entityName, String[] allocStatus) {
        QFilter filter = new QFilter("org", "=", (Object)importDto.getOrg());
        filter.and("costaccount", "=", (Object)importDto.getCostaccount());
        filter.and("period", "=", (Object)importDto.getPeriod());
        if (importDto.isEnableFactory()) {
            filter.and("manuorg", "in", (Object)importDto.getManuorg());
        }
        if (allocStatus != null && allocStatus.length > 0) {
            filter.and("allocstatus", "in", (Object)allocStatus);
        }
        filter.and("appnum", "=", (Object)importDto.getAppnum());
        filter.and("planscheme", "=", (Object)importDto.getPlanscheme());
        return QueryServiceHelper.exists((String)this.getMfgEntity(importDto.isActMfg(), entityName), (QFilter[])filter.toArray());
    }

    public Map<Long, List<Long>> getEntityBillIdsFromStatus(MfgFeeAllocImportParam importDto, String entityName, String[] billstatus) {
        LinkedHashMap<Long, List<Long>> entryMap = new LinkedHashMap<Long, List<Long>>();
        for (Long periodId : importDto.getCalcPeriodMap().keySet()) {
            importDto.setPeriod(periodId);
            QFilter filter = new QFilter("org", "=", (Object)importDto.getOrg());
            filter.and("costaccount", "=", (Object)importDto.getCostaccount());
            filter.and("period", "=", (Object)importDto.getPeriod());
            if (importDto.isEnableFactory()) {
                filter.and("manuorg", "in", (Object)importDto.getManuorg());
            }
            filter.and("appnum", "=", (Object)importDto.getAppnum());
            filter.and("planscheme", "=", (Object)importDto.getPlanscheme());
            if (!CadEmptyUtils.isEmpty((Set)importDto.getCostCenterIds())) {
                filter.and("costcenter", "in", (Object)importDto.getCostCenterIds());
            }
            filter.and("allocstatus", "in", (Object)billstatus);
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)(ALGO_KEY_CLASS_NAME + ".getEntityBillIds()"), (String)this.getMfgEntity(importDto.isActMfg(), entityName), (String)"id,period", (QFilter[])new QFilter[]{filter}, null);
            Throwable throwable = null;
            try {
                while (dataSet.hasNext()) {
                    Row row = dataSet.next();
                    entryMap.computeIfAbsent(row.getLong("period"), t -> new ArrayList(10)).add(row.getLong("id"));
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (dataSet == null) continue;
                if (throwable != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                dataSet.close();
            }
        }
        return entryMap;
    }

    public Set<Long> getEntityBillIds(List<MfgFeeAllocImportParam> importDtos, String entityName) {
        HashSet<Long> ids = new HashSet<Long>(16);
        for (MfgFeeAllocImportParam importDto : importDtos) {
            ids.addAll(this.getEntityBillIds(importDto, entityName));
        }
        return ids;
    }

    public Set<Long> getEntityBillIds(MfgFeeAllocImportParam importDto, String entityName) {
        HashSet<Long> ids = new HashSet<Long>(16);
        QFilter filter = new QFilter("org", "=", (Object)importDto.getOrg());
        filter.and("costaccount", "=", (Object)importDto.getCostaccount());
        filter.and("period", "=", (Object)importDto.getPeriod());
        if (importDto.isEnableFactory()) {
            filter.and("manuorg", "in", (Object)importDto.getManuorg());
        }
        filter.and("appnum", "=", (Object)importDto.getAppnum());
        filter.and("planscheme", "=", (Object)importDto.getPlanscheme());
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)(ALGO_KEY_CLASS_NAME + ".getEntityBillIds()"), (String)this.getMfgEntity(importDto.isActMfg(), entityName), (String)"id", (QFilter[])new QFilter[]{filter}, null);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                ids.add(row.getLong(0));
            }
        }
        return ids;
    }

    public Set<Long> getCoUnConfirmEntityBillIds(MfgFeeAllocImportParam importDto) {
        HashSet<Long> ids = new HashSet<Long>(16);
        QFilter filter = new QFilter("org", "=", (Object)importDto.getOrg());
        filter.and("costaccount", "=", (Object)importDto.getCostaccount());
        filter.and("period", "=", (Object)importDto.getPeriod());
        filter.and("allocstatus", "in", (Object)new String[]{ScaAllocEnum.ALLOCSTATUS_UNALLOC.getValue(), ScaAllocEnum.ALLOCSTATUS_ALLOC.getValue()});
        if (importDto.isEnableFactory()) {
            filter.and("manuorg", "in", (Object)importDto.getManuorg());
        }
        filter.and("appnum", "=", (Object)importDto.getAppnum());
        filter.and("planscheme", "=", (Object)importDto.getPlanscheme());
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)(ALGO_KEY_CLASS_NAME + ".getEntityBillIds()"), (String)"cad_mfgfeeallocco", (String)"id", (QFilter[])new QFilter[]{filter}, null);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                ids.add(row.getLong(0));
            }
        }
        return ids;
    }

    protected void expireMfgFeeBill(Set<Long> billIds, String entityType) {
        if (billIds == null || billIds.isEmpty()) {
            return;
        }
        MainEntityType mt = EntityMetadataCache.getDataEntityType((String)entityType);
        ArrayList<SqlParameter[]> paramsList = new ArrayList<SqlParameter[]>(billIds.size());
        for (Long id : billIds) {
            SqlParameter[] params = new SqlParameter[]{new SqlParameter("org", -5, (Object)999999L), new SqlParameter("billstatus", 12, (Object)"A"), new SqlParameter("id", -5, (Object)id)};
            paramsList.add(params);
        }
        String sql = String.format(EXPIRE_UPDATE_SQL, mt.getAlias());
        DB.executeBatch((DBRoute)new DBRoute("cal"), (String)sql, paramsList);
    }

    protected void expireCalcReport(Set<Long> billIds, String entityType) {
        if (CadEmptyUtils.isEmpty(billIds)) {
            return;
        }
        MainEntityType mt = EntityMetadataCache.getDataEntityType((String)entityType);
        ArrayList<SqlParameter[]> paramsList = new ArrayList<SqlParameter[]>(billIds.size());
        for (Long id : billIds) {
            SqlParameter[] params = new SqlParameter[]{new SqlParameter("org", -5, (Object)999999L), new SqlParameter("id", -5, (Object)id)};
            paramsList.add(params);
        }
        String sql = String.format(EXPIRE_UPDATE_REPORT_SQL, mt.getAlias());
        DB.executeBatch((DBRoute)new DBRoute("cal"), (String)sql, paramsList);
    }

    protected void updateAllocStatusBill(Set<Long> billIds, String entityType, String status) {
        if (billIds == null || billIds.isEmpty()) {
            return;
        }
        MainEntityType mt = EntityMetadataCache.getDataEntityType((String)entityType);
        Long curId = Long.parseLong(RequestContext.get().getUserId());
        Date curDate = new Date();
        ArrayList<SqlParameter[]> paramsList = new ArrayList<SqlParameter[]>(billIds.size());
        for (Long id : billIds) {
            SqlParameter[] params = new SqlParameter[]{new SqlParameter("fallocstatus", 12, (Object)status), new SqlParameter("fmodifierid", -5, (Object)curId), new SqlParameter("fmodifytime", 91, (Object)curDate), ScaAllocEnum.ALLOCSTATUS_CONFIRM.getValue().equals(status) ? new SqlParameter("fbillstatus", 12, (Object)"C") : new SqlParameter("fbillstatus", 12, (Object)"A"), new SqlParameter("id", -5, (Object)id)};
            paramsList.add(params);
        }
        String sql = String.format(UPDATE_CONFIRM_SQL, mt.getAlias());
        DB.executeBatch((DBRoute)new DBRoute("cal"), (String)sql, paramsList);
    }

    protected void deleteMfgFeeBill(Set<Long> billIds, String entityType) {
        if (billIds == null || billIds.isEmpty()) {
            return;
        }
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)entityType);
        DeleteServiceHelper.delete((IDataEntityType)dt, (Object[])billIds.toArray());
    }

    protected ExecuteResult getCostCenterNotExistResult(List<Long> costcenters) {
        ExecuteResult result = new ExecuteResult();
        String costcenterStr = this.getCostCenterNameStr(costcenters);
        result.setErrorNotification(String.format(ResManager.loadKDString((String)"\u5b58\u5728%s\u672a\u8bbe\u7f6e\u6210\u672c\u4e2d\u5fc3\u95f4\u5206\u914d\u6807\u51c6\uff0c\u4e0d\u80fd\u8fdb\u884c\u5f15\u5165\u64cd\u4f5c\u3002", (String)"MfgFeeAllocBase_7", (String)"macc-cad-business", (Object[])new Object[0]), costcenterStr));
        return result;
    }

    protected String getCostCenterNameStr(List<Long> costcenters) {
        QFilter filter = new QFilter("id", "in", costcenters);
        ArrayList<String> costcenterNames = new ArrayList<String>();
        DataSet costcenterDs = QueryServiceHelper.queryDataSet((String)(ALGO_KEY_CLASS_NAME + ".getCostCenterNotExistResult()"), (String)"bos_costcenter", (String)"name", (QFilter[])filter.toArray(), null);
        Object object = null;
        try {
            while (costcenterDs.hasNext()) {
                costcenterNames.add(costcenterDs.next().getString("name"));
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (costcenterDs != null) {
                if (object != null) {
                    try {
                        costcenterDs.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    costcenterDs.close();
                }
            }
        }
        StringBuilder sb = new StringBuilder();
        for (String str : costcenterNames) {
            sb.append("\u3010").append(str).append("\u3011").append("\u3001");
        }
        String sbStr = sb.toString();
        if (!CadEmptyUtils.isEmpty((String)sbStr)) {
            sbStr = sbStr.substring(0, sbStr.length() - 1);
        }
        return sbStr;
    }

    protected Map<Long, String> getCostCenterMap(Collection<Long> costcenters) {
        HashMap<Long, String> map = new HashMap<Long, String>();
        QFilter filter = new QFilter("id", "in", costcenters);
        try (DataSet costcenterDs = QueryServiceHelper.queryDataSet((String)(ALGO_KEY_CLASS_NAME + ".getCostCenterDs()"), (String)"bos_costcenter", (String)"id,number,name", (QFilter[])filter.toArray(), null);){
            while (costcenterDs.hasNext()) {
                Row row = costcenterDs.next();
                map.put(row.getLong("id"), row.getString("name"));
            }
        }
        return map;
    }

    protected Map<Long, String> getFeeMap(Collection<Long> feeids) {
        HashMap<Long, String> map = new HashMap<Long, String>();
        QFilter filter = new QFilter("id", "in", feeids);
        try (DataSet costcenterDs = QueryServiceHelper.queryDataSet((String)(ALGO_KEY_CLASS_NAME + ".getFeeMap()"), (String)"er_expenseitemedit", (String)"id,number,name", (QFilter[])filter.toArray(), null);){
            while (costcenterDs.hasNext()) {
                Row row = costcenterDs.next();
                map.put(row.getLong("id"), String.format("%s/%s", row.getString("number"), row.getString("name")));
            }
        }
        return map;
    }

    protected Map<Long, String> getSubelementMap(Collection<Long> subelementIds) {
        HashMap<Long, String> map = new HashMap<Long, String>(16);
        QFilter filter = new QFilter("id", "in", subelementIds);
        try (DataSet costcenterDs = QueryServiceHelper.queryDataSet((String)(ALGO_KEY_CLASS_NAME + ".getSubelementMap()"), (String)"cad_subelement", (String)"id,number,name", (QFilter[])filter.toArray(), null);){
            while (costcenterDs.hasNext()) {
                Row row = costcenterDs.next();
                map.put(row.getLong("id"), String.format("%s/%s", row.getString("number"), row.getString("name")));
            }
        }
        return map;
    }

    protected Map<Long, String> getCostDriverMap(Collection<Long> costDriverids) {
        HashMap<Long, String> map = new HashMap<Long, String>();
        QFilter filter = new QFilter("id", "in", costDriverids);
        try (DataSet costcenterDs = QueryServiceHelper.queryDataSet((String)(ALGO_KEY_CLASS_NAME + ".getCostDriverMap()"), (String)"cad_costdriver", (String)"id,number,name", (QFilter[])filter.toArray(), null);){
            while (costcenterDs.hasNext()) {
                Row row = costcenterDs.next();
                map.put(row.getLong("id"), row.getString("name"));
            }
        }
        return map;
    }

    protected DataSet getCostParam(Long orgId, List<Long> costAccounts, String appnum) {
        QFilter filter = new QFilter("org", "=", (Object)orgId);
        filter.and("costaccount", "in", costAccounts);
        filter.and("appnum", "=", (Object)appnum);
        return QueryServiceHelper.queryDataSet((String)(ALGO_KEY_CLASS_NAME + ".getCostParam()"), (String)"cad_sysparam", (String)"org,costaccount,assistant allocmethod", (QFilter[])filter.toArray(), null);
    }

    protected void asyncDeleteData(final Set<Long> ids, final String entity) {
        ThreadPools.executeOnce((String)"MfgFeeAllocBase.asyncDeleteData", (Runnable)new Runnable(){

            @Override
            public void run() {
                try (TXHandle h = TX.requiresNew();){
                    if (ids.size() > 0) {
                        MfgFeeAllocBase.this.deleteMfgFeeBill(ids, entity);
                    }
                }
            }
        });
    }

    public List<DynamicObject> validateCommon(DynamicObjectCollection dynCols, List<String> errorMsgs, String entityId, String appNum) {
        HashMap<Long, Long> accCurPeriodMap = new HashMap<Long, Long>();
        HashMap<Long, Boolean> accEnableFactoryMap = new HashMap<Long, Boolean>();
        HashMap<String, Boolean> closeAccountMap = new HashMap<String, Boolean>();
        Map<String, String> manuorgNameMap = null;
        ArrayList<DynamicObject> successObj = new ArrayList<DynamicObject>();
        for (DynamicObject dynObj : dynCols) {
            String tips;
            Long costaccountId = dynObj.getLong("costaccount");
            Long orgId = dynObj.getLong("org");
            if (!this.isPlanMfg(entityId)) {
                Long curPeriodId = 0L;
                if (!accCurPeriodMap.containsKey(costaccountId)) {
                    DynamicObject dyn = PeriodHelper.getCurrentPeriod((Long)costaccountId);
                    if (dyn != null) {
                        curPeriodId = dyn.getLong("id");
                        accCurPeriodMap.put(costaccountId, dyn.getLong("id"));
                    }
                } else {
                    curPeriodId = (Long)accCurPeriodMap.get(costaccountId);
                }
                if (!curPeriodId.equals(dynObj.getLong("period"))) {
                    tips = ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u4e0d\u5141\u8bb8\u5bf9\u975e\u5f53\u524d\u671f\u95f4\u6570\u636e\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"MfgFeeAllocBase_3", (String)"macc-cad-business", (Object[])new Object[0]);
                    errorMsgs.add(String.format("%s:%s", dynObj.getString("billno"), tips));
                    continue;
                }
                if (!accEnableFactoryMap.containsKey(costaccountId)) {
                    Boolean enableMulFactory = CostAccountHelper.isEnableMulFactory((Long)costaccountId);
                    accEnableFactoryMap.put(costaccountId, enableMulFactory);
                }
                if (((Boolean)accEnableFactoryMap.get(costaccountId)).booleanValue()) {
                    Long manuorgId = dynObj.getLong("manuorg");
                    String key = String.format("%s@%s@%s@%s", orgId, manuorgId, costaccountId, curPeriodId);
                    if (!closeAccountMap.containsKey(key)) {
                        closeAccountMap.put(key, CostCloseAccountHelper.checkIsCloseAccount((Long)orgId, (Long)manuorgId, (Long)costaccountId, (Long)curPeriodId));
                    }
                    if (((Boolean)closeAccountMap.get(key)).booleanValue()) {
                        if (manuorgNameMap == null) {
                            manuorgNameMap = this.getManuOrgName(orgId, entityId, appNum);
                        }
                        errorMsgs.add(String.format(ResManager.loadKDString((String)"%1$s:\u751f\u4ea7\u7ec4\u7ec7\u201c%2$s\u201d+\u6210\u672c\u8d26\u7c3f+\u5f53\u524d\u671f\u95f4\u5df2\u5173\u8d26\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"MfgFeeAllocBase_5", (String)"macc-cad-business", (Object[])new Object[0]), dynObj.getString("billno"), manuorgNameMap.get(manuorgId.toString())));
                        continue;
                    }
                }
            } else {
                Long planSchemeId = dynObj.getLong("planscheme");
                tips = PlanFeeAllocHelper.checkPeriodClosed((Long)planSchemeId, (Long)dynObj.getLong("period"));
                if (!CadEmptyUtils.isEmpty((String)tips)) {
                    errorMsgs.add(String.format("%s:%s", dynObj.getString("billno"), tips));
                    continue;
                }
            }
            successObj.add(dynObj);
        }
        return successObj;
    }

    protected static void refreshProgress(String opContent, int nowComplete, int total, Boolean isAddNum, String progressId) {
        ProgressParamDto paramDto = ProgressHelper.getProgressParam((String)progressId);
        if (paramDto == null) {
            return;
        }
        paramDto.setOpContent(opContent);
        if (isAddNum.booleanValue()) {
            Integer complete = paramDto.getComplete();
            paramDto.setComplete(Integer.valueOf(complete + nowComplete));
        } else {
            paramDto.setComplete(Integer.valueOf(nowComplete));
        }
        if (!CadEmptyUtils.isEmpty((Integer)total)) {
            paramDto.setTotal(Integer.valueOf(total));
        }
        paramDto.setUnit(ResManager.loadKDString((String)"\u6b65", (String)"MfgFeeAllocBase_6", (String)"macc-cad-business", (Object[])new Object[0]));
        paramDto.setDurationTimes(Integer.valueOf(0));
        if (nowComplete == -1) {
            paramDto.setComplete(paramDto.getTotal());
        }
        ProgressHelper.setProgressParam((String)progressId, (ProgressParamDto)paramDto);
    }

    private Map<String, String> getManuOrgName(Long orgId, String entityId, String appNum) {
        List permProOrgsByAccOrg = ImportServiceHelper.getPermProOrgsByAccOrg((Long)orgId, (String)entityId, (String)appNum);
        HashMap<String, String> map = new HashMap<String, String>(permProOrgsByAccOrg.size());
        for (ComboItem item : permProOrgsByAccOrg) {
            map.put(item.getValue(), item.getCaption().toString());
        }
        return map;
    }

    public boolean isHasNotConfirmBill(List<MfgFeeAllocImportParam> importDtos, String entityName) {
        for (MfgFeeAllocImportParam importDto : importDtos) {
            if (!this.isHasNotConfirmBill(importDto, entityName)) continue;
            return true;
        }
        return false;
    }

    public boolean isHasNotConfirmBill(MfgFeeAllocImportParam importDto, String entityName) {
        QFilter filter = this.getImportParamFilter(importDto, "costcenter");
        filter.and("allocstatus", "!=", (Object)ScaAllocEnum.ALLOCSTATUS_CONFIRM.getValue());
        boolean exists = QueryServiceHelper.exists((String)this.getMfgEntity(importDto.isActMfg(), entityName), (QFilter[])filter.toArray());
        return exists;
    }

    public DataSet getMfgAllocStd(Long orgId, String allocmold, String appnum, Long periodId) {
        String algoKey = ALGO_KEY_CLASS_NAME + ".getMfgAllocStd()";
        QFilter filter = new QFilter("org", "=", (Object)orgId);
        filter.and("allocmold", "=", (Object)allocmold);
        filter.and("billstatus", "=", (Object)"C");
        filter.and("appnum", "=", (Object)appnum);
        String selectFields = "org,manuorg,costcenter,noproduction,execondition,allocmold,expenseitem,costdriver,isrelatedwork,costdriverstatus,costdriverenable,unit,allocdim";
        DataSet allocStdDs = null;
        allocStdDs = MfgFeeAllocTypeEnum.AUXPROD.getValue().equals(allocmold) ? QueryServiceHelper.queryDataSet((String)algoKey, (String)"sca_mfgfeeallocstdnew", (String)"org,manuorg,costcenter,costcentergroup,issender,isexpense,noproduction,execondition,allocmold,entryentity.expenseitem expenseitem,entryentity.subelement subelement,entryentity.costdriver costdriver,entryentity.costdriver.isrelatedwork isrelatedwork,entryentity.costdriver.status costdriverstatus,entryentity.costdriver.enable costdriverenable,entryentity.costdriver.workactivity.unit unit,allocdim", (QFilter[])filter.toArray(), null) : QueryServiceHelper.queryDataSet((String)algoKey, (String)"sca_mfgfeeallocstdnew", (String)"org,manuorg,costcenter,costcentergroup,issender,isexpense,noproduction,execondition,allocmold,entryentity.expenseitem expenseitem,entryentity.subelement subelement,entryentity.costdriver costdriver,entryentity.costdriver.isrelatedwork isrelatedwork,entryentity.costdriver.status costdriverstatus,entryentity.costdriver.enable costdriverenable,entryentity.costdriver.unit unit,allocdim", (QFilter[])filter.toArray(), null);
        DataSet costCenterExpense = allocStdDs.filter("issender = true and isexpense = true").select(selectFields);
        DataSet costCenterGroupExpense = allocStdDs.filter("issender = false and isexpense = true").select("org,manuorg,costcentergroup,noproduction,execondition,allocmold,expenseitem,costdriver,isrelatedwork,unit,allocdim,costdriverstatus,costdriverenable");
        DataSet costCenterGroup = this.getCostCenterGroupDs(orgId, periodId);
        costCenterGroupExpense = costCenterGroupExpense.leftJoin(costCenterGroup).on("costcentergroup", "id").select(costCenterGroupExpense.getRowMeta().getFieldNames(), new String[]{"costcenter"}).finish();
        costCenterExpense = this.union(costCenterExpense, costCenterGroupExpense);
        DataSet costCenterSubElement = allocStdDs.filter("issender = true and isexpense = false").select("org,manuorg,costcenter,noproduction,execondition,allocmold,subelement,costdriver,isrelatedwork,unit,allocdim,costdriverstatus,costdriverenable");
        DataSet costCenterGroupSubElement = allocStdDs.filter("issender = false and isexpense = false").select("org,manuorg,costcentergroup,noproduction,execondition,allocmold,subelement,costdriver,isrelatedwork,unit,allocdim,costdriverstatus,costdriverenable");
        costCenterGroupSubElement = costCenterGroupSubElement.leftJoin(costCenterGroup).on("costcentergroup", "id").select(costCenterGroupSubElement.getRowMeta().getFieldNames(), new String[]{"costcenter"}).finish();
        costCenterSubElement = this.union(costCenterSubElement, costCenterGroupSubElement);
        DataSet subElementDs = this.getSubElementDs(orgId);
        costCenterSubElement = costCenterSubElement.leftJoin(subElementDs).on("subelement", "subelement").select(costCenterSubElement.getRowMeta().getFieldNames(), new String[]{"expenseitem"}).finish();
        costCenterExpense = this.union(costCenterExpense, costCenterSubElement).distinct();
        return costCenterExpense;
    }

    private DataSet getSubElementDs(Long orgId) {
        String algoKey = "kd.macc.cad.business.feealloc.MfgFeeAllocBase.getSubElementDs";
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        DataSet subElementDs = QueryServiceHelper.queryDataSet((String)algoKey, (String)"cad_subelementexpense", (String)"element,subelement,expenseitem", (QFilter[])orgFilter.toArray(), null);
        return subElementDs;
    }

    protected DataSet getCostCenterGroupDs(Long orgId, Long periodId) {
        Date endDate;
        Map periodEndDate;
        String algoKey = "kd.macc.cad.business.feealloc.MfgFeeAllocBase.getCostCenterGroupDs";
        Date date = new Date();
        if (!CadEmptyUtils.isEmpty((Long)periodId) && (periodEndDate = PeriodHelper.getEndDateByPeriod(Collections.singleton(periodId))) != null && (endDate = (Date)periodEndDate.get(periodId)) != null) {
            date = DateUtils.getDayEndTime((Date)endDate);
        }
        QFilter dateFilter = new QFilter("effectdate", "<=", (Object)date);
        dateFilter.and("expdate", ">", (Object)date);
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        statusFilter.and("enable", "=", (Object)Boolean.TRUE);
        DataSet costCenterGroup = QueryServiceHelper.queryDataSet((String)algoKey, (String)"cad_costcentergroup", (String)"id,entryentity.costcenter costcenter", (QFilter[])new QFilter[]{orgFilter, dateFilter, statusFilter}, null);
        return costCenterGroup;
    }

    protected DataSet union(DataSet ds1, DataSet ds2) {
        ds2 = ds2.select(ds1.getRowMeta().getFieldNames());
        return ds1.union(ds2);
    }

    protected QFilter getEffectDateFilter() {
        Date date = new Date();
        QFilter dateFilter = new QFilter("effectdate", "<=", (Object)date);
        dateFilter.and("expdate", ">", (Object)date);
        return dateFilter;
    }

    public DataSet getMfgAllocInnerStd(Long orgId, String appnum, Long periodId) {
        String algoKey = ALGO_KEY_CLASS_NAME + ".getMfgAllocInnerStd()";
        QFilter filter = new QFilter("org", "=", (Object)orgId);
        filter.and("billstatus", "=", (Object)"C");
        filter.and("appnum", "=", (Object)appnum);
        String selectFields = "org,manuorg,costcenter,allocmold,expenseitem,costdriver,costdriverstatus,costdriverenable,isrelatedwork,islinkresource,unit,allocdim";
        DataSet allocStdDs = QueryServiceHelper.queryDataSet((String)algoKey, (String)"sca_overheadallotcost", (String)"org,manuorg,costcenter,costcentergroup,issender,isexpense,allocmold,entryentity.expenseitem expenseitem,entryentity.subelement subelement,entryentity.costdriver costdriver,entryentity.costdriver.status costdriverstatus,entryentity.costdriver.enable costdriverenable,entryentity.costdriver.isrelatedwork isrelatedwork,entryentity.costdriver.islinkresource islinkresource,entryentity.costdriver.unit unit,allocdim", (QFilter[])filter.toArray(), null);
        DataSet costCenterExpense = allocStdDs.filter("issender = true and isexpense = true").select(selectFields);
        DataSet costCenterGroupExpense = allocStdDs.filter("issender = false and isexpense = true").select("org,manuorg,costcentergroup,allocmold,expenseitem,costdriver,costdriverstatus,costdriverenable,isrelatedwork,islinkresource,unit,allocdim");
        DataSet costCenterGroup = this.getCostCenterGroupDs(orgId, periodId);
        costCenterGroupExpense = costCenterGroupExpense.leftJoin(costCenterGroup).on("costcentergroup", "id").select(costCenterGroupExpense.getRowMeta().getFieldNames(), new String[]{"costcenter"}).finish();
        costCenterExpense = this.union(costCenterExpense, costCenterGroupExpense).addNullField("flag");
        DataSet costCenterSubElement = allocStdDs.filter("issender = true and isexpense = false").select("org,manuorg,costcenter,allocmold,subelement,costdriver,costdriverstatus,costdriverenable,isrelatedwork,islinkresource,unit,allocdim");
        DataSet costCenterGroupSubElement = allocStdDs.filter("issender = false and isexpense = false").select("org,manuorg,costcentergroup,allocmold,subelement,costdriver,costdriverstatus,costdriverenable,isrelatedwork,islinkresource,unit,allocdim");
        costCenterGroupSubElement = costCenterGroupSubElement.leftJoin(costCenterGroup).on("costcentergroup", "id").select(costCenterGroupSubElement.getRowMeta().getFieldNames(), new String[]{"costcenter"}).finish();
        costCenterSubElement = this.union(costCenterSubElement, costCenterGroupSubElement);
        DataSet subElementDs = this.getSubElementDs(orgId);
        costCenterSubElement = costCenterSubElement.leftJoin(subElementDs).on("subelement", "subelement").select(costCenterSubElement.getRowMeta().getFieldNames(), new String[]{"expenseitem", "1 as flag"}).finish();
        costCenterExpense = this.union(costCenterExpense, costCenterSubElement).distinct();
        return costCenterExpense;
    }

    public DataSet unionDs(DataSet targetDs, DataSet sourceDs) {
        if (!sourceDs.isEmpty()) {
            targetDs = targetDs == null ? sourceDs : targetDs.select(sourceDs.getRowMeta().getFieldNames()).union(sourceDs);
        }
        return targetDs;
    }

    protected DataSet getMulStandOnCostCenter(String appNum, Long orgId, String allocmoId, String entity, Long periodId) {
        String algoKey = ALGO_KEY_CLASS_NAME + ".getMulStandOnCostCenter()";
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter filter = new QFilter("billstatus", "=", (Object)"C");
        filter.and("appnum", "=", (Object)appNum);
        if (StringUtils.isNotBlank((CharSequence)allocmoId)) {
            filter.and("allocmold", "=", (Object)allocmoId);
        }
        DataSet allocStdDs = QueryServiceHelper.queryDataSet((String)algoKey, (String)entity, (String)"org,manuorg,costcenter,costcentergroup,issender", (QFilter[])new QFilter[]{orgFilter, filter}, null);
        DataSet costCenterDs = allocStdDs.filter("issender = true").select("org,manuorg,costcenter");
        DataSet costCenterGroupDs = allocStdDs.filter("issender = false").select("org,manuorg,costcentergroup");
        DataSet costCenterGroup = this.getCostCenterGroupDs(orgId, periodId);
        costCenterGroupDs = costCenterGroupDs.leftJoin(costCenterGroup).on("costcentergroup", "id").select(costCenterGroupDs.getRowMeta().getFieldNames(), new String[]{"costcenter", "1 as count"}).finish();
        DataSet mulStandDs = costCenterDs.join(costCenterGroupDs, JoinType.INNER).on("manuorg", "manuorg").on("costcenter", "costcenter").select(costCenterDs.getRowMeta().getFieldNames(), new String[]{"costcentergroup"}).finish().filter("costcenter is not null and costcenter != 0");
        DataSet groupMulStandDs = costCenterGroupDs.groupBy(new String[]{"org", "manuorg", "costcenter"}).sum("count").finish().filter("count > 1");
        if (!groupMulStandDs.isEmpty()) {
            groupMulStandDs = groupMulStandDs.select("org, manuorg, costcenter, 0 as costcentergroup");
            mulStandDs = mulStandDs.union(groupMulStandDs);
        }
        return mulStandDs;
    }

    public DataSet getHasInputCostenterDs(Long orgId, Long periodId, String appnum) {
        String algokey = ALGO_KEY_CLASS_NAME + ".getHasInputCostenterDs";
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter datefilter = this.getBookDateFilter(periodId);
        QFilter basefilter = new QFilter("billstatus", "=", (Object)"C");
        basefilter.and("appnum", "=", (Object)appnum);
        basefilter.and("entryentity.facthour", "!=", (Object)0L);
        DataSet resourceCollect = QueryServiceHelper.queryDataSet((String)algokey, (String)"sca_resourceuse", (String)"id,org,manuorg,costcenter", (QFilter[])new QFilter[]{orgFilter, datefilter, basefilter}, null);
        resourceCollect = resourceCollect.groupBy(new String[]{"org", "costcenter"}).count("id").finish();
        return resourceCollect;
    }

    public DataSet getHasWipCompleteCenter(Long orgId, Long periodId, String appNum) {
        String algoKey = ALGO_KEY_CLASS_NAME + ".getHasWipCompleteCenter";
        QFilter filter = new QFilter("org", "=", (Object)orgId);
        filter.and("billstatus", "=", (Object)"C");
        filter.and("appnum", "=", (Object)appNum);
        QFilter dateFilter = this.getBookDateFilter(periodId);
        DataSet factDs = QueryServiceHelper.queryDataSet((String)algoKey, (String)"cad_factnedoutputbill", (String)"org,manuorg,costcenter,completeqty", (QFilter[])new QFilter[]{filter, dateFilter}, null);
        factDs = factDs.groupBy(new String[]{"org", "costcenter"}).sum("completeqty").finish();
        factDs = factDs.filter(" completeqty !=0");
        return factDs;
    }

    private QFilter getDatefilter(Long periodId) {
        QFilter idfilter = new QFilter("id", "=", (Object)periodId);
        DynamicObject period = QueryServiceHelper.queryOne((String)"bd_period", (String)"begindate,enddate", (QFilter[])idfilter.toArray());
        QFilter datefilter = new QFilter("bizdate", ">=", (Object)period.getDate("begindate"));
        datefilter.and("bizdate", "<=", (Object)period.getDate("enddate"));
        return datefilter;
    }

    protected QFilter getBookDateFilter(Long periodId) {
        QFilter idfilter = new QFilter("id", "=", (Object)periodId);
        DynamicObject period = QueryServiceHelper.queryOne((String)"bd_period", (String)"begindate,enddate", (QFilter[])idfilter.toArray());
        QFilter datefilter = new QFilter("bookdate", ">=", (Object)period.getDate("begindate"));
        datefilter.and("bookdate", "<=", (Object)period.getDate("enddate"));
        return datefilter;
    }

    protected String getCostcenterFeeTip(DataSet costdriverNullDs, String tips, Set<String> errorInfo) {
        StringBuilder sb = new StringBuilder();
        HashMap<Long, Set> map = new HashMap<Long, Set>();
        HashSet<Long> expenseitemSet = new HashSet<Long>(256);
        while (costdriverNullDs.hasNext()) {
            Row row = costdriverNullDs.next();
            Long costcenter = row.getLong("costcenter");
            Long expenseitem = row.getLong("expenseitem");
            Set feeSet = map.computeIfAbsent(costcenter, t -> new HashSet());
            feeSet.add(expenseitem);
            expenseitemSet.add(expenseitem);
        }
        Map<Long, String> costcenterMap = this.getCostCenterMap(map.keySet());
        Map<Long, String> experMap = this.getFeeMap(expenseitemSet);
        for (Map.Entry entry : map.entrySet()) {
            Set feeSet = (Set)entry.getValue();
            StringBuilder feeSb = new StringBuilder();
            for (Long fee : feeSet) {
                feeSb.append("\u3010").append(experMap.get(fee)).append("\u3011").append(",");
                String errorMsg = String.format(tips, costcenterMap.get(entry.getKey()), experMap.get(fee));
                errorInfo.add(errorMsg);
            }
            sb.append(String.format(tips, costcenterMap.get(entry.getKey()), feeSb.toString().substring(0, feeSb.length() - 1))).append("\r\n");
        }
        return sb.toString().substring(0, sb.length() - 2);
    }

    protected DataSet getManuOrgCostcenterDs(MfgFeeAllocImportParam importDto) {
        QFilter qFilter = new QFilter("org", "=", (Object)importDto.getOrg());
        Date nowtime = new Date();
        qFilter.and("billstatus", "=", (Object)"C");
        qFilter.and("effectdate", "<=", (Object)nowtime);
        qFilter.and("expdate", ">", (Object)nowtime);
        qFilter.and("appnum", "=", (Object)"sca");
        return QueryServiceHelper.queryDataSet((String)"MfgFeeAllocBase.getManuOrgCostcenterDs", (String)"cad_centermanuorg", (String)"manuorg,entryentity.costcenter as costcenterid", (QFilter[])qFilter.toArray(), null);
    }

    protected DataSet replaceManuOrgFromDs(DataSet ds, MfgFeeAllocImportParam importDto, String costcenterField) {
        if (importDto.isEnableFactory()) {
            DataSet manuorgCostcenterDs = this.getManuOrgCostcenterDs(importDto);
            ArrayList<String> fieldNames = new ArrayList<String>();
            fieldNames.addAll(Arrays.asList(ds.getRowMeta().getFieldNames()));
            fieldNames.remove("manuorg");
            ds = ds.join(manuorgCostcenterDs).on(costcenterField, "costcenterid").select(fieldNames.toArray(new String[0]), new String[]{"manuorg"}).finish();
        }
        return ds;
    }

    protected String dealAllocStatus(String srcstatus, String tarstatus) {
        try {
            if (CadEmptyUtils.isEmpty((String)srcstatus)) {
                return tarstatus;
            }
            int tar = Integer.parseInt(tarstatus);
            int src = Integer.parseInt(srcstatus);
            if (src > tar) {
                return srcstatus;
            }
        }
        catch (Exception ex) {
            logger.error("\u8f6c\u6362\u72b6\u6001\u5931\u8d25", (Throwable)ex);
        }
        return tarstatus;
    }

    protected String getPeriodName(Long periodId) {
        DynamicObject periodDyn = BusinessDataServiceHelper.loadSingleFromCache((Object)periodId, (String)"bd_period");
        if (periodDyn != null) {
            return periodDyn.getString("name");
        }
        return "";
    }
}

