/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.business.feealloc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.algox.mfgfee.alloc.AssitProdAlloc;
import kd.macc.cad.algox.mfgfee.importer.MfgFeeImportAlgoxService;
import kd.macc.cad.business.feealloc.MfgFeeAllocBase;
import kd.macc.cad.common.dto.MfgFeeAllocImportParam;
import kd.macc.cad.common.enums.MfgFeeAllocTypeEnum;
import kd.macc.cad.common.enums.ScaAllocEnum;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.SimpleMutexHelper;
import kd.macc.cad.common.output.ExecuteResult;
import kd.macc.cad.common.output.MfgAllocResult;

public class MfgFeeAuxProdAllocService
extends MfgFeeAllocBase {
    private static final String ALGO_KEY_CLASS_NAME = MfgFeeAuxProdAllocService.class.getCanonicalName();
    private static final Log logger = LogFactory.getLog(MfgFeeAuxProdAllocService.class);

    public ExecuteResult feeAllocAuxProdImport(MfgFeeAllocImportParam importDto, String progressId) {
        return this.feeAllocAuxProdImport(importDto, progressId, "", 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecuteResult feeAllocAuxProdImport(MfgFeeAllocImportParam importDto, String progressId, String periodName, int currentIndex) {
        ExecuteResult result;
        block40: {
            int totalSize = 7;
            if (!importDto.isActMfg()) {
                totalSize = importDto.getCalcPeriodMap().size() * 7;
            }
            int current = (currentIndex - 1) * 7;
            MfgFeeAuxProdAllocService.refreshProgress(String.format(ResManager.loadKDString((String)"%s\u8f85\u52a9\u751f\u4ea7\u5206\u914d\u5f15\u5165\u5f00\u59cb", (String)"MfgFeeAuxProdAllocService_39", (String)"macc-cad-business", (Object[])new Object[0]), periodName), current + 1, totalSize, false, progressId);
            logger.info("\u8f85\u52a9\u751f\u4ea7\u5206\u914d-\u5f15\u5165\u5355\u636e\uff1a{}", (Object)importDto);
            result = new ExecuteResult();
            try {
                int size;
                ArrayList<Long> costAccountIds = new ArrayList<Long>(16);
                costAccountIds.add(importDto.getCostaccount());
                DataSet auxBillAndStdDs = this.getImportAuxBillDs(importDto, false);
                if (auxBillAndStdDs == null) {
                    ExecuteResult executeResult = result;
                    return executeResult;
                }
                HashSet<String> errorInfo = new HashSet<String>(16);
                DataSet costdriverNullDs = auxBillAndStdDs.copy().filter("costdriver is null");
                if (!costdriverNullDs.isEmpty()) {
                    ArrayList<Long> costcenters = new ArrayList<Long>();
                    try (DataSet costcenterDs = costdriverNullDs.groupBy(new String[]{"costcenter"}).finish();){
                        while (costcenterDs.hasNext()) {
                            Row row = costcenterDs.next();
                            costcenters.add(row.getLong("costcenter"));
                        }
                    }
                    auxBillAndStdDs.close();
                    costcenterDs = this.getCostCenterNotExistResult(costcenters);
                    return costcenterDs;
                }
                DataSet costdriverNotEnableDs = auxBillAndStdDs.copy().filter("costdriverenable = '0' or costdriverstatus in('A','B')");
                if (!costdriverNotEnableDs.isEmpty()) {
                    String tips = ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u201c%1$s\u201d\u4e0b%2$s\u9700\u8981\u91cd\u65b0\u7ef4\u62a4\u5bf9\u5e94\u7684\u5206\u914d\u6807\u51c6\u3002", (String)"MfgFeeAuxProdAllocService_27", (String)"macc-cad-business", (Object[])new Object[0]);
                    String errorMsg = this.getCostcenterFeeTip(costdriverNotEnableDs, tips, errorInfo);
                    result.setErrorInfo(errorInfo);
                    result.setErrorNotification(errorMsg);
                    auxBillAndStdDs.close();
                    ExecuteResult row = result;
                    return row;
                }
                DataSet costParamDs = this.getCostParam(importDto.getOrg(), costAccountIds, importDto.getAppnum());
                DataSet auxBillStdAndParamDs = auxBillAndStdDs.leftJoin(costParamDs).on("org", "org").on("costaccount", "costaccount").select(auxBillAndStdDs.getRowMeta().getFieldNames(), new String[]{"allocmethod"}).finish();
                DataSet notRelaDs = auxBillStdAndParamDs.copy().filter("isrelatedwork=false");
                MfgFeeImportAlgoxService algoxImportService = new MfgFeeImportAlgoxService();
                HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
                HashSet<Long> manuorgs = new HashSet<Long>();
                paramMap.put("appnum", importDto.getAppnum());
                paramMap.put("planscheme", importDto.getPlanscheme());
                if (!notRelaDs.isEmpty()) {
                    paramMap.put("publicaux", Boolean.TRUE);
                    paramMap.put("entitytype", importDto.getEntityType());
                    DataSet notRelaCopyDs = notRelaDs.copy();
                    while (notRelaCopyDs.hasNext()) {
                        manuorgs.add(notRelaCopyDs.next().getLong("manuorg"));
                    }
                    try {
                        MfgFeeAuxProdAllocService.refreshProgress(String.format(ResManager.loadKDString((String)"\u516c\u5171\u8f85\u52a9\u751f\u4ea7\u5f15\u5165", (String)"MfgFeeAuxProdAllocService_32", (String)"macc-cad-business", (Object[])new Object[0]), periodName), current + 3, totalSize, false, progressId);
                        size = algoxImportService.auxProdImportCalc(notRelaDs, paramMap);
                        result.setSuccessQty(result.getSuccessQty() + size);
                    }
                    catch (Exception ex) {
                        logger.error("\u516c\u5171\u8f85\u52a9\u751f\u4ea7\u5f15\u5165\u5931\u8d25\uff1a" + ex.getMessage(), (Throwable)ex);
                        result.setErrorNotification(String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff1a%s\u3002", (String)"MfgFeeAuxProdAllocService_28", (String)"macc-cad-business", (Object[])new Object[0]), ex.getMessage()));
                        ExecuteResult executeResult = result;
                        if (importDto.isActMfg()) {
                            SimpleMutexHelper.releaseXMutex((String)"auxImport", (Object)(importDto.getCostaccount() + "auxImport"));
                        }
                        if (currentIndex * 7 == totalSize) {
                            MfgFeeAuxProdAllocService.refreshProgress(ResManager.loadKDString((String)"\u8f85\u52a9\u751f\u4ea7\u5206\u914d\u5bfc\u5165\u5b8c\u6210\u3002", (String)"MfgFeeAuxProdAllocService_34", (String)"macc-cad-business", (Object[])new Object[0]), -1, 0, false, progressId);
                        }
                        return executeResult;
                    }
                }
                paramMap.put("publicaux", Boolean.FALSE);
                paramMap.put("entitytype", importDto.getEntityType());
                DataSet auxDs = auxBillStdAndParamDs.filter("isrelatedwork=true");
                if (manuorgs.size() > 0) {
                    auxDs = auxDs.filter(String.format("manuorg not in(%s)", this.getSetStr(manuorgs)));
                }
                if (auxDs.isEmpty()) break block40;
                try {
                    MfgFeeAuxProdAllocService.refreshProgress(String.format(ResManager.loadKDString((String)"\u8f85\u52a9\u751f\u4ea7\u5f15\u5165", (String)"MfgFeeAuxProdAllocService_33", (String)"macc-cad-business", (Object[])new Object[0]), periodName), current + 5, totalSize, false, progressId);
                    size = algoxImportService.auxProdImportCalc(auxDs, paramMap);
                    result.setSuccessQty(result.getSuccessQty() + size);
                }
                catch (Exception ex) {
                    logger.error("\u8f85\u52a9\u751f\u4ea7\u5f15\u5165\u5931\u8d25\uff1a" + ex.getMessage(), (Throwable)ex);
                    result.setErrorNotification(String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff1a%s\u3002", (String)"MfgFeeAuxProdAllocService_28", (String)"macc-cad-business", (Object[])new Object[0]), ex.getMessage()));
                    ExecuteResult executeResult = result;
                    if (importDto.isActMfg()) {
                        SimpleMutexHelper.releaseXMutex((String)"auxImport", (Object)(importDto.getCostaccount() + "auxImport"));
                    }
                    if (currentIndex * 7 == totalSize) {
                        MfgFeeAuxProdAllocService.refreshProgress(ResManager.loadKDString((String)"\u8f85\u52a9\u751f\u4ea7\u5206\u914d\u5bfc\u5165\u5b8c\u6210\u3002", (String)"MfgFeeAuxProdAllocService_34", (String)"macc-cad-business", (Object[])new Object[0]), -1, 0, false, progressId);
                    }
                    return executeResult;
                }
            }
            catch (Exception e) {
                logger.error("\u8f85\u52a9\u751f\u4ea7\u5206\u914d\u5931\u8d25", (Throwable)e);
            }
            finally {
                if (importDto.isActMfg()) {
                    SimpleMutexHelper.releaseXMutex((String)"auxImport", (Object)(importDto.getCostaccount() + "auxImport"));
                }
                if (currentIndex * 7 == totalSize) {
                    MfgFeeAuxProdAllocService.refreshProgress(ResManager.loadKDString((String)"\u8f85\u52a9\u751f\u4ea7\u5206\u914d\u5bfc\u5165\u5b8c\u6210\u3002", (String)"MfgFeeAuxProdAllocService_34", (String)"macc-cad-business", (Object[])new Object[0]), -1, 0, false, progressId);
                }
            }
        }
        logger.info("\u8f85\u52a9\u751f\u4ea7\u5f15\u5165{}\u5f20\u5355\u636e", (Object)result.getSuccessQty());
        return result;
    }

    private int feeAllocCommonAuxProdImport(MfgFeeAllocImportParam importDto) {
        logger.info("\u8f85\u52a9\u751f\u4ea7\u5206\u914d-\u516c\u5171\u8f85\u52a9-\u5f15\u5165\u5355\u636e\uff1a{}", (Object)importDto);
        ArrayList<Long> costAccountIds = new ArrayList<Long>(16);
        costAccountIds.add(importDto.getCostaccount());
        DataSet auxBillAndStdDs = this.getImportAuxBillDs(importDto, true);
        if (auxBillAndStdDs == null || auxBillAndStdDs.isEmpty()) {
            return 0;
        }
        DataSet costdriverNullDs = auxBillAndStdDs.copy().filter("costdriver is null");
        if (!costdriverNullDs.isEmpty()) {
            ArrayList<Long> costcenters = new ArrayList<Long>();
            try (DataSet costcenterDs = costdriverNullDs.groupBy(new String[]{"costcenter"}).finish();){
                while (costcenterDs.hasNext()) {
                    Row row = costcenterDs.next();
                    costcenters.add(row.getLong("costcenter"));
                }
            }
            auxBillAndStdDs.close();
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u516c\u5171\u8f85\u52a9\u751f\u4ea7\u5206\u914d\u5355\u5728\u786e\u8ba4\u65f6\u6267\u884c\u5bfc\u5165\u5931\u8d25\uff0c%s\u672a\u8bbe\u7f6e\u5206\u914d\u6807\u51c6\u3002", (String)"MfgFeeAuxProdAllocService_29", (String)"macc-cad-business", (Object[])new Object[0]), this.getCostCenterNameStr(costcenters)));
        }
        DataSet costParamDs = this.getCostParam(importDto.getOrg(), costAccountIds, importDto.getAppnum());
        DataSet auxBillStdAndParamDs = auxBillAndStdDs.leftJoin(costParamDs).on("org", "org").on("costaccount", "costaccount").select(auxBillAndStdDs.getRowMeta().getFieldNames(), new String[]{"allocmethod"}).finish();
        MfgFeeImportAlgoxService algoxImportService = new MfgFeeImportAlgoxService();
        HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
        DataSet auxDs = auxBillStdAndParamDs.filter("isrelatedwork=true");
        if (!auxDs.isEmpty()) {
            paramMap.put("publicaux", Boolean.FALSE);
            paramMap.put("entitytype", importDto.getEntityType());
            paramMap.put("appnum", importDto.getAppnum());
            paramMap.put("planscheme", importDto.getPlanscheme());
            int i = algoxImportService.auxProdImportCalc(auxDs, paramMap);
            logger.info("\u8f85\u52a9\u751f\u4ea7\u5f15\u5165{}\u5f20\u5355\u636e", (Object)i);
            return i;
        }
        return 0;
    }

    private DataSet getImportAuxBillDs(MfgFeeAllocImportParam importDto, boolean isQueryAux) {
        DataSet auxBillDs = null;
        auxBillDs = this.getMfgCollocBills(importDto, MfgFeeAllocTypeEnum.AUXPROD);
        DataSet nonDs = this.getNonProdBills(importDto, MfgFeeAllocTypeEnum.AUXPROD);
        auxBillDs = this.unionDs(auxBillDs, nonDs);
        if (isQueryAux) {
            DataSet pubAuxDs = this.getPubAuxProdBills(importDto);
            auxBillDs = this.unionDs(auxBillDs, pubAuxDs);
        }
        if (auxBillDs == null || auxBillDs.isEmpty()) {
            if (auxBillDs != null) {
                auxBillDs.close();
            }
            return null;
        }
        auxBillDs = this.replaceManuOrgFromDs(auxBillDs, importDto, "costcenter");
        DataSet auxprdstdDs = this.getMfgAllocStd(importDto.getOrg(), MfgFeeAllocTypeEnum.AUXPROD.getValue(), importDto.getAppnum(), importDto.getPeriod());
        DataSet auxBillAndStdDs = auxBillDs.leftJoin(auxprdstdDs).on("org", "org").on("manuorg", "manuorg").on("costcenter", "costcenter").select(new String[]{"id", "billno", "org", "costaccount", "manuorg", "period", "costcenter", "expenseitem", "totalamount", "currency", "amtprecision", "type"}, new String[]{"expenseitem expenseitemstd", "costdriver", "isrelatedwork", "costdriverstatus", "costdriverenable", "unit"}).finish();
        return auxBillAndStdDs;
    }

    public DataSet getPubAuxProdBills(MfgFeeAllocImportParam importDto) {
        String algoKey = ALGO_KEY_CLASS_NAME + ".getAuxProdBills()";
        QFilter filter = this.getImportParamFilter(importDto, "parallelentity.parallelsubentity.parsubcostcenter");
        filter.and("parallelentity.parallelsubentity.parsubcostcenter.orgduty", "=", (Object)5L);
        filter.and("publicaux", "=", (Object)Boolean.TRUE);
        DataSet auxAllocDs = QueryServiceHelper.queryDataSet((String)algoKey, (String)this.getMfgEntity(importDto.isActMfg(), importDto.getEntityType()), (String)"id,billno,org,costaccount,manuorg,period,parallelentity.parallelsubentity.parsubcostcenter costcenter,parallelentity.parallelsubentity.parsubexpenseitem expenseitem,parallelentity.parallelsubentity.parsubamt totalamount,currency,currency.amtprecision amtprecision,'auxprod' type,0 costobject,0 material", (QFilter[])filter.toArray(), null);
        return auxAllocDs;
    }

    private String getSetStr(Set<Long> ids) {
        StringBuilder sb = new StringBuilder();
        for (Long id : ids) {
            sb.append(id).append(",");
        }
        return sb.toString().substring(0, sb.length() - 1);
    }

    public void deleteAuxProdAndRelaBills(MfgFeeAllocImportParam importDto, boolean isDeleteSelf) {
        this.deleteAuxProdAndRelaBills(importDto, isDeleteSelf, null);
    }

    public void deleteAuxProdAndRelaBills(MfgFeeAllocImportParam importDto, boolean isDeleteSelf, Boolean isPubAux) {
        logger.info("\u8f85\u52a9\u751f\u4ea7\u5206\u914d-\u5220\u9664\u5355\u636e\uff1a{}\uff0c{}\uff0c{}", new Object[]{importDto, isDeleteSelf, isPubAux});
        DataSet relaCostcenterDs = this.getAuxProdBenefBill(importDto);
        String entityType = importDto.getEntityType();
        String basicEntity = this.getMfgEntity(importDto.isActMfg(), "cad_basicalloc");
        Set<Object> auxProdIds = new HashSet(16);
        if (isDeleteSelf && !(auxProdIds = this.getAuxBillIds(importDto, isPubAux)).isEmpty()) {
            logger.info("\u8f85\u52a9\u751f\u4ea7\u5206\u914d-\u5220\u9664\u8f85\u52a9\u751f\u4ea7\u5355\u636e\u6570\uff1a{}", (Object)auxProdIds.size());
            this.expireMfgFeeBill(auxProdIds, entityType);
            this.asyncDeleteData(auxProdIds, entityType);
        }
        if (relaCostcenterDs != null && !relaCostcenterDs.isEmpty()) {
            boolean isHasBasicCostcenter;
            boolean bl = isHasBasicCostcenter = !relaCostcenterDs.filter("orgduty=4").isEmpty();
            if (isHasBasicCostcenter) {
                Set<Long> cosIds;
                Set<Long> basicProdIds = this.getEntityBillIds(importDto, basicEntity);
                if (!basicProdIds.isEmpty()) {
                    logger.info("\u8f85\u52a9\u751f\u4ea7\u5206\u914d-\u5220\u9664\u57fa\u672c\u751f\u4ea7\u5355\u636e\u6570\uff1a{}", (Object)basicProdIds.size());
                    this.expireMfgFeeBill(basicProdIds, basicEntity);
                    this.asyncDeleteData(basicProdIds, basicEntity);
                }
                if (importDto.isActMfg() && !(cosIds = this.getEntityBillIds(importDto, "cad_mfgfeeallocco")).isEmpty()) {
                    logger.info("\u8f85\u52a9\u751f\u4ea7\u5206\u914d-\u5220\u9664\u6210\u672c\u4e2d\u5fc3\u5185\u5355\u636e\u6570\uff1a{}", (Object)cosIds.size());
                    this.expireMfgFeeBill(cosIds, "cad_mfgfeeallocco");
                    this.asyncDeleteData(cosIds, "cad_mfgfeeallocco");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MfgAllocResult doSelectAlloc(List<Long> ids, String appNum, String progressId, boolean planData) {
        MfgFeeAuxProdAllocService.refreshProgress(ResManager.loadKDString((String)"\u8f85\u52a9\u751f\u4ea7\u5206\u914d\u5f00\u59cb", (String)"MfgFeeAuxProdAllocService_35", (String)"macc-cad-business", (Object[])new Object[0]), 1, 3, false, progressId);
        MfgAllocResult allocResult = new MfgAllocResult();
        long costAccountId = 0L;
        try {
            String entityType = planData ? "cad_planauxprodalloc" : "cad_auxprodalloc";
            DynamicObjectCollection cols = this.getAuxProdBill(ids, entityType);
            ArrayList<String> errorMsgs = new ArrayList<String>();
            List<DynamicObject> dynCols = this.validateCommon(cols, errorMsgs, entityType, appNum);
            ArrayList<DynamicObject> verifyObj = new ArrayList<DynamicObject>();
            if (!dynCols.isEmpty()) {
                for (DynamicObject dynObj : dynCols) {
                    if (costAccountId == 0L) {
                        costAccountId = dynObj.getLong("costaccount");
                    }
                    if (ScaAllocEnum.ALLOCSTATUS_CONFIRM.getValue().equals(dynObj.getString("allocstatus"))) {
                        String tips = ResManager.loadKDString((String)"\u5355\u636e\u5df2\u5206\u914d\uff0c\u4e0d\u80fd\u518d\u5206\u914d\u3002", (String)"MfgFeeAuxProdAllocService_13", (String)"macc-cad-business", (Object[])new Object[0]);
                        errorMsgs.add(String.format("%s:%s", dynObj.getString("billno"), tips));
                        continue;
                    }
                    verifyObj.add(dynObj);
                }
            }
            if (!verifyObj.isEmpty()) {
                List<MfgFeeAllocImportParam> importDtos = this.getAllocImportDtos(verifyObj, entityType);
                MfgFeeAuxProdAllocService.refreshProgress(ResManager.loadKDString((String)"\u83b7\u53d6\u5206\u914d\u6807\u51c6\u5206\u914d\u4e2d\uff0c\u8bf7\u7a0d\u5019\u3002", (String)"MfgFeeAuxProdAllocService_36", (String)"macc-cad-business", (Object[])new Object[0]), 2, 3, false, progressId);
                allocResult = this.doAlloc(importDtos, null, planData);
                if (allocResult.getVerifyMsgs() == null) {
                    allocResult.setVerifyMsgs(errorMsgs);
                } else {
                    allocResult.getVerifyMsgs().addAll(errorMsgs);
                }
                MfgAllocResult mfgAllocResult = allocResult;
                return mfgAllocResult;
            }
            allocResult.setVerifyMsgs(errorMsgs);
        }
        catch (Exception e) {
            logger.error("\u8f85\u52a9\u751f\u4ea7\u5206\u914d\u5931\u8d25", (Throwable)e);
        }
        finally {
            SimpleMutexHelper.releaseXMutex((String)"auxAlloc", (Object)(costAccountId + "auxAlloc"));
            MfgFeeAuxProdAllocService.refreshProgress(ResManager.loadKDString((String)"\u8f85\u52a9\u751f\u4ea7\u5206\u914d\u5b8c\u6210\u3002", (String)"MfgFeeAuxProdAllocService_37", (String)"macc-cad-business", (Object[])new Object[0]), -1, 0, false, progressId);
        }
        return allocResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MfgAllocResult doAlloc(List<MfgFeeAllocImportParam> importDtos, String progressId, boolean planData) {
        MfgFeeAuxProdAllocService.refreshProgress(ResManager.loadKDString((String)"\u8f85\u52a9\u751f\u4ea7\u5206\u914d\u5f00\u59cb", (String)"MfgFeeAuxProdAllocService_35", (String)"macc-cad-business", (Object[])new Object[0]), 1, 3, false, progressId);
        MfgAllocResult allocResult = new MfgAllocResult();
        long costAccountId = 0L;
        try {
            for (MfgFeeAllocImportParam importDto : importDtos) {
                if (costAccountId == 0L) {
                    costAccountId = importDto.getCostaccount();
                }
                DataSet ds = this.getAuxProdAllocBill(importDto);
                Throwable throwable = null;
                try {
                    ArrayList<Long> ids = new ArrayList<Long>();
                    DataSet pubAuxDs = ds.filter("allocstatus!='2'");
                    if (!pubAuxDs.isEmpty()) {
                        while (pubAuxDs.hasNext()) {
                            Row row = pubAuxDs.next();
                            ids.add(row.getLong("id"));
                        }
                    }
                    try {
                        MfgFeeAuxProdAllocService.refreshProgress(ResManager.loadKDString((String)"\u83b7\u53d6\u5206\u914d\u6807\u51c6\u8fdb\u884c\u5206\u914d\u3002", (String)"MfgFeeAuxProdAllocService_38", (String)"macc-cad-business", (Object[])new Object[0]), 2, 3, false, progressId);
                        String status = new AssitProdAlloc().doAssitProdAlloc(ids, importDto.getAppnum(), planData, importDto.getPlanscheme());
                        if (!planData) {
                            allocResult.setAllocStatus(status);
                            continue;
                        }
                        allocResult.setAllocStatus(this.dealAllocStatus(status, allocResult.getAllocStatus()));
                    }
                    catch (Exception ex) {
                        String tips = ResManager.loadKDString((String)"\u5206\u914d\u5931\u8d25\uff1a%s\u3002", (String)"MfgFeeAuxProdAllocService_14", (String)"macc-cad-business", (Object[])new Object[0]);
                        logger.error("\u5206\u914d\u51fa\u73b0\u9519\u8bef\uff1a" + ex.getMessage(), (Throwable)ex);
                        ArrayList<String> errorMsgs = new ArrayList<String>();
                        errorMsgs.add(String.format(tips, ex.getMessage()));
                        allocResult.setVerifyMsgs(errorMsgs);
                        MfgAllocResult mfgAllocResult = allocResult;
                        if (ds != null) {
                            if (throwable != null) {
                                try {
                                    ds.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            } else {
                                ds.close();
                            }
                        }
                        if (!planData) {
                            SimpleMutexHelper.releaseXMutex((String)"auxAlloc", (Object)(costAccountId + "auxAlloc"));
                        }
                        MfgFeeAuxProdAllocService.refreshProgress(ResManager.loadKDString((String)"\u8f85\u52a9\u751f\u4ea7\u5206\u914d\u5b8c\u6210\u3002", (String)"MfgFeeAuxProdAllocService_37", (String)"macc-cad-business", (Object[])new Object[0]), -1, 0, false, progressId);
                        return mfgAllocResult;
                    }
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                finally {
                    if (ds == null) continue;
                    if (throwable != null) {
                        try {
                            ds.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                        continue;
                    }
                    ds.close();
                }
            }
        }
        catch (Exception e) {
            logger.error("\u8f85\u52a9\u751f\u4ea7\u5206\u914d\u5931\u8d25", (Throwable)e);
        }
        finally {
            if (!planData) {
                SimpleMutexHelper.releaseXMutex((String)"auxAlloc", (Object)(costAccountId + "auxAlloc"));
            }
            MfgFeeAuxProdAllocService.refreshProgress(ResManager.loadKDString((String)"\u8f85\u52a9\u751f\u4ea7\u5206\u914d\u5b8c\u6210\u3002", (String)"MfgFeeAuxProdAllocService_37", (String)"macc-cad-business", (Object[])new Object[0]), -1, 0, false, progressId);
        }
        return allocResult;
    }

    public List<String> doSelectConfirm(List<Long> ids, String appNum, String entityType) {
        DynamicObjectCollection cols = this.getAuxProdBill(ids, entityType);
        ArrayList<String> errorMsgs = new ArrayList<String>();
        List<DynamicObject> dynCols = this.validateCommon(cols, errorMsgs, entityType, appNum);
        ArrayList<DynamicObject> verifyObj = new ArrayList<DynamicObject>();
        if (dynCols.size() > 0) {
            for (DynamicObject dynObj : dynCols) {
                if (!ScaAllocEnum.ALLOCSTATUS_ALLOC.getValue().equals(dynObj.getString("allocstatus"))) {
                    String tips = ResManager.loadKDString((String)"\u5206\u914d\u72b6\u6001\u4e0d\u662f\u201c\u5df2\u5206\u914d\u201d\uff0c\u4e0d\u80fd\u64cd\u4f5c\u786e\u8ba4\u3002", (String)"MfgFeeAuxProdAllocService_16", (String)"macc-cad-business", (Object[])new Object[0]);
                    errorMsgs.add(String.format("%s:%s", dynObj.getString("billno"), tips));
                    continue;
                }
                verifyObj.add(dynObj);
            }
        }
        if (!verifyObj.isEmpty()) {
            List<MfgFeeAllocImportParam> importDtos = this.getAllocImportDtos(verifyObj, entityType);
            for (MfgFeeAllocImportParam importParam : importDtos) {
                String msg = this.doConfirm(importParam);
                if (!StringUtils.isNotEmpty((CharSequence)msg)) continue;
                errorMsgs.add(msg);
            }
        }
        return errorMsgs;
    }

    private String doConfirm(MfgFeeAllocImportParam importDto) {
        try (DataSet auxDs = this.getAuxProdAllocBill(importDto);){
            if (auxDs.isEmpty()) {
                String string = ResManager.loadKDString((String)"\u672a\u627e\u5230\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u540e\u8fdb\u884c\u5904\u7406\u3002", (String)"MfgFeeAuxProdAllocService_17", (String)"macc-cad-business", (Object[])new Object[0]);
                return string;
            }
            HashSet<Long> manuOrgs = new HashSet<Long>();
            HashSet<Long> ids = new HashSet<Long>();
            while (auxDs.hasNext()) {
                Row row = auxDs.next();
                String allocstatus = row.getString("allocstatus");
                if (ScaAllocEnum.ALLOCSTATUS_CONFIRM.getValue().equals(allocstatus)) continue;
                if (ScaAllocEnum.ALLOCSTATUS_UNALLOC.getValue().equals(allocstatus)) {
                    String string = ResManager.loadKDString((String)"\u201c\u6210\u672c\u8d26\u7c3f+\u5f53\u524d\u671f\u95f4\u201d\u4e0b\u5b58\u5728\u672a\u5206\u914d\u7684\u6570\u636e\uff0c\u8bf7\u5206\u914d\u540e\u518d\u8bd5\u3002", (String)"MfgFeeAuxProdAllocService_18", (String)"macc-cad-business", (Object[])new Object[0]);
                    return string;
                }
                ids.add(row.getLong("id"));
                String publicaux = row.getString("publicaux");
                if (!"true".equals(publicaux)) continue;
                manuOrgs.add(row.getLong("manuorg"));
            }
            if (manuOrgs.size() > 0) {
                try {
                    logger.info("\u786e\u8ba4\u65f6\u9700\u8981\u64cd\u4f5c\u5f15\u5165\u7684\u751f\u4ea7\u7ec4\u7ec7\uff1a{}", manuOrgs);
                    MfgFeeAllocImportParam importParam = new MfgFeeAllocImportParam();
                    importParam.setEntityType(importDto.getEntityType());
                    importParam.setOrg(importDto.getOrg());
                    importParam.setEnableFactory(importDto.isEnableFactory());
                    importParam.setCostaccount(importDto.getCostaccount());
                    importParam.setPeriod(importDto.getPeriod());
                    importParam.setManuorg(new ArrayList(manuOrgs));
                    importParam.setAppnum(importDto.getAppnum());
                    importParam.setPlanscheme(importDto.getPlanscheme());
                    if (importDto.isEnableFactory()) {
                        importParam.setCostCenterIds(OrgHelper.getCenterIdsByManuOrgIds((Long)importDto.getOrg(), (List)importParam.getManuorg(), (String)"sca"));
                    }
                    int i = this.feeAllocCommonAuxProdImport(importParam);
                    logger.info("\u786e\u8ba4\u64cd\u4f5c\u65f6\u751f\u6210\u7684\u5355\u636e\u6570\uff1a{}", (Object)i);
                }
                catch (Exception ex) {
                    logger.info("\u786e\u8ba4\u65f6\u64cd\u4f5c\u5f15\u5165\u51fa\u9519\uff1a" + ex.getMessage());
                    String string = String.format(ResManager.loadKDString((String)"\u516c\u5171\u8f85\u52a9\u751f\u4ea7\u5206\u914d\u5355\u751f\u6210\u4e0b\u6e38\u5355\u51fa\u9519\uff1a%s\u3002", (String)"MfgFeeAuxProdAllocService_30", (String)"macc-cad-business", (Object[])new Object[0]), ex.getMessage());
                    if (auxDs != null) {
                        if (var3_3 != null) {
                            try {
                                auxDs.close();
                            }
                            catch (Throwable throwable) {
                                var3_3.addSuppressed(throwable);
                            }
                        } else {
                            auxDs.close();
                        }
                    }
                    return string;
                }
            }
            this.updateAllocStatusBill(ids, importDto.getEntityType(), ScaAllocEnum.ALLOCSTATUS_CONFIRM.getValue());
            String string = null;
            return string;
        }
    }

    public List<String> doSelectUnConfirm(List<Long> ids, String appNum, String entityType) {
        String errMsg;
        DynamicObjectCollection cols = this.getAuxProdBill(ids, entityType);
        ArrayList<String> errorMsgs = new ArrayList<String>();
        List<DynamicObject> dynCols = this.validateCommon(cols, errorMsgs, entityType, appNum);
        ArrayList<DynamicObject> commonVerifyObj = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> pubVerifyObj = new ArrayList<DynamicObject>();
        if (dynCols.size() > 0) {
            for (DynamicObject dynObj : dynCols) {
                if (!ScaAllocEnum.ALLOCSTATUS_CONFIRM.getValue().equals(dynObj.getString("allocstatus"))) {
                    String tips = ResManager.loadKDString((String)"\u53cd\u786e\u8ba4\u5931\u8d25\uff0c\u53ea\u6709\u5206\u914d\u72b6\u6001\u4e3a\u201c\u5df2\u786e\u8ba4\u201d\uff0c\u624d\u5141\u8bb8\u8fdb\u884c\u53cd\u786e\u8ba4\u3002", (String)"MfgFeeAuxProdAllocService_23", (String)"macc-cad-business", (Object[])new Object[0]);
                    errorMsgs.add(String.format("%s:%s", dynObj.getString("billno"), tips));
                    continue;
                }
                if ("true".equals(dynObj.getString("publicaux"))) {
                    pubVerifyObj.add(dynObj);
                    continue;
                }
                commonVerifyObj.add(dynObj);
            }
        }
        if (!StringUtils.isEmpty((CharSequence)(errMsg = this.doUnConfirm(commonVerifyObj, false, entityType)))) {
            errorMsgs.add(errMsg);
        }
        ArrayList<DynamicObject> verifyObjs = new ArrayList<DynamicObject>();
        for (DynamicObject dynObj : pubVerifyObj) {
            List<MfgFeeAllocImportParam> params = this.getAllocImportDtos(dynObj, entityType);
            if (params == null || params.size() <= 0) continue;
            if (this.existsAuxProdAllocBill(params.get(0), false, ScaAllocEnum.ALLOCSTATUS_CONFIRM.getValue()).booleanValue()) {
                String tips = ResManager.loadKDString((String)"\u53cd\u786e\u8ba4\u5931\u8d25\uff0c\u4e0b\u6e38\u8f85\u52a9\u5206\u914d\u5355\u5df2\u7ecf\u786e\u8ba4\uff0c\u4e0d\u5141\u8bb8\u53cd\u786e\u8ba4\u3002", (String)"MfgFeeAuxProdAllocService_24", (String)"macc-cad-business", (Object[])new Object[0]);
                errorMsgs.add(String.format("%s:%s", dynObj.getString("billno"), tips));
                continue;
            }
            verifyObjs.add(dynObj);
        }
        errMsg = this.doUnConfirm(verifyObjs, true, entityType);
        if (!StringUtils.isEmpty((CharSequence)errMsg)) {
            errorMsgs.add(errMsg);
        }
        return errorMsgs;
    }

    private String doUnConfirm(List<DynamicObject> verifyObj, boolean isPubAux, String entityType) {
        if (!verifyObj.isEmpty()) {
            List<MfgFeeAllocImportParam> importDtos = this.getAllocImportDtos(verifyObj, entityType);
            for (MfgFeeAllocImportParam importDto : importDtos) {
                if (!"cad_planauxprodalloc".equals(entityType)) {
                    if (this.isBillGenVounums(importDto, importDto.getEntityType())) {
                        String tips = ResManager.loadKDString((String)"\u5206\u914d\u5355\u5df2\u7ecf\u751f\u6210\u4e86\u51ed\u8bc1\uff0c\u4e0d\u5141\u8bb8\u53cd\u786e\u8ba4\uff0c\u8bf7\u5220\u9664\u51ed\u8bc1\u540e\u518d\u64cd\u4f5c\u3002", (String)"MfgFeeAuxProdAllocService_25", (String)"macc-cad-business", (Object[])new Object[0]);
                        return tips;
                    }
                    if (this.isBillGenVounums(importDto, "cad_basicalloc") || this.isBillGenVounums(importDto, "cad_mfgfeeallocco")) {
                        String tips = ResManager.loadKDString((String)"\u4e0b\u6e38\u5206\u914d\u5355\u5df2\u7ecf\u751f\u6210\u4e86\u51ed\u8bc1\uff0c\u4e0d\u5141\u8bb8\u53cd\u786e\u8ba4\uff0c\u8bf7\u5220\u9664\u51ed\u8bc1\u540e\u518d\u64cd\u4f5c\u3002", (String)"MfgFeeAuxProdAllocService_26", (String)"macc-cad-business", (Object[])new Object[0]);
                        return tips;
                    }
                }
                this.doUnConfirm(importDto, isPubAux);
            }
        }
        return null;
    }

    private void doUnConfirm(MfgFeeAllocImportParam importDto, boolean isPubAux) {
        if (isPubAux) {
            this.deleteAuxProdAndRelaBills(importDto, true, false);
        } else {
            this.deleteAuxProdAndRelaBills(importDto, false);
        }
        HashSet<Long> ids = new HashSet<Long>(16);
        QFilter filter = this.getImportParamFilter(importDto, "costcenter");
        filter.and("publicaux", "=", (Object)isPubAux);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)(ALGO_KEY_CLASS_NAME + ".getEntityBillIds()"), (String)importDto.getEntityType(), (String)"id", (QFilter[])new QFilter[]{filter}, null);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                ids.add(row.getLong(0));
            }
        }
        this.updateAllocStatusBill(ids, importDto.getEntityType(), ScaAllocEnum.ALLOCSTATUS_ALLOC.getValue());
    }

    public List<MfgFeeAllocImportParam> getAllocImportDtos(DynamicObject billEntity, String entityType) {
        ArrayList<DynamicObject> billEntitys = new ArrayList<DynamicObject>();
        billEntitys.add(billEntity);
        return this.getAllocImportDtos(billEntitys, entityType);
    }

    public List<MfgFeeAllocImportParam> getAllocImportDtos(List<DynamicObject> billEntitys, String entityType) {
        HashMap<String, MfgFeeAllocImportParam> dtpMap = new HashMap<String, MfgFeeAllocImportParam>(16);
        for (DynamicObject dyn : billEntitys) {
            Long orgId = dyn.getLong("org");
            Long costaccountId = dyn.getLong("costaccount");
            Long planschemeId = dyn.getLong("planscheme");
            Long periodId = dyn.getLong("period");
            String key = String.format("%s@%s@%s@%s", orgId, costaccountId, periodId, planschemeId);
            MfgFeeAllocImportParam dto = dtpMap.computeIfAbsent(key, t -> new MfgFeeAllocImportParam());
            dto.setEntityType(entityType);
            dto.setOrg(orgId);
            dto.setCostaccount(costaccountId);
            dto.setPeriod(periodId);
            dto.setPlanscheme(planschemeId);
            if (dto.getManuorg() == null) {
                dto.setManuorg(new ArrayList());
            }
            Long manuorg = dyn.getLong("manuorg");
            if (!dto.getManuorg().contains(manuorg)) {
                dto.getManuorg().add(manuorg);
            }
            dto.setEnableFactory(true);
            dto.setAppnum(dyn.getString("appnum"));
        }
        ArrayList<MfgFeeAllocImportParam> importDtos = new ArrayList<MfgFeeAllocImportParam>(dtpMap.values());
        for (MfgFeeAllocImportParam dto : importDtos) {
            boolean enableMulFactory = OrgHelper.isOrgEnableMultiFactory((Long)dto.getOrg());
            dto.setEnableFactory(enableMulFactory);
            if (!enableMulFactory) continue;
            dto.setCostCenterIds(OrgHelper.getCenterIdsByManuOrgIds((Long)dto.getOrg(), (List)dto.getManuorg(), (String)"sca"));
        }
        return importDtos;
    }

    private DataSet getAuxProdBenefBill(MfgFeeAllocImportParam importDto) {
        QFilter filter = this.getImportParamFilter(importDto, "costcenter");
        filter.and("allocstatus", "=", (Object)"2");
        return QueryServiceHelper.queryDataSet((String)(ALGO_KEY_CLASS_NAME + ".getNonProdBill()"), (String)importDto.getEntityType(), (String)"comentity.comsubentity.subcostcenter benefcostcenter,comentity.comsubentity.subcostcenter.orgduty orgduty", (QFilter[])new QFilter[]{filter}, null);
    }

    public DynamicObjectCollection getAuxProdBill(List<Long> ids, String entityType) {
        QFilter filter = new QFilter("id", "in", ids);
        String absorbSelectFields = "id,billno,org,costaccount,manuorg,period,allocstatus,publicaux,appnum,planscheme";
        DynamicObjectCollection sourceBills = QueryServiceHelper.query((String)entityType, (String)absorbSelectFields, (QFilter[])filter.toArray(), (String)"period asc");
        return sourceBills;
    }

    public DataSet getAuxProdAllocBill(MfgFeeAllocImportParam importDto) {
        QFilter filter = this.getImportParamFilter(importDto, "costcenter");
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)(ALGO_KEY_CLASS_NAME + ".getAuxProdAllocBill()"), (String)importDto.getEntityType(), (String)"id,billno,org,costaccount,manuorg,period,allocstatus,publicaux,appnum,planscheme", (QFilter[])new QFilter[]{filter}, null);
        return dataSet;
    }

    public Boolean existsAuxProdAllocBill(MfgFeeAllocImportParam importDto, Boolean isPubAux, String allocStatus) {
        QFilter filter = this.getImportParamFilter(importDto, "costcenter");
        if (isPubAux != null) {
            filter.and("publicaux", "=", (Object)isPubAux);
        }
        if (!StringUtils.isEmpty((CharSequence)allocStatus)) {
            filter.and("allocstatus", "=", (Object)allocStatus);
        }
        return QueryServiceHelper.exists((String)"cad_auxprodalloc", (QFilter[])new QFilter[]{filter});
    }

    public Set<Long> getAuxBillIds(MfgFeeAllocImportParam importDto, Boolean isPubAux) {
        HashSet<Long> ids = new HashSet<Long>(16);
        QFilter filter = this.getImportParamFilter(importDto, "costcenter");
        if (isPubAux != null) {
            filter.and("publicaux", "=", (Object)isPubAux);
        }
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)(ALGO_KEY_CLASS_NAME + ".getAuxBillIds()"), (String)importDto.getEntityType(), (String)"id", (QFilter[])new QFilter[]{filter}, null);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                ids.add(row.getLong(0));
            }
        }
        return ids;
    }
}

