/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.business.feealloc;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.macc.cad.algox.mfgfee.alloc.BasicProdAlloc;
import kd.macc.cad.algox.mfgfee.importer.MfgFeeImportAlgoxService;
import kd.macc.cad.algox.utils.CadEmptyUtils;
import kd.macc.cad.business.feealloc.MfgFeeAllocBase;
import kd.macc.cad.common.dto.MfgFeeAllocImportParam;
import kd.macc.cad.common.enums.MfgFeeAllocTypeEnum;
import kd.macc.cad.common.enums.ScaAllocEnum;
import kd.macc.cad.common.helper.SimpleMutexHelper;
import kd.macc.cad.common.output.ExecuteResult;
import kd.macc.cad.common.output.MfgAllocResult;
import org.apache.commons.lang.StringUtils;

public class MfgFeeBasicAllocService
extends MfgFeeAllocBase {
    private static final String ALGO_KEY_CLASS_NAME = MfgFeeBasicAllocService.class.getCanonicalName();
    private static final Log logger = LogFactory.getLog(MfgFeeBasicAllocService.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecuteResult doImport(MfgFeeAllocImportParam importParam, String progressId, String periodName, int index) {
        ExecuteResult result = new ExecuteResult();
        try {
            int totalSize = 7;
            if (!importParam.isActMfg()) {
                totalSize = importParam.getCalcPeriodMap().size() * 7;
            }
            int current = (index - 1) * 7;
            MfgFeeBasicAllocService.refreshProgress(String.format(ResManager.loadKDString((String)"%s\u57fa\u672c\u751f\u4ea7\u5206\u914d\u5f15\u5165\u5f00\u59cb", (String)"MfgFeeBasicAllocService_22", (String)"macc-cad-business", (Object[])new Object[0]), periodName), current + 1, totalSize, false, progressId);
            HashSet<String> errorInfo = new HashSet<String>(16);
            String error = this.validateAllocStand(importParam, errorInfo);
            if (!CadEmptyUtils.isEmpty(errorInfo)) {
                result = new ExecuteResult();
                result.setSuccess(false);
                StringBuilder msgBuilder = new StringBuilder();
                for (String str : errorInfo) {
                    if (msgBuilder.length() > 0) {
                        msgBuilder.append("\\r\\n");
                    }
                    msgBuilder.append(str);
                }
                result.setErrorInfo(errorInfo);
                result.getFalseInfo().put("Error", msgBuilder.toString());
            } else if (StringUtils.isNotBlank((String)error)) {
                result = new ExecuteResult();
                result.setSuccess(false);
                result.getFalseInfo().put("Error", error);
            } else {
                result = this.pooBillAndNonProdAndAuxImport(importParam, progressId, periodName, index);
            }
            result.setPeriodName(periodName);
        }
        finally {
            if (index == importParam.getCalcPeriodMap().size()) {
                MfgFeeBasicAllocService.refreshProgress(ResManager.loadKDString((String)"\u57fa\u672c\u751f\u4ea7\u5206\u914d\u5bfc\u5165\u5b8c\u6210\u3002", (String)"MfgFeeBasicAllocService_17", (String)"macc-cad-business", (Object[])new Object[0]), -1, 0, false, progressId);
            }
        }
        return result;
    }

    public ExecuteResult pooBillAndNonProdAndAuxImport(MfgFeeAllocImportParam importParam, String progressId) {
        return this.pooBillAndNonProdAndAuxImport(importParam, progressId, "", 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecuteResult pooBillAndNonProdAndAuxImport(MfgFeeAllocImportParam importParam, String progressId, String periodName, int currentIndex) {
        int totalSize = 7;
        if (!importParam.isActMfg()) {
            totalSize = importParam.getCalcPeriodMap().size() * 7;
        }
        int current = (currentIndex - 1) * 7;
        MfgFeeBasicAllocService.refreshProgress(String.format(ResManager.loadKDString((String)"%s\u57fa\u672c\u751f\u4ea7\u5206\u914d\u5f15\u5165\u5f00\u59cb", (String)"MfgFeeBasicAllocService_22", (String)"macc-cad-business", (Object[])new Object[0]), periodName), current + 1, totalSize, false, progressId);
        logger.info("\u57fa\u672c\u751f\u4ea7\u5206\u914d-\u5f15\u5165\u5355\u636e\uff1a{}", (Object)importParam);
        ExecuteResult result = new ExecuteResult();
        try {
            HashSet<String> errorInfo = new HashSet<String>(16);
            HashMap<String, String> comboNameMap = new HashMap<String, String>(4);
            MainEntityType mfgFeeBillEntityType = EntityMetadataCache.getDataEntityType((String)"cad_mfgfeebill");
            MainEntityType nonProdEntityType = EntityMetadataCache.getDataEntityType((String)"cad_nonprodalloc");
            MainEntityType basicEntityType = EntityMetadataCache.getDataEntityType((String)"cad_basicalloc");
            this.buildAllocDim(importParam);
            StringBuilder tipSb = new StringBuilder();
            for (String allocDim : importParam.getAllocDimSet()) {
                String errorTip;
                String allocDimShowName = this.getComboName(comboNameMap, allocDim);
                if (SYS_ALLOC_DIM.contains(allocDim)) continue;
                if (mfgFeeBillEntityType.findProperty(allocDim) == null) {
                    errorTip = String.format(ResManager.loadKDString((String)"\u5236\u9020\u8d39\u7528\u5f52\u96c6\u5355\u636e\u672a\u589e\u52a0\u6807\u8bc6\u4e3a%1$s\u7684%2$s\u7ef4\u5ea6\u5b57\u6bb5\uff0c\u6210\u672c\u4e2d\u5fc3\u95f4\u8d39\u7528\u5206\u914d\u6807\u51c6\u5206\u914d\u7ef4\u5ea6\u4e0d\u5141\u8bb8\u8bbe\u7f6e%3$s\u7ef4\u5ea6\u3002", (String)"MfgFeeBasicAllocService_32", (String)"macc-cad-business", (Object[])new Object[0]), allocDim, allocDimShowName, allocDimShowName);
                    errorInfo.add(errorTip);
                    tipSb.append(errorTip);
                }
                if (nonProdEntityType.findProperty(allocDim) == null) {
                    errorTip = String.format(ResManager.loadKDString((String)"\u975e\u751f\u4ea7\u5206\u914d\u5355\u636e\u672a\u589e\u52a0\u6807\u8bc6\u4e3a%1$s\u7684%2$s\u7ef4\u5ea6\u5b57\u6bb5\uff0c\u6210\u672c\u4e2d\u5fc3\u95f4\u8d39\u7528\u5206\u914d\u6807\u51c6\u5206\u914d\u7ef4\u5ea6\u4e0d\u5141\u8bb8\u8bbe\u7f6e%3$s\u7ef4\u5ea6\u3002", (String)"MfgFeeBasicAllocService_33", (String)"macc-cad-business", (Object[])new Object[0]), allocDim, allocDimShowName, allocDimShowName);
                    errorInfo.add(errorTip);
                    tipSb.append(errorTip);
                }
                if (basicEntityType.findProperty(allocDim) != null) continue;
                errorTip = String.format(ResManager.loadKDString((String)"\u57fa\u672c\u751f\u4ea7\u5206\u914d\u5355\u636e\u672a\u589e\u52a0\u6807\u8bc6\u4e3a%1$s\u7684%2$s\u7ef4\u5ea6\u5b57\u6bb5\uff0c\u6210\u672c\u4e2d\u5fc3\u95f4\u8d39\u7528\u5206\u914d\u6807\u51c6\u5206\u914d\u7ef4\u5ea6\u4e0d\u5141\u8bb8\u8bbe\u7f6e%3$s\u7ef4\u5ea6\u3002", (String)"MfgFeeBasicAllocService_34", (String)"macc-cad-business", (Object[])new Object[0]), allocDim, allocDimShowName, allocDimShowName);
                errorInfo.add(errorTip);
                tipSb.append(errorTip);
            }
            if (!CadEmptyUtils.isEmpty(errorInfo)) {
                result.setErrorInfo(errorInfo);
                result.setErrorNotification(tipSb.toString());
                ExecuteResult executeResult = result;
                return executeResult;
            }
            MfgFeeBasicAllocService.refreshProgress(String.format(ResManager.loadKDString((String)"%s\u5236\u9020\u8d39\u7528\u5f52\u96c6\u5355\u53ca\u975e\u751f\u4ea7\u5206\u914d\u5355\u5f15\u5165", (String)"MfgFeeBasicAllocService_23", (String)"macc-cad-business", (Object[])new Object[0]), periodName), current + 3, totalSize, false, progressId);
            Integer nonAndPoolingCount = this.nonProdAndPoolingBillImport(importParam);
            MfgFeeBasicAllocService.refreshProgress(String.format(ResManager.loadKDString((String)"%s\u8f85\u52a9\u751f\u4ea7\u5206\u914d\u5355\u5f15\u5165", (String)"MfgFeeBasicAllocService_24", (String)"macc-cad-business", (Object[])new Object[0]), periodName), current + 5, totalSize, false, progressId);
            Integer auxCount = this.auxProdBillImport(importParam);
            Integer totalCount = nonAndPoolingCount + auxCount;
            if (totalCount.equals(0)) {
                ExecuteResult executeResult = result;
                return executeResult;
            }
            result.setSuccessQty(totalCount.intValue());
        }
        catch (Exception e) {
            result.setErrorNotification(String.format(ResManager.loadKDString((String)"\u5f15\u5165\u5931\u8d25\u3002%s", (String)"MfgFeeBasicAllocService_21", (String)"macc-cad-business", (Object[])new Object[0]), e.getMessage()));
            logger.error("\u57fa\u672c\u751f\u4ea7\u5206\u914d-\u5f15\u5165\u5355\u636e\u5931\u8d25", (Throwable)e);
        }
        finally {
            if (importParam.isActMfg()) {
                SimpleMutexHelper.releaseXMutex((String)"basicImport", (Object)(importParam.getCostaccount() + "basicImport"));
            }
            if (currentIndex * 7 == totalSize) {
                MfgFeeBasicAllocService.refreshProgress(ResManager.loadKDString((String)"\u57fa\u672c\u751f\u4ea7\u5206\u914d\u5bfc\u5165\u5b8c\u6210\u3002", (String)"MfgFeeBasicAllocService_17", (String)"macc-cad-business", (Object[])new Object[0]), -1, 0, false, progressId);
            }
        }
        return result;
    }

    private Integer nonProdAndPoolingBillImport(MfgFeeAllocImportParam importParam) {
        DataSet resultDataSet;
        HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
        paramMap.put("appNum", importParam.getAppnum());
        paramMap.put("entitytype", importParam.getEntityType());
        paramMap.put("planscheme", importParam.getPlanscheme());
        DataSet basicBillResult = this.getMfgCollocBills(importParam, MfgFeeAllocTypeEnum.BASIXPROD);
        DataSet nonProdBillResult = this.getNonProdBills(importParam, MfgFeeAllocTypeEnum.BASIXPROD);
        paramMap.put("allocDim", importParam.getAllocDimSet());
        MfgFeeImportAlgoxService service = new MfgFeeImportAlgoxService();
        int count = 0;
        if (!basicBillResult.isEmpty() && !(resultDataSet = this.filterBilByAllocStandard(basicBillResult = this.replaceManuOrgFromDs(basicBillResult, importParam, "costcenter"), importParam)).isEmpty()) {
            paramMap.put("sourceType", "B");
            count = service.basProdFroNonProAndPooImp(resultDataSet, paramMap);
        }
        if (!nonProdBillResult.isEmpty()) {
            nonProdBillResult = this.replaceManuOrgFromDs(nonProdBillResult, importParam, "costcenter");
            nonProdBillResult.print(true);
            resultDataSet = this.filterBilByAllocStandard(nonProdBillResult, importParam);
            if (!resultDataSet.isEmpty()) {
                paramMap.put("sourceType", "C");
                count += service.basProdFroNonProAndPooImp(resultDataSet, paramMap);
            }
        }
        return count;
    }

    private Integer auxProdBillImport(MfgFeeAllocImportParam importParam) {
        DataSet comprehensiveDataSet = this.getBasProFroAuxBill(importParam, "A");
        if (comprehensiveDataSet.isEmpty()) {
            return 0;
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
        paramMap.put("entitytype", importParam.getEntityType());
        paramMap.put("appNum", importParam.getAppnum());
        paramMap.put("planscheme", importParam.getPlanscheme());
        DataSet parallelDataSet = this.getBasProFroAuxBill(importParam, "B");
        comprehensiveDataSet = this.replaceManuOrgFromDs(comprehensiveDataSet, importParam, "benefcostcenter");
        DataSet comprehensiveResultDataSet = this.filterAuxBillByAllStand(comprehensiveDataSet, importParam);
        if (comprehensiveResultDataSet.isEmpty()) {
            return 0;
        }
        parallelDataSet = this.replaceManuOrgFromDs(parallelDataSet, importParam, "benefcostcenter");
        DataSet copy = comprehensiveResultDataSet.copy();
        while (copy.hasNext()) {
            Row next = copy.next();
            String value = next.getString("expenseitem") + "@" + next.getString("costdriver") + "@" + next.getString("baseunit");
            paramMap.put(next.getString("id") + next.getString("benefcostcenter"), value);
        }
        DataSet parallelResultDataSet = this.filterCarryForWardTypeB(parallelDataSet, comprehensiveResultDataSet);
        DataSet resultDataSet = parallelResultDataSet.union(comprehensiveResultDataSet);
        paramMap.put("appNum", importParam.getAppnum());
        return new MfgFeeImportAlgoxService().basicProFroAuxProImp(resultDataSet, paramMap);
    }

    private DataSet filterCarryForWardTypeB(DataSet parallelDataSet, DataSet comprehensiveResultDataSet) {
        HashSet<Long> orgSet = new HashSet<Long>();
        HashSet<Long> costAccountSet = new HashSet<Long>();
        HashSet<Long> manuOrgSet = new HashSet<Long>();
        HashSet<Long> periodSet = new HashSet<Long>();
        HashSet<Long> costCenterSet = new HashSet<Long>();
        for (Row row : comprehensiveResultDataSet.copy()) {
            orgSet.add(row.getLong("org"));
            costAccountSet.add(row.getLong("costaccount"));
            manuOrgSet.add(row.getLong("manuorg"));
            periodSet.add(row.getLong("period"));
            costCenterSet.add(row.getLong("benefcostcenter"));
        }
        String filter = "org in(" + StringUtils.join(orgSet, (String)",") + ") and costaccount in(" + StringUtils.join(costAccountSet, (String)",") + ") and manuorg in (" + StringUtils.join(manuOrgSet, (String)",") + ") and period in (" + StringUtils.join(periodSet, (String)",") + " ) and benefcostcenter in(" + StringUtils.join(costCenterSet, (String)",") + ")";
        return parallelDataSet.filter(filter).select(new String[]{"id", "billno", "org", "costaccount", "manuorg", "period", "allocmold", "allocmethod", "costcenter", "currency", "amtprecision", "comsubentryid", "benefcostcenter", "amount", "type", "expenseitem", "costdriver", "baseunit"});
    }

    private DataSet filterAuxBillByAllStand(DataSet dataSet, MfgFeeAllocImportParam importParam) {
        DataSet basicAllocStandard = this.getBasicAllocStand(importParam);
        if (!"cad_planbasicalloc".equals(importParam.getEntityType())) {
            DataSet hasProductDs = this.getHasInputCostenterDs(importParam.getOrg(), importParam.getPeriod(), importParam.getAppnum());
            DataSet hasWipCompleteDs = this.getHasWipCompleteCenter(importParam.getOrg(), importParam.getPeriod(), importParam.getAppnum());
            basicAllocStandard = basicAllocStandard.leftJoin(hasProductDs).on("costcenter", "costcenter").select(basicAllocStandard.getRowMeta().getFieldNames(), new String[]{"id as countId"}).finish();
            basicAllocStandard = basicAllocStandard.leftJoin(hasWipCompleteDs).on("costcenter", "costcenter").select(basicAllocStandard.getRowMeta().getFieldNames(), new String[]{"completeqty"}).finish();
            DataSet noExeConditionDs = basicAllocStandard.filter("execondition == '' or execondition is null");
            DataSet hasExeConditionDs = basicAllocStandard.filter("(execondition =='NO_WORK' and countId is null) or (execondition =='NO_COM' and completeqty is null)");
            basicAllocStandard = noExeConditionDs.union(hasExeConditionDs);
        }
        DataSet finish = dataSet.join(basicAllocStandard).on("org", "org").on("manuorg", "manuorg").on("benefcostcenter", "costcenter").on("expenseitem", "expenseitem").select(new String[]{"id", "billno", "org", "costaccount", "manuorg", "period", "allocmold", "allocmethod", "costcenter", "currency", "amtprecision", "comsubentryid", "benefcostcenter", "amount", "type"}, new String[]{"expenseitem", "costdriver", "unit baseunit"}).finish();
        basicAllocStandard.close();
        return finish;
    }

    public DataSet getBasicAllocStd(MfgFeeAllocImportParam importParam) {
        DataSet basicAllocStandard = this.getBasicAllocStand(importParam);
        if (!"cad_planbasicalloc".equals(importParam.getEntityType())) {
            DataSet hasProductDs = this.getHasInputCostenterDs(importParam.getOrg(), importParam.getPeriod(), importParam.getAppnum());
            DataSet hasWipCompleteDs = this.getHasWipCompleteCenter(importParam.getOrg(), importParam.getPeriod(), importParam.getAppnum());
            basicAllocStandard = basicAllocStandard.leftJoin(hasProductDs).on("costcenter", "costcenter").select(basicAllocStandard.getRowMeta().getFieldNames(), new String[]{"id as countId"}).finish();
            basicAllocStandard = basicAllocStandard.leftJoin(hasWipCompleteDs).on("costcenter", "costcenter").select(basicAllocStandard.getRowMeta().getFieldNames(), new String[]{"completeqty"}).finish();
            DataSet noExeConditionDs = basicAllocStandard.filter("execondition == '' or execondition is null");
            DataSet hasExeConditionDs = basicAllocStandard.filter("(execondition =='NO_WORK' and countId is null) or (execondition =='NO_COM' and completeqty is null)");
            basicAllocStandard = noExeConditionDs.union(hasExeConditionDs);
        }
        return basicAllocStandard;
    }

    private DataSet filterBilByAllocStandard(DataSet dataSet, MfgFeeAllocImportParam importParam) {
        ArrayList fieldLists = Lists.newArrayList((Object[])new String[]{"id", "billno", "org", "costaccount", "manuorg", "period", "costcenter", "expenseitem", "totalamount", "currency", "amtprecision", "type", "productgroup"});
        fieldLists.addAll(importParam.getAllocDimSet());
        DataSet basicAllocStandard = this.getBasicAllocStd(importParam);
        DataSet finish = dataSet.join(basicAllocStandard).on("org", "org").on("manuorg", "manuorg").on("costcenter", "costcenter").on("expenseitem", "expenseitem").select(fieldLists.toArray(new String[0]), new String[]{"expenseitem expenseitemstd", "costdriver", "isrelatedwork", "allocdim"}).finish();
        basicAllocStandard.close();
        return finish;
    }

    public DataSet getBasicAllocStand(MfgFeeAllocImportParam importParam) {
        String algoKey = ALGO_KEY_CLASS_NAME + ".getBasicAllocStand()";
        QFilter filter = new QFilter("org", "=", (Object)importParam.getOrg());
        filter.and("appnum", "=", (Object)importParam.getAppnum());
        filter.and("allocmold", "=", (Object)"C");
        filter.and("billstatus", "=", (Object)"C");
        QFilter orgFilter = new QFilter("org", "=", (Object)importParam.getOrg());
        String selectFields = "org,manuorg,costcenter,noproduction,allocmold,expenseitem,costdriver,isrelatedwork,unit,costdriverstatus,costdriverenable,execondition,allocdim";
        DataSet allocStdDs = QueryServiceHelper.queryDataSet((String)algoKey, (String)"sca_mfgfeeallocstdnew", (String)"org,manuorg,costcenter,costcentergroup,issender,isexpense,noproduction,allocmold,execondition,entryentity.expenseitem expenseitem,entryentity.subelement subelement,entryentity.costdriver costdriver,entryentity.costdriver.isrelatedwork isrelatedwork,entryentity.costdriver.unit unit,entryentity.costdriver.status costdriverstatus,entryentity.costdriver.enable costdriverenable,allocdim", (QFilter[])new QFilter[]{filter}, null);
        DataSet costCenterExpense = allocStdDs.filter("issender = true and isexpense = true").select(selectFields);
        DataSet costCenterGroupExpense = allocStdDs.filter("issender = false and isexpense = true").select("org,manuorg,costcentergroup,noproduction,allocmold,expenseitem,costdriver,isrelatedwork,unit,allocdim,costdriverstatus,costdriverenable,execondition");
        DataSet costCenterGroup = this.getCostCenterGroupDs(importParam.getOrg(), importParam.getPeriod());
        costCenterGroupExpense = costCenterGroupExpense.leftJoin(costCenterGroup).on("costcentergroup", "id").select(costCenterGroupExpense.getRowMeta().getFieldNames(), new String[]{"costcenter"}).finish();
        costCenterExpense = this.union(costCenterExpense, costCenterGroupExpense).addNullField("flag");
        DataSet costCenterSubElement = allocStdDs.filter("issender = true and isexpense = false").select("org,manuorg,costcenter,noproduction,allocmold,subelement,costdriver,isrelatedwork,unit,allocdim,costdriverstatus,costdriverenable,execondition");
        DataSet costCenterGroupSubElement = allocStdDs.filter("issender = false and isexpense = false").select("org,manuorg,costcentergroup,noproduction,allocmold,subelement,costdriver,isrelatedwork,unit,allocdim,costdriverstatus,costdriverenable,execondition");
        costCenterGroupSubElement = costCenterGroupSubElement.leftJoin(costCenterGroup).on("costcentergroup", "id").select(costCenterGroupSubElement.getRowMeta().getFieldNames(), new String[]{"costcenter"}).finish();
        costCenterSubElement = this.union(costCenterSubElement, costCenterGroupSubElement);
        DataSet subElementDs = QueryServiceHelper.queryDataSet((String)(ALGO_KEY_CLASS_NAME + "#getFeeAndSubElementDs"), (String)"cad_subelementexpense", (String)"element,subelement,expenseitem", (QFilter[])orgFilter.toArray(), null);
        costCenterSubElement = costCenterSubElement.leftJoin(subElementDs).on("subelement", "subelement").select(costCenterSubElement.getRowMeta().getFieldNames(), new String[]{"expenseitem", "1 as flag"}).finish();
        costCenterExpense = this.union(costCenterExpense, costCenterSubElement).distinct();
        return costCenterExpense;
    }

    private DataSet mergeDataSet(DataSet poolingDataSet, DataSet noProdDataSet) {
        if (!poolingDataSet.isEmpty() && !noProdDataSet.isEmpty()) {
            return poolingDataSet.union(noProdDataSet);
        }
        if (!poolingDataSet.isEmpty()) {
            return poolingDataSet;
        }
        return noProdDataSet;
    }

    public void delRelateBills(MfgFeeAllocImportParam importParam, Boolean isUnConfirm) {
        Set<Long> cosIds;
        DataSet dataSet = this.getBasicAllocBillDataSet(importParam);
        HashSet<Long> basicBillIds = new HashSet<Long>(16);
        if (!isUnConfirm.booleanValue()) {
            basicBillIds.addAll(this.getEntityBillIds(importParam, importParam.getEntityType()));
            if (!CollectionUtils.isEmpty(basicBillIds)) {
                logger.info("\u57fa\u672c\u751f\u4ea7\u5206\u914d-\u5220\u9664\u57fa\u672c\u751f\u4ea7\u5355\u636e\u6570\uff1a{}", (Object)basicBillIds.size());
                this.expireMfgFeeBill(basicBillIds, importParam.getEntityType());
                this.asyncDeleteData(basicBillIds, importParam.getEntityType());
            }
        }
        if (importParam.isActMfg() && !dataSet.isEmpty() && (cosIds = this.getEntityBillIds(importParam, "cad_mfgfeeallocco")).size() > 0) {
            logger.info("\u57fa\u672c\u751f\u4ea7\u5206\u914d-\u5220\u9664\u57fa\u672c\u751f\u4ea7\u5355\u636e\u6570\uff1a{}", (Object)cosIds.size());
            this.expireMfgFeeBill(cosIds, "cad_mfgfeeallocco");
            this.asyncDeleteData(cosIds, "cad_mfgfeeallocco");
        }
    }

    private DataSet getBasicAllocBillDataSet(MfgFeeAllocImportParam importParam) {
        QFilter filter = new QFilter("org", "=", (Object)importParam.getOrg());
        filter.and("costaccount", "=", (Object)importParam.getCostaccount());
        filter.and("period", "=", (Object)importParam.getPeriod());
        if (importParam.isEnableFactory()) {
            filter.and("manuorg", "in", (Object)importParam.getManuorg());
        }
        filter.and("allocstatus", "=", (Object)"2");
        String selectFields = "entryentity.entrycostcenter benefcostcenter,comentity.comsubentity.subcostcenter comsubbenefcostcenter,parallelentity.parallelsubentity.parsubcostcenter parsubbenefcostcenter";
        return QueryServiceHelper.queryDataSet((String)(ALGO_KEY_CLASS_NAME + ".getBasicAllocBillDataSet()"), (String)"cad_basicalloc", (String)selectFields, (QFilter[])new QFilter[]{filter}, null);
    }

    public boolean getAuxProdBillIsAllConfirm(MfgFeeAllocImportParam importParam) {
        QFilter filter = this.getImportParamFilter(importParam, "costcenter");
        filter.and("allocstatus", "!=", (Object)"2");
        String auxProdType = this.getMfgEntity(importParam.isActMfg(), "cad_auxprodalloc");
        boolean exists = QueryServiceHelper.exists((String)auxProdType, (QFilter[])filter.toArray());
        return exists;
    }

    public DataSet getBasProFroAuxBill(MfgFeeAllocImportParam importDto, String carryForwardType) {
        String selectFields;
        String algoKey = ALGO_KEY_CLASS_NAME + ".getBasicProdBillsFromAuxProdBill()";
        QFilter filter = new QFilter("org", "=", (Object)importDto.getOrg());
        filter.and("costaccount", "=", (Object)importDto.getCostaccount());
        filter.and("period", "=", (Object)importDto.getPeriod());
        filter.and("planscheme", "=", (Object)importDto.getPlanscheme());
        String auxEntity = this.getMfgEntity(importDto.isActMfg(), "cad_auxprodalloc");
        if (importDto.isEnableFactory()) {
            if (StringUtils.equals((String)"A", (String)carryForwardType)) {
                filter.and("comentity.comsubentity.subcostcenter", "in", (Object)importDto.getCostCenterIds());
            } else {
                filter.and("parallelentity.parallelsubentity.parsubcostcenter", "in", (Object)importDto.getCostCenterIds());
            }
        }
        filter.and("allocstatus", "=", (Object)ScaAllocEnum.ALLOCSTATUS_CONFIRM.getValue());
        if (StringUtils.equals((String)"A", (String)carryForwardType)) {
            filter.and("comentity.comsubentity.subcostcenter.orgduty", "=", (Object)4L);
            selectFields = "id,billno,org,costaccount,manuorg,period,allocmold,allocmethod,costcenter,currency,currency.amtprecision amtprecision,comentity.comsubentity.id comsubentryid,comentity.comsubentity.subcostcenter benefcostcenter,comentity.comsubentity.subexpenseitem expenseitem,comentity.comsubentity.subcostdriver costdriver,comentity.comsubentity.subbaseunit baseunit,case when allocmethod ='mutual' or allocmethod='algebra' then comentity.comsubentity.suboutamt else comentity.comsubentity.subamt end amount, 'comprehensive' type";
        } else {
            filter.and("parallelentity.parallelsubentity.parsubcostcenter.orgduty", "=", (Object)4L);
            selectFields = "id,billno,org,costaccount,manuorg,period,allocmold,allocmethod,costcenter,currency,currency.amtprecision amtprecision,parallelentity.parallelsubentity.comsubentryid comsubentryid,parallelentity.parallelsubentity.parsubcostcenter benefcostcenter,parallelentity.parallelsubentity.parsubexpenseitem expenseitem,parallelentity.parallelsubentity.parsubcostdriver costdriver,parallelentity.parallelsubentity.parsubbaseunit baseunit,case when allocmethod ='mutual' or allocmethod='algebra' then parallelentity.parallelsubentity.parsuboutamt else parallelentity.parallelsubentity.parsubamt end amount,'parallel' type";
        }
        return QueryServiceHelper.queryDataSet((String)algoKey, (String)auxEntity, (String)selectFields, (QFilter[])filter.toArray(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MfgAllocResult doUnConfirmByPlanPeriod(Map<Long, List<Long>> periodIdMap, String appnum, String progressId, boolean planData) {
        String entityType = planData ? "cad_planbasicalloc" : "cad_basicalloc";
        MfgAllocResult allocResult = new MfgAllocResult();
        try {
            int size = periodIdMap.size();
            int currindex = 0;
            for (Map.Entry<Long, List<Long>> entry : periodIdMap.entrySet()) {
                MfgFeeBasicAllocService.refreshProgress(String.format(ResManager.loadKDString((String)"%s\u57fa\u672c\u751f\u4ea7\u5206\u914d\u5355\u53cd\u786e\u8ba4\u5f00\u59cb", (String)"MfgFeeBasicAllocService_30", (String)"macc-cad-business", (Object[])new Object[0]), this.getPeriodName(entry.getKey())), currindex, size, false, progressId);
                List splitLists = Lists.partition(entry.getValue(), (int)200);
                for (List list : splitLists) {
                    OperationResult result = OperationServiceHelper.executeOperate((String)"op_unconfirm", (String)entityType, (Object[])list.toArray(), (OperateOption)OperateOption.create());
                    if (result.isSuccess()) continue;
                    if (allocResult.getVerifyMsgs() == null) {
                        allocResult.setVerifyMsgs(new ArrayList(10));
                    }
                    for (IOperateInfo errInfo : result.getAllErrorOrValidateInfo()) {
                        allocResult.getVerifyMsgs().add(errInfo.getMessage());
                    }
                }
            }
        }
        catch (Exception ex) {
            logger.error("\u57fa\u672c\u751f\u4ea7\u5206\u914d\u53cd\u786e\u8ba4\u5931\u8d25-0", (Throwable)ex);
            if (allocResult.getVerifyMsgs() == null) {
                allocResult.setVerifyMsgs(new ArrayList(10));
            }
            allocResult.getVerifyMsgs().add(ex.getMessage());
        }
        finally {
            MfgFeeBasicAllocService.refreshProgress(ResManager.loadKDString((String)"\u57fa\u672c\u751f\u4ea7\u5206\u914d\u5355\u53cd\u786e\u8ba4\u5b8c\u6210", (String)"MfgFeeBasicAllocService_26", (String)"macc-cad-business", (Object[])new Object[0]), -1, 0, false, progressId);
        }
        return allocResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MfgAllocResult doConfirmByPlanPeriod(Map<Long, List<Long>> periodIdMap, String appnum, String progressId, boolean planData) {
        String entityType = planData ? "cad_planbasicalloc" : "cad_basicalloc";
        MfgAllocResult allocResult = new MfgAllocResult();
        try {
            int size = periodIdMap.size();
            int currindex = 0;
            for (Map.Entry<Long, List<Long>> entry : periodIdMap.entrySet()) {
                MfgFeeBasicAllocService.refreshProgress(String.format(ResManager.loadKDString((String)"%s\u57fa\u672c\u751f\u4ea7\u5206\u914d\u5355\u786e\u8ba4\u5f00\u59cb", (String)"MfgFeeBasicAllocService_31", (String)"macc-cad-business", (Object[])new Object[0]), this.getPeriodName(entry.getKey())), currindex, size, false, progressId);
                List splitLists = Lists.partition(entry.getValue(), (int)200);
                for (List list : splitLists) {
                    OperationResult result = OperationServiceHelper.executeOperate((String)"op_confirm", (String)entityType, (Object[])list.toArray(), (OperateOption)OperateOption.create());
                    if (result.isSuccess()) continue;
                    if (allocResult.getVerifyMsgs() == null) {
                        allocResult.setVerifyMsgs(new ArrayList(10));
                    }
                    for (IOperateInfo errInfo : result.getAllErrorOrValidateInfo()) {
                        allocResult.getVerifyMsgs().add(errInfo.getMessage());
                    }
                }
            }
        }
        catch (Exception ex) {
            logger.error("\u57fa\u672c\u751f\u4ea7\u5206\u914d\u786e\u8ba4\u5931\u8d25-0", (Throwable)ex);
            if (allocResult.getVerifyMsgs() == null) {
                allocResult.setVerifyMsgs(new ArrayList(10));
            }
            allocResult.getVerifyMsgs().add(ex.getMessage());
        }
        finally {
            MfgFeeBasicAllocService.refreshProgress(ResManager.loadKDString((String)"\u57fa\u672c\u751f\u4ea7\u5206\u914d\u5355\u786e\u8ba4\u5b8c\u6210", (String)"MfgFeeBasicAllocService_28", (String)"macc-cad-business", (Object[])new Object[0]), -1, 0, false, progressId);
        }
        return allocResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MfgAllocResult doAllocByPlanPeriod(List<Long> ids, String appnum, String progressId, boolean planData, Long planschemeId) {
        String entityType = planData ? "cad_planbasicalloc" : "cad_basicalloc";
        DynamicObjectCollection cols = this.getBasicBillByIds(ids, entityType);
        LinkedHashMap<String, List> periodBillIdsMap = new LinkedHashMap<String, List>();
        for (DynamicObject dyn : cols) {
            periodBillIdsMap.computeIfAbsent(dyn.getString("periodname"), t -> new ArrayList(10)).add(dyn.getLong("id"));
        }
        MfgAllocResult allocResult = new MfgAllocResult();
        try {
            int size = periodBillIdsMap.size();
            int currindex = 0;
            for (Map.Entry entry : periodBillIdsMap.entrySet()) {
                MfgFeeBasicAllocService.refreshProgress(String.format(ResManager.loadKDString((String)"%s\u57fa\u672c\u751f\u4ea7\u5206\u914d\u5f00\u59cb", (String)"MfgFeeBasicAllocService_29", (String)"macc-cad-business", (Object[])new Object[0]), entry.getKey()), currindex, size, false, progressId);
                MfgAllocResult result = this.doAlloc((List)entry.getValue(), appnum, null, planData, planschemeId);
                allocResult.setAllocStatus(this.dealAllocStatus(result.getAllocStatus(), allocResult.getAllocStatus()));
                if (result.getVerifyMsgs() == null) continue;
                if (allocResult.getVerifyMsgs() == null) {
                    allocResult.setVerifyMsgs(result.getVerifyMsgs());
                    continue;
                }
                allocResult.getVerifyMsgs().addAll(result.getVerifyMsgs());
            }
        }
        catch (Exception ex) {
            logger.error("\u57fa\u672c\u751f\u4ea7\u5206\u914d\u5931\u8d25-0", (Throwable)ex);
            if (allocResult.getVerifyMsgs() == null) {
                allocResult.setVerifyMsgs(new ArrayList(10));
            }
            allocResult.getVerifyMsgs().add(ex.getMessage());
        }
        finally {
            MfgFeeBasicAllocService.refreshProgress(ResManager.loadKDString((String)"\u57fa\u672c\u751f\u4ea7\u5206\u914d\u5b8c\u6210", (String)"MfgFeeBasicAllocService_20", (String)"macc-cad-business", (Object[])new Object[0]), -1, 0, false, progressId);
        }
        return allocResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MfgAllocResult doAlloc(List<Long> ids, String appId, String progressId, boolean planData, Long planschemeId) {
        MfgFeeBasicAllocService.refreshProgress(ResManager.loadKDString((String)"\u57fa\u672c\u751f\u4ea7\u5206\u914d\u5f00\u59cb", (String)"MfgFeeBasicAllocService_18", (String)"macc-cad-business", (Object[])new Object[0]), 1, 3, false, progressId);
        MfgAllocResult allocResult = new MfgAllocResult();
        long costAccountId = 0L;
        try {
            String entityType = planData ? "cad_planbasicalloc" : "cad_basicalloc";
            DynamicObjectCollection cols = this.getBasicBillByIds(ids, entityType);
            ArrayList<String> errorMsg = new ArrayList<String>();
            List<DynamicObject> dynCols = this.validateCommon(cols, errorMsg, entityType, appId);
            if (dynCols.size() > 0) {
                ArrayList<Long> allocIds = new ArrayList<Long>(dynCols.size());
                for (DynamicObject dynObj : dynCols) {
                    if (costAccountId == 0L) {
                        costAccountId = dynObj.getLong("costaccount");
                    }
                    if (ScaAllocEnum.ALLOCSTATUS_CONFIRM.getValue().equals(dynObj.getString("allocstatus"))) {
                        String tips = ResManager.loadKDString((String)"\u5355\u636e\u5df2\u5206\u914d\uff0c\u4e0d\u80fd\u518d\u5206\u914d\u3002", (String)"MfgFeeBasicAllocService_2", (String)"macc-cad-business", (Object[])new Object[0]);
                        errorMsg.add(String.format("%s:%s", dynObj.getString("billno"), tips));
                        continue;
                    }
                    allocIds.add(dynObj.getLong("id"));
                }
                if (allocIds.size() > 0) {
                    try {
                        MfgFeeBasicAllocService.refreshProgress(ResManager.loadKDString((String)"\u83b7\u53d6\u5206\u914d\u6807\u51c6\u5206\u914d\u4e2d\uff0c\u8bf7\u7a0d\u5019\u3002", (String)"MfgFeeBasicAllocService_19", (String)"macc-cad-business", (Object[])new Object[0]), 2, 3, false, progressId);
                        allocResult.setAllocStatus(new BasicProdAlloc().doBasicAlloc(allocIds, appId, planData, planschemeId));
                    }
                    catch (Exception ex) {
                        logger.error("\u8c03\u7528\u57fa\u672c\u751f\u4ea7\u5206\u914d\u5931\u8d25\uff1a" + ex.getMessage(), (Throwable)ex);
                        String tips = ResManager.loadKDString((String)"\u5206\u914d\u5931\u8d25\u3002", (String)"MfgFeeBasicAllocService_4", (String)"macc-cad-business", (Object[])new Object[0]);
                        errorMsg.add(tips + ex.getMessage());
                    }
                }
            }
            allocResult.setVerifyMsgs(errorMsg);
        }
        catch (Exception e) {
            logger.error("\u57fa\u672c\u751f\u4ea7\u5206\u914d\u5931\u8d25", (Throwable)e);
        }
        finally {
            SimpleMutexHelper.releaseXMutex((String)"basicAlloc", (Object)(costAccountId + "basicAlloc"));
            MfgFeeBasicAllocService.refreshProgress(ResManager.loadKDString((String)"\u57fa\u672c\u751f\u4ea7\u5206\u914d\u5b8c\u6210", (String)"MfgFeeBasicAllocService_20", (String)"macc-cad-business", (Object[])new Object[0]), -1, 0, false, progressId);
        }
        return allocResult;
    }

    private DynamicObjectCollection getBasicBillByIds(List<Long> ids, String entityType) {
        QFilter filter = new QFilter("id", "in", ids);
        String absorbSelectFields = "id,billno,org,costaccount,manuorg,period,allocstatus,planscheme";
        if (this.isPlanMfg(entityType)) {
            absorbSelectFields = absorbSelectFields + ",period.name periodname";
        }
        return QueryServiceHelper.query((String)entityType, (String)absorbSelectFields, (QFilter[])filter.toArray());
    }

    private String getIdWithSplitStr(Collection<Long> ids) {
        StringBuilder sb = new StringBuilder();
        for (Long id : ids) {
            sb.append(id).append(",");
        }
        return sb.toString().substring(0, sb.length() - 1);
    }

    public String costCenterMatchStd(DataSet ds, MfgFeeAllocImportParam importParam, String type, Set<String> errorInfo) {
        DataSet stdCostcenterDs = this.getBasicAllocStand(importParam);
        HashSet<Long> costcenterIds = new HashSet<Long>();
        DataSet dsCopyDs = ds.copy();
        while (dsCopyDs.hasNext()) {
            if (StringUtils.equals((String)"A", (String)type)) {
                costcenterIds.add(dsCopyDs.next().getLong("benefcostcenter"));
                continue;
            }
            costcenterIds.add(dsCopyDs.next().getLong("costcenter"));
        }
        HashSet<Long> setStdCostcenterIds = new HashSet<Long>();
        DataSet stdCostcenterCopyDs = stdCostcenterDs.copy();
        while (stdCostcenterCopyDs.hasNext()) {
            Long costcneterId = stdCostcenterCopyDs.next().getLong("costcenter");
            if (!costcenterIds.contains(costcneterId)) continue;
            setStdCostcenterIds.add(costcneterId);
        }
        if (!setStdCostcenterIds.isEmpty()) {
            DataSet hasStdDs;
            String ids = this.getIdWithSplitStr(setStdCostcenterIds);
            if (StringUtils.equals((String)"A", (String)type)) {
                hasStdDs = ds.copy().filter(String.format("benefcostcenter in(%s)", ids));
                hasStdDs = hasStdDs.leftJoin(stdCostcenterDs).on("org", "org").on("manuorg", "manuorg").on("benefcostcenter", "costcenter").on("expenseitem", "expenseitem").select(new String[]{"id", "billno", "org", "costaccount", "manuorg", "period", "benefcostcenter as costcenter", "expenseitem", "currency", "amtprecision", "type"}, new String[]{"expenseitem expenseitemstd", "costdriver", "costdriverstatus", "costdriverenable", "isrelatedwork", "unit"}).finish();
            } else {
                hasStdDs = ds.copy().filter(String.format("costcenter in(%s)", ids));
                hasStdDs = hasStdDs.leftJoin(stdCostcenterDs).on("org", "org").on("manuorg", "manuorg").on("costcenter", "costcenter").on("expenseitem", "expenseitem").select(new String[]{"id", "billno", "org", "costaccount", "manuorg", "period", "costcenter", "expenseitem", "currency", "amtprecision", "type"}, new String[]{"expenseitem expenseitemstd", "costdriver", "costdriverstatus", "costdriverenable", "isrelatedwork", "unit"}).finish();
            }
            DataSet costDriverNullDs = hasStdDs.copy().filter("costdriver is null");
            if (!costDriverNullDs.isEmpty()) {
                String tips;
                DataSet costDriverNullFlagDs = costDriverNullDs.leftJoin(stdCostcenterDs).on("org", "org").on("manuorg", "manuorg").on("costcenter", "costcenter").select(new String[]{"id", "billno", "org", "costaccount", "manuorg", "period", "costcenter", "expenseitem"}, new String[]{"flag"}).finish();
                DataSet subElementDriverNullDs = costDriverNullFlagDs.filter("flag == 1");
                DataSet expenseDriverNullDs = costDriverNullFlagDs.filter("flag != 1");
                String errorMsg = "";
                if (!subElementDriverNullDs.isEmpty()) {
                    tips = ResManager.loadKDString((String)"\u201c%1$s\u201d\u4e0b%2$s\u672a\u7ef4\u62a4\u5206\u914d\u6807\u51c6\uff0c\u8bf7\u68c0\u67e5\u6210\u672c\u4e2d\u5fc3\u95f4\u5206\u914d\u6807\u51c6\u3002", (String)"MfgFeeBasicAllocService_11", (String)"macc-cad-business", (Object[])new Object[0]);
                    errorMsg = this.getCostcenterFeeTip(subElementDriverNullDs, tips, errorInfo);
                }
                if (!expenseDriverNullDs.isEmpty()) {
                    tips = ResManager.loadKDString((String)"\u201c%1$s\u201d\u4e0b%2$s\u672a\u7ef4\u62a4\u5206\u914d\u6807\u51c6\uff0c\u8bf7\u68c0\u67e5\u6210\u672c\u4e2d\u5fc3\u95f4\u5206\u914d\u6807\u51c6\u3002", (String)"MfgFeeBasicAllocService_11", (String)"macc-cad-business", (Object[])new Object[0]);
                    String expenseMsg = this.getCostcenterFeeTip(expenseDriverNullDs, tips, errorInfo);
                    errorMsg = StringUtils.isNotBlank((String)errorMsg) ? errorMsg + "\n" + expenseMsg : expenseMsg;
                }
                return errorMsg;
            }
        }
        return "";
    }

    /*
     * WARNING - void declaration
     */
    public String checkCosCenterAndExpenseItemStand(DataSet dataSet, MfgFeeAllocImportParam importParam, String type) {
        HashMap centerExpenMap = new HashMap();
        while (dataSet.hasNext()) {
            void var6_6;
            Row row = dataSet.next();
            if (StringUtils.equals((String)"A", (String)type)) {
                Long l = row.getLong("benefcostcenter");
            } else {
                Long l = row.getLong("costcenter");
            }
            Long l = row.getLong("expenseitem");
            if (CollectionUtils.isEmpty((Collection)((Collection)centerExpenMap.get(var6_6)))) {
                HashSet<Long> expenseItemList = new HashSet<Long>();
                expenseItemList.add(l);
                centerExpenMap.put(var6_6, expenseItemList);
                continue;
            }
            ((Set)centerExpenMap.get(var6_6)).add(l);
        }
        for (Map.Entry entry : centerExpenMap.entrySet()) {
            Set set = (Set)entry.getValue();
            QFilter filter = new QFilter("org", "=", (Object)importParam.getOrg());
            filter.and("allocmold", "=", (Object)"C");
            filter.and("billstatus", "=", (Object)"C");
            filter.and("costcenter", "=", entry.getKey());
            filter.and("appnum", "=", (Object)importParam.getAppnum());
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"sca_mfgfeeallocstdnew", (String)"costcenter,allocmold,entryentity.expenseitem expenseitem", (QFilter[])filter.toArray(), null);
            for (DynamicObject dynamicObject : dynamicObjects) {
                set.add(dynamicObject.getLong("expenseitem"));
            }
        }
        HashMap notExistCosAndExpMap = new HashMap();
        for (Map.Entry entry : centerExpenMap.entrySet()) {
            Set expenseItems = (Set)entry.getValue();
            Long costCenter = (Long)entry.getKey();
            ArrayList<Long> existExp = new ArrayList<Long>();
            if (expenseItems.size() > 1) {
                QFilter filter = new QFilter("org", "=", (Object)importParam.getOrg());
                filter.and("allocmold", "=", (Object)"C");
                filter.and("billstatus", "=", (Object)"C");
                filter.and("costcenter", "=", (Object)costCenter);
                filter.and("entryentity.expenseitem", "in", (Object)expenseItems);
                filter.and("appnum", "=", (Object)importParam.getAppnum());
                DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"sca_mfgfeeallocstdnew", (String)"costcenter,allocmold,entryentity.expenseitem expenseitem", (QFilter[])filter.toArray(), null);
                if (dynamicObjects != null && dynamicObjects.size() > 0 && dynamicObjects.size() < expenseItems.size()) {
                    for (DynamicObject dynamicObject : dynamicObjects) {
                        existExp.add(dynamicObject.getLong("expenseitem"));
                    }
                }
            }
            if (CollectionUtils.isEmpty(existExp)) continue;
            for (Long expenseItem : expenseItems) {
                if (existExp.contains(expenseItem)) continue;
                List list = (List)notExistCosAndExpMap.get(costCenter);
                if (CollectionUtils.isEmpty((Collection)list)) {
                    ArrayList<Long> expenseItemList = new ArrayList<Long>();
                    expenseItemList.add(expenseItem);
                    notExistCosAndExpMap.put(costCenter, expenseItemList);
                    continue;
                }
                list.add(expenseItem);
            }
        }
        if (!CollectionUtils.isEmpty(notExistCosAndExpMap)) {
            StringBuilder stringBuilder = new StringBuilder();
            for (Map.Entry entry : notExistCosAndExpMap.entrySet()) {
                List expenseItemList = (List)entry.getValue();
                QFilter cosCenterFilter = new QFilter("id", "=", entry.getKey());
                QFilter expenseItemFilter = new QFilter("id", "in", (Object)expenseItemList);
                DynamicObject costCenter = QueryServiceHelper.queryOne((String)"bos_costcenter", (String)"number,name", (QFilter[])cosCenterFilter.toArray());
                DynamicObjectCollection expenseItems = QueryServiceHelper.query((String)"er_expenseitemedit", (String)"number,name", (QFilter[])expenseItemFilter.toArray(), null);
                String centerName = costCenter.getString("name");
                stringBuilder.append("\u3010").append(centerName).append("\u3011").append(ResManager.loadKDString((String)"\u4e0b", (String)"MfgFeeBasicAllocService_7", (String)"macc-cad-business", (Object[])new Object[0]));
                for (DynamicObject expenseItem : expenseItems) {
                    String expNumber = expenseItem.getString("number");
                    String expName = expenseItem.getString("name");
                    stringBuilder.append("\u3010").append(expNumber).append("/").append(expName).append("\u3011");
                }
                stringBuilder.append("\r\n");
            }
            return stringBuilder.toString();
        }
        return "";
    }

    public String validateAllocStand(MfgFeeAllocImportParam importDto, Set<String> errorInfo) {
        DataSet nonCostDriverNotEnableDs;
        DataSet auxCostDriverNotEnableDs;
        DataSet union;
        DataSet isMulStandDs = this.getMulStandOnCostCenter(importDto.getAppnum(), importDto.getOrg(), MfgFeeAllocTypeEnum.BASIXPROD.getValue(), "sca_mfgfeeallocstdnew", importDto.getPeriod());
        if (!isMulStandDs.isEmpty()) {
            String tips = ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u201c%1$s/%2$s\u201d\u7ef4\u62a4\u4e86\u591a\u4e2a\u5206\u914d\u6807\u51c6\u3002", (String)"MfgFeeBasicAllocService_12", (String)"macc-cad-business", (Object[])new Object[0]);
            StringBuilder sb = new StringBuilder();
            HashSet<Long> costCenterIds = new HashSet<Long>(16);
            for (Row row : isMulStandDs) {
                costCenterIds.add(row.getLong("costcenter"));
            }
            QFilter filter = new QFilter("id", "in", costCenterIds);
            try (DataSet costcenterDs = QueryServiceHelper.queryDataSet((String)(ALGO_KEY_CLASS_NAME + ".getCostCenterDs()"), (String)"bos_costcenter", (String)"id,number,name", (QFilter[])filter.toArray(), null);){
                for (Row row : costcenterDs) {
                    String errorMsg = String.format(tips, row.getString("number"), row.getString("name"));
                    errorInfo.add(errorMsg);
                    sb.append(errorMsg).append("\r\n");
                }
            }
            return sb.toString();
        }
        DataSet basicAllocStandard = this.getBasicAllocStand(importDto);
        DataSet hasProductDs = this.getHasInputCostenterDs(importDto.getOrg(), importDto.getPeriod(), importDto.getAppnum());
        DataSet hasWipCompleteDs = this.getHasWipCompleteCenter(importDto.getOrg(), importDto.getPeriod(), importDto.getAppnum());
        basicAllocStandard = basicAllocStandard.leftJoin(hasProductDs).on("costcenter", "costcenter").select(basicAllocStandard.getRowMeta().getFieldNames(), new String[]{"id as countId"}).finish();
        basicAllocStandard = basicAllocStandard.leftJoin(hasWipCompleteDs).on("costcenter", "costcenter").select(basicAllocStandard.getRowMeta().getFieldNames(), new String[]{"completeqty"}).finish();
        DataSet noExeConditionDs = basicAllocStandard.filter("execondition == '' or execondition is null");
        DataSet hasExeConditionDs = basicAllocStandard.filter("(execondition =='NO_WORK' and countId is null) or (execondition =='NO_COM' and completeqty is null)");
        basicAllocStandard = noExeConditionDs.union(hasExeConditionDs);
        DataSet auxDataSet = this.getBasProFroAuxBill(importDto, "A");
        auxDataSet = this.replaceManuOrgFromDs(auxDataSet, importDto, "benefcostcenter");
        DataSet costAuxEnable = auxDataSet.copy().join(basicAllocStandard).on("org", "org").on("benefcostcenter", "costcenter").on("expenseitem", "expenseitem").on("manuorg", "manuorg").select(auxDataSet.getRowMeta().getFieldNames(), new String[]{"costdriverstatus", "costdriverenable"}).finish();
        DataSet auxFinish = auxDataSet.join(basicAllocStandard).on("org", "org").on("benefcostcenter", "costcenter").on("manuorg", "manuorg").select(auxDataSet.getRowMeta().getFieldNames(), new String[]{"costdriverstatus", "costdriverenable"}).finish();
        String auxResult = this.costCenterMatchStd(auxFinish, importDto, "A", errorInfo);
        DataSet basicBillResult = this.getMfgCollocBills(importDto, MfgFeeAllocTypeEnum.BASIXPROD);
        DataSet nonProdBillResult = this.getNonProdBills(importDto, MfgFeeAllocTypeEnum.BASIXPROD);
        if (basicBillResult.isEmpty() && nonProdBillResult.isEmpty()) {
            return auxResult;
        }
        DataSet dataSet = this.mergeDataSet(basicBillResult, nonProdBillResult);
        dataSet = this.replaceManuOrgFromDs(dataSet, importDto, "costcenter");
        DataSet costNonEnable = dataSet.copy().join(basicAllocStandard).on("org", "org").on("costcenter", "costcenter").on("expenseitem", "expenseitem").on("manuorg", "manuorg").select(dataSet.getRowMeta().getFieldNames(), new String[]{"costdriverstatus", "costdriverenable", "costdriver"}).finish();
        DataSet nonFinish = dataSet.join(basicAllocStandard).on("org", "org").on("costcenter", "costcenter").on("manuorg", "manuorg").select(dataSet.getRowMeta().getFieldNames(), new String[]{"costdriverstatus", "costdriverenable", "costdriver"}).finish();
        String nonAndColResult = this.costCenterMatchStd(nonFinish, importDto, "B", errorInfo);
        if (StringUtils.isNotBlank((String)nonAndColResult)) {
            auxResult = auxResult + nonAndColResult;
        }
        if (StringUtils.isBlank((String)auxResult) && !(union = (auxCostDriverNotEnableDs = costAuxEnable.filter("costdriverenable = '0' or costdriverstatus in('A','B')").select("costdriverenable,costdriverstatus,benefcostcenter costcenter,expenseitem,costdriver")).union(nonCostDriverNotEnableDs = costNonEnable.filter("costdriverenable = '0' or costdriverstatus in('A','B')").select("costdriverenable,costdriverstatus,costcenter,expenseitem,costdriver"))).isEmpty()) {
            return this.getCostcenterFeeTip(union, ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u201c%1$s\u201d\u4e0b%2$s\u9700\u8981\u91cd\u65b0\u7ef4\u62a4\u5bf9\u5e94\u7684\u5206\u914d\u6807\u51c6\u3002", (String)"MfgFeeBasicAllocService_13", (String)"macc-cad-business", (Object[])new Object[0]), errorInfo);
        }
        return auxResult;
    }

    public DataSet getBasicProdBillByDs(List<Long> ids, String entityType) {
        QFilter filter = new QFilter("id", "in", ids);
        String absorbSelectFields = "id,billno,org,costaccount,manuorg,period,allocstatus,planscheme";
        if (this.isPlanMfg(entityType)) {
            absorbSelectFields = absorbSelectFields + ",period.name periodname";
        }
        return QueryServiceHelper.queryDataSet((String)"getNonProdBillByDs", (String)entityType, (String)absorbSelectFields, (QFilter[])filter.toArray(), (String)"period asc");
    }
}

