/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.business.feealloc;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.macc.cad.algox.constants.AllocResultEnum;
import kd.macc.cad.algox.mfgfee.alloc.InnerAlloc;
import kd.macc.cad.algox.mfgfee.importer.MfgFeeImportAlgoxService;
import kd.macc.cad.business.feealloc.MfgFeeAllocBase;
import kd.macc.cad.common.dto.MfgFeeAllocImportParam;
import kd.macc.cad.common.enums.MfgFeeAllocTypeEnum;
import kd.macc.cad.common.enums.ScaAllocEnum;
import kd.macc.cad.common.helper.SimpleMutexHelper;
import kd.macc.cad.common.output.ExecuteResult;
import kd.macc.cad.common.output.MfgAllocResult;
import kd.macc.cad.common.utils.CadBgParamUtils;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.DataSetUtils;

public class MfgFeeInnerCostcenterAllocService
extends MfgFeeAllocBase {
    private static final String ALGO_KEY_CLASS_NAME = MfgFeeInnerCostcenterAllocService.class.getCanonicalName();
    private static final Log logger = LogFactory.getLog(MfgFeeInnerCostcenterAllocService.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecuteResult feeAllocInnerCostcenterImport(MfgFeeAllocImportParam importDto, String progressId) {
        MfgFeeInnerCostcenterAllocService.refreshProgress(ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3\u5185\u5206\u914d\u5bfc\u5165\u5f00\u59cb\u3002", (String)"MfgFeeInnerCostcenterAllocService_22", (String)"macc-cad-business", (Object[])new Object[0]), 1, 11, false, progressId);
        logger.info("\u6210\u672c\u4e2d\u5fc3\u5185\u5206\u914d-\u5f15\u5165\u5355\u636e\uff1a{}", (Object)importDto);
        ExecuteResult result = new ExecuteResult();
        try {
            String allocDimShowName;
            DataSet ds = null;
            HashSet<String> errorInfo = new HashSet<String>(16);
            long time = System.currentTimeMillis();
            MfgFeeInnerCostcenterAllocService.refreshProgress(ResManager.loadKDString((String)"\u83b7\u53d6\u5236\u9020\u8d39\u7528\u5f52\u96c6\u5355\u3001\u975e\u751f\u4ea7\u5206\u914d\u3001\u8f85\u52a9\u751f\u4ea7\u5206\u914d\u5355\u6570\u636e", (String)"MfgFeeInnerCostcenterAllocService_23", (String)"macc-cad-business", (Object[])new Object[0]), 3, 11, false, progressId);
            this.buildAllocDim(importDto);
            MainEntityType costObjectEntityType = EntityMetadataCache.getDataEntityType((String)"cad_costobject");
            MainEntityType mfgFeeBillEntityType = EntityMetadataCache.getDataEntityType((String)"cad_mfgfeebill");
            MainEntityType nonProdEntityType = EntityMetadataCache.getDataEntityType((String)"cad_nonprodalloc");
            MainEntityType basicEntityType = EntityMetadataCache.getDataEntityType((String)"cad_basicalloc");
            MainEntityType coEntityType = EntityMetadataCache.getDataEntityType((String)"cad_mfgfeeallocco");
            HashMap<String, String> comboNameMap = new HashMap<String, String>(4);
            StringBuilder tipSb = new StringBuilder();
            for (String allocDim : importDto.getAllocDimSet()) {
                String errorTip;
                allocDimShowName = this.getComboName(comboNameMap, allocDim);
                if (SYS_ALLOC_DIM.contains(allocDim)) continue;
                if (costObjectEntityType.findProperty(allocDim) == null) {
                    errorTip = String.format(ResManager.loadKDString((String)"\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u5355\u636e\u672a\u589e\u52a0\u6807\u8bc6\u4e3a%1$s\u7684%2$s\u7ef4\u5ea6\u5b57\u6bb5\uff0c\u6210\u672c\u4e2d\u5fc3\u95f4\u8d39\u7528\u5206\u914d\u6807\u51c6\u5206\u914d\u7ef4\u5ea6\u4e0d\u5141\u8bb8\u8bbe\u7f6e%3$s\u7ef4\u5ea6\u3002", (String)"MfgFeeInnerCostcenterAllocService_33", (String)"macc-cad-business", (Object[])new Object[0]), allocDim, allocDimShowName, allocDimShowName);
                    errorInfo.add(errorTip);
                    tipSb.append(errorTip);
                }
                if (mfgFeeBillEntityType.findProperty(allocDim) == null) {
                    errorTip = String.format(ResManager.loadKDString((String)"\u5236\u9020\u8d39\u7528\u5f52\u96c6\u5355\u636e\u672a\u589e\u52a0\u6807\u8bc6\u4e3a%1$s\u7684%2$s\u7ef4\u5ea6\u5b57\u6bb5\uff0c\u6210\u672c\u4e2d\u5fc3\u95f4\u8d39\u7528\u5206\u914d\u6807\u51c6\u5206\u914d\u7ef4\u5ea6\u4e0d\u5141\u8bb8\u8bbe\u7f6e%3$s\u7ef4\u5ea6\u3002", (String)"MfgFeeInnerCostcenterAllocService_34", (String)"macc-cad-business", (Object[])new Object[0]), allocDim, allocDimShowName, allocDimShowName);
                    errorInfo.add(errorTip);
                    tipSb.append(errorTip);
                }
                if (nonProdEntityType.findProperty(allocDim) == null) {
                    errorTip = String.format(ResManager.loadKDString((String)"\u975e\u751f\u4ea7\u5206\u914d\u5355\u636e\u672a\u589e\u52a0\u6807\u8bc6\u4e3a%1$s\u7684%2$s\u7ef4\u5ea6\u5b57\u6bb5\uff0c\u6210\u672c\u4e2d\u5fc3\u95f4\u8d39\u7528\u5206\u914d\u6807\u51c6\u5206\u914d\u7ef4\u5ea6\u4e0d\u5141\u8bb8\u8bbe\u7f6e%3$s\u7ef4\u5ea6\u3002", (String)"MfgFeeInnerCostcenterAllocService_35", (String)"macc-cad-business", (Object[])new Object[0]), allocDim, allocDimShowName, allocDimShowName);
                    errorInfo.add(errorTip);
                    tipSb.append(errorTip);
                }
                if (basicEntityType.findProperty(allocDim) == null) {
                    errorTip = String.format(ResManager.loadKDString((String)"\u57fa\u672c\u751f\u4ea7\u5206\u914d\u5355\u636e\u672a\u589e\u52a0\u6807\u8bc6\u4e3a%1$s\u7684%2$s\u7ef4\u5ea6\u5b57\u6bb5\uff0c\u6210\u672c\u4e2d\u5fc3\u95f4\u8d39\u7528\u5206\u914d\u6807\u51c6\u5206\u914d\u7ef4\u5ea6\u4e0d\u5141\u8bb8\u8bbe\u7f6e%3$s\u7ef4\u5ea6\u3002", (String)"MfgFeeInnerCostcenterAllocService_36", (String)"macc-cad-business", (Object[])new Object[0]), allocDim, allocDimShowName, allocDimShowName);
                    errorInfo.add(errorTip);
                    tipSb.append(errorTip);
                }
                if (coEntityType.findProperty(allocDim) != null) continue;
                errorTip = String.format(ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3\u5185\u5206\u914d\u5355\u636e\u672a\u589e\u52a0\u6807\u8bc6\u4e3a%1$s\u7684%2$s\u7ef4\u5ea6\u5b57\u6bb5\uff0c\u6210\u672c\u4e2d\u5fc3\u95f4\u8d39\u7528\u5206\u914d\u6807\u51c6\u5206\u914d\u7ef4\u5ea6\u4e0d\u5141\u8bb8\u8bbe\u7f6e%3$s\u7ef4\u5ea6\u3002", (String)"MfgFeeInnerCostcenterAllocService_37", (String)"macc-cad-business", (Object[])new Object[0]), allocDim, allocDimShowName, allocDimShowName);
                errorInfo.add(errorTip);
                tipSb.append(errorTip);
            }
            if (!CadEmptyUtils.isEmpty(errorInfo)) {
                result.setErrorInfo(errorInfo);
                result.setErrorNotification(tipSb.toString());
                ExecuteResult executeResult = result;
                return executeResult;
            }
            DataSet upDs = this.getDsFromUp(importDto);
            MfgFeeInnerCostcenterAllocService.refreshProgress(ResManager.loadKDString((String)"\u83b7\u53d6\u57fa\u672c\u751f\u4ea7\u5206\u914d\u5355\u6570\u636e", (String)"MfgFeeInnerCostcenterAllocService_24", (String)"macc-cad-business", (Object[])new Object[0]), 5, 11, false, progressId);
            DataSet basicDs = this.getDsFromBasic(importDto);
            basicDs = basicDs.addFields(new String[]{"''", "null"}, new String[]{"outsourcetype", "isoutsource"});
            logger.info("\u6210\u672c\u4e2d\u5fc3\u5185\u5206\u914d\u5355\u5f15\u5165\u67e5\u8be2\u6765\u6e90\u7ed3\u679c\u96c6\u8017\u65f6\uff1a{}ms", (Object)(System.currentTimeMillis() - time));
            ds = DataSetUtils.union((DataSet)upDs, (DataSet)basicDs);
            if (ds == null || ds.isEmpty()) {
                allocDimShowName = result;
                return allocDimShowName;
            }
            DataSet isMulStandDs = this.getMulStandOnCostCenter(importDto.getAppnum(), importDto.getOrg(), MfgFeeAllocTypeEnum.BASIXPROD.getValue(), "sca_overheadallotcost", importDto.getPeriod());
            if (!isMulStandDs.isEmpty()) {
                String tips = ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u201c%1$s/%2$s\u201d\u7ef4\u62a4\u4e86\u591a\u4e2a\u5206\u914d\u6807\u51c6\u3002", (String)"MfgFeeInnerCostcenterAllocService_17", (String)"macc-cad-business", (Object[])new Object[0]);
                StringBuilder sb = new StringBuilder();
                HashSet<Long> costCenterIds = new HashSet<Long>(16);
                for (Row row : isMulStandDs) {
                    costCenterIds.add(row.getLong("costcenter"));
                }
                QFilter filter = new QFilter("id", "in", costCenterIds);
                try (DataSet costcenterDs = QueryServiceHelper.queryDataSet((String)(ALGO_KEY_CLASS_NAME + ".getCostCenterDs()"), (String)"bos_costcenter", (String)"id,number,name", (QFilter[])filter.toArray(), null);){
                    for (Row row : costcenterDs) {
                        errorInfo.add(String.format(tips, row.getString("number"), row.getString("name")));
                        sb.append(String.format(tips, row.getString("number"), row.getString("name"))).append("\r\n");
                    }
                }
                result.setErrorInfo(errorInfo);
                result.setErrorNotification(sb.toString());
                costcenterDs = result;
                return costcenterDs;
            }
            MfgFeeInnerCostcenterAllocService.refreshProgress(ResManager.loadKDString((String)"\u5339\u914d\u6210\u672c\u4e2d\u5fc3\u5185\u5206\u914d\u6807\u51c6", (String)"MfgFeeInnerCostcenterAllocService_25", (String)"macc-cad-business", (Object[])new Object[0]), 7, 11, false, progressId);
            DataSet billAndStdDs = this.costcenterMatchStd(ds, importDto);
            DataSet costdriverNullDs = billAndStdDs.copy().filter("costdriver is null and costobject=0");
            if (!costdriverNullDs.isEmpty()) {
                String tips;
                DataSet innerStdDs = this.getMfgAllocInnerStd(importDto.getOrg(), importDto.getAppnum(), importDto.getPeriod());
                DataSet costDriverNullFlagDs = costdriverNullDs.leftJoin(innerStdDs).on("org", "org").on("manuorg", "manuorg").on("costcenter", "costcenter").select(new String[]{"id", "billno", "org", "costaccount", "manuorg", "period", "costcenter", "expenseitem"}, new String[]{"flag"}).finish();
                DataSet subElementDriverNullDs = costDriverNullFlagDs.filter("flag == 1");
                DataSet expenseDriverNullDs = costDriverNullFlagDs.filter("flag != 1");
                StringBuilder errorMsgSb = new StringBuilder();
                String subElementMsg = "";
                String expenseMsg = "";
                if (!subElementDriverNullDs.isEmpty()) {
                    tips = ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u201c%1$s\u201d\u4e0b%2$s\u6ca1\u6709\u5728\u6210\u672c\u5b50\u8981\u7d20\u4e0e\u8d39\u7528\u9879\u76ee\u5173\u7cfb\u8868\u7ef4\u62a4\u5bf9\u5e94\u7684\u6210\u672c\u5b50\u8981\u7d20\u3002", (String)"MfgFeeInnerCostcenterAllocService_18", (String)"macc-cad-business", (Object[])new Object[0]);
                    subElementMsg = this.getCostcenterFeeTip(subElementDriverNullDs, tips, errorInfo);
                }
                if (!expenseDriverNullDs.isEmpty()) {
                    tips = ResManager.loadKDString((String)"\u201c%1$s\u201d\u4e0b\u201c%2$s\u201d\u672a\u7ef4\u62a4\u5206\u914d\u6807\u51c6\uff0c\u8bf7\u68c0\u67e5\u6210\u672c\u4e2d\u5fc3\u5185\u5206\u914d\u6807\u51c6\u3002", (String)"MfgFeeInnerCostcenterAllocService_19", (String)"macc-cad-business", (Object[])new Object[0]);
                    expenseMsg = this.getCostcenterFeeTip(expenseDriverNullDs, tips, errorInfo);
                }
                if (subElementMsg.equals("")) {
                    errorMsgSb.append(expenseMsg);
                } else {
                    errorMsgSb.append(subElementMsg).append("\n").append(expenseMsg);
                }
                result.setErrorInfo(errorInfo);
                result.setErrorNotification(errorMsgSb.toString());
                billAndStdDs.close();
                tips = result;
                return tips;
            }
            DataSet costdriverNotEnableDs = billAndStdDs.copy().filter("costdriverenable = '0' or costdriverstatus in('A','B')");
            if (!costdriverNotEnableDs.isEmpty()) {
                String tips = ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u201c%1$s\u201d\u4e0b%2$s\u9700\u8981\u91cd\u65b0\u7ef4\u62a4\u5bf9\u5e94\u7684\u5206\u914d\u6807\u51c6\u3002", (String)"MfgFeeInnerCostcenterAllocService_20", (String)"macc-cad-business", (Object[])new Object[0]);
                String errorMsg = this.getCostcenterFeeTip(costdriverNotEnableDs, tips, errorInfo);
                result.setErrorInfo(errorInfo);
                result.setErrorNotification(errorMsg);
                billAndStdDs.close();
                ExecuteResult expenseDriverNullDs = result;
                return expenseDriverNullDs;
            }
            DataSet feeSubelementDs = this.getFeeAndSubElementDs(importDto.getOrg(), importDto.getAppnum());
            DataSet elementNullDs = (billAndStdDs = billAndStdDs.leftJoin(feeSubelementDs).on("expenseitem", "expenseitem").select(billAndStdDs.getRowMeta().getFieldNames(), new String[]{"element", "subelement"}).finish()).copy().filter("subelement is null or subelement=0");
            if (!elementNullDs.isEmpty()) {
                String errorMsg = this.getFeeTip(elementNullDs, errorInfo);
                result.setErrorInfo(errorInfo);
                result.setErrorNotification(errorMsg);
                billAndStdDs.close();
                ExecuteResult errorMsgSb = result;
                return errorMsgSb;
            }
            logger.info("\u6210\u672c\u4e2d\u5fc3\u5185\u5206\u914d\u5355\u5f15\u5165\u67e5\u8be2\u7ed3\u679c\u96c6\u8017\u65f6\uff1a{}ms", (Object)(System.currentTimeMillis() - time));
            try {
                int i;
                time = System.currentTimeMillis();
                MfgFeeImportAlgoxService algoxImportService = new MfgFeeImportAlgoxService();
                HashMap<String, Object> paramMap = new HashMap<String, Object>();
                paramMap.put("appnum", importDto.getAppnum());
                Boolean isMergeBill = importDto.isMergeBill();
                paramMap.put("isMergeBill", isMergeBill);
                paramMap.put("allocDim", importDto.getAllocDimSet());
                MfgFeeInnerCostcenterAllocService.refreshProgress(ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3\u5185\u5206\u914d\u5355\u5f15\u5165", (String)"MfgFeeInnerCostcenterAllocService_26", (String)"macc-cad-business", (Object[])new Object[0]), 9, 11, false, progressId);
                if ("eca".equals(importDto.getAppnum()) || !isMergeBill.booleanValue()) {
                    DataSet finalDiffDs = this.compareDiff(billAndStdDs.copy(), importDto);
                    i = algoxImportService.innerCostCenterBillImport(finalDiffDs, paramMap);
                } else {
                    i = algoxImportService.innerCostCenterBillImport(billAndStdDs, paramMap);
                }
                result.setSuccessQty(i);
                logger.info("\u6210\u672c\u4e2d\u5fc3\u5185\u5206\u914d\u5355\u5f15\u5165algox\u5904\u7406\u7ed3\u679c\u96c6\u8017\u65f6\uff1a{}ms", (Object)(System.currentTimeMillis() - time));
            }
            catch (Exception ex) {
                logger.error("\u6210\u672c\u4e2d\u5fc3\u5185\u5f15\u5165\u5931\u8d25\uff1a" + ex.getMessage(), (Throwable)ex);
                result.setErrorNotification(String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff1a%s\u3002", (String)"MfgFeeInnerCostcenterAllocService_21", (String)"macc-cad-business", (Object[])new Object[0]), ex.getMessage()));
            }
        }
        catch (Exception e) {
            logger.error("\u6210\u672c\u4e2d\u5fc3\u5185\u5f15\u5165\u5931\u8d25\uff1a", (Throwable)e);
        }
        finally {
            SimpleMutexHelper.releaseXMutex((String)"coImport", (Object)(importDto.getCostaccount() + "coImport"));
            MfgFeeInnerCostcenterAllocService.refreshProgress(ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3\u5185\u5206\u914d\u5bfc\u5165\u5b8c\u6210\u3002", (String)"MfgFeeInnerCostcenterAllocService_27", (String)"macc-cad-business", (Object[])new Object[0]), -1, 0, false, progressId);
        }
        return result;
    }

    private DataSet compareDiff(DataSet billAndStdDs, MfgFeeAllocImportParam importDto) {
        String[] selectFieldsArr = billAndStdDs.getRowMeta().getFieldNames();
        DataSet mfgFeeAllocBills = this.getCoMfgFeeAllocBills(importDto);
        DataSet leftDs = billAndStdDs.leftJoin(mfgFeeAllocBills).on("id", "sourceid").select(selectFieldsArr, new String[]{"sourceid"}).finish();
        DataSet rightDs = mfgFeeAllocBills.leftJoin(billAndStdDs).on("sourceid", "id").select(mfgFeeAllocBills.getRowMeta().getFieldNames(), new String[]{"id as missid"}).finish();
        DataSet createSourceDs = leftDs.filter("sourceid is null").select(selectFieldsArr);
        String reverseSelectFields = importDto.getAllocDim() + "id as mfgallocid,sourceid as id,org,costaccount,manuorg,period,costcenter,expenseitem,0 - cototalamount as totalamount,currency,srctype as type,costdriver,element,subelement,productgroup";
        DataSet missSourceDs = rightDs.filter("missid is null").select(reverseSelectFields);
        DataSet innerDs = billAndStdDs.join(mfgFeeAllocBills, JoinType.INNER).on("id", "sourceid").select(new String[]{"id as srcid"}, mfgFeeAllocBills.getRowMeta().getFieldNames()).finish();
        DataSet totalMfgFeeAllocBills = mfgFeeAllocBills.groupBy(new String[]{"sourceid", "org", "costaccount", "manuorg", "period", "costcenter", "productgroup", "subelement", "expenseitem"}).sum("cototalamount").finish();
        DataSet sameDimensionDs = billAndStdDs.join(totalMfgFeeAllocBills, JoinType.INNER).on("id", "sourceid").on("org", "org").on("costaccount", "costaccount").on("manuorg", "manuorg").on("period", "period").on("costcenter", "costcenter").on("productgroup", "productgroup").on("subelement", "subelement").on("expenseitem", "expenseitem").select(selectFieldsArr, new String[]{"totalamount - cototalamount as diffamount"}).finish();
        DataSet diffDimensionDs = innerDs.leftJoin(sameDimensionDs).on("srcid", "id").select(innerDs.getRowMeta().getFieldNames(), new String[]{"id as sameid"}).finish();
        diffDimensionDs = diffDimensionDs.filter("sameid is null");
        DataSet reverseDimensionDs = diffDimensionDs.select(reverseSelectFields);
        DataSet newDimenSionDs = billAndStdDs.join(diffDimensionDs, JoinType.INNER).on("id", "sourceid").select(selectFieldsArr).finish();
        String selectFields = importDto.getAllocDim() + "allocdim,id,org,costaccount,manuorg,period,costcenter,expenseitem,diffamount as totalamount,currency,type,productgroup,costobject,material,outsourcetype,isoutsource,costdriver,element,subelement";
        sameDimensionDs = sameDimensionDs.filter("diffamount != 0").select(selectFields).distinct();
        DataSet tempDs = DataSetUtils.union((DataSet)sameDimensionDs, (DataSet)createSourceDs);
        DataSet finalDiffDs = DataSetUtils.union((DataSet)tempDs, (DataSet)newDimenSionDs);
        DataSet reverseDs = missSourceDs.union(reverseDimensionDs).addNullField("allocdim");
        boolean hasDirectAllocData = false;
        DataSet emptyCostDriverDs = reverseDs.copy().filter("costdriver is null or costdriver = 0");
        if (!emptyCostDriverDs.isEmpty()) {
            HashSet<Long> mfgAllocIds = new HashSet<Long>(16);
            while (emptyCostDriverDs.hasNext()) {
                mfgAllocIds.add(emptyCostDriverDs.next().getLong("mfgallocid"));
            }
            if (!CadEmptyUtils.isEmpty(mfgAllocIds)) {
                QFilter qFilter = new QFilter("id", "in", mfgAllocIds);
                DataSet reverseAllocBills = QueryServiceHelper.queryDataSet((String)"getReverseAllocBills", (String)"cad_mfgfeeallocco", (String)"id,entryentity.material material,entryentity.costobject costobject,entryentity.costobject.isoutsource isoutsource,entryentity.outsourcetype outsourcetype", (QFilter[])qFilter.toArray(), null);
                reverseDs = reverseDs.leftJoin(reverseAllocBills).on("mfgallocid", "id").select(emptyCostDriverDs.getRowMeta().getFieldNames(), new String[]{"costobject", "material", "isoutsource", "outsourcetype"}).finish();
                hasDirectAllocData = true;
            }
        }
        if (!hasDirectAllocData) {
            reverseDs = reverseDs.addNullField(new String[]{"costobject", "material", "isoutsource", "outsourcetype"});
        }
        finalDiffDs = DataSetUtils.union((DataSet)finalDiffDs, (DataSet)reverseDs);
        return finalDiffDs;
    }

    private DataSet getFeeAndSubElementDs(Long orgId, String appnum) {
        QFilter filter = new QFilter("org", "=", (Object)orgId);
        filter.and("appnum", "=", (Object)appnum);
        return QueryServiceHelper.queryDataSet((String)(ALGO_KEY_CLASS_NAME + "#getFeeAndSubElementDs"), (String)"cad_subelementexpense", (String)"element,subelement,expenseitem", (QFilter[])filter.toArray(), null);
    }

    public List<Long> getCoEntityBillIds(MfgFeeAllocImportParam importDto, String allocStatus) {
        ArrayList<Long> ids = new ArrayList<Long>();
        QFilter filter = new QFilter("org", "=", (Object)importDto.getOrg());
        filter.and("costaccount", "=", (Object)importDto.getCostaccount());
        filter.and("period", "=", (Object)importDto.getPeriod());
        filter.and("allocstatus", "=", (Object)allocStatus);
        if (importDto.isEnableFactory()) {
            filter.and("manuorg", "in", (Object)importDto.getManuorg());
        }
        filter.and("appnum", "=", (Object)importDto.getAppnum());
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"getCoEntityBillIds", (String)"cad_mfgfeeallocco", (String)"id", (QFilter[])new QFilter[]{filter}, null);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                ids.add(row.getLong(0));
            }
        }
        return ids;
    }

    private DataSet costcenterMatchStd(DataSet ds, MfgFeeAllocImportParam importDto) {
        DataSet stdDs = this.getMfgAllocInnerStd(importDto.getOrg(), importDto.getAppnum(), importDto.getPeriod());
        DataSet stdNotCostcenterDs = stdDs.copy().filter("costcenter=0");
        DataSet stdCostcenterDs = stdDs.filter("costcenter>0");
        HashSet<Long> costcenterIds = new HashSet<Long>(16);
        DataSet dsCopyDs = ds.copy();
        while (dsCopyDs.hasNext()) {
            costcenterIds.add(dsCopyDs.next().getLong("costcenter"));
        }
        HashSet<Long> setStdCostcenterIds = new HashSet<Long>();
        DataSet stdCostcenterCopyDs = stdCostcenterDs.copy();
        while (stdCostcenterCopyDs.hasNext()) {
            Long costcneterId = stdCostcenterCopyDs.next().getLong("costcenter");
            if (!costcenterIds.contains(costcneterId)) continue;
            setStdCostcenterIds.add(costcneterId);
        }
        ArrayList leftFields = Lists.newArrayList((Object[])new String[]{"id", "billno", "org", "costaccount", "manuorg", "period", "costcenter", "expenseitem", "totalamount", "currency", "amtprecision", "type", "productgroup", "costobject", "material", "outsourcetype", "isoutsource"});
        leftFields.addAll(importDto.getAllocDimSet());
        ArrayList rightFields = Lists.newArrayList((Object[])new String[]{"expenseitem expenseitemstd", "costdriver", "costdriverstatus", "costdriverenable", "isrelatedwork", "unit", "allocdim"});
        if (!setStdCostcenterIds.isEmpty()) {
            String ids = this.getIdWithSplitStr(setStdCostcenterIds);
            DataSet hasStdDs = ds.copy().filter(String.format("costcenter in(%s)", ids));
            DataSet notStdDs = ds.filter(String.format("costcenter not in(%s)", ids));
            hasStdDs = hasStdDs.leftJoin(stdCostcenterDs).on("org", "org").on("manuorg", "manuorg").on("costcenter", "costcenter").on("expenseitem", "expenseitem").select(leftFields.toArray(new String[0]), rightFields.toArray(new String[0])).finish();
            if (notStdDs.isEmpty()) {
                return hasStdDs;
            }
            notStdDs = notStdDs.leftJoin(stdNotCostcenterDs).on("org", "org").on("manuorg", "manuorg").on("expenseitem", "expenseitem").select(leftFields.toArray(new String[0]), rightFields.toArray(new String[0])).finish();
            return hasStdDs.union(notStdDs);
        }
        return ds.leftJoin(stdNotCostcenterDs).on("org", "org").on("manuorg", "manuorg").on("expenseitem", "expenseitem").select(leftFields.toArray(new String[0]), rightFields.toArray(new String[0])).finish();
    }

    private String getIdWithSplitStr(Collection<Long> ids) {
        StringBuilder sb = new StringBuilder();
        for (Long id : ids) {
            sb.append(id).append(",");
        }
        return sb.toString().substring(0, sb.length() - 1);
    }

    private DataSet mergeDs(DataSet ds1, DataSet ds2) {
        DataSet ds = null;
        ds = ds1 != null && ds2 != null ? ds1.select(ds2.getRowMeta().getFieldNames()).union(ds2) : (ds1 != null ? ds1 : ds2);
        return ds;
    }

    private String getFeeTip(DataSet costdriverNullDs, Set<String> errorInfo) {
        String tips = ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c%s\u6ca1\u6709\u5728\u6210\u672c\u5b50\u8981\u7d20\u4e0e\u8d39\u7528\u9879\u76ee\u5173\u7cfb\u8868\u7ef4\u62a4\u5bf9\u5e94\u7684\u6210\u672c\u5b50\u8981\u7d20\u3002", (String)"MfgFeeInnerCostcenterAllocService_10", (String)"macc-cad-business", (Object[])new Object[0]);
        StringBuilder sb = new StringBuilder();
        HashSet<Long> expenseitemSet = new HashSet<Long>(16);
        while (costdriverNullDs.hasNext()) {
            Row row = costdriverNullDs.next();
            expenseitemSet.add(row.getLong("expenseitem"));
        }
        Map<Long, String> experMap = this.getFeeMap(expenseitemSet);
        for (Long expenseitem : expenseitemSet) {
            errorInfo.add(String.format(tips, experMap.get(expenseitem)));
            sb.append("\u3010").append(experMap.get(expenseitem)).append("\u3011").append(",");
        }
        return String.format(tips, sb.toString().substring(0, sb.length() - 1));
    }

    private DataSet getMfgCollocBills(MfgFeeAllocImportParam importDto) {
        String algoKey = ALGO_KEY_CLASS_NAME + ".getMfgCollocBills()";
        QFilter filter = this.getImportParamFilter(importDto, "costcenter");
        filter.and("allocmold", "=", (Object)MfgFeeAllocTypeEnum.BASIXPROD.getValue());
        DataSet mfgfeebillList = QueryServiceHelper.queryDataSet((String)algoKey, (String)"cad_mfgfeebill", (String)(importDto.getAllocDim() + "id,billno,org,costaccount,manuorg,period,costcenter,expenseitem,productgroup,totalamount,currency,currency.amtprecision amtprecision,'feebill' type,costobject,costobject.material material,outsourcetype,costobject.isoutsource isoutsource"), (QFilter[])filter.toArray(), null);
        return mfgfeebillList;
    }

    private DataSet getCoMfgFeeAllocBills(MfgFeeAllocImportParam importDto) {
        String algoKey = ALGO_KEY_CLASS_NAME + ".getMfgFeeAllocBills()";
        QFilter filter = this.getImportParamFilter(importDto, "benefcostcenter");
        DataSet mfgFeeAllocBills = QueryServiceHelper.queryDataSet((String)algoKey, (String)"cad_mfgfeeallocco", (String)(importDto.getAllocDim() + "id,org,costaccount,manuorg,period,benefcostcenter as costcenter,element,subelement,srcexpentry.expenseitem as expenseitem,srcexpentry.colamt as cototalamount,case when srcexpentry.srctype = 'A' then 'feebill' when srcexpentry.srctype = 'B' then 'nonprod' when srcexpentry.srctype = 'C' then 'aux' when srcexpentry.srctype = 'D' then 'basic' else 'noaux' end as srctype,srcexpentry.expbillid as sourceid,currency,costdriver,productgroup"), (QFilter[])filter.toArray(), null);
        return mfgFeeAllocBills;
    }

    private DataSet getDsFromUp(MfgFeeAllocImportParam importDto) {
        DataSet ds = this.getMfgCollocBills(importDto);
        DataSet nonDs = this.getNonProdBills(importDto, MfgFeeAllocTypeEnum.BASIXPROD);
        nonDs = nonDs.addFields(new String[]{"''", "null"}, new String[]{"outsourcetype", "isoutsource"});
        ds = this.unionDs(ds, nonDs);
        DataSet auxComDs = this.getAuxComProdBill(importDto);
        auxComDs = auxComDs.addFields(new String[]{"''", "null"}, new String[]{"outsourcetype", "isoutsource"});
        ds = DataSetUtils.unionIfRowDiff((DataSet)ds, (DataSet)auxComDs);
        ds = this.replaceManuOrgFromDs(ds, importDto, "costcenter");
        DataSet basicBillAndStdDs = null;
        if (ds != null) {
            DataSet stdDs = this.getMfgAllocStd(importDto.getOrg(), MfgFeeAllocTypeEnum.BASIXPROD.getValue(), importDto.getAppnum(), importDto.getPeriod());
            stdDs = stdDs.groupBy(new String[]{"org", "manuorg", "costcenter", "execondition"}).finish();
            DataSet hasProductDs = this.getHasInputCostenterDs(importDto.getOrg(), importDto.getPeriod(), importDto.getAppnum());
            DataSet hasWipCompleteDs = this.getHasWipCompleteCenter(importDto.getOrg(), importDto.getPeriod(), importDto.getAppnum());
            stdDs = stdDs.leftJoin(hasProductDs).on("costcenter", "costcenter").select(stdDs.getRowMeta().getFieldNames(), new String[]{"id as countId"}).finish();
            stdDs = stdDs.leftJoin(hasWipCompleteDs).on("costcenter", "costcenter").select(stdDs.getRowMeta().getFieldNames(), new String[]{"completeqty"}).finish();
            DataSet noExeConditionDs = stdDs.filter("execondition == '' or execondition is null");
            DataSet hasExeConditionDs = stdDs.filter("(execondition =='NO_WORK' and countId is null) or (execondition =='NO_COM' and completeqty is null)");
            stdDs = noExeConditionDs.union(hasExeConditionDs);
            ArrayList selectFields = Lists.newArrayList((Object[])new String[]{"id", "billno", "org", "costaccount", "manuorg", "period", "costcenter", "expenseitem", "totalamount", "currency", "amtprecision", "type", "productgroup", "costobject", "material", "outsourcetype", "isoutsource"});
            selectFields.addAll(importDto.getAllocDimSet());
            basicBillAndStdDs = ds.leftJoin(stdDs).on("org", "org").on("manuorg", "manuorg").on("costcenter", "costcenter").select(selectFields.toArray(new String[0]), new String[]{"costcenter costcenterstd"}).finish().filter("costcenterstd is null or costobject > 0").select(selectFields.toArray(new String[0]));
            return basicBillAndStdDs;
        }
        return ds;
    }

    private DataSet getDsFromBasic(MfgFeeAllocImportParam importDto) {
        DataSet ds = null;
        ds = this.getBasicCommonProdBill(importDto);
        DataSet auxDs = this.getBasicAuxProdBill(importDto);
        ds = DataSetUtils.unionIfRowDiff((DataSet)ds, (DataSet)auxDs);
        return this.replaceManuOrgFromDs(ds, importDto, "costcenter");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MfgAllocResult doAlloc(List<Long> ids, String appnum, String progressId) {
        String disableAllocCalcReport;
        if (!CadEmptyUtils.isEmpty(ids) && "1".equals(disableAllocCalcReport = CadBgParamUtils.getCadBgParamForString((String)"disableAllocCalcReport", (String)"1"))) {
            QFilter idQFilter = new QFilter("id", "in", ids);
            DeleteServiceHelper.delete((String)"cad_alloccalcreport", (QFilter[])idQFilter.toArray());
        }
        MfgFeeInnerCostcenterAllocService.refreshProgress(ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3\u5185\u5206\u914d\u5f00\u59cb\u3002", (String)"MfgFeeInnerCostcenterAllocService_28", (String)"macc-cad-business", (Object[])new Object[0]), 1, 3, false, progressId);
        MfgAllocResult allocResult = new MfgAllocResult();
        long costAccountId = 0L;
        try {
            DynamicObjectCollection cols = this.getInnerCostcenterBill(ids);
            ArrayList<String> errorMsgs = new ArrayList<String>();
            List<DynamicObject> dynCols = this.validateCommon(cols, errorMsgs, "cad_mfgfeeallocco", appnum);
            if (dynCols.size() > 0) {
                ArrayList<Long> allocIds = new ArrayList<Long>(dynCols.size());
                for (DynamicObject dynObj : dynCols) {
                    String tips;
                    if (costAccountId == 0L) {
                        costAccountId = dynObj.getLong("costaccount");
                    }
                    if (ScaAllocEnum.ALLOCSTATUS_CONFIRM.getValue().equals(dynObj.getString("allocstatus"))) {
                        tips = ResManager.loadKDString((String)"\u5355\u636e\u5df2\u786e\u8ba4\uff0c\u4e0d\u80fd\u518d\u8fdb\u884c\u5206\u914d\u3002", (String)"MfgFeeInnerCostcenterAllocService_31", (String)"macc-cad-business", (Object[])new Object[0]);
                        errorMsgs.add(String.format("%s:%s", dynObj.getString("billno"), tips));
                        continue;
                    }
                    if ("true".equals(dynObj.getString("directalloc"))) {
                        tips = ResManager.loadKDString((String)"\u4e3a\u201c\u76f4\u63a5\u5206\u914d\u201d\u7c7b\u578b\u5355\u636e\uff0c\u4e0d\u80fd\u8fdb\u884c\u5206\u914d\u3002", (String)"MfgFeeInnerCostcenterAllocService_32", (String)"macc-cad-business", (Object[])new Object[0]);
                        errorMsgs.add(String.format("%s:%s", dynObj.getString("billno"), tips));
                        continue;
                    }
                    allocIds.add(dynObj.getLong("id"));
                }
                if (allocIds.size() > 0) {
                    try {
                        MfgFeeInnerCostcenterAllocService.refreshProgress(ResManager.loadKDString((String)"\u83b7\u53d6\u5206\u914d\u6807\u51c6\u5206\u914d\u4e2d\uff0c\u8bf7\u7a0d\u5019\u3002", (String)"MfgFeeInnerCostcenterAllocService_29", (String)"macc-cad-business", (Object[])new Object[0]), 2, 3, false, progressId);
                        allocResult.setAllocStatus(new InnerAlloc().doInnerAlloc(allocIds, appnum));
                    }
                    catch (Exception ex) {
                        logger.error("\u8c03\u7528\u6210\u672c\u4e2d\u5fc3\u95f4\u5185\u5206\u914d\u5931\u8d25\uff1a" + ex.getMessage(), (Throwable)ex);
                        String tips = ResManager.loadKDString((String)"\u5206\u914d\u51fa\u73b0\u9519\u8bef\uff1a", (String)"MfgFeeInnerCostcenterAllocService_14", (String)"macc-cad-business", (Object[])new Object[0]);
                        errorMsgs.add(tips + ex.getMessage());
                    }
                }
            } else if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)cols)) {
                allocResult.setAllocStatus(AllocResultEnum.Failure.getResult());
                costAccountId = ((DynamicObject)cols.get(0)).getLong("costaccount");
            }
            if (!CadEmptyUtils.isEmpty(errorMsgs)) {
                allocResult.setAllocStatus(AllocResultEnum.Failure.getResult());
            }
            allocResult.setVerifyMsgs(errorMsgs);
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u6210\u672c\u4e2d\u5fc3\u95f4\u5185\u5206\u914d\u5931\u8d25\uff1a", (Throwable)e);
        }
        finally {
            SimpleMutexHelper.releaseXMutex((String)"coImport", (Object)(costAccountId + "coImport"));
            MfgFeeInnerCostcenterAllocService.refreshProgress(ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3\u5185\u5206\u914d\u5b8c\u6210\u3002", (String)"MfgFeeInnerCostcenterAllocService_30", (String)"macc-cad-business", (Object[])new Object[0]), -1, 0, false, progressId);
        }
        return allocResult;
    }

    public void deleteInnerCostcenterBills(MfgFeeAllocImportParam importDto) {
        logger.info("\u6210\u672c\u4e2d\u5fc3\u5185\u5206\u914d-\u5220\u9664\u5355\u636e\uff1a{}", (Object)importDto);
        HashSet<Long> innerIds = new HashSet<Long>(16);
        if ("eca".equals(importDto.getAppnum()) || !importDto.isMergeBill()) {
            innerIds.addAll(this.getCoUnConfirmEntityBillIds(importDto));
        } else {
            innerIds.addAll(this.getEntityBillIds(importDto, "cad_mfgfeeallocco"));
        }
        logger.info("\u6210\u672c\u4e2d\u5fc3\u5185\u5206\u914d-\u5220\u9664\u672c\u5c42\u5355\u636e\u6570\uff1a{}", (Object)innerIds.size());
        if (innerIds.size() > 0) {
            this.expireMfgFeeBill(innerIds, "cad_mfgfeeallocco");
            this.expireCalcReport(innerIds, "cad_alloccalcreport");
            this.asyncDeleteData(innerIds, "cad_mfgfeeallocco");
            this.asyncDeleteData(innerIds, "cad_alloccalcreport");
        }
    }

    public DynamicObjectCollection getInnerCostcenterBill(List<Long> ids) {
        QFilter filter = new QFilter("id", "in", ids);
        String absorbSelectFields = "id,billno,org,costaccount,manuorg,period,allocstatus,directalloc";
        DynamicObjectCollection sourceBills = QueryServiceHelper.query((String)"cad_mfgfeeallocco", (String)absorbSelectFields, (QFilter[])filter.toArray());
        return sourceBills;
    }

    public DataSet getAuxComProdBill(MfgFeeAllocImportParam importDto) {
        String algoKey = ALGO_KEY_CLASS_NAME + ".getAuxComProdBill()";
        QFilter filter = new QFilter("org", "=", (Object)importDto.getOrg());
        filter.and("costaccount", "=", (Object)importDto.getCostaccount());
        filter.and("period", "=", (Object)importDto.getPeriod());
        if (importDto.isEnableFactory()) {
            filter.and("comentity.comsubentity.subcostcenter", "in", (Object)importDto.getCostCenterIds());
        }
        filter.and("allocstatus", "=", (Object)ScaAllocEnum.ALLOCSTATUS_CONFIRM.getValue());
        filter.and("comentity.comsubentity.subcostcenter.orgduty", "=", (Object)4L);
        String selectFields = "id,billno,org,costaccount,manuorg,period,comentity.comsubentity.subcostcenter costcenter,comentity.comsubentity.subexpenseitem expenseitem,case when allocmethod ='mutual' or allocmethod='algebra' then comentity.comsubentity.suboutamt else comentity.comsubentity.subamt end totalamount,currency,currency.amtprecision amtprecision,'aux' type,0 costobject,0 material,0 productgroup";
        return QueryServiceHelper.queryDataSet((String)algoKey, (String)"cad_auxprodalloc", (String)selectFields, (QFilter[])filter.toArray(), null);
    }

    public DataSet getBasicCommonProdBill(MfgFeeAllocImportParam importDto) {
        String algoKey = ALGO_KEY_CLASS_NAME + ".getAuxComProdBill()";
        QFilter filter = new QFilter("org", "=", (Object)importDto.getOrg());
        filter.and("costaccount", "=", (Object)importDto.getCostaccount());
        filter.and("period", "=", (Object)importDto.getPeriod());
        if (importDto.isEnableFactory()) {
            filter.and("entryentity.entrycostcenter", "in", (Object)importDto.getCostCenterIds());
        }
        filter.and("allocstatus", "=", (Object)ScaAllocEnum.ALLOCSTATUS_CONFIRM.getValue());
        filter.and("srcbilltype", "=", (Object)"A");
        filter.and("entryentity.entrycostcenter.orgduty", "=", (Object)4L);
        String selectFields = importDto.getAllocDim() + "id,billno,org,costaccount,manuorg,period,entryentity.entrycostcenter costcenter,entryentity.entryexpenseitem expenseitem,entryentity.entryamount totalamount,currency,currency.amtprecision amtprecision,'basic' type,0 costobject,0 material,productgroup";
        return QueryServiceHelper.queryDataSet((String)algoKey, (String)"cad_basicalloc", (String)selectFields, (QFilter[])filter.toArray(), null);
    }

    public DataSet getBasicAuxProdBill(MfgFeeAllocImportParam importDto) {
        String algoKey = ALGO_KEY_CLASS_NAME + ".getAuxComProdBill()";
        QFilter filter = new QFilter("org", "=", (Object)importDto.getOrg());
        filter.and("costaccount", "=", (Object)importDto.getCostaccount());
        filter.and("period", "=", (Object)importDto.getPeriod());
        if (importDto.isEnableFactory()) {
            filter.and("comentity.comsubentity.subcostcenter", "in", (Object)importDto.getCostCenterIds());
        }
        filter.and("allocstatus", "=", (Object)ScaAllocEnum.ALLOCSTATUS_CONFIRM.getValue());
        filter.and("srcbilltype", "=", (Object)"B");
        filter.and("comentity.comsubentity.subcostcenter.orgduty", "=", (Object)4L);
        String selectFields = "id,billno,org,costaccount,manuorg,period,comentity.comsubentity.subcostcenter costcenter,comentity.comsubentity.subcomexpenseitem expenseitem,comentity.comsubentity.subamt totalamount,currency,currency.amtprecision amtprecision,'basic_aux' type,0 costobject,0 material,productgroup";
        return QueryServiceHelper.queryDataSet((String)algoKey, (String)"cad_basicalloc", (String)selectFields, (QFilter[])filter.toArray(), null);
    }
}

