/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.business.feealloc;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.macc.cad.algox.mfgfee.alloc.NotProdAlloc;
import kd.macc.cad.algox.mfgfee.importer.MfgFeeImportAlgoxService;
import kd.macc.cad.business.feealloc.MfgFeeAllocBase;
import kd.macc.cad.common.dto.MfgFeeAllocImportParam;
import kd.macc.cad.common.enums.MfgFeeAllocTypeEnum;
import kd.macc.cad.common.enums.ScaAllocEnum;
import kd.macc.cad.common.helper.SimpleMutexHelper;
import kd.macc.cad.common.output.ExecuteResult;
import kd.macc.cad.common.output.MfgAllocResult;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class MfgFeeNonProdAllocService
extends MfgFeeAllocBase {
    private static final String ALGO_KEY_CLASS_NAME = MfgFeeNonProdAllocService.class.getCanonicalName();
    private static final Log logger = LogFactory.getLog(MfgFeeNonProdAllocService.class);

    public ExecuteResult feeAllocNonProdImport(MfgFeeAllocImportParam importDto, String progressId) {
        return this.feeAllocNonProdImport(importDto, progressId, "", 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecuteResult feeAllocNonProdImport(MfgFeeAllocImportParam importDto, String progressId, String periodName, int currentIndex) {
        int totalSize = 7;
        if (!importDto.isActMfg()) {
            totalSize = importDto.getCalcPeriodMap().size() * 7;
        }
        int current = (currentIndex - 1) * 7;
        MfgFeeNonProdAllocService.refreshProgress(String.format(ResManager.loadKDString((String)"%s\u975e\u751f\u4ea7\u5206\u914d\u5f15\u5165\u5f00\u59cb", (String)"MfgFeeNonProdAllocService_22", (String)"macc-cad-business", (Object[])new Object[0]), periodName), current + 1, totalSize, false, progressId);
        logger.info("\u975e\u751f\u4ea7\u5206\u914d-\u5f15\u5165\u5355\u636e\uff1a{}", (Object)importDto);
        ExecuteResult result = new ExecuteResult();
        try {
            HashSet<String> errorInfo = new HashSet<String>(16);
            HashMap<String, String> comboNameMap = new HashMap<String, String>(4);
            MainEntityType mfgFeeBillEntityType = EntityMetadataCache.getDataEntityType((String)"cad_mfgfeebill");
            MainEntityType nonProdEntityType = EntityMetadataCache.getDataEntityType((String)"cad_nonprodalloc");
            this.buildAllocDim(importDto);
            StringBuilder tipSb = new StringBuilder();
            for (String allocDim : importDto.getAllocDimSet()) {
                String errorTip;
                String allocDimShowName = this.getComboName(comboNameMap, allocDim);
                if (SYS_ALLOC_DIM.contains(allocDim)) continue;
                if (mfgFeeBillEntityType.findProperty(allocDim) == null) {
                    errorTip = String.format(ResManager.loadKDString((String)"\u5236\u9020\u8d39\u7528\u5f52\u96c6\u5355\u636e\u672a\u589e\u52a0\u6807\u8bc6\u4e3a%1$s\u7684%2$s\u7ef4\u5ea6\u5b57\u6bb5\uff0c\u6210\u672c\u4e2d\u5fc3\u95f4\u8d39\u7528\u5206\u914d\u6807\u51c6\u5206\u914d\u7ef4\u5ea6\u4e0d\u5141\u8bb8\u8bbe\u7f6e%3$s\u7ef4\u5ea6\u3002", (String)"MfgFeeNonProdAllocService_32", (String)"macc-cad-business", (Object[])new Object[0]), allocDim, allocDimShowName, allocDimShowName);
                    errorInfo.add(errorTip);
                    tipSb.append(errorTip);
                }
                if (nonProdEntityType.findProperty(allocDim) != null) continue;
                errorTip = String.format(ResManager.loadKDString((String)"\u975e\u751f\u4ea7\u5206\u914d\u5355\u636e\u672a\u589e\u52a0\u6807\u8bc6\u4e3a%1$s\u7684%2$s\u7ef4\u5ea6\u5b57\u6bb5\uff0c\u6210\u672c\u4e2d\u5fc3\u95f4\u8d39\u7528\u5206\u914d\u6807\u51c6\u5206\u914d\u7ef4\u5ea6\u4e0d\u5141\u8bb8\u8bbe\u7f6e%3$s\u7ef4\u5ea6\u3002", (String)"MfgFeeNonProdAllocService_33", (String)"macc-cad-business", (Object[])new Object[0]), allocDim, allocDimShowName, allocDimShowName);
                errorInfo.add(errorTip);
                tipSb.append(errorTip);
            }
            if (!CadEmptyUtils.isEmpty(errorInfo)) {
                result.setErrorInfo(errorInfo);
                result.setErrorNotification(tipSb.toString());
                ExecuteResult executeResult = result;
                return executeResult;
            }
            DataSet ds = this.getMfgCollocBills(importDto, MfgFeeAllocTypeEnum.NONPROD);
            MfgFeeNonProdAllocService.refreshProgress(String.format(ResManager.loadKDString((String)"%s\u83b7\u53d6\u975e\u751f\u4ea7\u5206\u914d\u6807\u51c6", (String)"MfgFeeNonProdAllocService_23", (String)"macc-cad-business", (Object[])new Object[0]), periodName), current + 3, totalSize, false, progressId);
            DataSet nonprdstdDs = this.getMfgAllocStd(importDto.getOrg(), MfgFeeAllocTypeEnum.NONPROD.getValue(), importDto.getAppnum(), importDto.getPeriod());
            DataSet nonBillAndStdDs = ds.leftJoin(nonprdstdDs).on("org", "org").on("manuorg", "manuorg").on("costcenter", "costcenter").on("expenseitem", "expenseitem").select(ds.getRowMeta().getFieldNames(), new String[]{"expenseitem expenseitemstd", "costdriver", "isrelatedwork", "costdriverstatus", "costdriverenable", "unit", "allocdim"}).finish();
            DataSet costdriverNotEnableDs = nonBillAndStdDs.copy().filter("costdriverenable = '0' or costdriverstatus in('A','B')");
            if (!costdriverNotEnableDs.isEmpty()) {
                String tips = ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u201c%1$s\u201d\u4e0b%2$s\u9700\u8981\u91cd\u65b0\u7ef4\u62a4\u5bf9\u5e94\u7684\u5206\u914d\u6807\u51c6\u3002", (String)"MfgFeeNonProdAllocService_13", (String)"macc-cad-business", (Object[])new Object[0]);
                String errorMsg = this.getCostcenterFeeTip(costdriverNotEnableDs, tips, errorInfo);
                result.setErrorInfo(errorInfo);
                result.setErrorNotification(errorMsg);
                nonBillAndStdDs.close();
                ExecuteResult executeResult = result;
                return executeResult;
            }
            if (nonBillAndStdDs.isEmpty()) {
                ExecuteResult tips = result;
                return tips;
            }
            try {
                long time = System.currentTimeMillis();
                MfgFeeImportAlgoxService algoxImportService = new MfgFeeImportAlgoxService();
                HashMap<String, Object> paramMap = new HashMap<String, Object>();
                paramMap.put("appnum", importDto.getAppnum());
                paramMap.put("planscheme", importDto.getPlanscheme());
                paramMap.put("allocDim", importDto.getAllocDimSet());
                paramMap.put("entitytype", importDto.getEntityType());
                MfgFeeNonProdAllocService.refreshProgress(String.format(ResManager.loadKDString((String)"%s\u975e\u751f\u4ea7\u5206\u914d\u5355\u5f15\u5165", (String)"MfgFeeNonProdAllocService_24", (String)"macc-cad-business", (Object[])new Object[0]), periodName), current + 5, totalSize, false, progressId);
                int i = algoxImportService.nonProdImportCalc(nonBillAndStdDs, paramMap);
                result.setSuccessQty(i);
                logger.info("\u975e\u751f\u4ea7\u5206\u914d\u5355\u5f15\u5165algox\u5904\u7406\u7ed3\u679c\u96c6\u8017\u65f6\uff1a{}ms", (Object)(System.currentTimeMillis() - time));
            }
            catch (Exception ex) {
                logger.error("\u975e\u751f\u4ea7\u5f15\u5165\u5931\u8d25\uff1a" + ex.getMessage(), (Throwable)ex);
                result.setErrorNotification(String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff1a%s\u3002", (String)"MfgFeeNonProdAllocService_14", (String)"macc-cad-business", (Object[])new Object[0]), ex.getMessage()));
            }
        }
        catch (Exception e) {
            logger.error("\u975e\u751f\u4ea7\u5f15\u5165\u5931\u8d25", (Throwable)e);
        }
        finally {
            if (importDto.isActMfg()) {
                SimpleMutexHelper.releaseXMutex((String)"nonImport", (Object)(importDto.getCostaccount() + "nonImport"));
            }
            if (currentIndex * 7 == totalSize) {
                MfgFeeNonProdAllocService.refreshProgress(ResManager.loadKDString((String)"\u975e\u751f\u4ea7\u5206\u914d\u5bfc\u5165\u5b8c\u6210\u3002", (String)"MfgFeeNonProdAllocService_18", (String)"macc-cad-business", (Object[])new Object[0]), -1, 0, false, progressId);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MfgAllocResult doUnConfirmByPlanPeriod(Map<Long, List<Long>> periodIdMap, String appnum, String progressId, boolean planData) {
        String entityType = planData ? "cad_plannonprodalloc" : "cad_nonprodalloc";
        MfgAllocResult allocResult = new MfgAllocResult();
        try {
            int size = periodIdMap.size();
            int currindex = 0;
            for (Map.Entry<Long, List<Long>> entry : periodIdMap.entrySet()) {
                MfgFeeNonProdAllocService.refreshProgress(String.format(ResManager.loadKDString((String)"%s\u975e\u751f\u4ea7\u5206\u914d\u5355\u53cd\u786e\u8ba4\u5f00\u59cb", (String)"MfgFeeNonProdAllocService_29", (String)"macc-cad-business", (Object[])new Object[0]), this.getPeriodName(entry.getKey())), currindex, size, false, progressId);
                List splitLists = Lists.partition(entry.getValue(), (int)200);
                for (List list : splitLists) {
                    OperationResult result = OperationServiceHelper.executeOperate((String)"op_unconfirm", (String)entityType, (Object[])list.toArray(), (OperateOption)OperateOption.create());
                    if (result.isSuccess()) continue;
                    if (allocResult.getVerifyMsgs() == null) {
                        allocResult.setVerifyMsgs(new ArrayList(10));
                    }
                    for (IOperateInfo errInfo : result.getAllErrorOrValidateInfo()) {
                        allocResult.getVerifyMsgs().add(errInfo.getMessage());
                    }
                }
            }
        }
        catch (Exception ex) {
            logger.error("\u975e\u751f\u4ea7\u5206\u914d\u53cd\u786e\u8ba4\u5931\u8d25-0", (Throwable)ex);
            if (allocResult.getVerifyMsgs() == null) {
                allocResult.setVerifyMsgs(new ArrayList(10));
            }
            allocResult.getVerifyMsgs().add(ex.getMessage());
        }
        finally {
            MfgFeeNonProdAllocService.refreshProgress(ResManager.loadKDString((String)"\u975e\u751f\u4ea7\u5206\u914d\u5355\u53cd\u786e\u8ba4\u5b8c\u6210", (String)"MfgFeeNonProdAllocService_26", (String)"macc-cad-business", (Object[])new Object[0]), -1, 0, false, progressId);
        }
        return allocResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MfgAllocResult doConfirmByPlanPeriod(Map<Long, List<Long>> periodIdMap, String appnum, String progressId, boolean planData) {
        String entityType = planData ? "cad_plannonprodalloc" : "cad_nonprodalloc";
        MfgAllocResult allocResult = new MfgAllocResult();
        try {
            int size = periodIdMap.size();
            int currindex = 0;
            for (Map.Entry<Long, List<Long>> entry : periodIdMap.entrySet()) {
                MfgFeeNonProdAllocService.refreshProgress(String.format(ResManager.loadKDString((String)"%s\u975e\u751f\u4ea7\u5206\u914d\u5355\u786e\u8ba4\u5f00\u59cb", (String)"MfgFeeNonProdAllocService_30", (String)"macc-cad-business", (Object[])new Object[0]), this.getPeriodName(entry.getKey())), currindex, size, false, progressId);
                List splitLists = Lists.partition(entry.getValue(), (int)200);
                for (List list : splitLists) {
                    OperationResult result = OperationServiceHelper.executeOperate((String)"op_confirm", (String)entityType, (Object[])list.toArray(), (OperateOption)OperateOption.create());
                    if (result.isSuccess()) continue;
                    if (allocResult.getVerifyMsgs() == null) {
                        allocResult.setVerifyMsgs(new ArrayList(10));
                    }
                    for (IOperateInfo errInfo : result.getAllErrorOrValidateInfo()) {
                        allocResult.getVerifyMsgs().add(errInfo.getMessage());
                    }
                }
            }
        }
        catch (Exception ex) {
            logger.error("\u975e\u751f\u4ea7\u5206\u914d\u786e\u8ba4\u5931\u8d25-0", (Throwable)ex);
            if (allocResult.getVerifyMsgs() == null) {
                allocResult.setVerifyMsgs(new ArrayList(10));
            }
            allocResult.getVerifyMsgs().add(ex.getMessage());
        }
        finally {
            MfgFeeNonProdAllocService.refreshProgress(ResManager.loadKDString((String)"\u975e\u751f\u4ea7\u5206\u914d\u5355\u786e\u8ba4\u5b8c\u6210", (String)"MfgFeeNonProdAllocService_28", (String)"macc-cad-business", (Object[])new Object[0]), -1, 0, false, progressId);
        }
        return allocResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MfgAllocResult doAllocByPlanPeriod(List<Long> ids, String appnum, String progressId, boolean planData, Long planschemeId) {
        String entityType = planData ? "cad_plannonprodalloc" : "cad_nonprodalloc";
        DynamicObjectCollection cols = this.getNonProdBill(ids, entityType);
        LinkedHashMap<String, List> periodBillIdsMap = new LinkedHashMap<String, List>();
        for (DynamicObject dyn : cols) {
            periodBillIdsMap.computeIfAbsent(dyn.getString("periodname"), t -> new ArrayList(10)).add(dyn.getLong("id"));
        }
        MfgAllocResult allocResult = new MfgAllocResult();
        try {
            int size = periodBillIdsMap.size();
            int currindex = 0;
            for (Map.Entry entry : periodBillIdsMap.entrySet()) {
                MfgFeeNonProdAllocService.refreshProgress(String.format(ResManager.loadKDString((String)"%s\u975e\u751f\u4ea7\u5206\u914d\u5f00\u59cb", (String)"MfgFeeNonProdAllocService_31", (String)"macc-cad-business", (Object[])new Object[0]), entry.getKey()), currindex, size, false, progressId);
                MfgAllocResult result = this.doAlloc((List)entry.getValue(), appnum, null, planData, planschemeId);
                allocResult.setAllocStatus(this.dealAllocStatus(result.getAllocStatus(), allocResult.getAllocStatus()));
                if (result.getVerifyMsgs() == null) continue;
                if (allocResult.getVerifyMsgs() == null) {
                    allocResult.setVerifyMsgs(result.getVerifyMsgs());
                    continue;
                }
                allocResult.getVerifyMsgs().addAll(result.getVerifyMsgs());
            }
        }
        catch (Exception ex) {
            logger.error("\u975e\u751f\u4ea7\u5206\u914d\u5931\u8d25-0", (Throwable)ex);
            if (allocResult.getVerifyMsgs() == null) {
                allocResult.setVerifyMsgs(new ArrayList(10));
            }
            allocResult.getVerifyMsgs().add(ex.getMessage());
        }
        finally {
            MfgFeeNonProdAllocService.refreshProgress(ResManager.loadKDString((String)"\u975e\u751f\u4ea7\u5206\u914d\u5b8c\u6210\u3002", (String)"MfgFeeNonProdAllocService_21", (String)"macc-cad-business", (Object[])new Object[0]), -1, 0, false, progressId);
        }
        return allocResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MfgAllocResult doAlloc(List<Long> ids, String appnum, String progressId, boolean planData, Long planschemeId) {
        MfgFeeNonProdAllocService.refreshProgress(ResManager.loadKDString((String)"\u975e\u751f\u4ea7\u5206\u914d\u5f00\u59cb", (String)"MfgFeeNonProdAllocService_19", (String)"macc-cad-business", (Object[])new Object[0]), 1, 3, false, progressId);
        MfgAllocResult allocResult = new MfgAllocResult();
        long costAccountId = 0L;
        try {
            String entityType = planData ? "cad_plannonprodalloc" : "cad_nonprodalloc";
            DynamicObjectCollection cols = this.getNonProdBill(ids, entityType);
            ArrayList<String> errorMsgs = new ArrayList<String>();
            List<DynamicObject> dynCols = this.validateCommon(cols, errorMsgs, entityType, appnum);
            if (dynCols.size() > 0) {
                ArrayList<Long> allocIds = new ArrayList<Long>(dynCols.size());
                for (DynamicObject dynObj : dynCols) {
                    if (costAccountId == 0L) {
                        costAccountId = dynObj.getLong("costaccount");
                    }
                    if (ScaAllocEnum.ALLOCSTATUS_CONFIRM.getValue().equals(dynObj.getString("allocstatus"))) {
                        String tips = ResManager.loadKDString((String)"\u5355\u636e\u5df2\u5206\u914d\uff0c\u4e0d\u80fd\u518d\u5206\u914d\u3002", (String)"MfgFeeNonProdAllocService_5", (String)"macc-cad-business", (Object[])new Object[0]);
                        errorMsgs.add(String.format("%s:%s", dynObj.getString("billno"), tips));
                        continue;
                    }
                    allocIds.add(dynObj.getLong("id"));
                }
                if (allocIds.size() > 0) {
                    try {
                        MfgFeeNonProdAllocService.refreshProgress(ResManager.loadKDString((String)"\u83b7\u53d6\u5206\u914d\u6807\u51c6\u5206\u914d\u4e2d\uff0c\u8bf7\u7a0d\u5019\u3002", (String)"MfgFeeNonProdAllocService_20", (String)"macc-cad-business", (Object[])new Object[0]), 2, 3, false, progressId);
                        allocResult.setAllocStatus(new NotProdAlloc().doNotProdAlloc(entityType, allocIds, appnum, planData, planschemeId));
                    }
                    catch (Exception ex) {
                        logger.error("\u8c03\u7528\u975e\u751f\u4ea7\u5206\u914d\u5931\u8d25\uff1a" + ex.getMessage(), (Throwable)ex);
                        String tips = ResManager.loadKDString((String)"\u5206\u914d\u5931\u8d25\u3002", (String)"MfgFeeNonProdAllocService_7", (String)"macc-cad-business", (Object[])new Object[0]);
                        errorMsgs.add(tips + ex.getMessage());
                    }
                }
            }
            allocResult.setVerifyMsgs(errorMsgs);
        }
        catch (Exception e) {
            logger.error("\u975e\u751f\u4ea7\u5206\u914d\u5931\u8d25", (Throwable)e);
        }
        finally {
            if (!planData) {
                SimpleMutexHelper.releaseXMutex((String)"nonAlloc", (Object)(costAccountId + "nonAlloc"));
            }
            MfgFeeNonProdAllocService.refreshProgress(ResManager.loadKDString((String)"\u975e\u751f\u4ea7\u5206\u914d\u5b8c\u6210\u3002", (String)"MfgFeeNonProdAllocService_21", (String)"macc-cad-business", (Object[])new Object[0]), -1, 0, false, progressId);
        }
        return allocResult;
    }

    public void deleteNonProdAndRelaBills(MfgFeeAllocImportParam importDto, boolean isDeleteSelf) {
        logger.info("\u975e\u751f\u4ea7\u5206\u914d-\u5220\u9664\u5355\u636e\uff1a{}\uff0c{}", (Object)importDto, (Object)isDeleteSelf);
        String noProAlloc = importDto.getEntityType();
        String auxProdAlloc = this.getMfgEntity(importDto.isActMfg(), "cad_auxprodalloc");
        String basicAlloc = this.getMfgEntity(importDto.isActMfg(), "cad_basicalloc");
        DataSet relaCostcenterDs = this.getNonProdBenefBill(importDto);
        HashSet<Long> nonProdIds = new HashSet<Long>(16);
        if (isDeleteSelf) {
            nonProdIds.addAll(this.getEntityBillIds(importDto, noProAlloc));
            if (nonProdIds.size() > 0) {
                logger.info("\u975e\u751f\u4ea7\u5206\u914d-\u5220\u9664\u975e\u751f\u4ea7\u5355\u636e\u6570\uff1a{}", (Object)nonProdIds.size());
                this.expireMfgFeeBill(nonProdIds, noProAlloc);
                this.asyncDeleteData(nonProdIds, noProAlloc);
            }
        }
        if (relaCostcenterDs != null && !relaCostcenterDs.isEmpty()) {
            Set<Long> auxProdIds;
            boolean isHasBasicCostcenter;
            boolean isHasAuxCostcenter = !relaCostcenterDs.copy().filter("orgduty=5").isEmpty();
            boolean bl = isHasBasicCostcenter = !relaCostcenterDs.filter("orgduty=4").isEmpty();
            if (isHasAuxCostcenter && (auxProdIds = this.getEntityBillIds(importDto, auxProdAlloc)).size() > 0) {
                logger.info("\u975e\u751f\u4ea7\u5206\u914d-\u5220\u9664\u8f85\u52a9\u751f\u4ea7\u5355\u636e\u6570\uff1a{}", (Object)auxProdIds.size());
                this.expireMfgFeeBill(auxProdIds, auxProdAlloc);
                this.asyncDeleteData(auxProdIds, auxProdAlloc);
            }
            if (isHasAuxCostcenter || isHasBasicCostcenter) {
                Set<Long> cosIds;
                Set<Long> basicProdIds = this.getEntityBillIds(importDto, basicAlloc);
                if (basicProdIds.size() > 0) {
                    logger.info("\u975e\u751f\u4ea7\u5206\u914d-\u5220\u9664\u57fa\u672c\u751f\u4ea7\u5355\u636e\u6570\uff1a{}", (Object)basicProdIds.size());
                    this.expireMfgFeeBill(basicProdIds, basicAlloc);
                    this.asyncDeleteData(basicProdIds, basicAlloc);
                }
                if (importDto.isActMfg() && (cosIds = this.getEntityBillIds(importDto, "cad_mfgfeeallocco")).size() > 0) {
                    logger.info("\u975e\u751f\u4ea7\u5206\u914d-\u5220\u9664\u6210\u672c\u4e2d\u5fc3\u5185\u5355\u636e\u6570\uff1a{}", (Object)cosIds.size());
                    this.expireMfgFeeBill(cosIds, "cad_mfgfeeallocco");
                    this.asyncDeleteData(cosIds, "cad_mfgfeeallocco");
                }
            }
        }
    }

    private DataSet getNonProdBenefBill(MfgFeeAllocImportParam importDto) {
        QFilter filter = this.getImportParamFilter(importDto, "entryentity.benefcostcenter");
        filter.and("allocstatus", "=", (Object)"2");
        return QueryServiceHelper.queryDataSet((String)(ALGO_KEY_CLASS_NAME + ".getNonProdBill()"), (String)importDto.getEntityType(), (String)"entryentity.benefcostcenter benefcostcenter,entryentity.benefcostcenter.orgduty orgduty", (QFilter[])new QFilter[]{filter}, null);
    }

    public DynamicObjectCollection getNonProdBill(List<Long> ids, String entityType) {
        QFilter filter = new QFilter("id", "in", ids);
        String absorbSelectFields = "id,billno,org,costaccount,manuorg,period,allocstatus,planscheme";
        if (this.isPlanMfg(entityType)) {
            absorbSelectFields = absorbSelectFields + ",period.name periodname";
        }
        return QueryServiceHelper.query((String)entityType, (String)absorbSelectFields, (QFilter[])filter.toArray(), (String)"period asc");
    }

    public DataSet getNonProdBillByDs(List<Long> ids, String entityType) {
        QFilter filter = new QFilter("id", "in", ids);
        String absorbSelectFields = "id,billno,org,costaccount,manuorg,period,allocstatus,planscheme";
        if (this.isPlanMfg(entityType)) {
            absorbSelectFields = absorbSelectFields + ",period.name periodname";
        }
        return QueryServiceHelper.queryDataSet((String)"getNonProdBillByDs", (String)entityType, (String)absorbSelectFields, (QFilter[])filter.toArray(), (String)"period asc");
    }
}

