/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.business.feealloc;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.JoinType;
import kd.bos.algo.Output;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.DataSetInput;
import kd.bos.algo.input.OrmInput;
import kd.bos.algo.output.DataSetOutput;
import kd.bos.algox.AlgoX;
import kd.bos.algox.DataSetX;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.JobSession;
import kd.bos.algox.JoinDataSetX;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.macc.cad.algox.resourcerate.function.PlanResColSubelementNullFunction;
import kd.macc.cad.algox.resourcerate.function.PlanResRateCalcFunction;
import kd.macc.cad.algox.resourcerate.function.PlanResUnitConvisionFunction;
import kd.macc.cad.algox.utils.CadEmptyUtils;
import kd.macc.cad.business.feealloc.MfgFeeAllocBase;
import kd.macc.cad.business.feealloc.MfgFeeInnerCostcenterAllocService;
import kd.macc.cad.common.dto.AllocReport;
import kd.macc.cad.common.dto.MfgFeeAllocImportParam;
import kd.macc.cad.common.enums.MfgFeeAllocTypeEnum;
import kd.macc.cad.common.enums.ScaAllocEnum;
import kd.macc.cad.common.helper.AllocReportHelper;
import kd.macc.cad.common.helper.CurrencyHelper;
import kd.macc.cad.common.utils.DataSetUtils;

public class PlanResourceRateCalcService
extends MfgFeeAllocBase {
    private static final String ALGO_KEY_CLASS_NAME = MfgFeeInnerCostcenterAllocService.class.getCanonicalName();
    private static final Log logger = LogFactory.getLog(MfgFeeInnerCostcenterAllocService.class);
    private static final String INSERT_PLANRESOURCERATE_BILL_SQL = "insert into t_cad_resourcplanrate(fid,fbillno,forgid,fcostaccountid,fmanuorgid,fperiodid,fcostcenterid,felementid,fsubelementid,famount,fcurrencyid,fresourceunit,fqty,fplanrate,fbillstatus,fcreatetime,fcreatorid,fmodifytime,fmodifierid,fauditdate,fauditorid,fappnum,fplanschemeid) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    private static final String INSERT_PLANRESOURCE_ENTRY_SQL = "insert into t_cad_resourcplanrate_res(fpkid,fid,fbasedataid) values(?,?,?)";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String resourceRateCalc(MfgFeeAllocImportParam importDto, String progressId) {
        int totalSize = importDto.getCalcPeriodMap().size();
        int current = 0;
        StringBuilder msgBuilder = new StringBuilder();
        for (Long periodId : importDto.getCalcPeriodMap().keySet()) {
            boolean isError = false;
            importDto.setPeriod(periodId);
            String periodName = this.getPeriodName(periodId);
            msgBuilder.append(periodName);
            Long currencyId = CurrencyHelper.getCurrency((Long)importDto.getCostaccount());
            PlanResourceRateCalcService.refreshProgress(String.format(ResManager.loadKDString((String)"%s\u8ba1\u5212\u8d44\u6e90\u8d39\u7387\u8ba1\u7b97", (String)"PlanResourceRateCalcService_0", (String)"macc-cad-business", (Object[])new Object[0]), periodName), current, totalSize, false, progressId);
            AllocReport report = AllocReportHelper.initReport((long)importDto.getOrg(), (long)importDto.getCostaccount(), (long)periodId, (long)currencyId, (String)"9", (String)"sca");
            report.setPlanschemeId(importDto.getPlanscheme().longValue());
            report.setReportType(ResManager.loadKDString((String)"\u8ba1\u7b97\u62a5\u544a", (String)"PlanResourceRateCalcService_25", (String)"macc-cad-business", (Object[])new Object[0]));
            report.setPlandata(true);
            try {
                int size = this.periodResourceCalc(importDto, report);
                msgBuilder.append(String.format(ResManager.loadKDString((String)"\u751f\u6210\u4e86%s\u5f20\u5355\u636e\u3002", (String)"PlanResourceRateCalcService_1", (String)"macc-cad-business", (Object[])new Object[0]), size));
            }
            catch (Exception ex) {
                logger.error("\u8ba1\u5212\u8d44\u6e90\u8d39\u7387\u8ba1\u7b97\u62a5\u9519:", (Throwable)ex);
                AllocReportHelper.addCheckDatail((AllocReport)report, null, (long)0L, (String)String.format(ResManager.loadKDString((String)"\u8ba1\u7b97\u51fa\u73b0\u5f02\u5e38\uff1a%s", (String)"PlanResourceRateCalcService_2", (String)"macc-cad-business", (Object[])new Object[0]), ex.getMessage()));
                isError = true;
            }
            finally {
                ++current;
                AllocReportHelper.saveReport((AllocReport)report);
                if (!isError && !"3".equals(report.getStatus())) continue;
                msgBuilder.append(ResManager.loadKDString((String)"\u8ba1\u7b97\u5b58\u5728\u5f02\u5e38\u4fe1\u606f\uff0c\u8be6\u60c5\u8bf7\u70b9\u51fb\u8ba1\u7b97\u62a5\u544a\u67e5\u8be2\u3002", (String)"PlanResourceRateCalcService_3", (String)"macc-cad-business", (Object[])new Object[0]));
            }
        }
        PlanResourceRateCalcService.refreshProgress(ResManager.loadKDString((String)"\u8ba1\u5212\u8d44\u6e90\u8d39\u7387\u8ba1\u7b97\u5b8c\u6210", (String)"PlanResourceRateCalcService_4", (String)"macc-cad-business", (Object[])new Object[0]), -1, 0, false, progressId);
        return msgBuilder.toString();
    }

    private int periodResourceCalc(MfgFeeAllocImportParam importDto, AllocReport report) {
        this.delResurcePlanRate(importDto);
        AllocReportHelper.addCheckItem((AllocReport)report, (String)"2", (String)ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3\u6ca1\u6709\u7b26\u5408\u7684\u5206\u914d\u6807\u51c6\u3002", (String)"PlanResourceRateCalcService_6", (String)"macc-cad-business", (Object[])new Object[0]));
        DataSet billAndStdDs = this.getFeeAllocDs(importDto, report);
        DataSet resourceDriverDs = this.getResourceCostdriver();
        DataSet innerStdDs = this.getMfgAllocInnerBySubelementStd(importDto.getOrg(), "sca", importDto.getPeriod());
        OrmInput elementDs = new OrmInput("getProCostDataSetInfo", "cad_elementdetail", "subelement,subelement.number subelementnum,subelement.name subelementname, element,element.number elementnum,element.name elementname", null);
        DataSet resourceData = this.getResourceDs(importDto);
        JobSession session = AlgoX.createSession((String)"matchPeriodByBookDate");
        DataSetX resourceDsx = session.fromInput((Input)new DataSetInput(resourceData));
        DataSetX innerStdDsx = session.fromInput((Input)new DataSetInput(innerStdDs));
        DataSetX resourceDriverDsx = session.fromInput((Input)new DataSetInput(resourceDriverDs));
        DataSetX billAndStdDsx = session.fromInput((Input)new DataSetInput(billAndStdDs));
        DataSetX elementDsx = session.fromInput((Input)elementDs);
        resourceDsx = resourceDsx.leftJoin(resourceDriverDsx).on("resource", "resource").select(resourceDsx.getRowMeta().getFieldNames(), new String[]{"costdriverid"});
        resourceDsx = resourceDsx.leftJoin(innerStdDsx).on("costcenter", "costcenter").on("costdriverid", "costdriver").select(resourceDsx.getRowMeta().getFieldNames(), new String[]{"subelement"});
        DataSetX resourceNoSubelementDsx = resourceDsx.groupBy(new String[]{"resourceid"}).reduceGroup((GroupReduceFunction)new PlanResColSubelementNullFunction()).distinct(new String[]{"costcenter", "billno"});
        resourceDsx = resourceDsx.filter("subelement>0");
        resourceDsx = resourceDsx.groupBy(new String[]{"resourceunit"}).reduceGroup((GroupReduceFunction)new PlanResUnitConvisionFunction());
        DataSetX resourceUnitDsx = resourceDsx.filter("resourceunit<=0").distinct(new String[]{"costcenter", "billno"});
        resourceDsx = resourceDsx.filter("resourceunit>0").groupBy(new String[]{"org", "manuorg", "costcenter", "resource", "subelement", "costdriverid", "resourceunit"}).sum("qty");
        resourceDsx = resourceDsx.addFields(new Field[]{new Field("costaccount", (DataType)DataType.LongType), new Field("period", (DataType)DataType.LongType)}, new Object[]{importDto.getCostaccount(), importDto.getPeriod()});
        billAndStdDsx = billAndStdDsx.groupBy(new String[]{"org", "costaccount", "manuorg", "period", "costcenter", "subelement", "costdriver"}).sum("totalamount");
        JoinDataSetX resultDsx = resourceDsx.join(billAndStdDsx).on("costcenter", "costcenter").on("costdriverid", "costdriver").on("subelement", "subelement").select(new String[]{"costdriverid", "resource", "resourceunit", "qty"}, billAndStdDsx.getRowMeta().getFieldNames());
        DataSetX resultNoFeeDsx = resourceDsx.leftJoin(billAndStdDsx).on("costcenter", "costcenter").on("costdriverid", "costdriver").on("subelement", "subelement").select(resourceDsx.getRowMeta().getFieldNames(), new String[]{"costdriver", "totalamount"}).filter("costdriver is null");
        DataSetX resultNoResDsx = billAndStdDsx.leftJoin(resourceDsx).on("costcenter", "costcenter").on("costdriver", "costdriverid").on("subelement", "subelement").select(billAndStdDsx.getRowMeta().getFieldNames(), new String[]{"resource"}).filter("resource is null");
        resultNoFeeDsx = resultNoFeeDsx.distinct(new String[]{"costcenter", "subelement", "resource"}).leftJoin(elementDsx).on("subelement", "subelement").select(new String[]{"costcenter", "resource", "subelement"}, new String[]{"subelementnum", "subelementname"});
        resultNoResDsx = resultNoResDsx.distinct(new String[]{"costcenter", "subelement"}).leftJoin(elementDsx).on("subelement", "subelement").select(new String[]{"costcenter", "subelement"}, new String[]{"subelementnum", "subelementname"});
        resultDsx = resultDsx.leftJoin(elementDsx).on("subelement", "subelement").select(resultDsx.getRowMeta().getFieldNames(), new String[]{"element"});
        resultDsx = resultDsx.addFields(new Field[]{new Field("planrate", (DataType)DataType.BigDecimalType), new Field("mulresource", (DataType)DataType.StringType)}, new Object[]{BigDecimal.ZERO, ""});
        resultDsx = resultDsx.groupBy(new String[]{"org", "costaccount", "manuorg", "period", "costcenter", "subelement"}).reduceGroup((GroupReduceFunction)new PlanResRateCalcFunction());
        DataSetOutput dataSetOutput = new DataSetOutput(resultDsx.getRowMeta());
        DataSetOutput resourceNoSubelementOutput = new DataSetOutput(resourceNoSubelementDsx.getRowMeta());
        DataSetOutput resourceUnitOutput = new DataSetOutput(resourceUnitDsx.getRowMeta());
        DataSetOutput resultNoResDsOutput = new DataSetOutput(resultNoResDsx.getRowMeta());
        DataSetOutput resultNoFeeDsOutput = new DataSetOutput(resultNoFeeDsx.getRowMeta());
        resultDsx.output((Output)dataSetOutput);
        resourceNoSubelementDsx.output((Output)resourceNoSubelementOutput);
        resourceUnitDsx.output((Output)resourceUnitOutput);
        resultNoResDsx.output((Output)resultNoResDsOutput);
        resultNoFeeDsx.output((Output)resultNoFeeDsOutput);
        session.commit(60, TimeUnit.MINUTES);
        DataSet resultDs = session.readDataSet(dataSetOutput.getId());
        DataSet resourceNoSubelementDs = session.readDataSet(resourceNoSubelementOutput.getId());
        DataSet resourceUnitDs = session.readDataSet(resourceUnitOutput.getId());
        DataSet resultNoResDs = session.readDataSet(resultNoResDsOutput.getId());
        DataSet resultNoFeeDs = session.readDataSet(resultNoFeeDsOutput.getId());
        this.showResultNoRes(resultNoResDs, report);
        this.showResultNoFee(resultNoFeeDs, report);
        this.showUnitNoChange(resourceUnitDs, report);
        this.showResourceNoSubelementMsg(resourceNoSubelementDs, report);
        return PlanResourceRateCalcService.savePlanResourceRateData(importDto, resultDs, report.getCurrencyId());
    }

    private void showResultNoRes(DataSet resultNoResDs, AllocReport report) {
        AllocReportHelper.addCheckItem((AllocReport)report, (String)"5", (String)ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3\u8d39\u7528\u6709\u91d1\u989d\uff0c\u5bf9\u5e94\u7684\u8d44\u6e90\u6ca1\u6709\u6570\u91cf\u3002", (String)"PlanResourceRateCalcService_7", (String)"macc-cad-business", (Object[])new Object[0]), (String)"4");
        String msg = ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3\u4e0b\u6210\u672c\u5b50\u8981\u7d20\u3010%s\u3011\u5bf9\u5e94\u7684\u8d44\u6e90\u6ca1\u6709\u6570\u91cf\u3002", (String)"PlanResourceRateCalcService_20", (String)"macc-cad-business", (Object[])new Object[0]);
        for (Row row : resultNoResDs) {
            AllocReportHelper.addCheckDatail((AllocReport)report, (String)"5", (long)row.getLong("costcenter"), (String)String.format(msg, row.getString("subelementnum") + "/" + row.getString("subelementname")));
        }
    }

    private void showResultNoFee(DataSet resultNoFeeDs, AllocReport report) {
        AllocReportHelper.addCheckItem((AllocReport)report, (String)"5", (String)ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3\u8d39\u7528\u6ca1\u6709\u91d1\u989d\uff0c\u5bf9\u5e94\u7684\u8d44\u6e90\u6709\u6570\u91cf\u3002", (String)"PlanResourceRateCalcService_9", (String)"macc-cad-business", (Object[])new Object[0]));
        String msg = ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3\u4e0b\u6210\u672c\u5b50\u8981\u7d20\u3010%1$s\u3011\u5bf9\u5e94\u7684\u8d44\u6e90\u3010%2$s\u3011\u6709\u6570\u91cf\uff0c\u8d39\u7528\u65e0\u91d1\u989d\u3002", (String)"PlanResourceRateCalcService_21", (String)"macc-cad-business", (Object[])new Object[0]);
        if (resultNoFeeDs.isEmpty()) {
            return;
        }
        DataSet resultNoFeeCopyDs = resultNoFeeDs.copy();
        HashSet<Long> resourceIds = new HashSet<Long>(10);
        for (Row row : resultNoFeeCopyDs) {
            resourceIds.add(row.getLong("resource"));
        }
        QFilter filter = new QFilter("id", "in", resourceIds);
        DataSet ds = QueryServiceHelper.queryDataSet((String)"resource", (String)"mpdm_resources", (String)"id,number,name", (QFilter[])filter.toArray(), null);
        HashMap<Long, String> resMap = new HashMap<Long, String>(10);
        for (Row row : ds) {
            resMap.putIfAbsent(row.getLong("id"), String.format("%s/%s", row.getString("number"), row.getString("name")));
        }
        for (Row row : resultNoFeeDs) {
            AllocReportHelper.addCheckDatail((AllocReport)report, (String)"6", (long)row.getLong("costcenter"), (String)String.format(msg, String.format("%s/%s", row.getString("subelementnum"), row.getString("subelementname")), resMap.get(row.getLong("resource"))));
        }
    }

    private void showUnitNoChange(DataSet resourceNoSubelementDs, AllocReport report) {
        if (resourceNoSubelementDs.isEmpty()) {
            return;
        }
        AllocReportHelper.addCheckItem((AllocReport)report, (String)"4", (String)ResManager.loadKDString((String)"\u8ba1\u5212\u8d44\u6e90\u5f52\u96c6\u5355\u7684\u8d44\u6e90\u5355\u4f4d\u65e0\u6cd5\u8f6c\u6362\u6210\u5206\u3002", (String)"PlanResourceRateCalcService_11", (String)"macc-cad-business", (Object[])new Object[0]));
        String msg = ResManager.loadKDString((String)"\u8ba1\u5212\u8d44\u6e90\u5f52\u96c6\u5355\u3010%s\u3011\u5bf9\u5e94\u7684\u8d44\u6e90\u5355\u4f4d\u65e0\u6cd5\u8f6c\u6362\u6210\u3010\u5206\u3011\u3002", (String)"PlanResourceRateCalcService_12", (String)"macc-cad-business", (Object[])new Object[0]);
        for (Row row : resourceNoSubelementDs) {
            AllocReportHelper.addCheckDatail((AllocReport)report, (String)"4", (long)row.getLong("costcenter"), (String)String.format(msg, row.getString("billno")));
        }
    }

    private void showResourceNoSubelementMsg(DataSet resourceNoSubelementDs, AllocReport report) {
        AllocReportHelper.addCheckItem((AllocReport)report, (String)"3", (String)ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3\u5bf9\u5e94\u7684\u8d44\u6e90\u672a\u5339\u914d\u4e0a\u6210\u672c\u5b50\u8981\u7d20\u3002", (String)"PlanResourceRateCalcService_13", (String)"macc-cad-business", (Object[])new Object[0]));
        if (resourceNoSubelementDs.isEmpty()) {
            return;
        }
        String msg = ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3\u4e0b\u8ba1\u5212\u8d44\u6e90\u5f52\u96c6\u5355\u3010%s\u3011\u5bf9\u5e94\u7684\u8d44\u6e90\u672a\u5339\u914d\u4e0a\u6210\u672c\u5b50\u8981\u7d20\u3002", (String)"PlanResourceRateCalcService_22", (String)"macc-cad-business", (Object[])new Object[0]);
        for (Row row : resourceNoSubelementDs) {
            AllocReportHelper.addCheckDatail((AllocReport)report, (String)"3", (long)row.getLong("costcenter"), (String)String.format(msg, row.getString("billno")));
        }
    }

    private static int savePlanResourceRateData(MfgFeeAllocImportParam importDto, DataSet resDs, Long currencyId) {
        int size = 0;
        ArrayList<Object[]> bills = new ArrayList<Object[]>(10);
        ArrayList<Object[]> entrys = new ArrayList<Object[]>(10);
        Date date = TimeServiceHelper.now();
        Long userId = RequestContext.get().getCurrUserId();
        int dataSize = resDs.copy().count("org", false);
        String[] batchNumber = CodeRuleServiceHelper.getBatchNumber((String)"cad_resourcplanrate", (DynamicObject)BusinessDataServiceHelper.newDynamicObject((String)"cad_resourcplanrate"), (String)RequestContext.get().getLoginOrg(), (int)dataSize);
        int count = 0;
        for (Row row : resDs) {
            Long id = ID.genLongId();
            Object[] bill = new Object[]{id, batchNumber[count], row.getLong("org"), row.getLong("costaccount"), row.getLong("manuorg"), row.getLong("period"), row.getLong("costcenter"), row.getLong("element"), row.getLong("subelement"), row.getBigDecimal("totalamount"), currencyId, row.getLong("resourceunit"), row.getBigDecimal("qty"), row.getBigDecimal("planrate"), "A", date, userId, date, userId, date, userId, "sca", importDto.getPlanscheme()};
            bills.add(bill);
            ++count;
            String mulresource = row.getString("mulresource");
            if (!kd.macc.cad.common.utils.CadEmptyUtils.isEmpty((String)mulresource)) {
                String[] resources;
                for (String re : resources = mulresource.split(",")) {
                    if (kd.macc.cad.common.utils.CadEmptyUtils.isEmpty((String)re)) continue;
                    entrys.add(new Object[]{ID.genLongId(), id, Long.valueOf(re)});
                }
            }
            if (bills.size() <= 500) continue;
            DB.executeBatch((DBRoute)DBRoute.of((String)"cal"), (String)INSERT_PLANRESOURCERATE_BILL_SQL, bills);
            size += bills.size();
            bills.clear();
            if (entrys.isEmpty()) continue;
            DB.executeBatch((DBRoute)DBRoute.of((String)"cal"), (String)INSERT_PLANRESOURCE_ENTRY_SQL, entrys);
            entrys.clear();
        }
        if (!bills.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"cal"), (String)INSERT_PLANRESOURCERATE_BILL_SQL, bills);
            size += bills.size();
            bills.clear();
        }
        if (!entrys.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"cal"), (String)INSERT_PLANRESOURCE_ENTRY_SQL, entrys);
            entrys.clear();
        }
        return size;
    }

    private DataSet getResourceDs(MfgFeeAllocImportParam importDto) {
        QFilter filter = new QFilter("org", "=", (Object)importDto.getOrg());
        filter.and("period", "=", (Object)importDto.getPeriod());
        filter.and("costaccount", "=", (Object)importDto.getCostaccount());
        if (!kd.macc.cad.common.utils.CadEmptyUtils.isEmpty((Set)importDto.getCostCenterIds())) {
            filter.and(new QFilter("costcenter", "in", (Object)importDto.getCostCenterIds()));
        }
        filter.and("planscheme", "=", (Object)importDto.getPlanscheme());
        return QueryServiceHelper.queryDataSet((String)"planresource", (String)"cad_planresource", (String)"org,id as resourceid,billno,manuorg,costcenter,resource,resourceunit,qty", (QFilter[])filter.toArray(), null);
    }

    private DataSet getResourceCostdriver() {
        QFilter filter = new QFilter("appnum", "=", (Object)"sca");
        String algoKey = "kd.macc.cad.algox.resourcerate.helper.PlanResourceRateImportHelper#getPlanFeeDs#getResourceInfo";
        filter.and("islinkresource", "=", (Object)Boolean.TRUE);
        filter.and("iscomplexcd", "=", (Object)Boolean.FALSE);
        filter.and("allocclass", "=", (Object)"COSTOBJECT");
        DataSet resourceDriver = QueryServiceHelper.queryDataSet((String)algoKey, (String)"cad_costdriver", (String)"id costdriverid,matchpattern,resource.fbasedataid resource,resourcetype", (QFilter[])filter.toArray(), null);
        DataSet resourceDs = resourceDriver.filter("matchpattern = 'resource'").select("costdriverid,resource");
        DataSet resourcetype = resourceDriver.filter("matchpattern = 'resourcetype'").select("costdriverid,resource,resourcetype");
        ArrayList<Object[]> datasetlist = new ArrayList<Object[]>(10);
        RowMeta rowMeta = resourcetype.getRowMeta();
        Field[] fields = rowMeta.getFields();
        for (Row row : resourcetype) {
            String[] split;
            String resourcetype1 = row.getString("resourcetype");
            for (String str : split = resourcetype1.split(",")) {
                if (CadEmptyUtils.isEmpty((String)str)) continue;
                Object[] rowData = new Object[fields.length];
                for (int i = 0; i < fields.length; ++i) {
                    Object val;
                    rowData[i] = val = row.get(i);
                }
                rowData[rowMeta.getFieldIndex((String)"resourcetype")] = str;
                datasetlist.add(rowData);
            }
        }
        resourcetype = Algo.create((String)"resourcetype").createDataSet(datasetlist.iterator(), rowMeta).select("costdriverid,resource,case when resourcetype='A' then 'mpdm_equipment' when resourcetype='B' then 'mpdm_toolsresource' when resourcetype='C' then 'mpdm_toolequip' when resourcetype='D' then 'mpdm_mould' when resourcetype='E' then 'mpdm_manuperson' end resourcetype");
        DataSet resoureAndType = QueryServiceHelper.queryDataSet((String)"mm", (String)"mpdm_resources", (String)"id as resourceid,resourcesentryentity.itemclasstype resourcetype", null, null);
        resourcetype = resourcetype.join(resoureAndType, JoinType.INNER).on("resourcetype", "resourcetype").select(resourcetype.getRowMeta().getFieldNames(), new String[]{"resourceid"}).finish();
        resourcetype = resourcetype.select("costdriverid,resourceid resource");
        resourceDs = resourceDs.union(resourcetype).distinct();
        return resourceDs;
    }

    private int delResurcePlanRate(MfgFeeAllocImportParam importDto) {
        QFilter filter = new QFilter("org", "=", (Object)importDto.getOrg());
        filter.and(new QFilter("costaccount", "=", (Object)importDto.getCostaccount()));
        filter.and(new QFilter("period", "in", (Object)importDto.getPeriod()));
        if (!kd.macc.cad.common.utils.CadEmptyUtils.isEmpty((Set)importDto.getCostCenterIds())) {
            filter.and(new QFilter("costcenter", "in", (Object)importDto.getCostCenterIds()));
        }
        filter.and("planscheme", "=", (Object)importDto.getPlanscheme());
        DataSet delBillDs = QueryServiceHelper.queryDataSet((String)"querydeletbill", (String)"cad_resourcplanrate", (String)"id", (QFilter[])filter.toArray(), null);
        ArrayList<Long> delIds = new ArrayList<Long>();
        for (Row delBill : delBillDs) {
            delIds.add(delBill.getLong("id"));
        }
        if (!delIds.isEmpty()) {
            MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"cad_resourcplanrate");
            DeleteServiceHelper.delete((IDataEntityType)dt, (Object[])delIds.toArray());
        }
        return delIds.size();
    }

    public DataSet getFeeAllocDs(MfgFeeAllocImportParam importDto, AllocReport report) {
        DataSet costdriverNotEnableDs;
        DataSet billAndStdDs;
        DataSet costdriverNullDs;
        DataSet ds = null;
        long time = System.currentTimeMillis();
        DataSet upDs = this.getDsFromUp(importDto);
        DataSet basicDs = this.getDsFromBasic(importDto);
        logger.info("\u8ba1\u5212\u8d44\u6e90\u8d39\u7387\u5f15\u5165\u67e5\u8be2\u6765\u6e90\u7ed3\u679c\u96c6\u8017\u65f6\uff1a{}ms", (Object)(System.currentTimeMillis() - time));
        ds = DataSetUtils.union((DataSet)upDs, (DataSet)basicDs);
        ds = ds.groupBy(new String[]{"org", "costaccount", "manuorg", "period", "costcenter", "expenseitem"}).sum("totalamount").finish();
        DataSet isMulStandDs = this.getMulStandOnCostCenter(importDto.getAppnum(), importDto.getOrg(), MfgFeeAllocTypeEnum.BASIXPROD.getValue(), "sca_overheadallotcost", importDto.getPeriod());
        if (!isMulStandDs.isEmpty()) {
            String tip = ResManager.loadKDString((String)"\u540c\u4e00\u4e2a\u6210\u672c\u4e2d\u5fc3\u4e0b\u7ef4\u62a4\u4e86\u591a\u4e2a\u5206\u914d\u6807\u51c6\u3002", (String)"PlanResourceRateCalcService_15", (String)"macc-cad-business", (Object[])new Object[0]);
            HashSet<Long> costCenterIds = new HashSet<Long>(16);
            for (Row row : isMulStandDs) {
                costCenterIds.add(row.getLong("costcenter"));
            }
            for (Long costcenterId : costCenterIds) {
                AllocReportHelper.addCheckDatail((AllocReport)report, (String)"2", (long)costcenterId, (String)tip);
            }
        }
        if (!(costdriverNullDs = (billAndStdDs = this.costcenterMatchStd(ds, importDto.getOrg(), importDto.getAppnum(), importDto.getPeriod())).copy().filter("costdriver is null")).isEmpty()) {
            String tips;
            DataSet feeSubelementDs = this.getFeeAndSubElementDs(importDto.getOrg(), importDto.getAppnum());
            costdriverNullDs = costdriverNullDs.leftJoin(feeSubelementDs).on("expenseitem", "expenseitem").select(costdriverNullDs.getRowMeta().getFieldNames(), new String[]{"subelement"}).finish();
            DataSet subElementDriverNullDs = costdriverNullDs.filter("subelement is null");
            DataSet expenseDriverNullDs = costdriverNullDs.filter("subelement is not null");
            if (!subElementDriverNullDs.isEmpty()) {
                tips = ResManager.loadKDString((String)"\u3010%1$s\u3011\u4e0b%2$s\u6ca1\u6709\u5728\u6210\u672c\u5b50\u8981\u7d20\u4e0e\u8d39\u7528\u9879\u76ee\u5173\u7cfb\u8868\u7ef4\u62a4\u5bf9\u5e94\u7684\u6210\u672c\u5b50\u8981\u7d20\u3002", (String)"PlanResourceRateCalcService_24", (String)"macc-cad-business", (Object[])new Object[0]);
                this.getCostcenterFeeTip(subElementDriverNullDs, tips, report);
            }
            if (!expenseDriverNullDs.isEmpty()) {
                tips = ResManager.loadKDString((String)"\u3010%1$s\u3011\u4e0b%2$s\u672a\u7ef4\u62a4\u5206\u914d\u6807\u51c6\uff0c\u8bf7\u68c0\u67e5\u6210\u672c\u4e2d\u5fc3\u5185\u5206\u914d\u6807\u51c6\u3002", (String)"PlanResourceRateCalcService_17", (String)"macc-cad-business", (Object[])new Object[0]);
                this.getCostcenterFeeTip(expenseDriverNullDs, tips, report);
            }
        }
        if (!(costdriverNotEnableDs = (billAndStdDs = billAndStdDs.filter("costdriver is not null")).copy().filter("costdriverenable = '0' or costdriverstatus in('A','B')")).isEmpty()) {
            String tips = ResManager.loadKDString((String)"\u3010%1$s\u3011\u4e0b%2$s\u9700\u8981\u91cd\u65b0\u7ef4\u62a4\u5bf9\u5e94\u7684\u5206\u914d\u6807\u51c6\u3002", (String)"PlanResourceRateCalcService_18", (String)"macc-cad-business", (Object[])new Object[0]);
            this.getCostcenterFeeTip(costdriverNotEnableDs, tips, report);
        }
        billAndStdDs = billAndStdDs.filter("costdriverenable<>'0' and costdriverstatus='C' and islinkresource=true");
        DataSet feeSubelementDs = this.getFeeAndSubElementDs(importDto.getOrg(), importDto.getAppnum());
        DataSet elementNullDs = (billAndStdDs = billAndStdDs.leftJoin(feeSubelementDs).on("expenseitem", "expenseitem").select(billAndStdDs.getRowMeta().getFieldNames(), new String[]{"element", "subelement"}).finish()).copy().filter("subelement is null or subelement=0");
        if (!elementNullDs.isEmpty()) {
            this.getFeeTip(elementNullDs, report);
        }
        billAndStdDs = billAndStdDs.filter("subelement>0");
        logger.info("\u6210\u672c\u4e2d\u5fc3\u5185\u5206\u914d\u5355\u5f15\u5165\u67e5\u8be2\u7ed3\u679c\u96c6\u8017\u65f6\uff1a{}ms", (Object)(System.currentTimeMillis() - time));
        return billAndStdDs;
    }

    protected void getCostcenterFeeTip(DataSet costdriverNullDs, String tips, AllocReport report) {
        HashMap<Long, Set> map = new HashMap<Long, Set>();
        HashSet<Long> expenseitemSet = new HashSet<Long>(256);
        while (costdriverNullDs.hasNext()) {
            Row row = costdriverNullDs.next();
            Long costcenter = row.getLong("costcenter");
            Long expenseitem = row.getLong("expenseitem");
            Set feeSet = map.computeIfAbsent(costcenter, t -> new HashSet());
            feeSet.add(expenseitem);
            expenseitemSet.add(expenseitem);
        }
        Map<Long, String> costcenterMap = this.getCostCenterMap(map.keySet());
        Map<Long, String> experMap = this.getFeeMap(expenseitemSet);
        for (Map.Entry entry : map.entrySet()) {
            Set feeSet = (Set)entry.getValue();
            StringBuilder feeSb = new StringBuilder();
            for (Long fee : feeSet) {
                feeSb.append("\u3010").append(experMap.get(fee)).append("\u3011").append(",");
                String errorMsg = String.format(tips, costcenterMap.get(entry.getKey()), experMap.get(fee));
                AllocReportHelper.addCheckDatail((AllocReport)report, (String)"2", (long)((Long)entry.getKey()), (String)errorMsg);
            }
        }
    }

    private DataSet getFeeAndSubElementDs(Long orgId, String appnum) {
        QFilter filter = new QFilter("org", "=", (Object)orgId);
        filter.and("appnum", "=", (Object)appnum);
        return QueryServiceHelper.queryDataSet((String)(ALGO_KEY_CLASS_NAME + "#getFeeAndSubElementDs"), (String)"cad_subelementexpense", (String)"element,subelement,expenseitem", (QFilter[])filter.toArray(), null);
    }

    public List<Long> getCoEntityBillIds(MfgFeeAllocImportParam importDto, String allocStatus) {
        ArrayList<Long> ids = new ArrayList<Long>();
        QFilter filter = new QFilter("org", "=", (Object)importDto.getOrg());
        filter.and("costaccount", "=", (Object)importDto.getCostaccount());
        filter.and("period", "=", (Object)importDto.getPeriod());
        filter.and("allocstatus", "=", (Object)allocStatus);
        if (importDto.isEnableFactory()) {
            filter.and("manuorg", "in", (Object)importDto.getManuorg());
        }
        filter.and("appnum", "=", (Object)importDto.getAppnum());
        filter.and("planscheme", "=", (Object)importDto.getPlanscheme());
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"getCoEntityBillIds", (String)"cad_mfgfeeallocco", (String)"id", (QFilter[])new QFilter[]{filter}, null);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                ids.add(row.getLong(0));
            }
        }
        return ids;
    }

    private DataSet costcenterMatchStd(DataSet ds, Long orgId, String appnum, Long periodId) {
        DataSet stdDs = this.getMfgAllocInnerStd(orgId, appnum, periodId);
        DataSet stdNotCostcenterDs = stdDs.copy().filter("costcenter=0");
        DataSet stdCostcenterDs = stdDs.filter("costcenter>0");
        HashSet<Long> costcenterIds = new HashSet<Long>(16);
        DataSet dsCopyDs = ds.copy();
        while (dsCopyDs.hasNext()) {
            costcenterIds.add(dsCopyDs.next().getLong("costcenter"));
        }
        HashSet<Long> setStdCostcenterIds = new HashSet<Long>();
        DataSet stdCostcenterCopyDs = stdCostcenterDs.copy();
        while (stdCostcenterCopyDs.hasNext()) {
            Long costcneterId = stdCostcenterCopyDs.next().getLong("costcenter");
            if (!costcenterIds.contains(costcneterId)) continue;
            setStdCostcenterIds.add(costcneterId);
        }
        if (!setStdCostcenterIds.isEmpty()) {
            String ids = this.getIdWithSplitStr(setStdCostcenterIds);
            DataSet hasStdDs = ds.copy().filter(String.format("costcenter in(%s)", ids));
            DataSet notStdDs = ds.filter(String.format("costcenter not in(%s)", ids));
            hasStdDs = hasStdDs.leftJoin(stdCostcenterDs).on("org", "org").on("manuorg", "manuorg").on("costcenter", "costcenter").on("expenseitem", "expenseitem").select(new String[]{"org", "costaccount", "manuorg", "period", "costcenter", "expenseitem", "totalamount"}, new String[]{"expenseitem expenseitemstd", "costdriver", "costdriverstatus", "costdriverenable", "islinkresource"}).finish();
            if (notStdDs.isEmpty()) {
                return hasStdDs;
            }
            notStdDs = notStdDs.leftJoin(stdNotCostcenterDs).on("org", "org").on("manuorg", "manuorg").on("expenseitem", "expenseitem").select(new String[]{"org", "costaccount", "manuorg", "period", "costcenter", "expenseitem", "totalamount"}, new String[]{"expenseitem expenseitemstd", "costdriver", "costdriverstatus", "costdriverenable", "islinkresource"}).finish();
            return hasStdDs.union(notStdDs);
        }
        return ds.leftJoin(stdNotCostcenterDs).on("org", "org").on("manuorg", "manuorg").on("expenseitem", "expenseitem").select(new String[]{"org", "costaccount", "manuorg", "period", "costcenter", "expenseitem", "totalamount"}, new String[]{"expenseitem expenseitemstd", "costdriver", "costdriverstatus", "costdriverenable", "islinkresource"}).finish();
    }

    public DataSet getMfgAllocInnerBySubelementStd(Long orgId, String appnum, Long periodId) {
        String algoKey = ALGO_KEY_CLASS_NAME + ".getMfgAllocInnerStd()";
        QFilter filter = new QFilter("org", "=", (Object)orgId);
        filter.and("billstatus", "=", (Object)"C");
        filter.and("appnum", "=", (Object)appnum);
        DataSet allocStdDs = QueryServiceHelper.queryDataSet((String)algoKey, (String)"sca_overheadallotcost", (String)"org,manuorg,costcenter,costcentergroup,issender,isexpense,allocmold,entryentity.expenseitem expenseitem,entryentity.subelement subelement ,entryentity.costdriver costdriver,entryentity.costdriver.status costdriverstatus,entryentity.costdriver.enable costdriverenable,entryentity.costdriver.isrelatedwork isrelatedwork,entryentity.costdriver.islinkresource islinkresource,entryentity.costdriver.unit unit", (QFilter[])filter.toArray(), null);
        DataSet costCenterGroup = this.getCostCenterGroupDs(orgId, periodId);
        DataSet costCenterSubElement = allocStdDs.filter("issender = true and isexpense = false").select("org,manuorg,costcenter,allocmold,subelement,costdriver,costdriverstatus,costdriverenable,isrelatedwork,islinkresource,unit");
        DataSet costCenterGroupSubElement = allocStdDs.filter("issender = false and isexpense = false").select("org,manuorg,costcentergroup,allocmold,subelement,costdriver,costdriverstatus,costdriverenable,isrelatedwork,islinkresource,unit");
        costCenterGroupSubElement = costCenterGroupSubElement.leftJoin(costCenterGroup).on("costcentergroup", "id").select(costCenterGroupSubElement.getRowMeta().getFieldNames(), new String[]{"costcenter"}).finish();
        costCenterSubElement = this.union(costCenterSubElement, costCenterGroupSubElement);
        return costCenterSubElement;
    }

    private String getIdWithSplitStr(Collection<Long> ids) {
        StringBuilder sb = new StringBuilder();
        for (Long id : ids) {
            sb.append(id).append(",");
        }
        return sb.toString().substring(0, sb.length() - 1);
    }

    private void getFeeTip(DataSet costdriverNullDs, AllocReport report) {
        String tips = ResManager.loadKDString((String)"%s\u6ca1\u6709\u5728\u6210\u672c\u5b50\u8981\u7d20\u4e0e\u8d39\u7528\u9879\u76ee\u5173\u7cfb\u8868\u7ef4\u62a4\u5bf9\u5e94\u7684\u6210\u672c\u5b50\u8981\u7d20\u3002", (String)"PlanResourceRateCalcService_19", (String)"macc-cad-business", (Object[])new Object[0]);
        HashSet<Long> expenseitemSet = new HashSet<Long>(16);
        while (costdriverNullDs.hasNext()) {
            Row row = costdriverNullDs.next();
            expenseitemSet.add(row.getLong("expenseitem"));
        }
        Map<Long, String> experMap = this.getFeeMap(expenseitemSet);
        for (Long expenseitem : expenseitemSet) {
            AllocReportHelper.addCheckDatail((AllocReport)report, (String)"2", (long)0L, (String)String.format(tips, experMap.get(expenseitem)));
        }
    }

    private DataSet getMfgCollocBills(MfgFeeAllocImportParam importDto) {
        String algoKey = ALGO_KEY_CLASS_NAME + ".getMfgCollocBills()";
        QFilter filter = this.getImportParamFilter(importDto, "costcenter");
        filter.and("allocmold", "=", (Object)MfgFeeAllocTypeEnum.BASIXPROD.getValue());
        return QueryServiceHelper.queryDataSet((String)algoKey, (String)"cad_planfeebill", (String)"id,billno,org,costaccount,manuorg,period,costcenter,expenseitem,0L as productgroup,totalamount,currency,currency.amtprecision amtprecision,'feebill' type, 0L costobject,0L material", (QFilter[])filter.toArray(), null);
    }

    private DataSet getDsFromUp(MfgFeeAllocImportParam importDto) {
        DataSet ds = this.getMfgCollocBills(importDto);
        DataSet nonDs = this.getNonProdBills(importDto, MfgFeeAllocTypeEnum.BASIXPROD);
        ds = this.unionDs(ds, nonDs);
        DataSet auxComDs = this.getAuxComProdBill(importDto);
        ds = this.unionDs(ds, auxComDs);
        ds = ds.groupBy(new String[]{"org", "costaccount", "manuorg", "period", "costcenter", "expenseitem", "type"}).sum("totalamount").finish();
        ds = this.replaceManuOrgFromDs(ds, importDto, "costcenter");
        DataSet basicBillAndStdDs = null;
        if (ds != null) {
            DataSet stdDs = this.getMfgAllocStd(importDto.getOrg(), MfgFeeAllocTypeEnum.BASIXPROD.getValue(), importDto.getAppnum(), importDto.getPeriod());
            stdDs = stdDs.groupBy(new String[]{"org", "manuorg", "costcenter", "execondition"}).finish();
            DataSet hasProductDs = this.getHasInputCostenterDs(importDto.getOrg(), importDto.getPeriod(), importDto.getAppnum());
            DataSet hasWipCompleteDs = this.getHasWipCompleteCenter(importDto.getOrg(), importDto.getPeriod(), importDto.getAppnum());
            stdDs = stdDs.leftJoin(hasProductDs).on("costcenter", "costcenter").select(stdDs.getRowMeta().getFieldNames(), new String[]{"id as countId"}).finish();
            stdDs = stdDs.leftJoin(hasWipCompleteDs).on("costcenter", "costcenter").select(stdDs.getRowMeta().getFieldNames(), new String[]{"completeqty"}).finish();
            DataSet noExeConditionDs = stdDs.filter("execondition == '' or execondition is null");
            DataSet hasExeConditionDs = stdDs.filter("(execondition =='NO_WORK' and countId is null) or (execondition =='NO_COM' and completeqty is null)");
            stdDs = noExeConditionDs.union(hasExeConditionDs);
            basicBillAndStdDs = ds.leftJoin(stdDs).on("org", "org").on("manuorg", "manuorg").on("costcenter", "costcenter").select(new String[]{"org", "costaccount", "manuorg", "period", "costcenter", "expenseitem", "type", "totalamount"}, new String[]{"costcenter costcenterstd"}).finish().filter("costcenterstd is null").select(new String[]{"org", "costaccount", "manuorg", "period", "costcenter", "expenseitem", "type", "totalamount"});
            return basicBillAndStdDs;
        }
        return ds;
    }

    private DataSet getDsFromBasic(MfgFeeAllocImportParam importDto) {
        DataSet ds = null;
        ds = this.getBasicCommonProdBill(importDto);
        DataSet auxDs = this.getBasicAuxProdBill(importDto);
        ds = this.unionDs(ds, auxDs);
        ds = ds.groupBy(new String[]{"org", "costaccount", "manuorg", "period", "costcenter", "expenseitem", "type"}).sum("totalamount").finish();
        return this.replaceManuOrgFromDs(ds, importDto, "costcenter");
    }

    public DataSet getAuxComProdBill(MfgFeeAllocImportParam importDto) {
        String algoKey = ALGO_KEY_CLASS_NAME + ".getAuxComProdBill()";
        QFilter filter = new QFilter("org", "=", (Object)importDto.getOrg());
        filter.and("costaccount", "=", (Object)importDto.getCostaccount());
        filter.and("period", "=", (Object)importDto.getPeriod());
        filter.and("planscheme", "=", (Object)importDto.getPlanscheme());
        if (importDto.isEnableFactory()) {
            filter.and("comentity.comsubentity.subcostcenter", "in", (Object)importDto.getCostCenterIds());
        }
        filter.and("allocstatus", "=", (Object)ScaAllocEnum.ALLOCSTATUS_CONFIRM.getValue());
        filter.and("comentity.comsubentity.subcostcenter.orgduty", "=", (Object)4L);
        String selectFields = "id,billno,org,costaccount,manuorg,period,comentity.comsubentity.subcostcenter costcenter,comentity.comsubentity.subexpenseitem expenseitem,case when allocmethod ='mutual' or allocmethod='algebra' then comentity.comsubentity.suboutamt else comentity.comsubentity.subamt end totalamount,currency,currency.amtprecision amtprecision,'aux' type,0 costobject,0 material,0 productgroup";
        return QueryServiceHelper.queryDataSet((String)algoKey, (String)"cad_planauxprodalloc", (String)selectFields, (QFilter[])filter.toArray(), null);
    }

    public DataSet getBasicCommonProdBill(MfgFeeAllocImportParam importDto) {
        String algoKey = ALGO_KEY_CLASS_NAME + ".getAuxComProdBill()";
        QFilter filter = new QFilter("org", "=", (Object)importDto.getOrg());
        filter.and("costaccount", "=", (Object)importDto.getCostaccount());
        filter.and("period", "=", (Object)importDto.getPeriod());
        filter.and("planscheme", "=", (Object)importDto.getPlanscheme());
        if (importDto.isEnableFactory()) {
            filter.and("entryentity.entrycostcenter", "in", (Object)importDto.getCostCenterIds());
        }
        filter.and("allocstatus", "=", (Object)ScaAllocEnum.ALLOCSTATUS_CONFIRM.getValue());
        filter.and("srcbilltype", "=", (Object)"A");
        filter.and("entryentity.entrycostcenter.orgduty", "=", (Object)4L);
        String selectFields = "id,org,costaccount,manuorg,period,entryentity.entrycostcenter costcenter,entryentity.entryexpenseitem expenseitem,entryentity.entryamount totalamount,'basic' type";
        return QueryServiceHelper.queryDataSet((String)algoKey, (String)"cad_planbasicalloc", (String)selectFields, (QFilter[])filter.toArray(), null);
    }

    public DataSet getBasicAuxProdBill(MfgFeeAllocImportParam importDto) {
        String algoKey = ALGO_KEY_CLASS_NAME + ".getAuxComProdBill()";
        QFilter filter = new QFilter("org", "=", (Object)importDto.getOrg());
        filter.and("costaccount", "=", (Object)importDto.getCostaccount());
        filter.and("period", "=", (Object)importDto.getPeriod());
        filter.and("planscheme", "=", (Object)importDto.getPlanscheme());
        if (importDto.isEnableFactory()) {
            filter.and("comentity.comsubentity.subcostcenter", "in", (Object)importDto.getCostCenterIds());
        }
        filter.and("allocstatus", "=", (Object)ScaAllocEnum.ALLOCSTATUS_CONFIRM.getValue());
        filter.and("srcbilltype", "=", (Object)"B");
        filter.and("comentity.comsubentity.subcostcenter.orgduty", "=", (Object)4L);
        String selectFields = "id,org,costaccount,manuorg,period,comentity.comsubentity.subcostcenter costcenter,comentity.comsubentity.subcomexpenseitem expenseitem,comentity.comsubentity.subamt totalamount,'basic_aux' type";
        return QueryServiceHelper.queryDataSet((String)algoKey, (String)"cad_planbasicalloc", (String)selectFields, (QFilter[])filter.toArray(), null);
    }
}

