/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.business.numcheck;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.business.numcheck.service.BaseNumCheckService;
import kd.macc.cad.business.numcheck.service.FactBillNumCheckServiceImpl;
import kd.macc.cad.business.numcheck.service.MatAllocNumCheckServiceImpl;
import kd.macc.cad.business.numcheck.service.MatBillNumCheckServiceImpl;
import kd.macc.cad.business.numcheck.service.PlanBillNumCheckServiceImpl;
import kd.macc.cad.business.numcheck.service.PlanResourceNumCheckServiceImpl;
import kd.macc.cad.business.numcheck.service.ResourceBillNumCheckServiceImpl;
import kd.macc.cad.common.constants.LogarithmParam;
import kd.macc.cad.common.dto.CollectDiff;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.DateUtils;

public class CollNumCheckHelper {
    private static final String BIZ_TYPE_RO = "RO";

    public static DataSet queryTotalNumDataSet(LogarithmParam param, String[] targetBills) {
        if (targetBills == null || targetBills.length == 0) {
            return null;
        }
        String billtype = targetBills[0];
        DataSet dataSet = CollNumCheckHelper.getResultDataSet(param, billtype, false);
        if (dataSet == null) {
            return null;
        }
        return dataSet.addField("'" + billtype + "'", "targetbilltype");
    }

    public static DataSet queryDetailConDataSet(LogarithmParam param, String[] targetBills) {
        if (targetBills == null || targetBills.length == 0) {
            return null;
        }
        ArrayList<DataSet> dataSetList = new ArrayList<DataSet>(5);
        DataSet resultDataSet = null;
        for (int i = 0; i < targetBills.length; ++i) {
            DataSet dataSet;
            String billtype = targetBills[i];
            if (CadEmptyUtils.isEmpty((String)billtype) || (dataSet = CollNumCheckHelper.getResultDataSet(param, billtype, true)) == null) continue;
            dataSet = dataSet.addField("'" + billtype + "'", "targetbilltype");
            if (resultDataSet == null) {
                resultDataSet = dataSet;
                continue;
            }
            dataSetList.add(dataSet);
        }
        if (resultDataSet != null && !CadEmptyUtils.isEmpty(dataSetList)) {
            resultDataSet = resultDataSet.union(dataSetList.toArray(new DataSet[0]));
        }
        return resultDataSet;
    }

    public static DataSet getResultDataSet(LogarithmParam param, String billType, boolean isDetail) {
        BaseNumCheckService numService = null;
        switch (billType) {
            case "B": {
                numService = new PlanBillNumCheckServiceImpl();
                break;
            }
            case "C": {
                numService = new FactBillNumCheckServiceImpl();
                break;
            }
            case "D": {
                numService = new ResourceBillNumCheckServiceImpl();
                break;
            }
            case "E": {
                numService = new MatBillNumCheckServiceImpl();
                break;
            }
            case "F": {
                numService = new MatAllocNumCheckServiceImpl();
                break;
            }
            case "PLAN_RESOURCE": {
                numService = new PlanResourceNumCheckServiceImpl();
            }
        }
        if (numService == null) {
            return null;
        }
        numService.setParam(param);
        if (isDetail) {
            return numService.getDetailConResultDs();
        }
        return numService.getTotalNumResultDs();
    }

    public static void getCostCenterDiff(String billType, String daterange, Long accountOrgId, String appNum, List<Long> costCenterIds, List<CollectDiff> diffs, Long planSchemed) {
        boolean costObjectRuleAllRoType = CollNumCheckHelper.isCostObjectRuleAllRoType(accountOrgId);
        if (costObjectRuleAllRoType) {
            LogarithmParam logarithmParam = new LogarithmParam();
            logarithmParam.setOrgId(accountOrgId);
            logarithmParam.setPlanSchemeId(planSchemed);
            logarithmParam.setAppnum(appNum);
            logarithmParam.setIsWareHousePoint(CollNumCheckHelper.getWareHousePoint(logarithmParam));
            logarithmParam.setCostCenterIds(costCenterIds);
            if (!CadEmptyUtils.isEmpty((String)daterange)) {
                String[] dateranges = daterange.split("\uff5e");
                Date startDate = DateUtils.parseDate((String)(dateranges[0] + " 00:00:00"));
                Date endDate = DateUtils.parseShortDate((String)(dateranges[1] + " 00:00:00"));
                logarithmParam.setStartDate(startDate);
                logarithmParam.setEndDate(endDate);
            }
            logarithmParam.setShowBizOrg(false);
            DataSet dataSet = CollNumCheckHelper.getResultDataSet(logarithmParam, billType, Boolean.TRUE);
            String csNotExistsName = ResManager.loadKDString((String)"\u6e90\u5355\u672a\u627e\u5230\u5339\u914d\u7684\u6210\u672c\u4e2d\u5fc3", (String)"CollNumCheckHelper_0", (String)"macc-cad-business", (Object[])new Object[0]);
            String suCostcenterName = ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u6210\u672c\u4e2d\u5fc3\u6620\u5c04\u6765\u6e90\u6570\u636e\u662f\u5426\u6b63\u786e\u3002", (String)"CollNumCheckHelper_1", (String)"macc-cad-business", (Object[])new Object[0]);
            String reason = ResManager.loadKDString((String)"\u672a\u5339\u914d\u5230\u6210\u672c\u4e2d\u5fc3\uff0c\u8bf7\u68c0\u67e5\u5355\u636e\u7684\u6210\u672c\u4e2d\u5fc3\u5b57\u6bb5\u662f\u5426\u6709\u503c\u6216\u6210\u672c\u4e2d\u5fc3\u5df2\u914d\u7f6e\u6620\u5c04\u89c4\u5219\u3002", (String)"CollNumCheckHelper_2", (String)"macc-cad-business", (Object[])new Object[0]);
            String suggest = ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u5355\u636e\u7684\u6210\u672c\u4e2d\u5fc3\u6216\u6210\u672c\u4e2d\u5fc3\u6620\u5c04\u914d\u7f6e\u89c4\u5219\u3002", (String)"CollNumCheckHelper_3", (String)"macc-cad-business", (Object[])new Object[0]);
            String srcNoCostCenterMappingDiffName = ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3\u6620\u5c04\u914d\u7f6e\u9519\u8bef\u6216\u8005\u672a\u914d\u7f6e", (String)"CollNumCheckHelper_4", (String)"macc-cad-business", (Object[])new Object[0]);
            if (dataSet != null) {
                for (Row row : dataSet) {
                    if (!csNotExistsName.equals(row.getString("diffreason")) && !suCostcenterName.equals(row.getString("diffreason")) && !srcNoCostCenterMappingDiffName.equals(row.getString("diffreason"))) continue;
                    CollectDiff collectDiff = new CollectDiff(row.getString("srcbillno"), row.getInteger("entryseq"), null, reason);
                    collectDiff.setSuggest(suggest);
                    diffs.add(collectDiff);
                }
            }
        }
    }

    private static boolean isCostObjectRuleAllRoType(long orgId) {
        QFilter orgQf = new QFilter("accountorg", "=", (Object)orgId);
        QFilter billStatusQf = new QFilter("status", "=", (Object)"C");
        DynamicObjectCollection costObjRule = QueryServiceHelper.query((String)"cad_costobjectrule", (String)"biztype", (QFilter[])new QFilter[]{orgQf, billStatusQf});
        for (DynamicObject rule : costObjRule) {
            String bizType = rule.getString("biztype");
            if (BIZ_TYPE_RO.equals(bizType)) continue;
            return false;
        }
        return true;
    }

    private static Boolean getWareHousePoint(LogarithmParam logarithmParam) {
        QFilter acctOrgFilter = new QFilter("accountorg", "=", (Object)logarithmParam.getOrgId());
        QFilter whFilter = new QFilter("warehousepoint", "=", (Object)Boolean.TRUE);
        QFilter appNumFilter = new QFilter("appnum", "=", (Object)logarithmParam.getAppnum());
        if (QueryServiceHelper.exists((String)"cad_sysparam", (QFilter[])new QFilter[]{acctOrgFilter, whFilter, appNumFilter})) {
            return true;
        }
        return false;
    }
}

