/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.business.numcheck.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.util.Tuple2;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.impl.ORMImpl;
import kd.bos.orm.query.QFilter;
import kd.macc.cad.business.numcheck.NumCheckService;
import kd.macc.cad.business.numcheck.service.PlanBillNumCheckServiceImpl;
import kd.macc.cad.common.constants.LogarithmParam;
import kd.macc.cad.common.dto.CollectReport;
import kd.macc.cad.common.helper.CostObjectHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.LogarithmHelper;
import kd.macc.cad.common.helper.OldCollectConfigHelper;
import kd.macc.cad.common.helper.PlanFeeAllocHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.DataSetUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class BaseNumCheckService
implements NumCheckService {
    protected static final Log logger = LogFactory.getLog(BaseNumCheckService.class);
    protected static final String ALGOPRE_KEY = "numcheck";
    protected LogarithmParam param;

    public LogarithmParam getParam() {
        return this.param;
    }

    public void setParam(LogarithmParam param) {
        this.param = param;
    }

    public abstract String getTarEntity();

    public abstract DataSet getTotalNumTarResultDs();

    public abstract DataSet getTotalNumSrcResultDs();

    @Override
    public DataSet getTotalNumResultDs() {
        DataSet targetDs = this.getTotalNumTarResultDs();
        DataSet srcDs = this.getTotalNumSrcResultDs();
        String dateStr = String.format("to_date('%s','yyyy-MM-dd')", "2000-01-01");
        if (targetDs != null) {
            targetDs = targetDs.select("manuorg,billtype,billtypename,tarauditdate,tarqty,1 tarsize," + dateStr + " as srcauditdate,0.0 srcqty,0 srcsize");
        }
        if (srcDs != null) {
            srcDs = srcDs.filter("entryId>0");
            srcDs = srcDs.select("manuorg,billtype,billtypeName," + dateStr + " tarauditdate,0.0 tarqty,0 tarsize,srcauditdate,srcqty,1 srcsize");
        }
        DataSet resultDs = null;
        if (targetDs != null) {
            resultDs = targetDs;
        }
        if (srcDs != null) {
            resultDs = resultDs == null ? srcDs : DataSetUtils.union((DataSet)resultDs, (DataSet)srcDs);
        }
        if (resultDs != null) {
            resultDs = this.param.isShowBizOrg() ? resultDs.groupBy(new String[]{"manuorg", "billtype", "billtypename"}).sum("srcqty").sum("srcsize").max("srcauditdate").sum("tarqty").sum("tarsize").max("tarauditdate").finish().addField(dateStr, "stdate") : resultDs.groupBy(new String[]{"billtype", "billtypename"}).sum("srcqty").sum("srcsize").max("srcauditdate").sum("tarqty").sum("tarsize").max("tarauditdate").finish().addField(dateStr, "stdate").addField("0L", "manuorg");
            String[] fieldNameStr = resultDs.getRowMeta().getFieldNames();
            ArrayList<String> fieldNames = new ArrayList<String>(Arrays.asList(fieldNameStr));
            fieldNames.add("srcqty-tarqty as diffqty");
            fieldNames.add("srcsize-tarsize as diffsize");
            fieldNames.remove("srcauditdate");
            fieldNames.remove("tarauditdate");
            if (this instanceof PlanBillNumCheckServiceImpl) {
                fieldNames.add("null as srcauditdate");
                fieldNames.add("null as tarauditdate");
                fieldNames.add("'0' as bizbillchange");
            } else {
                fieldNames.add("case when stdate=srcauditdate then null else srcauditdate end srcauditdate");
                fieldNames.add("case when stdate=tarauditdate then null else tarauditdate end tarauditdate");
                fieldNames.add("case when srcauditdate>tarauditdate then '1' else '0' end as bizbillchange");
            }
            resultDs = resultDs.select(fieldNames.toArray(new String[0]));
        }
        return resultDs;
    }

    @Override
    public DataSet getDetailConResultDs() {
        DataSet targetDs = this.getDetailConTarResultDs();
        DataSet srcDs = this.getDetailConSrcResultDs();
        DataSet resultDs = null;
        if (srcDs == null) {
            targetDs = targetDs.addField("0L", "entryId");
            targetDs = targetDs.addField("null", "id");
            targetDs = targetDs.addField("null", "srcauditdate");
            targetDs = targetDs.addField("''", "srcbillno");
            targetDs = targetDs.addField("1", "entryseq");
            targetDs = targetDs.addField("0.0", "srcqty");
            resultDs = targetDs = targetDs.addField("'1'", "billsrc");
        } else {
            srcDs = srcDs.filter("entryId>0");
            DataSet leftDs = srcDs.leftJoin(targetDs).on("entryId", "sourcebillentry").select(new String[]{"id", "srcauditdate", "srcbillno", "billtype", "billtypeName", "manuorg", "entryId", "entryseq", "srcqty", "billsrc"}, new String[]{"tarbillno", "tarid", "tarqty", "tarauditdate", "sourcebillentry"}).finish();
            if (this.param.isShowdiffonly()) {
                leftDs = leftDs.filter("tarid is null or tarqty<>srcqty");
            }
            DataSet rightDs = srcDs.rightJoin(targetDs).on("entryId", "sourcebillentry").select(new String[]{"id", "srcauditdate", "srcbillno", "entryId", "entryseq", "srcqty", "billsrc"}, new String[]{"billtype", "manuorg", "billtypeName", "tarbillno", "tarid", "tarqty", "tarauditdate", "sourcebillentry"}).finish().filter("id is null");
            resultDs = leftDs.union(rightDs.select(leftDs.getRowMeta().getFieldNames()));
        }
        return this.diffJudge(resultDs);
    }

    private DataSet diffJudge(DataSet resultDs) {
        ArrayList<String> fieldNames = new ArrayList<String>(Arrays.asList(resultDs.getRowMeta().getFieldNames()));
        if (this instanceof PlanBillNumCheckServiceImpl) {
            fieldNames.remove("srcauditdate");
            fieldNames.remove("tarauditdate");
            fieldNames.add("null as srcauditdate");
            fieldNames.add("null as tarauditdate");
        }
        String srcNotExistsName = ResManager.loadKDString((String)"\u6e90\u5355\u4e0d\u5b58\u5728", (String)"BaseNumCheckService_1", (String)"macc-cad-business", (Object[])new Object[0]);
        String qtyDiffName = ResManager.loadKDString((String)"\u6e90\u5355\u4e0e\u6210\u672c\u5f52\u96c6\u5355\u6570\u91cf\u5b58\u5728\u5dee\u5f02\u3002", (String)"BaseNumCheckService_2", (String)"macc-cad-business", (Object[])new Object[0]);
        String tarNotExistsName = ResManager.loadKDString((String)"\u6210\u672c\u5355\u636e\u4e0d\u5b58\u5728\u3002", (String)"BaseNumCheckService_3", (String)"macc-cad-business", (Object[])new Object[0]);
        String csNotExistsName = ResManager.loadKDString((String)"\u6e90\u5355\u672a\u627e\u5230\u5339\u914d\u7684\u6210\u672c\u4e2d\u5fc3\u3002", (String)"BaseNumCheckService_4", (String)"macc-cad-business", (Object[])new Object[0]);
        String suColName = ResManager.loadKDString((String)"\u5efa\u8bae\u91cd\u65b0\u5f52\u96c6\u3002", (String)"BaseNumCheckService_5", (String)"macc-cad-business", (Object[])new Object[0]);
        String suCostcenterName = ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u6210\u672c\u4e2d\u5fc3\u6620\u5c04\u6765\u6e90\u6570\u636e\u662f\u5426\u6b63\u786e\u3002", (String)"BaseNumCheckService_6", (String)"macc-cad-business", (Object[])new Object[0]);
        fieldNames.add("case when srcqty<>tarqty then '1' else '0' end diff");
        fieldNames.add(String.format("case when srcqty==tarqty then '' when id is not null and billsrc is null then '%s' else '%s' end suggest", suCostcenterName, suColName));
        if (!this.param.isShowBizOrg()) {
            fieldNames.remove("manuorg");
            fieldNames.add("0L as manuorg");
        }
        fieldNames.add(String.format("case when id is not null and billsrc is null then '%s' when tarid is null then '%s' when id is null then '%s' when srcqty<>tarqty then '%s' else '' end diffreason", csNotExistsName, tarNotExistsName, srcNotExistsName, qtyDiffName));
        resultDs = resultDs.select(fieldNames.toArray(new String[0]));
        return resultDs;
    }

    public abstract DataSet getDetailConTarResultDs();

    public abstract DataSet getDetailConSrcResultDs();

    protected Map<String, DataSet> getCollconfigsDataSet(LogarithmParam logarithmParam, String entity, boolean isDetail) {
        boolean isOldUserForSysParamBizRange;
        List collConfigList;
        HashMap<String, DataSet> map = new HashMap<String, DataSet>(16);
        Long orgId = logarithmParam.getOrgId();
        String appNum = logarithmParam.getAppnum();
        ORMImpl orm = new ORMImpl();
        List costCenterIds = logarithmParam.getCostCenterIds();
        if (costCenterIds == null) {
            return map;
        }
        if (logarithmParam.getCalcDimensionIds() == null) {
            Map objRules = CostObjectHelper.getCostObjectRulesMap((Long)orgId, (List)costCenterIds);
            HashSet calcDimensionIds = new HashSet(10);
            HashSet biztypes = new HashSet(10);
            objRules.values().forEach(p -> {
                calcDimensionIds.add(p.getLong("costcalcdimension"));
                biztypes.add(p.getString("biztype"));
            });
            logarithmParam.setCalcDimensionIds(calcDimensionIds);
            logarithmParam.setBiztypes(biztypes);
        }
        if (CadEmptyUtils.isEmpty((List)(collConfigList = ImportServiceHelper.getCollConfigs((Long)orgId, null, (Set)logarithmParam.getCalcDimensionIds(), (String)entity, (String)appNum, null, (Set)logarithmParam.getBiztypes())))) {
            return map;
        }
        Map collConfigMappingMap = ImportServiceHelper.getCollConfigMappingMap((List)collConfigList);
        Map collSelectValueMappingMap = ImportServiceHelper.getCollSelectValueMappingMap((List)collConfigList);
        Map collConfigFilterMap = ImportServiceHelper.getCollConfigFilterMap((List)collConfigList, (String)entity);
        if (logarithmParam.getCostCentersourceTypeDataMap() == null) {
            Map costCenterSourceDataMap = LogarithmHelper.getCostCenterSourceDataMap((List)costCenterIds, (LogarithmParam)logarithmParam);
            HashMap costCentersourceTypeDataMap = new HashMap(16);
            costCenterSourceDataMap.forEach((ccs, obj) -> {
                String[] srcDataStr = ccs.split("@");
                if (srcDataStr.length < 2) {
                    return;
                }
                String sourceType = srcDataStr[0];
                Long sourceData = Long.parseLong(srcDataStr[1]);
                costCentersourceTypeDataMap.computeIfAbsent(sourceType, p -> new HashSet(10)).add(sourceData);
            });
            logarithmParam.setCostCentersourceTypeDataMap(costCentersourceTypeDataMap);
        }
        Map billRangeMap = (isOldUserForSysParamBizRange = ImportServiceHelper.isOldUserForSysParamBizRange().booleanValue()) ? OldCollectConfigHelper.getBillRangeMap((Long)logarithmParam.getOrgId(), (List)logarithmParam.getCostCenterIds(), (String)entity, (String)logarithmParam.getAppnum(), (CollectReport)new CollectReport()) : null;
        collConfigList.forEach(arg_0 -> this.lambda$getCollconfigsDataSet$3(collConfigMappingMap, collSelectValueMappingMap, isOldUserForSysParamBizRange, billRangeMap, entity, isDetail, logarithmParam, collConfigFilterMap, (ORM)orm, map, arg_0));
        return map;
    }

    private List<QFilter> getConfigQFilter(LogarithmParam logarithmParam, String entity, String sourceBillEntity, DynamicObject config, Map<Long, List<QFilter>> collConfigFilterMap, Map<String, String> fieldMappingMap, Map<String, String> selectValueMappingMap, boolean entrySearch) {
        MainEntityType mainEntityType;
        List collConfigFilterInCenter = ImportServiceHelper.getSrcQFiltersForNoTime((Long)logarithmParam.getOrgId(), (List)logarithmParam.getCostCenterIds(), (List)logarithmParam.getBizorgIds(), (DynamicObject)config, collConfigFilterMap, fieldMappingMap, selectValueMappingMap, (Map)logarithmParam.getCostCentersourceTypeDataMap(), entrySearch ? new ArrayList(logarithmParam.getEntryIds()) : null, (Long)this.param.getCostaccountId(), null, (String)logarithmParam.getAppnum(), null, (CollectReport)new CollectReport(), null);
        if ("cad_factnedoutputbill".equals(entity) && ("im_mdc_mftmanuinbill".equals(sourceBillEntity) || "im_mdc_mftreturnbill".equals(sourceBillEntity))) {
            collConfigFilterInCenter.add(new QFilter("billtype.billformid", "=", (Object)sourceBillEntity));
        }
        ArrayList<QFilter> extraQfilters = new ArrayList<QFilter>();
        String timeField = "";
        timeField = "cad_plannedoutputbill".equals(entity) || "aca_matalloc".equals(entity) || "cad_planresource".equals(entity) ? fieldMappingMap.get("bizdate") : fieldMappingMap.get("bookdate");
        QFilter timeFilter = null;
        if (!CadEmptyUtils.isEmpty((String)timeField)) {
            if ("cad_planresource".equals(entity)) {
                List periodIds = PlanFeeAllocHelper.getPlanSchemeEnableUnclosePeriods((Long)logarithmParam.getPlanSchemeId());
                timeFilter = new QFilter(fieldMappingMap.get("period"), "in", (Object)periodIds);
            } else {
                timeFilter = new QFilter(timeField, ">=", (Object)logarithmParam.getStartDate());
                timeFilter.and(new QFilter(timeField, "<", (Object)logarithmParam.getEndDate()));
            }
            extraQfilters.add(timeFilter);
        }
        if ("sca_resourceuse".equals(entity) && "pom_mftorderreport".equals(sourceBillEntity) && logarithmParam.getIsWareHousePoint().booleanValue()) {
            extraQfilters.add(new QFilter("sumentry.warehousepoint", "=", (Object)true));
        }
        if ("sca_resourceuse".equals(entity)) {
            mainEntityType = EntityMetadataCache.getDataEntityType((String)sourceBillEntity);
            if (mainEntityType.findProperty("docbilltype") != null) {
                extraQfilters.add(new QFilter("docbilltype.billformid", "=", (Object)sourceBillEntity));
            }
        } else if (!("aca_matalloc".equals(entity) || "cad_factnedoutputbill".equals(entity) || "cal_costadjust_subentity".equals(sourceBillEntity) || (mainEntityType = EntityMetadataCache.getDataEntityType((String)sourceBillEntity)).findProperty("billtype") == null)) {
            extraQfilters.add(new QFilter("billtype.billformid", "=", (Object)sourceBillEntity));
        }
        ArrayList<QFilter> allQfInCenters = new ArrayList<QFilter>(collConfigFilterInCenter.size() + extraQfilters.size());
        allQfInCenters.addAll(collConfigFilterInCenter);
        allQfInCenters.addAll(extraQfilters);
        return allQfInCenters;
    }

    private String getQueryConfigFields(DynamicObjectCollection fields, String sourceBillEntity, String sourceBillEntityName, String entity, boolean isDetail) {
        HashSet<String> srcFields = new HashSet<String>(10);
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)sourceBillEntity);
        srcFields.add("id");
        srcFields.add(String.format("%s as srcauditdate", this.getSrcAuditDateField(mainEntityType, fields)));
        if (isDetail) {
            if (mainEntityType.findProperty("billno") != null) {
                srcFields.add("billno as srcbillno");
            } else if (mainEntityType.findProperty("number") != null) {
                srcFields.add("number AS srcbillno");
            } else {
                srcFields.add("'' AS srcbillno");
            }
        }
        if (sourceBillEntity.equals("cal_costadjust_subentity")) {
            srcFields.add("'" + sourceBillEntity + "' AS billtype ");
            srcFields.add("'" + sourceBillEntityName + "' AS billtypeName ");
        } else if (mainEntityType.findProperty("billtype") != null && mainEntityType.findProperty("billtype").getPropertyType().getName().endsWith("DynamicObject")) {
            srcFields.add("billtype.billformid AS billtype ");
            srcFields.add("billtype.billformid.name AS billtypeName ");
        } else if (mainEntityType.findProperty("docbilltype") != null && mainEntityType.findProperty("docbilltype").getPropertyType().getName().endsWith("DynamicObject")) {
            srcFields.add("docbilltype.billformid AS billtype ");
            srcFields.add("docbilltype.billformid.name AS billtypeName ");
        } else {
            srcFields.add("'" + sourceBillEntity + "' AS billtype ");
            srcFields.add("'" + sourceBillEntityName + "' AS billtypeName ");
        }
        String manuorgField = this.getSrcFieldByTar(fields, "manuorg");
        if (CadEmptyUtils.isEmpty((String)manuorgField)) {
            srcFields.add("0L as manuorg");
        } else {
            srcFields.add(manuorgField + " as manuorg");
        }
        Tuple2<String, String> entryTuple2 = this.getSrcFieldEntity(fields, mainEntityType);
        if (!StringUtils.isEmpty((CharSequence)((CharSequence)entryTuple2.t1))) {
            if (!StringUtils.isEmpty((CharSequence)((CharSequence)entryTuple2.t2))) {
                srcFields.add(String.format("%s.%s.id as entryId", entryTuple2.t1, entryTuple2.t2));
                if (isDetail) {
                    srcFields.add(String.format("%s.%s.seq as entryseq", entryTuple2.t1, entryTuple2.t2));
                }
            } else {
                srcFields.add((String)entryTuple2.t1 + ".id AS entryId");
                if (isDetail) {
                    srcFields.add((String)entryTuple2.t1 + ".seq AS entryseq");
                }
            }
        } else {
            srcFields.add("id AS entryId");
            if (isDetail) {
                srcFields.add("1 AS entryseq");
            }
        }
        srcFields.add(this.getQtyFields(entity, fields));
        if ("aca_matalloc".equals(entity)) {
            srcFields.add("bizentityobject AS bizobject");
            srcFields.add("bookdate");
            srcFields.add("entry.actualcost as srcamt");
            srcFields.add("entry.project as project");
            srcFields.add("billstatus");
        }
        return String.join((CharSequence)",", srcFields);
    }

    private String getSrcAuditDateField(MainEntityType mainEntityType, DynamicObjectCollection fields) {
        if (mainEntityType.findProperty("auditdate") != null) {
            return "auditdate";
        }
        if (mainEntityType.findProperty("bookdate") != null) {
            return "bookdate";
        }
        String bizdate = this.getSrcFieldByTar(fields, "bizdate");
        if (StringUtils.isEmpty((CharSequence)bizdate)) {
            return bizdate;
        }
        return "null";
    }

    private String getQtyFields(String entity, DynamicObjectCollection fields) {
        ArrayList<String> list = new ArrayList<String>(10);
        switch (entity) {
            case "cad_plannedoutputbill": 
            case "cad_planresource": {
                list.add("qty");
                break;
            }
            case "cad_factnedoutputbill": {
                list.add("completeqty");
                break;
            }
            case "sca_resourceuse": {
                list.add("entryentity.facthour");
                list.add("entryentity.factuse");
                list.add("entryentity.factbatch");
                break;
            }
            case "sca_matusecollect": 
            case "aca_matusecollect": {
                list.add("entryentity.qty");
                break;
            }
            case "aca_matalloc": 
            case "sca_matalloc": {
                list.add("useqty");
                break;
            }
        }
        StringBuilder sbField = new StringBuilder();
        for (String fieldName : list) {
            String sourceField = this.getSrcFieldByTar(fields, fieldName);
            if (sourceField == null) continue;
            if (sbField.length() > 0) {
                sbField.append("+");
            }
            sbField.append(sourceField);
        }
        if (sbField.length() > 0) {
            sbField.append(" as srcqty");
        } else {
            sbField.append("0.0 as srcqty");
        }
        return sbField.toString();
    }

    private Tuple2<String, String> getSrcFieldEntity(DynamicObjectCollection fields, MainEntityType mainEntityType) {
        HashSet<String> values = new HashSet<String>(16);
        String entryEntity = "";
        String subEntryEntity = "";
        for (DynamicObject obj : fields) {
            String sourcefield = obj.getString("sourcefield");
            String selectValue = obj.getString("selectvalue");
            if (!"0".equals(selectValue) || StringUtils.isEmpty((CharSequence)sourcefield)) continue;
            String[] splitValue = sourcefield.split(",");
            values.addAll(Arrays.asList(splitValue));
        }
        for (String value : values) {
            if (CadEmptyUtils.isEmpty((String)entryEntity) && value.contains(".")) {
                entryEntity = value.split("\\.")[0];
            }
            if (!CadEmptyUtils.isEmpty((String)subEntryEntity) || value.split("\\.").length < 3) continue;
            String[] split = value.split("\\.");
            String subEntry = split[1];
            Map allEntities = mainEntityType.getAllEntities();
            EntityType childreportentity = (EntityType)allEntities.get(subEntry);
            if (childreportentity == null || childreportentity.getParent() == null || !entryEntity.equals(childreportentity.getParent().getName())) continue;
            subEntryEntity = subEntry;
        }
        return new Tuple2((Object)entryEntity, (Object)subEntryEntity);
    }

    private String getSrcFieldByTar(DynamicObjectCollection fields, String field) {
        for (DynamicObject obj : fields) {
            String costfield = obj.getString("costfield");
            String sourcefield = obj.getString("sourcefield");
            String selectValue = obj.getString("selectvalue");
            if (!field.equals(costfield) || "1".equals(selectValue)) continue;
            return sourcefield;
        }
        return null;
    }

    protected DataSet getTotalSrcDataSetByBill(String billEntity) {
        Map<String, DataSet> collConfigDataSetMap = this.getCollconfigsDataSet(this.param, billEntity, false);
        DataSet dataSet = null;
        if (!collConfigDataSetMap.isEmpty()) {
            for (DataSet tempDataSet : collConfigDataSetMap.values()) {
                if (tempDataSet.getRowMeta().getFieldIndex("entryId", false) >= 0) {
                    ArrayList<String> fieldNames = new ArrayList<String>(Arrays.asList(tempDataSet.getRowMeta().getFieldNames()));
                    fieldNames.remove("manuorg");
                    tempDataSet = tempDataSet.groupBy(fieldNames.toArray(new String[0])).max("manuorg").finish();
                }
                if (dataSet == null) {
                    dataSet = tempDataSet;
                    continue;
                }
                dataSet = DataSetUtils.union((DataSet)dataSet, (DataSet)tempDataSet);
            }
        }
        return dataSet;
    }

    protected DataSet getDetailSrcDataSetByBill(String billEntity) {
        Map<String, DataSet> collConfigDataSetMap = this.getCollconfigsDataSet(this.param, billEntity, true);
        DataSet dataSet = null;
        if (!collConfigDataSetMap.isEmpty()) {
            for (DataSet tempDataSet : collConfigDataSetMap.values()) {
                if (tempDataSet.getRowMeta().getFieldIndex("entryId", false) >= 0) {
                    ArrayList<String> fieldNames = new ArrayList<String>(Arrays.asList(tempDataSet.getRowMeta().getFieldNames()));
                    fieldNames.remove("manuorg");
                    tempDataSet = tempDataSet.groupBy(fieldNames.toArray(new String[0])).max("manuorg").finish();
                }
                if (dataSet == null) {
                    dataSet = tempDataSet;
                    continue;
                }
                dataSet = DataSetUtils.union((DataSet)dataSet, (DataSet)tempDataSet);
            }
        }
        return dataSet;
    }

    private /* synthetic */ void lambda$getCollconfigsDataSet$3(Map collConfigMappingMap, Map collSelectValueMappingMap, boolean isOldUserForSysParamBizRange, Map billRangeMap, String entity, boolean isDetail, LogarithmParam logarithmParam, Map collConfigFilterMap, ORM orm, Map map, DynamicObject config) {
        List<QFilter> allQfInCenters;
        long configId = config.getLong("id");
        String billno = config.getString("number");
        String targetBillEntity = config.getString("costbill.id");
        String sourceBillEntity = config.getString("sourcebill.id");
        String sourceBillEntityName = config.getString("sourcebill.name");
        if (!CadEmptyUtils.isEmpty((Set)this.param.getBillTypes()) && !this.param.getBillTypes().contains(sourceBillEntity)) {
            return;
        }
        Map fieldMappingMap = (Map)collConfigMappingMap.get(configId);
        Map selectValueMappingMap = (Map)collSelectValueMappingMap.get(configId);
        if (isOldUserForSysParamBizRange && billRangeMap != null && !billRangeMap.containsKey("norange")) {
            if (!billRangeMap.containsKey(sourceBillEntity)) {
                logger.info("\u6e90\u5355\uff1a\u3010" + sourceBillEntity + "\u3011\uff0c\u4e0d\u5728\u76ee\u6807\u5355\u3010" + targetBillEntity + "\u3011\u8bbe\u7f6e\u7684\u5f52\u96c6\u5355\u636e\u8303\u56f4\u5185");
                return;
            }
            List ccsIds = (List)billRangeMap.get(sourceBillEntity);
            if (CadEmptyUtils.isEmpty((List)ccsIds)) {
                logger.info("\u6e90\u5355\uff1a\u3010" + sourceBillEntity + "\u3011\uff0c\u76ee\u6807\u5355\u3010" + targetBillEntity + "\u3011\uff0c\u6ca1\u6709\u9700\u8981\u5f52\u96c6\u7684\u6210\u672c\u4e2d\u5fc3");
                return;
            }
        }
        DynamicObjectCollection fields = config.getDynamicObjectCollection("fieldmapentity");
        String selectFields = this.getQueryConfigFields(fields, sourceBillEntity, sourceBillEntityName, entity, isDetail);
        DataSet tempDataInCenterSet = null;
        if (!CadEmptyUtils.isEmpty((Set)this.param.getEntryIds()) && "1".equals(this.param.getEntryIdSearchType())) {
            allQfInCenters = this.getConfigQFilter(logarithmParam, entity, sourceBillEntity, config, collConfigFilterMap, fieldMappingMap, selectValueMappingMap, false);
            List<QFilter> allQfInCenters2 = this.getConfigQFilter(logarithmParam, entity, sourceBillEntity, config, collConfigFilterMap, fieldMappingMap, selectValueMappingMap, true);
            logger.info("\u5f52\u96c6\u5bf9\u6570-\u67e5\u8be2\u6e90\u5355\uff0c\u65b9\u6848\uff1a{}\uff0c\u67e5\u8be2\u5b57\u6bb5\uff1a{}\uff0c\u6570\u636e\u6761\u4ef6\uff1a{}", new Object[]{billno, selectFields, allQfInCenters});
            DataSet costcenterDs = orm.queryDataSet("LogarithmHelper_getCollconfigsDataSet", sourceBillEntity, selectFields, allQfInCenters.toArray(new QFilter[0]), "", -1, null);
            costcenterDs = costcenterDs.addField("'1'", "billsrc");
            DataSet entryDs = orm.queryDataSet("LogarithmHelper_getCollconfigsDataSet", sourceBillEntity, selectFields, allQfInCenters2.toArray(new QFilter[0]), "", -1, null);
            entryDs = entryDs.leftJoin(costcenterDs).on("entryId", "entryId").select(entryDs.getRowMeta().getFieldNames(), new String[]{"billsrc"}).finish().filter("billsrc is null");
            tempDataInCenterSet = entryDs.union(costcenterDs);
        } else {
            allQfInCenters = this.getConfigQFilter(logarithmParam, entity, sourceBillEntity, config, collConfigFilterMap, fieldMappingMap, selectValueMappingMap, true);
            logger.info("\u5f52\u96c6\u5bf9\u6570-\u67e5\u8be2\u6e90\u5355\uff0c\u65b9\u6848\uff1a{}\uff0c\u67e5\u8be2\u5b57\u6bb5\uff1a{}\uff0c\u6570\u636e\u6761\u4ef6\uff1a{}", new Object[]{billno, selectFields, allQfInCenters});
            tempDataInCenterSet = orm.queryDataSet("LogarithmHelper_getCollconfigsDataSet", sourceBillEntity, selectFields, allQfInCenters.toArray(new QFilter[0]), "", -1, null);
            tempDataInCenterSet = tempDataInCenterSet.addField("'1'", "billsrc");
        }
        DataSet result = (DataSet)map.get(sourceBillEntity);
        if (result != null) {
            tempDataInCenterSet = result.union(tempDataInCenterSet.select(result.getRowMeta().getFieldNames()));
        }
        map.put(sourceBillEntity, tempDataInCenterSet);
    }
}

