/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.business.numcheck.service;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.business.numcheck.service.BaseNumCheckService;
import kd.macc.cad.common.constants.LogarithmParam;
import kd.macc.cad.common.helper.InFilterHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class FactBillNumCheckServiceImpl
extends BaseNumCheckService {
    @Override
    public DataSet getTotalNumTarResultDs() {
        LogarithmParam param = this.getParam();
        QFilter filter = new QFilter("org", "=", (Object)param.getOrgId());
        filter.and(new QFilter("billstatus", "=", (Object)"C"));
        if (!CadEmptyUtils.isEmpty((List)param.getBizorgIds())) {
            filter.and(new QFilter("manuorg", "in", (Object)param.getBizorgIds()));
        }
        if (!CadEmptyUtils.isEmpty((Set)param.getBillTypes())) {
            filter.and("srcbilltype", "in", (Object)param.getBillTypes());
        }
        filter.and(new QFilter("bookdate", ">=", (Object)param.getStartDate()));
        filter.and(new QFilter("bookdate", "<", (Object)param.getEndDate()));
        filter.and(new QFilter("appnum", "=", (Object)param.getAppnum()));
        if (!CadEmptyUtils.isEmpty((Set)param.getEntryIds()) && "0".equals(param.getEntryIdSearchType())) {
            filter.and(InFilterHelper.getQFilterByBachSize((String)"entryentity.costobject.probill", new ArrayList(param.getEntryIds()), (String)"in", (int)480000));
        }
        String selectField = "manuorg,id tarid,entryentity.qty tarqty,srcbilltype billtype,srcbilltype.name billtypename,nsrcauditdate tarauditdate,sourcebillentry";
        return QueryServiceHelper.queryDataSet((String)"numcheckplan", (String)this.getTarEntity(), (String)selectField, (QFilter[])new QFilter[]{filter}, null);
    }

    @Override
    public DataSet getTotalNumSrcResultDs() {
        return this.getTotalSrcDataSetByBill(this.getTarEntity());
    }

    @Override
    public DataSet getDetailConTarResultDs() {
        LogarithmParam param = this.getParam();
        QFilter filter = new QFilter("org", "=", (Object)param.getOrgId());
        filter.and(new QFilter("billstatus", "=", (Object)"C"));
        if (!CadEmptyUtils.isEmpty((List)param.getBizorgIds())) {
            filter.and(new QFilter("manuorg", "in", (Object)param.getBizorgIds()));
        }
        if (!CadEmptyUtils.isEmpty((Set)param.getBillTypes())) {
            filter.and("srcbilltype", "in", (Object)param.getBillTypes());
        }
        filter.and(new QFilter("bookdate", ">=", (Object)param.getStartDate()));
        filter.and(new QFilter("bookdate", "<", (Object)param.getEndDate()));
        filter.and(new QFilter("appnum", "=", (Object)param.getAppnum()));
        if (!CadEmptyUtils.isEmpty((Set)param.getEntryIds()) && "0".equals(param.getEntryIdSearchType())) {
            filter.and(InFilterHelper.getQFilterByBachSize((String)"entryentity.costobject.probill", new ArrayList(param.getEntryIds()), (String)"in", (int)480000));
        }
        String selectField = "billno tarbillno,manuorg,id tarid,entryentity.qty tarqty,srcbilltype billtype,srcbilltype.name billtypename,nsrcauditdate tarauditdate,sourcebillentry";
        return QueryServiceHelper.queryDataSet((String)"numcheckplan", (String)this.getTarEntity(), (String)selectField, (QFilter[])new QFilter[]{filter}, null);
    }

    @Override
    public DataSet getDetailConSrcResultDs() {
        return this.getDetailSrcDataSetByBill(this.getTarEntity());
    }

    @Override
    public String getTarEntity() {
        return "cad_factnedoutputbill";
    }
}

