/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.business.numcheck.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.FilterFunction;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.business.numcheck.service.BaseNumCheckService;
import kd.macc.cad.common.constants.LogarithmParam;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class MatAllocNumCheckServiceImpl
extends BaseNumCheckService {
    @Override
    public DataSet getTotalNumTarResultDs() {
        LogarithmParam param = this.getParam();
        QFilter filter = new QFilter("org", "=", (Object)param.getOrgId());
        if (!CadEmptyUtils.isEmpty((List)param.getBizorgIds())) {
            filter.and(new QFilter("manuorg", "in", (Object)param.getBizorgIds()));
        }
        if (!CadEmptyUtils.isEmpty((Set)param.getBillTypes())) {
            filter.and("srcbilltype", "in", (Object)param.getBillTypes());
        }
        filter.and(new QFilter("costaccount", "=", (Object)param.getCostaccountId()));
        filter.and(new QFilter("bizdate", ">=", (Object)param.getStartDate()));
        filter.and(new QFilter("bizdate", "<", (Object)param.getEndDate()));
        filter.and(new QFilter("appnum", "=", (Object)param.getAppnum()));
        String costrecordName = ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"MatAllocNumCheckServiceImpl_0", (String)"macc-cad-business", (Object[])new Object[0]);
        String selectField = "billno tarbillno,manuorg,id tarid,useqty tarqty,'cal_costrecord_subentity' billtype,'" + costrecordName + "' billtypename,auditdate tarauditdate,matusesrcbillentryid sourcebillentry";
        return QueryServiceHelper.queryDataSet((String)"numcheckplan", (String)this.getTarEntity(), (String)selectField, (QFilter[])new QFilter[]{filter}, null);
    }

    @Override
    public DataSet getTotalNumSrcResultDs() {
        return this.getTotalSrcDataSetByBill(this.getTarEntity());
    }

    @Override
    public DataSet getDetailConTarResultDs() {
        LogarithmParam param = this.getParam();
        QFilter filter = new QFilter("org", "=", (Object)param.getOrgId());
        filter.and(new QFilter("costaccount", "=", (Object)param.getCostaccountId()));
        filter.and(new QFilter("bizdate", ">=", (Object)param.getStartDate()));
        filter.and(new QFilter("bizdate", "<", (Object)param.getEndDate()));
        filter.and(new QFilter("appnum", "=", (Object)param.getAppnum()));
        String selectField = "billno tarbillno,manuorg,id tarid,useqty tarqty,useamount taramt,'' billtype,'' billtypename,auditdate tarauditdate,matusesrcbillentryid sourcebillentry";
        return QueryServiceHelper.queryDataSet((String)"numcheckplan", (String)this.getTarEntity(), (String)selectField, (QFilter[])new QFilter[]{filter}, null);
    }

    @Override
    public DataSet getDetailConSrcResultDs() {
        return this.getDetailSrcDataSetByBill(this.getTarEntity());
    }

    @Override
    public String getTarEntity() {
        if (!"sca".equals(this.getParam().getAppnum())) {
            return "aca_matalloc";
        }
        return "sca_matalloc";
    }

    @Override
    public DataSet getDetailConResultDs() {
        DataSet targetDs = this.getDetailConTarResultDs();
        DataSet srcDs = this.getDetailConSrcResultDs();
        DataSet resultDs = srcDs.leftJoin(targetDs).on("entryId", "sourcebillentry").select(new String[]{"id", "srcauditdate", "srcbillno", "billstatus", "billtype", "billtypeName", "manuorg", "entryId", "entryseq", "srcqty", "srcamt", "bizobject", "bookdate", "project", "billsrc"}, new String[]{"tarbillno", "tarid", "tarqty", "tarauditdate", "sourcebillentry", "taramt"}).finish();
        resultDs = this.diffJudge(resultDs);
        if (this.param.getProjectId() != null) {
            resultDs = resultDs.filter(new FilterFunction(){

                public boolean test(Row row) {
                    return Objects.equals(MatAllocNumCheckServiceImpl.this.param.getProjectId(), row.getLong("project"));
                }
            });
        }
        if (this.param.isShowdiffonly()) {
            resultDs = resultDs.filter("diff='1'");
        }
        return resultDs;
    }

    private DataSet diffJudge(DataSet resultDs) {
        ArrayList<String> fieldNames = new ArrayList<String>(Arrays.asList(resultDs.getRowMeta().getFieldNames()));
        String srcNoCostCenterMappingDiffSuggest = ResManager.loadKDString((String)"\u5efa\u8bae\u914d\u7f6e\u5bf9\u5e94\u7684\u6210\u672c\u4e2d\u5fc3\u6620\u5c04", (String)"MatAllocNumCheckServiceImpl_6", (String)"macc-cad-business", (Object[])new Object[0]);
        String rcAndTarDiffSuggest = ResManager.loadKDString((String)"\u5efa\u8bae\u91cd\u65b0\u6267\u884c\u5f15\u5165", (String)"MatAllocNumCheckServiceImpl_1", (String)"macc-cad-business", (Object[])new Object[0]);
        String unAuditSuggest = ResManager.loadKDString((String)"\u5efa\u8bae\u67e5\u770b\u6838\u7b97\u6210\u672c\u8bb0\u5f55\u5355\u636e\u662f\u5426\u5df2\u5ba1\u6838", (String)"MatAllocNumCheckServiceImpl_2", (String)"macc-cad-business", (Object[])new Object[0]);
        String unCollectSuggest = ResManager.loadKDString((String)"\u5efa\u8bae\u91cd\u65b0\u6267\u884c\u5f15\u5165", (String)"MatAllocNumCheckServiceImpl_1", (String)"macc-cad-business", (Object[])new Object[0]);
        String srcNoCostCenterMappingDiffName = ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3\u6620\u5c04\u914d\u7f6e\u9519\u8bef\u6216\u8005\u672a\u914d\u7f6e", (String)"MatAllocNumCheckServiceImpl_7", (String)"macc-cad-business", (Object[])new Object[0]);
        String srcAndTarDiffName = ResManager.loadKDString((String)"\u6e90\u5355\u4e0e\u76ee\u6807\u5355\u636e\u5b58\u5728\u5dee\u5f02", (String)"MatAllocNumCheckServiceImpl_3", (String)"macc-cad-business", (Object[])new Object[0]);
        String unAuditName = ResManager.loadKDString((String)"\u6838\u7b97\u6210\u672c\u8bb0\u5f55\u672a\u5ba1\u6838", (String)"MatAllocNumCheckServiceImpl_4", (String)"macc-cad-business", (Object[])new Object[0]);
        String unCollectName = ResManager.loadKDString((String)"\u6210\u672c\u672a\u5f52\u96c6", (String)"MatAllocNumCheckServiceImpl_5", (String)"macc-cad-business", (Object[])new Object[0]);
        fieldNames.add("case when srcqty<>tarqty or srcamt<>taramt  then '1' else '0' end diff");
        fieldNames.add(String.format("case when billsrc is null then '%1$s' when tarid is not null and (srcqty<>tarqty or srcamt<>taramt) then '%2$s' when tarid is null and billstatus!='C' then '%3$s' when tarid is null then '%4$s' else '' end diffreason", srcNoCostCenterMappingDiffName, srcAndTarDiffName, unAuditName, unCollectName));
        fieldNames.add(String.format("case when billsrc is null then '%1$s' when tarid is not null and (srcqty<>tarqty or srcamt<>taramt) then '%2$s' when tarid is null and billstatus!='C' then '%3$s' when tarid is null then '%4$s' else '' end suggest", srcNoCostCenterMappingDiffSuggest, rcAndTarDiffSuggest, unAuditSuggest, unCollectSuggest));
        resultDs = resultDs.select(fieldNames.toArray(new String[0]));
        return resultDs;
    }
}

