/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.business.numcheck.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.business.numcheck.service.BaseNumCheckService;
import kd.macc.cad.common.constants.LogarithmParam;
import kd.macc.cad.common.helper.InFilterHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class PlanBillNumCheckServiceImpl
extends BaseNumCheckService {
    @Override
    public DataSet getTotalNumTarResultDs() {
        LogarithmParam param = this.getParam();
        QFilter filter = new QFilter("accountorg", "=", (Object)param.getOrgId());
        filter.and(new QFilter("billstatus", "=", (Object)"C"));
        if (!CadEmptyUtils.isEmpty((List)param.getBizorgIds())) {
            filter.and(new QFilter("manuorg", "in", (Object)param.getBizorgIds()));
        }
        if (!CadEmptyUtils.isEmpty((Set)param.getBillTypes())) {
            filter.and("srcbilltype", "in", this.getBilltypes());
        }
        filter.and(new QFilter("bizdate", ">=", (Object)param.getStartDate()));
        filter.and(new QFilter("bizdate", "<", (Object)param.getEndDate()));
        filter.and(new QFilter("appnum", "=", (Object)param.getAppnum()));
        if (!CadEmptyUtils.isEmpty((Set)param.getEntryIds()) && "0".equals(param.getEntryIdSearchType())) {
            filter.and(InFilterHelper.getQFilterByBachSize((String)"sourcebillentry", new ArrayList(param.getEntryIds()), (String)"in", (int)490000));
        }
        String selectField = "manuorg,id tarid,qty tarqty,srcbilltype billtype,srcbilltype.name billtypename,bizdate tarauditdate,sourcebillentry";
        return QueryServiceHelper.queryDataSet((String)"numcheckplan", (String)this.getTarEntity(), (String)selectField, (QFilter[])new QFilter[]{filter}, null);
    }

    @Override
    public DataSet getTotalNumSrcResultDs() {
        LogarithmParam param = this.getParam();
        DataSet resultDs = null;
        if (CadEmptyUtils.isEmpty((Set)param.getBillTypes()) || param.getBillTypes().contains("pom_mftorder")) {
            resultDs = this.unionDs(resultDs, PlanBillNumCheckServiceImpl.getPomXmftOrderLog(param));
            resultDs = this.unionDs(resultDs, PlanBillNumCheckServiceImpl.getPomMftOrderSplitLog(param));
        }
        if (CadEmptyUtils.isEmpty((Set)param.getBillTypes()) || param.getBillTypes().contains("om_mftorder")) {
            resultDs = this.unionDs(resultDs, PlanBillNumCheckServiceImpl.getOmXmftOrderLog(param));
            boolean metaDataExist = MetadataDao.checkNumber((String)"om_mftorder_splitog");
            if (metaDataExist) {
                resultDs = this.unionDs(resultDs, PlanBillNumCheckServiceImpl.getOmMftOrderSplitLog(param));
            }
        }
        DataSet configResultDs = this.getTotalSrcDataSetByBill(this.getTarEntity());
        if (resultDs != null && configResultDs != null) {
            DataSet resultLastDs;
            DataSet resultCurDs = (resultDs = resultDs.leftJoin(configResultDs.copy()).on("srcbillentryid", "entryId").select(resultDs.getRowMeta().getFieldNames(), new String[]{"id", "manuorg", "srcauditdate", "billsrc"}).finish()).copy().filter("id is not null");
            if (!resultCurDs.isEmpty()) {
                configResultDs = configResultDs.union(resultCurDs.select(configResultDs.getRowMeta().getFieldNames()));
            }
            if (!(resultLastDs = resultDs.filter("id is null")).isEmpty()) {
                DataSet resultCopyDs = resultLastDs.copy();
                HashSet<Long> entryIds = new HashSet<Long>(20);
                for (Row row : resultCopyDs) {
                    entryIds.add(row.getLong("srcbillentryid"));
                }
                if (!entryIds.isEmpty()) {
                    DataSet planDs = this.getPlanDs(entryIds);
                    ArrayList<String> fieldNames = new ArrayList<String>(Arrays.asList(resultLastDs.getRowMeta().getFieldNames()));
                    fieldNames.remove("manuorg");
                    fieldNames.remove("srcauditdate");
                    resultLastDs = resultLastDs.join(planDs).on("srcbillentryid", "sourcebillentry").select(fieldNames.toArray(new String[0]), new String[]{"manuorg", "srcauditdate"}).finish();
                    if (!resultLastDs.isEmpty()) {
                        configResultDs = configResultDs.union(resultLastDs.select(configResultDs.getRowMeta().getFieldNames()));
                    }
                }
            }
        }
        return configResultDs;
    }

    private DataSet getPlanDs(Set<Long> entryIds) {
        LogarithmParam param = this.getParam();
        QFilter filter = new QFilter("accountorg", "=", (Object)param.getOrgId());
        filter.and(new QFilter("billstatus", "=", (Object)"C"));
        filter.and(new QFilter("manuorg", "in", (Object)param.getBizorgIds()));
        filter.and(new QFilter("bizdate", "<", (Object)param.getStartDate()));
        if (!CadEmptyUtils.isEmpty((Set)param.getBillTypes())) {
            filter.and("srcbilltype", "in", (Object)param.getBillTypes());
        }
        filter.and(new QFilter("appnum", "=", (Object)param.getAppnum()));
        filter.and(new QFilter("fromlogid", "=", (Object)0L));
        if (!CadEmptyUtils.isEmpty((Set)param.getEntryIds()) && "0".equals(param.getEntryIdSearchType())) {
            entryIds.retainAll(param.getEntryIds());
        }
        filter.and(new QFilter("sourcebillentry", "in", entryIds));
        String selectField = "0 as entryseq,manuorg,bizdate srcauditdate,sourcebillentry";
        return QueryServiceHelper.queryDataSet((String)"numcheckplan", (String)this.getTarEntity(), (String)selectField, (QFilter[])new QFilter[]{filter}, null);
    }

    private DataSet unionDs(DataSet ds, DataSet srcDs) {
        if (srcDs == null) {
            return ds;
        }
        if (ds == null) {
            return srcDs;
        }
        return ds.union(srcDs.select(ds.getRowMeta().getFieldNames()));
    }

    private static DataSet getPomMftOrderSplitLog(LogarithmParam param) {
        QFilter mftsplitlogFilter = new QFilter("orderstatus", "=", (Object)"C");
        String dateField = "createtime";
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"pom_mftorder_splitlog");
        if (mainEntityType.findProperty("beginbookdate") != null) {
            dateField = "billentry.beginbookdate";
        }
        mftsplitlogFilter.and(new QFilter(dateField, ">=", (Object)param.getStartDate()));
        mftsplitlogFilter.and(new QFilter(dateField, "<", (Object)param.getEndDate()));
        if (!QueryServiceHelper.exists((String)"bos_objecttype", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"pom_mftorder_splitlog")})) {
            return null;
        }
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"splitlog", (String)"pom_mftorder_splitlog", (String)"id as entryId,0 as entryseq,orderid as srcbillid,orderentryid as srcbillentryid,aftsplitqty as aftqty,befsplitqty as befqty", (QFilter[])mftsplitlogFilter.toArray(), null).distinct();
        String proBillSplit = ResManager.loadKDString((String)"\u751f\u4ea7\u5de5\u5355\u62c6\u5206\u65e5\u5fd7", (String)"PlanBillNumCheckServiceImpl_0", (String)"macc-cad-business", (Object[])new Object[0]);
        return dataSet.select("entryId,entryseq,srcbillid,srcbillentryid,aftqty-befqty as srcqty").filter("srcqty is not null").addField("'pom_mftorder_splitlog'", "billtype").addField("cast(entryId as String)", "srcbillno").addField(String.format("'%s'", proBillSplit), "billtypename");
    }

    private static DataSet getOmMftOrderSplitLog(LogarithmParam param) {
        QFilter mftsplitlogFilter = new QFilter("orderstatus", "=", (Object)"C");
        String dateField = "createtime";
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"om_mftorder_splitog");
        if (mainEntityType.findProperty("beginbookdate") != null) {
            dateField = "billentry.beginbookdate";
        }
        mftsplitlogFilter.and(new QFilter(dateField, ">=", (Object)param.getStartDate()));
        mftsplitlogFilter.and(new QFilter(dateField, "<", (Object)param.getEndDate()));
        if (!QueryServiceHelper.exists((String)"bos_objecttype", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"om_mftorder_splitog")})) {
            return null;
        }
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"splitlog", (String)"om_mftorder_splitog", (String)"id as entryId,0 as entryseq,orderid as srcbillid,orderentryid as srcbillentryid,aftsplitqty as aftqty,befsplitqty as befqty", (QFilter[])mftsplitlogFilter.toArray(), null).distinct();
        String proBillSplit = ResManager.loadKDString((String)"\u59d4\u5916\u5de5\u5355\u62c6\u5206\u65e5\u5fd7", (String)"PlanBillNumCheckServiceImpl_5", (String)"macc-cad-business", (Object[])new Object[0]);
        return dataSet.select("entryId,entryseq,srcbillid,srcbillentryid,aftqty-befqty as srcqty").filter("srcqty is not null").addField("'om_mftorder_splitog'", "billtype").addField("cast(entryId as String)", "srcbillno").addField(String.format("'%s'", proBillSplit), "billtypename");
    }

    private static DataSet getPomXmftOrderLog(LogarithmParam param) {
        QFilter mftorglogFilter = new QFilter("changestatus", "=", (Object)"B");
        String dateField = "biztime";
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"pom_xmftorderlog");
        if (mainEntityType.findProperty("beginbookdate") != null) {
            dateField = "beginbookdate";
        }
        mftorglogFilter.and(new QFilter(dateField, ">=", (Object)param.getStartDate()));
        mftorglogFilter.and(new QFilter(dateField, "<", (Object)param.getEndDate()));
        if (!QueryServiceHelper.exists((String)"bos_objecttype", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"pom_xmftorderlog")})) {
            return null;
        }
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"xmftorder", (String)"pom_xmftorderlog", (String)"id as entryId,xbillno srcbillno,0 entryseq,srcbillid,srcbillentryid,entryentity.qty as qty,0.0 srcqty", (QFilter[])new QFilter[]{mftorglogFilter}, null);
        int len = dataSet.getRowMeta().getFields().length;
        ArrayList<Object[]> dataList = new ArrayList<Object[]>(10);
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            String qty = row.getString("qty");
            BigDecimal srcqty = PlanBillNumCheckServiceImpl.parseQty(qty);
            if (srcqty == null || srcqty.compareTo(BigDecimal.ZERO) == 0) continue;
            Object[] dataRow = new Object[len];
            for (int i = 0; i < len; ++i) {
                dataRow[i] = "srcqty".equals(dataSet.getRowMeta().getFieldName(i)) ? srcqty : row.get(i);
            }
            dataList.add(dataRow);
        }
        String proBillChange = ResManager.loadKDString((String)"\u751f\u4ea7\u5de5\u5355\u53d8\u66f4\u65e5\u5fd7", (String)"PlanBillNumCheckServiceImpl_3", (String)"macc-cad-business", (Object[])new Object[0]);
        return Algo.create((String)"macc.cad.rpt").createDataSet(dataList.iterator(), dataSet.getRowMeta()).filter("srcqty != 0").addField("'pom_xmftorderlog'", "billtype").addField(String.format("'%s'", proBillChange), "billtypename").removeFields(new String[]{"qty"});
    }

    private static DataSet getOmXmftOrderLog(LogarithmParam param) {
        if (!QueryServiceHelper.exists((String)"bos_objecttype", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"om_xmftorderlog")})) {
            return null;
        }
        QFilter mftorglogFilter = new QFilter("changestatus", "=", (Object)"B");
        String dateField = "biztime";
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"om_xmftorderlog");
        if (mainEntityType.findProperty("beginbookdate") != null) {
            dateField = "beginbookdate";
        }
        mftorglogFilter.and(new QFilter(dateField, ">=", (Object)param.getStartDate()));
        mftorglogFilter.and(new QFilter(dateField, "<", (Object)param.getEndDate()));
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"xmftorderlog", (String)"om_xmftorderlog", (String)"id entryId,xbillno srcbillno,0 entryseq,srcbillid,srcbillentryid,entryentity.qty as qty,0.0 srcqty", (QFilter[])mftorglogFilter.toArray(), null);
        int len = dataSet.getRowMeta().getFields().length;
        ArrayList<Object[]> dataList = new ArrayList<Object[]>(10);
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            String qty = row.getString("qty");
            BigDecimal srcqty = PlanBillNumCheckServiceImpl.parseQty(qty);
            Object[] dataRow = new Object[len];
            for (int i = 0; i < len; ++i) {
                dataRow[i] = "srcqty".equals(dataSet.getRowMeta().getFieldName(i)) ? srcqty : row.get(i);
            }
            dataList.add(dataRow);
        }
        String outBillChange = ResManager.loadKDString((String)"\u59d4\u5916\u5de5\u5355\u53d8\u66f4\u65e5\u5fd7", (String)"PlanBillNumCheckServiceImpl_4", (String)"macc-cad-business", (Object[])new Object[0]);
        return Algo.create((String)"macc.cad.rpt").createDataSet(dataList.iterator(), dataSet.getRowMeta()).filter("srcqty != 0").addField("'om_xmftorderlog'", "billtype").addField(String.format("'%s'", outBillChange), "billtypename").removeFields(new String[]{"qty"});
    }

    private static BigDecimal parseQty(String qty) {
        if (StringUtils.isEmpty((CharSequence)qty)) {
            return BigDecimal.ZERO;
        }
        String splictStr = "->";
        if (!qty.contains(splictStr)) {
            return BigDecimal.ZERO;
        }
        String[] split = qty.trim().replace(" ", "").split(splictStr);
        if (split.length != 2) {
            return BigDecimal.ZERO;
        }
        String endQtyStr = split[1];
        if (endQtyStr.endsWith("\u2193") || endQtyStr.endsWith("\u2191")) {
            String substring = endQtyStr.substring(0, endQtyStr.length() - 1);
            try {
                BigDecimal endQty = new BigDecimal(substring);
                BigDecimal startQty = new BigDecimal(split[0]);
                return endQty.subtract(startQty);
            }
            catch (Exception e) {
                logger.error("\u6570\u91cf\u5b57\u7b26\u4e32\u89e3\u6790\u5f02\u5e38,\u53ef\u80fd\u5bfc\u81f4\u90e8\u5206\u5dee\u5f02\u5355\u6570\u91cf\u9519\u8bef\uff1a", (Throwable)e);
            }
        }
        return BigDecimal.ZERO;
    }

    @Override
    public DataSet getDetailConTarResultDs() {
        LogarithmParam param = this.getParam();
        QFilter filter = new QFilter("accountorg", "=", (Object)param.getOrgId());
        filter.and(new QFilter("billstatus", "=", (Object)"C"));
        if (!CadEmptyUtils.isEmpty((List)param.getBizorgIds())) {
            filter.and(new QFilter("manuorg", "in", (Object)param.getBizorgIds()));
        }
        if (!CadEmptyUtils.isEmpty((Set)param.getBillTypes())) {
            filter.and("srcbilltype", "in", this.getBilltypes());
        }
        filter.and(new QFilter("bizdate", ">=", (Object)param.getStartDate()));
        filter.and(new QFilter("bizdate", "<", (Object)param.getEndDate()));
        filter.and(new QFilter("appnum", "=", (Object)param.getAppnum()));
        if (!CadEmptyUtils.isEmpty((Set)param.getEntryIds()) && "0".equals(param.getEntryIdSearchType())) {
            filter.and(InFilterHelper.getQFilterByBachSize((String)"sourcebillentry", new ArrayList(param.getEntryIds()), (String)"in", (int)490000));
        }
        String selectField = "billno tarbillno,manuorg,id tarid,qty tarqty,srcbilltype billtype,srcbilltype.name billtypename,bizdate tarauditdate,sourcebillentry,fromlogid";
        DataSet ds = QueryServiceHelper.queryDataSet((String)"numcheckplan", (String)this.getTarEntity(), (String)selectField, (QFilter[])new QFilter[]{filter}, null);
        ArrayList<String> fieldNames = new ArrayList<String>(Arrays.asList(ds.getRowMeta().getFieldNames()));
        fieldNames.remove("fromlogid");
        fieldNames.remove("sourcebillentry");
        fieldNames.add("case when fromlogid>0 then fromlogid else sourcebillentry end sourcebillentry");
        ds = ds.select(fieldNames.toArray(new String[0]));
        return ds;
    }

    @Override
    public DataSet getDetailConSrcResultDs() {
        LogarithmParam param = this.getParam();
        DataSet resultDs = null;
        if (CadEmptyUtils.isEmpty((Set)param.getBillTypes()) || param.getBillTypes().contains("pom_mftorder")) {
            resultDs = this.unionDs(resultDs, PlanBillNumCheckServiceImpl.getPomXmftOrderLog(param));
            resultDs = this.unionDs(resultDs, PlanBillNumCheckServiceImpl.getPomMftOrderSplitLog(param));
        }
        if (CadEmptyUtils.isEmpty((Set)param.getBillTypes()) || param.getBillTypes().contains("om_mftorder")) {
            resultDs = this.unionDs(resultDs, PlanBillNumCheckServiceImpl.getOmXmftOrderLog(param));
            boolean metaDataExist = MetadataDao.checkNumber((String)"om_mftorder_splitog");
            if (metaDataExist) {
                resultDs = this.unionDs(resultDs, PlanBillNumCheckServiceImpl.getOmMftOrderSplitLog(param));
            }
        }
        DataSet configResultDs = this.getDetailSrcDataSetByBill(this.getTarEntity());
        if (resultDs != null && configResultDs != null) {
            DataSet resultLastDs;
            DataSet resultCurDs = (resultDs = resultDs.leftJoin(configResultDs.copy()).on("srcbillentryid", "entryId").select(resultDs.getRowMeta().getFieldNames(), new String[]{"id", "manuorg", "srcauditdate", "billsrc"}).finish()).copy().filter("id is not null");
            if (!resultCurDs.isEmpty()) {
                configResultDs = configResultDs.union(resultCurDs.select(configResultDs.getRowMeta().getFieldNames()));
            }
            if (!(resultLastDs = resultDs.filter("id is null")).isEmpty()) {
                DataSet resultCopyDs = resultLastDs.copy();
                HashSet<Long> entryIds = new HashSet<Long>(20);
                for (Row row : resultCopyDs) {
                    entryIds.add(row.getLong("srcbillentryid"));
                }
                if (!entryIds.isEmpty()) {
                    DataSet planDs = this.getPlanDs(entryIds);
                    ArrayList<String> fieldNames = new ArrayList<String>(Arrays.asList(resultLastDs.getRowMeta().getFieldNames()));
                    fieldNames.remove("manuorg");
                    fieldNames.remove("srcauditdate");
                    resultLastDs = resultLastDs.join(planDs).on("srcbillentryid", "sourcebillentry").select(fieldNames.toArray(new String[0]), new String[]{"manuorg", "srcauditdate"}).finish();
                    if (!resultLastDs.isEmpty()) {
                        configResultDs = configResultDs.union(resultLastDs.select(configResultDs.getRowMeta().getFieldNames()));
                    }
                }
            }
        }
        return configResultDs;
    }

    private Set<String> getBilltypes() {
        if (CadEmptyUtils.isEmpty((Set)this.getParam().getBillTypes())) {
            return null;
        }
        HashSet<String> billTypes = new HashSet<String>(this.getParam().getBillTypes());
        if (this.getParam().getBillTypes().contains("pom_mftorder")) {
            billTypes.add("pom_mftorder_splitlog");
            billTypes.add("pom_xmftorderlog");
        } else if (this.getParam().getBillTypes().contains("om_mftorder")) {
            billTypes.add("om_mftorder_splitog");
            billTypes.add("om_xmftorderlog");
        }
        return billTypes;
    }

    @Override
    public String getTarEntity() {
        return "cad_plannedoutputbill";
    }
}

