/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.business.planoutput;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.common.enums.CostObjectEnum;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class PlanOutputService {
    private static final Log logger = LogFactory.getLog(PlanOutputService.class);

    public static void dealBizDateModify(List<Long> planIds, Date newBizDate) {
        DynamicObject[] planOutputBills;
        QFilter filter = new QFilter("id", "in", planIds);
        String selectProps = "id,billno,bizdate,accountorg,costcenter,costobject,ismodifybizdate";
        for (DynamicObject bill : planOutputBills = BusinessDataServiceHelper.load((String)"cad_plannedoutputbill", (String)selectProps, (QFilter[])new QFilter[]{filter})) {
            bill.set("bizdate", (Object)newBizDate);
            bill.set("ismodifybizdate", (Object)Boolean.TRUE);
        }
        logger.info("\u8ba1\u5212\u751f\u4ea7\u6570\u91cf\u5f52\u96c6\u4fee\u6539\u8bb0\u8d26\u65e5\u671f\u5355\u636eid\u96c6\u5408{}", planIds);
        SaveServiceHelper.update((DynamicObject[])planOutputBills);
    }

    public static String cherckBizDateModify(List<Long> planIds, Long acctOrg) {
        StringBuilder message = new StringBuilder();
        QFilter filter = new QFilter("id", "in", planIds);
        String selectProps = "id,billno,bizdate,accountorg,costcenter,costobject";
        DynamicObject[] planOutputBills = BusinessDataServiceHelper.load((String)"cad_plannedoutputbill", (String)selectProps, (QFilter[])new QFilter[]{filter});
        ArrayList<Long> unRoPlanIds = new ArrayList<Long>(10);
        for (DynamicObject bill : planOutputBills) {
            String costCalMethod = bill.getString("costobject.biztype");
            if (CostObjectEnum.BIZTYPE_RO.getValue().equals(costCalMethod)) continue;
            unRoPlanIds.add(bill.getLong("id"));
            String billno = bill.getString("billno");
            String msg = String.format(ResManager.loadKDString((String)"%s\u5355\u636e\u6210\u672c\u8ba1\u4ef7\u65b9\u6cd5\u975e\u5de5\u5355\u6cd5\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u8bb0\u8d26\u65e5\u671f\u3002", (String)"PlanOutputService_0", (String)"macc-cad-business", (Object[])new Object[0]), billno);
            message.append(msg);
            message.append("\r\n");
        }
        Long maxPeriod = PeriodHelper.getMaxPeriodByAcctOrg((Long)acctOrg, (String)"aca");
        if (maxPeriod == 0L) {
            String msg = String.format(ResManager.loadKDString((String)"\u6240\u9009\u5355\u636e\u5bf9\u5e94\u5f53\u524d\u6838\u7b97\u7ec4\u7ec7\u4e0b\u672a\u542f\u7528\u8d26\u7c3f\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u8bb0\u8d26\u65e5\u671f\u3002", (String)"PlanOutputService_1", (String)"macc-cad-business", (Object[])new Object[0]), new Object[0]);
            message.append(msg);
            message.append("\r\n");
        } else {
            QFilter calcQf = new QFilter("org", "=", (Object)acctOrg);
            calcQf.and(new QFilter("billtype", "=", (Object)"2"));
            calcQf.and(new QFilter("type", "=", (Object)"4"));
            calcQf.and(new QFilter("period", "<", (Object)maxPeriod));
            Boolean isExistCal = QueryServiceHelper.exists((String)"aca_calcreport", (QFilter[])new QFilter[]{calcQf});
            if (isExistCal.booleanValue()) {
                HashSet<Long> periodIds = new HashSet<Long>(16);
                periodIds.add(maxPeriod);
                Map dateMap = PeriodHelper.getDateByPeriod(periodIds);
                Date beginDate = (Date)dateMap.get("begindate");
                for (DynamicObject bill : planOutputBills) {
                    Date bizdate;
                    if (unRoPlanIds.contains(bill.getLong("id")) || (bizdate = bill.getDate("bizdate")).compareTo(beginDate) >= 0) continue;
                    String billno = bill.getString("billno");
                    String msg = String.format(ResManager.loadKDString((String)"%s\u5355\u636e\u5b58\u5728\u524d\u671f\u6210\u672c\u8ba1\u7b97\u7ed3\u679c\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u8bb0\u8d26\u65e5\u671f\u3002", (String)"PlanOutputService_2", (String)"macc-cad-business", (Object[])new Object[0]), billno);
                    message.append(msg);
                    message.append("\r\n");
                }
            }
        }
        return message.toString();
    }

    public static DynamicObjectCollection getBizDateModifyInfo(List<Long> planIds) {
        if (CadEmptyUtils.isEmpty(planIds)) {
            return null;
        }
        QFilter filter = new QFilter("id", "in", planIds);
        filter.and(new QFilter("ismodifybizdate", "=", (Object)Boolean.TRUE));
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"cad_plannedoutputbill", (String)"billno,ismodifybizdate", (QFilter[])new QFilter[]{filter});
        return rows;
    }
}

