/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.business.price;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.model.OrgRelationParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.macc.cad.algox.calc.helper.BomRuleSettingStdCalcHelper;
import kd.macc.cad.common.helper.DynamicObjectHelper;
import kd.macc.cad.common.helper.ElementHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.MatBaseDataFilterHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.PriceHelper;
import kd.macc.cad.common.price.PricePluginPojo;
import kd.macc.cad.common.price.Supplier;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.DateUtils;
import kd.mpscmm.msbd.business.helper.FetchPriceHelper;

public abstract class AbstractPurchasePrice {
    private final Log logger = LogFactory.getLog(this.getClass());
    private static final String LOG_SIGN = "+++++PurchasePrice";
    protected boolean isManualspecified = false;
    protected boolean isrelatedtransaction = true;
    protected final boolean isQuota;
    protected int priceprecision = 4;
    protected final String billIden;
    protected final String billEntryIden;
    protected long exrateTable;
    protected long sourceId = 0L;
    protected long sourceUnitId = 11L;
    protected Set<Long> relatedSupplierIds = new HashSet<Long>(16);
    protected List<Long> purOrgIds = new ArrayList<Long>(10);
    private Map<Long, Set<String>> routeInfoMap;
    protected long ruleId = 0L;
    protected final Map<Long, Long[]> material2ElementArray = new HashMap<Long, Long[]>(16);

    public AbstractPurchasePrice(String billIden, String billEntryIden, boolean isQuota) {
        this.billIden = billIden;
        this.billEntryIden = billEntryIden;
        this.isQuota = isQuota;
    }

    public final List<PricePluginPojo> pricingCall(String entity, long orgId, long costTypeId, long ruleId) {
        this.ruleId = ruleId;
        this.logger.info("{} - {} \u5f00\u59cb\u53d6\u4ef7", (Object)LOG_SIGN, (Object)entity);
        ArrayList<PricePluginPojo> res = new ArrayList<PricePluginPojo>();
        long startTime = System.currentTimeMillis();
        Long purOrgId = this.getPurOrg(orgId, costTypeId);
        List<Long> proOrgIds = this.getProdOrg(orgId, costTypeId);
        Long currency = this.getCurrency(costTypeId);
        this.updatePrecision(currency);
        this.updateExrateTable(orgId);
        this.updateRuleParam(ruleId);
        if (CadEmptyUtils.isEmpty((Long)this.sourceId) && this.billIden.equals("cad_resourceout")) {
            return res;
        }
        Date curDate = new Date();
        long curtime = System.currentTimeMillis();
        Set<Long> purMatIds = this.getMaterials(proOrgIds);
        if ("cad_resourceout".equals(this.billIden)) {
            this.routeInfoMap = this.getRouteInfoMap(orgId, costTypeId, proOrgIds, purMatIds);
            purMatIds.retainAll(this.routeInfoMap.keySet());
        }
        this.logger.info("{} - {} \u7b2c\u4e00\u6b65: \u83b7\u53d6\u7269\u6599\u7ed3\u675f\u3002\u7528\u65f6\uff1a{} ", new Object[]{LOG_SIGN, entity, System.currentTimeMillis() - curtime});
        this.logger.info("{} - {} \u83b7\u53d6\u7269\u6599\u603b\u6570: {} ", new Object[]{LOG_SIGN, entity, purMatIds.size()});
        curtime = System.currentTimeMillis();
        this.material2ElementArray.putAll(ElementHelper.getDefSubEles((Long)orgId, purMatIds));
        Map<String, BigDecimal> matToManuPrice = null;
        matToManuPrice = "cad_purprices".equals(this.billIden) ? this.getMatToManuPrice(curDate, purMatIds, costTypeId, ruleId) : this.getMatToManuPrice(curDate, purMatIds, costTypeId);
        this.logger.info("{} - {} \u7b2c\u4e8c\u6b65: \u67e5\u8be2\u7269\u6599\u6210\u672c\u4fe1\u606f\u6807\u51c6\u6210\u672c\u7ed3\u675f\u3002\u7528\u65f6\uff1a{} ", new Object[]{LOG_SIGN, entity, System.currentTimeMillis() - curtime});
        this.logger.info("{} - {} \u7f13\u5b58\u7684\u7269\u6599\u6210\u672c\u4fe1\u606f\u603b\u6570: {} ", new Object[]{LOG_SIGN, entity, matToManuPrice.size()});
        curtime = System.currentTimeMillis();
        List<Map<String, Object>> collectParams = this.invokeQuotaService(purOrgId, curDate, purMatIds);
        this.logger.info("{} - {} \u7b2c\u4e09\u6b65: \u8c03\u7528\u914d\u989d\u63a5\u53e3\u7ed3\u675f\u3002\u7528\u65f6\uff1a{}\uff0c\u7ed3\u679c\uff1a{} ", new Object[]{LOG_SIGN, entity, System.currentTimeMillis() - curtime, collectParams.size()});
        curtime = System.currentTimeMillis();
        HashSet<Long> keyIds = new HashSet<Long>(16);
        List<DynamicObject> purPricesDOList = this.pkgFetchPriceParams(collectParams, ruleId, keyIds, purMatIds);
        this.logger.info("{} - {} \u7b2c\u56db\u6b65: \u7ec4\u88c5\u91c7\u8d2d\u53d6\u4ef7\u63a5\u53e3\u53c2\u6570\u7ed3\u675f\u3002\u7528\u65f6\uff1a{} ", new Object[]{LOG_SIGN, entity, System.currentTimeMillis() - curtime});
        curtime = System.currentTimeMillis();
        Map<String, BigDecimal> finalMatToManuPrice = matToManuPrice;
        Lists.partition(purPricesDOList, (int)10000).forEach(list -> {
            HashMap<Long, List> billMaps = new HashMap<Long, List>(16);
            billMaps.put(purOrgId, (List)list);
            Map fetchPriceResult = FetchPriceHelper.integrationFetchPrice(billMaps, (String)this.billIden, new HashMap());
            this.logger.info("integrationFetchPrice--\u300bresult\uff1a{}", (Object)(fetchPriceResult == null ? 0 : fetchPriceResult.size()));
            if (fetchPriceResult == null || fetchPriceResult.isEmpty()) {
                return;
            }
            Map fetchPriceMap = (Map)fetchPriceResult.get(purOrgId);
            this.logger.info("integrationFetchPrice--\u300bfetchPriceMap--\u300bresult\uff1a{}", (Object)(fetchPriceMap == null ? 0 : fetchPriceMap.size()));
            this.pkgResultData((List<PricePluginPojo>)res, currency, (List<DynamicObject>)list, fetchPriceMap, finalMatToManuPrice, ruleId);
        });
        this.logger.info("{} - {} \u7b2c\u4e94\u6b65: \u8c03\u7528\u53d6\u4ef7\u63a5\u53e3\u7ed3\u675f\u3002\u7528\u65f6\uff1a{} ", new Object[]{LOG_SIGN, entity, System.currentTimeMillis() - curtime});
        this.logger.info("{} - {} \u53d6\u4ef7\u64cd\u4f5c\u5b8c\u6210\u3002\u603b\u7528\u65f6\uff1a{} ", new Object[]{LOG_SIGN, entity, System.currentTimeMillis() - startTime});
        return res;
    }

    public Long getPurOrg(long orgId, long costtypeId) {
        Long returnPurOrgId = -1L;
        boolean isMulFactory = OrgHelper.isOrgEnableMultiFactory((Long)orgId);
        if (isMulFactory) {
            QFilter costTypeQf = new QFilter("id", "=", (Object)costtypeId);
            costTypeQf.and("costtypeentry.costtypeattr", "=", (Object)"0");
            DynamicObject cadCosttypeEntry = QueryServiceHelper.queryOne((String)"cad_costtype", (String)"costtypeentry.costtype arrcosttype", (QFilter[])costTypeQf.toArray());
            if (cadCosttypeEntry == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u53d6\u4ef7\u7684\u6a21\u578b\u6210\u672c\u7c7b\u578b\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AbstractPurchasePrice_6", (String)"macc-cad-business", (Object[])new Object[0]));
            }
            long arrcosttype = cadCosttypeEntry.getLong("arrcosttype");
            if (CadEmptyUtils.isEmpty((Long)arrcosttype)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u53d6\u4ef7\u7684\u6a21\u62df\u6210\u672c\u7c7b\u578b\u672a\u6307\u5b9a\u6838\u7b97\u6210\u672c\u7c7b\u578b\u3002", (String)"AbstractPurchasePrice_1", (String)"macc-cad-business", (Object[])new Object[0]));
            }
            QFilter costTypeOrgQf = new QFilter("costtype", "=", (Object)arrcosttype);
            costTypeOrgQf.and("calorg", "=", (Object)orgId);
            costTypeOrgQf.and("bizstatus", "=", (Object)"1");
            costTypeOrgQf.and("effectdate", "<=", (Object)new Date());
            costTypeOrgQf.and("invaliddate", ">", (Object)new Date());
            DynamicObject calBdCosttypeorg = QueryServiceHelper.queryOne((String)"cal_bd_costtypeorg", (String)"calorg,storageorgunit,costtype", (QFilter[])costTypeOrgQf.toArray());
            if (calBdCosttypeorg == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u53d6\u4ef7\u7ec4\u7ec7\u5f00\u542f\u4e86\u591a\u5de5\u5382\uff0c\u672a\u80fd\u6839\u636e\u6838\u7b97\u6210\u672c\u7c7b\u578b\uff0c\u5728\u7ec4\u7ec7\u4e0e\u6210\u672c\u7c7b\u578b\u5bf9\u5e94\u8868\u627e\u5230\u5e93\u5b58\u7ec4\u7ec7\u3002", (String)"AbstractPurchasePrice_2", (String)"macc-cad-business", (Object[])new Object[0]));
            }
            long strOrgId = calBdCosttypeorg.getLong("storageorgunit");
            if (CadEmptyUtils.isEmpty((Long)strOrgId)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u53d6\u4ef7\u7ec4\u7ec7\u5f00\u542f\u4e86\u591a\u5de5\u5382\uff0c\u672a\u80fd\u6839\u636e\u6838\u7b97\u6210\u672c\u7c7b\u578b\uff0c\u5728\u7ec4\u7ec7\u4e0e\u6210\u672c\u7c7b\u578b\u5bf9\u5e94\u8868\u627e\u5230\u5e93\u5b58\u7ec4\u7ec7\u3002", (String)"AbstractPurchasePrice_2", (String)"macc-cad-business", (Object[])new Object[0]));
            }
            boolean isPurchase = OrgUnitServiceHelper.checkOrgFunction((Long)strOrgId, (String)"02");
            if (isPurchase) {
                returnPurOrgId = strOrgId;
            }
            Long purOrgId = orgId;
            OrgRelationParam param = new OrgRelationParam();
            param.setNumber("org2purchase");
            param.setOrgId(strOrgId);
            param.setToViewType("02");
            param.setFromViewType("15");
            param.setDirectViewType("toorg");
            param.setIncludeSelf(false);
            Map relationMap = OrgUnitServiceHelper.getOrgRelation((OrgRelationParam)param);
            List realtionInfo = (List)relationMap.get("data");
            for (Map stringObjectMap : realtionInfo) {
                purOrgId = (Long)stringObjectMap.get("orgId");
                this.purOrgIds.add(purOrgId);
                if (!Boolean.TRUE.equals(stringObjectMap.get("isDefault"))) continue;
                returnPurOrgId = returnPurOrgId == -1L ? purOrgId : returnPurOrgId;
            }
            returnPurOrgId = returnPurOrgId == -1L ? purOrgId : returnPurOrgId;
        } else {
            boolean isPurchase = OrgUnitServiceHelper.checkOrgFunction((Long)orgId, (String)"02");
            if (isPurchase) {
                returnPurOrgId = orgId;
            }
            Long purOrgId = orgId;
            OrgRelationParam param = new OrgRelationParam();
            param.setNumber("orgunit2accounting");
            param.setOrgId(orgId);
            param.setToViewType("10");
            param.setFromViewType("02");
            param.setDirectViewType("fromorg");
            param.setIncludeSelf(false);
            Map relationMap = OrgUnitServiceHelper.getOrgRelation((OrgRelationParam)param);
            List realtionInfo = (List)relationMap.get("data");
            for (Map stringObjectMap : realtionInfo) {
                purOrgId = (Long)stringObjectMap.get("orgId");
                this.purOrgIds.add(purOrgId);
                if (!Boolean.TRUE.equals(stringObjectMap.get("isDefault"))) continue;
                returnPurOrgId = returnPurOrgId == -1L ? purOrgId : returnPurOrgId;
            }
            returnPurOrgId = returnPurOrgId == -1L ? purOrgId : returnPurOrgId;
        }
        return returnPurOrgId;
    }

    public List<Long> getProdOrg(long orgId, long costtypeId) {
        ArrayList<Long> prodOrgs = new ArrayList<Long>(10);
        boolean isMulFactory = OrgHelper.isOrgEnableMultiFactory((Long)orgId);
        if (isMulFactory) {
            QFilter costTypeQf = new QFilter("id", "=", (Object)costtypeId);
            costTypeQf.and("costtypeentry.costtypeattr", "=", (Object)"0");
            DynamicObject cadCosttypeEntry = QueryServiceHelper.queryOne((String)"cad_costtype", (String)"costtypeentry.costtype arrcosttype", (QFilter[])costTypeQf.toArray());
            if (cadCosttypeEntry == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6a21\u62df\u6210\u672c\u7c7b\u578b\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AbstractPurchasePrice_0", (String)"macc-cad-business", (Object[])new Object[0]));
            }
            long arrcosttype = cadCosttypeEntry.getLong("arrcosttype");
            if (CadEmptyUtils.isEmpty((Long)arrcosttype)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u53d6\u4ef7\u7684\u6a21\u62df\u6210\u672c\u7c7b\u578b\u672a\u6307\u5b9a\u6838\u7b97\u6210\u672c\u7c7b\u578b\u3002", (String)"AbstractPurchasePrice_1", (String)"macc-cad-business", (Object[])new Object[0]));
            }
            QFilter costTypeOrgQf = new QFilter("costtype", "=", (Object)arrcosttype);
            costTypeOrgQf.and("calorg", "=", (Object)orgId);
            costTypeOrgQf.and("bizstatus", "=", (Object)"1");
            costTypeOrgQf.and("effectdate", "<=", (Object)new Date());
            costTypeOrgQf.and("invaliddate", ">", (Object)new Date());
            DynamicObjectCollection calBdCosttypeOrgs = QueryServiceHelper.query((String)"cal_bd_costtypeorg", (String)"calorg,storageorgunit,costtype", (QFilter[])costTypeOrgQf.toArray());
            if (CadEmptyUtils.isEmpty((DynamicObjectCollection)calBdCosttypeOrgs)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u53d6\u4ef7\u7ec4\u7ec7\u5f00\u542f\u4e86\u591a\u5de5\u5382\uff0c\u672a\u80fd\u6839\u636e\u6838\u7b97\u6210\u672c\u7c7b\u578b\uff0c\u5728\u7ec4\u7ec7\u4e0e\u6210\u672c\u7c7b\u578b\u5bf9\u5e94\u8868\u627e\u5230\u5e93\u5b58\u7ec4\u7ec7\u3002", (String)"AbstractPurchasePrice_2", (String)"macc-cad-business", (Object[])new Object[0]));
            }
            ArrayList<Long> invOrgs = new ArrayList<Long>(10);
            for (DynamicObject calBdCosttypeOrg : calBdCosttypeOrgs) {
                long storageOrgUnit = calBdCosttypeOrg.getLong("storageorgunit");
                if (CadEmptyUtils.isEmpty((Long)storageOrgUnit)) continue;
                invOrgs.add(storageOrgUnit);
            }
            if (CadEmptyUtils.isEmpty(invOrgs)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u53d6\u4ef7\u7ec4\u7ec7\u5f00\u542f\u4e86\u591a\u5de5\u5382\uff0c\u672a\u80fd\u6839\u636e\u6838\u7b97\u6210\u672c\u7c7b\u578b\uff0c\u5728\u7ec4\u7ec7\u4e0e\u6210\u672c\u7c7b\u578b\u5bf9\u5e94\u8868\u627e\u5230\u5e93\u5b58\u7ec4\u7ec7\u3002", (String)"AbstractPurchasePrice_2", (String)"macc-cad-business", (Object[])new Object[0]));
            }
            for (Long invOrg : invOrgs) {
                boolean isProduce = OrgUnitServiceHelper.checkOrgFunction((Long)invOrg, (String)"04");
                if (!isProduce) continue;
                prodOrgs.add(invOrg);
            }
            if (CadEmptyUtils.isEmpty(prodOrgs)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7ec4\u7ec7\u4e0e\u6210\u672c\u7c7b\u578b\u5bf9\u5e94\u8868\u4e2d\uff0c\u6210\u672c\u7c7b\u578b\u5173\u8054\u7684\u5e93\u5b58\u7ec4\u7ec7\u6ca1\u6709\u751f\u4ea7\u804c\u80fd\u3002", (String)"AbstractPurchasePrice_4", (String)"macc-cad-business", (Object[])new Object[0]));
            }
        } else {
            OrgRelationParam param = new OrgRelationParam();
            param.setNumber("Accounting_TO_Production_S");
            param.setOrgId(orgId);
            param.setToViewType("04");
            param.setFromViewType("10");
            param.setDirectViewType("toorg");
            param.setIncludeSelf(true);
            List bizRelationOrgIds = OrgUnitServiceHelper.getBizRelationOrgIds((OrgRelationParam)param);
            if (!CadEmptyUtils.isEmpty((List)bizRelationOrgIds)) {
                prodOrgs.addAll(bizRelationOrgIds);
            }
            if (CadEmptyUtils.isEmpty(prodOrgs)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u6ca1\u6709\u751f\u4ea7\u804c\u80fd\uff0c\u4e14\u6ca1\u6709\u59d4\u6258\u7684\u9ed8\u8ba4\u751f\u4ea7\u7ec4\u7ec7\u3002", (String)"AbstractPurchasePrice_5", (String)"macc-cad-business", (Object[])new Object[0]));
            }
        }
        return prodOrgs;
    }

    public abstract Set<Long> getMaterials(List<Long> var1);

    public Long getCurrency(long costTypeId) {
        DynamicObject costTypeDo = QueryServiceHelper.queryOne((String)"cad_costtype", (String)"currency", (QFilter[])new QFilter("id", "=", (Object)costTypeId).toArray());
        return costTypeDo == null ? 1L : costTypeDo.getLong("currency");
    }

    public void updatePrecision(Long currency) {
        DynamicObject currencyDO = QueryServiceHelper.queryOne((String)"bd_currency", (String)"amtprecision, priceprecision", (QFilter[])new QFilter("id", "=", (Object)currency).toArray());
        this.priceprecision = currencyDO.getInt("priceprecision");
    }

    public void updateExrateTable(long orgId) {
        QFilter orgFilter = new QFilter("calorg", "=", (Object)orgId);
        orgFilter.and(new QFilter("enable", "=", (Object)"1"));
        DynamicObjectCollection accountBooks = QueryServiceHelper.query((String)"cal_bd_costaccount", (String)"calpolicy.exratetable.id exratetableid,ismainaccount", (QFilter[])new QFilter[]{orgFilter}, (String)"number asc");
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)accountBooks)) {
            this.exrateTable = 0L;
            return;
        }
        for (DynamicObject accountBook : accountBooks) {
            boolean ismainaccount;
            long exratetableid = accountBook.getLong("exratetableid");
            if (CadEmptyUtils.isEmpty((Long)this.exrateTable)) {
                this.exrateTable = exratetableid;
            }
            if (!(ismainaccount = accountBook.getBoolean("ismainaccount"))) continue;
            this.exrateTable = exratetableid;
            return;
        }
    }

    private void updateRuleParam(long ruleId) {
        DynamicObject calcRuleDo = QueryServiceHelper.queryOne((String)"cad_calcrule", (String)"manualspecified,source,source.resourceunit.id sourceunit,isrelatedtransaction", (QFilter[])new QFilter("id", "=", (Object)ruleId).toArray());
        if (calcRuleDo != null) {
            this.isManualspecified = calcRuleDo.getBoolean("manualspecified");
            this.sourceId = calcRuleDo.getLong("source");
            this.isrelatedtransaction = calcRuleDo.getBoolean("isrelatedtransaction");
        }
    }

    public Map<String, BigDecimal> getMatToManuPrice(Date curDate, Set<Long> purMatIds, long costTypeId) {
        HashMap<String, BigDecimal> matToManuPrice = new HashMap<String, BigDecimal>(16);
        QFilter qFilter = new QFilter("id", "=", (Object)costTypeId).and("costtypeentry.costtypeattr", "=", (Object)"0");
        DynamicObject costtype = QueryServiceHelper.queryOne((String)"cad_costtype", (String)"costtypeentry.costtype", (QFilter[])qFilter.toArray());
        if (costtype == null) {
            return matToManuPrice;
        }
        QFilter purPricesQF = new QFilter("costtype", "=", (Object)costtype.getLong("costtypeentry.costtype")).and("material", "in", purMatIds).and("effectdate", "<=", (Object)curDate).and("expdate", ">", (Object)curDate);
        String amount = this.billIden.equals("cad_outsourceprice") ? "price" : "amount";
        DataSet purPricesDC = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)this.billIden, (String)("material, " + amount), (QFilter[])purPricesQF.toArray(), null);
        while (purPricesDC.hasNext()) {
            Row row = purPricesDC.next();
            matToManuPrice.put(row.getString("material"), row.getBigDecimal(amount));
        }
        return matToManuPrice;
    }

    public Map<String, BigDecimal> getMatToManuPrice(Date curDate, Set<Long> purMatIds, long costTypeId, long ruleId) {
        HashMap<String, BigDecimal> matToManuPrice = new HashMap<String, BigDecimal>(16);
        QFilter qFilter = new QFilter("id", "=", (Object)costTypeId).and("costtypeentry.costtypeattr", "=", (Object)"0");
        DynamicObject costtype = QueryServiceHelper.queryOne((String)"cad_costtype", (String)"costtypeentry.costtype", (QFilter[])qFilter.toArray());
        if (costtype == null) {
            return matToManuPrice;
        }
        QFilter purPricesQF = new QFilter("costtype", "=", (Object)costtype.getLong("costtypeentry.costtype")).and("material", "in", purMatIds).and("effectdate", "<=", (Object)curDate).and("expdate", ">", (Object)curDate);
        DataSet purPricesDataSet = QueryServiceHelper.queryDataSet((String)"getMatToManuPrice#1", (String)"cad_purprices", (String)"material,entryentity.element element,entryentity.subelement subelement,entryentity.price price", (QFilter[])purPricesQF.toArray(), null);
        if (purPricesDataSet.isEmpty()) {
            return matToManuPrice;
        }
        QFilter filter = new QFilter("id", "=", (Object)ruleId);
        DataSet priceRuleDataSet = QueryServiceHelper.queryDataSet((String)"getMatToManuPrice#1", (String)"cad_calcrule", (String)"entryentity.element element,entryentity.pricelisttype pricelisttype", (QFilter[])new QFilter[]{filter}, null);
        if ((priceRuleDataSet = priceRuleDataSet.filter("element>0 and pricelisttype>0")).isEmpty()) {
            purPricesDataSet = purPricesDataSet.groupBy(new String[]{"material"}).sum("price").finish();
            while (purPricesDataSet.hasNext()) {
                Row row = purPricesDataSet.next();
                matToManuPrice.put(row.getString("material"), row.getBigDecimal("price"));
            }
            return matToManuPrice;
        }
        if (CadEmptyUtils.isEmpty(this.material2ElementArray)) {
            return matToManuPrice;
        }
        ArrayList<Object[]> defEleDatas = new ArrayList<Object[]>(10);
        for (Map.Entry<Long, Long[]> entry : this.material2ElementArray.entrySet()) {
            Long[] value = entry.getValue();
            Object[] objects = new Object[]{entry.getKey(), value[0], value[1]};
            Object[] objects1 = new Object[]{entry.getKey(), 773141433937984512L, 773175492709890048L};
            defEleDatas.add(objects);
            defEleDatas.add(objects1);
        }
        DataSet defEleDataSet = Algo.create((String)"macc-cad-business").createDataSet(defEleDatas.iterator(), new RowMeta(new Field[]{new Field("material", (DataType)DataType.LongType), new Field("element", (DataType)DataType.LongType), new Field("subelement", (DataType)DataType.LongType)}));
        purPricesDataSet = purPricesDataSet.join(priceRuleDataSet, JoinType.INNER).on("element", "element").select(purPricesDataSet.getRowMeta().getFieldNames(), new String[]{"pricelisttype"}).finish();
        DataSet finishDataSet = purPricesDataSet.join(defEleDataSet, JoinType.INNER).on("material", "material").on("element", "element").on("subelement", "subelement").select(purPricesDataSet.getRowMeta().getFieldNames()).finish();
        finishDataSet = finishDataSet.groupBy(new String[]{"material", "element"}).sum("price").finish();
        finishDataSet = finishDataSet.filter("element == 773126985240072192");
        while (finishDataSet.hasNext()) {
            Row row = finishDataSet.next();
            matToManuPrice.put(row.getString("material"), row.getBigDecimal("price"));
        }
        return matToManuPrice;
    }

    public List<Map<String, Object>> invokeQuotaService(Long purOrgId, Date curDate, Set<Long> purMatIds) {
        ArrayList<Map<String, Object>> collectParams = new ArrayList<Map<String, Object>>(purMatIds.size());
        Set<Long> noQuoteMaterials = this.doQuote(purOrgId, curDate, purMatIds, collectParams);
        for (Long orgId : this.purOrgIds) {
            noQuoteMaterials = this.doQuote(orgId, curDate, noQuoteMaterials, collectParams);
        }
        for (Long matId : noQuoteMaterials) {
            HashMap<String, Object> mapper = new HashMap<String, Object>(16);
            mapper.put("purchaseOrgId", purOrgId);
            mapper.put("materialId", matId);
            mapper.put("bizDate", DateUtils.formatDate((Date)curDate, (String)"yyyy-MM-dd"));
            mapper.put("srcBillId", 0L);
            mapper.put("srcBillEntryId", 0L);
            mapper.put("entry", new ArrayList());
            collectParams.add(mapper);
        }
        return collectParams;
    }

    private Set<Long> doQuote(Long purOrgId, Date curDate, Set<Long> purMatIds, List<Map<String, Object>> collectParams) {
        if (!this.isQuota) {
            return purMatIds;
        }
        if (!this.isrelatedtransaction) {
            this.relatedSupplierIds = this.getRelatedSupplierIds();
        }
        HashSet<Long> noQuoteMaterial = new HashSet<Long>(16);
        for (Long purMatId : purMatIds) {
            HashMap<String, Object> mapper = new HashMap<String, Object>(16);
            mapper.put("purchaseOrgId", purOrgId);
            mapper.put("materialId", purMatId);
            mapper.put("bizDate", DateUtils.formatDate((Date)curDate, (String)"yyyy-MM-dd"));
            mapper.put("srcBillId", 0L);
            mapper.put("srcBillEntryId", 0L);
            ArrayList entry = new ArrayList();
            String jsonResult = this.doQuoteService(mapper);
            JSONObject result = JSON.parseObject((String)jsonResult);
            if (result.getBoolean("success").booleanValue()) {
                JSONArray datas = result.getJSONArray("data");
                for (int i = 0; i <= datas.size() - 1; ++i) {
                    if (!datas.getJSONObject(i).getLong("priorityLevel").equals(1L)) continue;
                    HashMap<String, Number> ent = new HashMap<String, Number>(8);
                    Long supplierId = datas.getJSONObject(i).getLong("supplierId");
                    if (!this.isrelatedtransaction && !this.relatedSupplierIds.contains(supplierId)) continue;
                    ent.put("supplierId", supplierId);
                    ent.put("quotaRate", datas.getJSONObject(i).getBigDecimal("quotaRate"));
                    entry.add(ent);
                }
            }
            mapper.put("entry", entry);
            if (entry.isEmpty()) {
                noQuoteMaterial.add(purMatId);
                continue;
            }
            collectParams.add(mapper);
        }
        return noQuoteMaterial;
    }

    private String doQuoteService(Map<String, Object> mapper) {
        String jsonResult = (String)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"pm", (String)"QuotaService", (String)"invokeQuotaSchemaService", (Object[])new Object[]{String.valueOf(new JSONObject(mapper))});
        return jsonResult;
    }

    public List<DynamicObject> pkgFetchPriceParams(List<Map<String, Object>> collectParams, long ruleId, Set<Long> keyIds, Set<Long> purMatIds) {
        ArrayList<DynamicObject> purPricesDOList = new ArrayList<DynamicObject>(collectParams.size());
        HashSet<Long> supplierIds = new HashSet<Long>(16);
        for (Map<String, Object> collectParam : collectParams) {
            if (collectParam.get("entry") == null) continue;
            List supplierEntrys = (List)collectParam.get("entry");
            for (Map supplierEntry : supplierEntrys) {
                Long supplierId = (Long)supplierEntry.get("supplierId");
                supplierIds.add(supplierId);
            }
        }
        Map supplierDOMap = BusinessDataServiceHelper.loadFromCache((Object[])supplierIds.toArray(), (String)"bd_supplier");
        DynamicObject rule = BusinessDataServiceHelper.loadSingle((Object)ruleId, (String)"cad_calcrule");
        HashMap<Long, Set> matToAuxpty = new HashMap<Long, Set>(16);
        QFilter materialQF = new QFilter("material.isuseauxpty", "=", (Object)"1");
        materialQF.and("material.auxptyentry.isaffectprice", "=", (Object)"1");
        DynamicObjectCollection cadPurprices = QueryServiceHelper.query((String)"cad_purprices", (String)"material,auxpty", (QFilter[])materialQF.toArray());
        for (DynamicObject cadPurprice : cadPurprices) {
            matToAuxpty.computeIfAbsent(cadPurprice.getLong("material"), v -> new HashSet(8)).add(cadPurprice.getLong("auxpty"));
        }
        for (Map<String, Object> collectParam : collectParams) {
            long id = (Long)collectParam.get("materialId");
            DynamicObject cadPurpricesDO = this.buildFetchPriceParam(keyIds, supplierDOMap, rule, collectParam, id, 0L);
            purPricesDOList.add(cadPurpricesDO);
            for (Long auxpty : (Set)matToAuxpty.get(id)) {
                DynamicObject purpricesDO = this.buildFetchPriceParam(keyIds, supplierDOMap, rule, collectParam, id, auxpty);
                purPricesDOList.add(purpricesDO);
            }
        }
        return purPricesDOList;
    }

    public DynamicObject buildFetchPriceParam(Set<Long> keyIds, Map<Object, DynamicObject> supplierDOMap, DynamicObject rule, Map<String, Object> collectParam, long id, long auxptyId) {
        DynamicObject cadPurpricesDO = BusinessDataServiceHelper.newDynamicObject((String)this.billIden);
        while (!keyIds.add(id)) {
            ++id;
        }
        cadPurpricesDO.set("id", (Object)id);
        cadPurpricesDO.set("material", collectParam.get("materialId"));
        cadPurpricesDO.set("pricerule", (Object)rule);
        cadPurpricesDO.set("createtime", (Object)new Date());
        cadPurpricesDO.set("auxpty", (Object)auxptyId);
        DynamicObjectCollection pursupentrys = cadPurpricesDO.getDynamicObjectCollection(this.billEntryIden);
        List supplierEntrys = (List)collectParam.get("entry");
        for (Map supplierEntry : supplierEntrys) {
            Long supplierId = (Long)supplierEntry.get("supplierId");
            DynamicObject pursupentry = pursupentrys.addNew();
            pursupentry.set("id", (Object)supplierId);
            pursupentry.set("supplier", (Object)supplierDOMap.get(supplierId));
            pursupentry.set("quotaratio", supplierEntry.get("quotaRate"));
        }
        return cadPurpricesDO;
    }

    public abstract void initPricePluginPojo(PricePluginPojo var1);

    public void pkgResultData(List<PricePluginPojo> res, long currency, List<DynamicObject> purPricesDOList, Map<String, Object> featchPriceMap, Map<String, BigDecimal> matToManuPrice, long ruleId) {
        this.logger.info("purPricesDOList size:{},featchPriceMap size:{}", (Object)purPricesDOList.size(), (Object)featchPriceMap.size());
        for (DynamicObject purPrices : purPricesDOList) {
            Supplier supplier;
            PricePluginPojo pricePluginPojo = new PricePluginPojo();
            pricePluginPojo.setCurrency(currency);
            pricePluginPojo.setMaterialId(purPrices.getLong("material"));
            pricePluginPojo.setAuxptyId(0L);
            if (this.routeInfoMap != null && !this.routeInfoMap.containsKey(pricePluginPojo.getMaterialId())) continue;
            this.initPricePluginPojo(pricePluginPojo);
            BigDecimal amount = BigDecimal.ZERO;
            BigDecimal entrySum = BigDecimal.ZERO;
            DynamicObjectCollection pursupentry = purPrices.getDynamicObjectCollection(this.billEntryIden);
            String splitChar = "$$";
            ArrayList<Supplier> supplierList = new ArrayList<Supplier>();
            if (pursupentry.isEmpty()) {
                String keyId = this.jointKeyNoEnd(splitChar, purPrices.getString("id"), "0", "0");
                BigDecimal bigDecimal = amount = featchPriceMap.get((String)keyId + "unitprice") == null ? BigDecimal.ZERO : (BigDecimal)featchPriceMap.get((String)keyId + "unitprice");
                if (amount.compareTo(BigDecimal.ZERO) == 0) {
                    String key = this.jointKeyNoEnd(splitChar, purPrices.getString("id"));
                    amount = featchPriceMap.get(key + "unitprice") == null ? BigDecimal.ZERO : (BigDecimal)featchPriceMap.get(key + "unitprice");
                }
                amount = this.transformRate(currency, featchPriceMap, keyId, amount);
                Long supplierId = (Long)featchPriceMap.get((String)keyId + "supplier");
                if (supplierId == null || amount.compareTo(BigDecimal.ZERO) == 0) continue;
                supplier = new Supplier();
                supplier.setSupplierId(supplierId.longValue());
                supplier.setQuoaratio(new BigDecimal(100));
                entrySum = new BigDecimal(100);
                supplier.setUnitPrice(amount.setScale(this.priceprecision, RoundingMode.HALF_UP));
                supplier.setManualPrice(false);
                supplierList.add(supplier);
            } else {
                for (DynamicObject entry : pursupentry) {
                    String key = this.jointKeyNoEnd(splitChar, purPrices.getString("id"), entry.getString("id"), entry.getString("seq"));
                    BigDecimal unitPrice = featchPriceMap.get(key + "unitprice") == null ? BigDecimal.ZERO : (BigDecimal)featchPriceMap.get(key + "unitprice");
                    unitPrice = this.transformRate(currency, featchPriceMap, key, unitPrice);
                    boolean manualPrice = false;
                    if (unitPrice.compareTo(BigDecimal.ZERO) == 0 && this.isManualspecified) {
                        unitPrice = matToManuPrice.get(purPrices.getString("material"));
                        manualPrice = true;
                    }
                    if (unitPrice == null || unitPrice.compareTo(BigDecimal.ZERO) == 0) continue;
                    entrySum = entrySum.add(entry.getBigDecimal("quotaratio"));
                    Supplier supplier2 = new Supplier();
                    supplier2.setSupplierId(entry.getDynamicObject("supplier").getLong("id"));
                    supplier2.setQuoaratio(entry.getBigDecimal("quotaratio"));
                    supplier2.setUnitPrice(unitPrice.setScale(this.priceprecision, RoundingMode.HALF_UP));
                    supplier2.setManualPrice(manualPrice);
                    supplierList.add(supplier2);
                }
            }
            if (this.isQuota) {
                Object quoaratioAdd = BigDecimal.ZERO;
                for (int i = 0; i < supplierList.size(); ++i) {
                    supplier = (Supplier)supplierList.get(i);
                    BigDecimal quoaratio = supplier.getQuoaratio();
                    if (i == supplierList.size() - 1) {
                        supplier.setQuoaratio(new BigDecimal(100).subtract((BigDecimal)quoaratioAdd));
                        continue;
                    }
                    BigDecimal num = new BigDecimal(100).divide(entrySum, 2, RoundingMode.HALF_UP);
                    BigDecimal multiply = quoaratio.multiply(num);
                    quoaratioAdd = ((BigDecimal)quoaratioAdd).add(quoaratio.multiply(num));
                    supplier.setQuoaratio(multiply);
                }
            }
            pricePluginPojo.setSuppliers(supplierList);
            amount = BigDecimal.ZERO;
            if (!pricePluginPojo.getSuppliers().isEmpty()) {
                for (Supplier supplier3 : pricePluginPojo.getSuppliers()) {
                    BigDecimal amountFactor = supplier3.getUnitPrice().multiply(supplier3.getQuoaratio()).divide(new BigDecimal(100), 10, RoundingMode.HALF_UP);
                    amount = amount.add(amountFactor);
                }
            }
            if (amount.compareTo(BigDecimal.ZERO) == 0) continue;
            pricePluginPojo.setAmount(amount.setScale(this.priceprecision, RoundingMode.HALF_UP));
            if ("cad_resourceout".equals(this.billIden)) {
                Set<String> routeInfos = this.routeInfoMap.get(pricePluginPojo.getMaterialId());
                for (String routeInfo : routeInfos) {
                    PricePluginPojo newPricePluginPojo = pricePluginPojo.copy();
                    String[] split = routeInfo.split("@");
                    newPricePluginPojo.setManuOrgId(Long.parseLong(split[0]));
                    newPricePluginPojo.setRouteId(Long.parseLong(split[1]));
                    newPricePluginPojo.setProcessSeq(split[2]);
                    newPricePluginPojo.setOperationNo(split[3]);
                    newPricePluginPojo.setOperation(Long.parseLong(split[4]));
                    newPricePluginPojo.setOperationDesc(split[5]);
                    newPricePluginPojo.setWorkStation(Long.parseLong(split[6]));
                    newPricePluginPojo.setPdmRouteId(Long.parseLong(split[7]));
                    newPricePluginPojo.setSrcRoute(split[8]);
                    res.add(newPricePluginPojo);
                }
                continue;
            }
            res.add(pricePluginPojo);
        }
    }

    public BigDecimal transformRate(long currency, Map<String, Object> fetchPriceMap, String key, BigDecimal unitPrice) {
        Long featchCurrency;
        if (!fetchPriceMap.containsKey(key + "currency")) {
            key = key.substring(0, key.indexOf("$$") + 2);
        }
        if ((featchCurrency = (Long)fetchPriceMap.get(key + "currency")) != null && featchCurrency != currency && this.exrateTable > 0L) {
            BigDecimal rate = BaseDataServiceHelper.getExchangeRate((Long)this.exrateTable, (Long)featchCurrency, (Long)currency, (Date)new Date());
            unitPrice = unitPrice.multiply(rate);
        }
        return unitPrice;
    }

    public BigDecimal transformRate(Long currency, Row row, BigDecimal amount) {
        if (!row.getLong("settlecurrency").equals(currency) && this.exrateTable > 0L) {
            BigDecimal rate = BaseDataServiceHelper.getExchangeRate((Long)this.exrateTable, (Long)row.getLong("settlecurrency"), (Long)currency, (Date)new Date());
            if (rate == null) {
                DynamicObject rule = QueryServiceHelper.queryOne((String)"cad_calcrule", (String)"id,name", (QFilter[])new QFilter("id", "=", (Object)this.ruleId).toArray());
                DynamicObjectCollection currencies = QueryServiceHelper.query((String)"bd_currency", (String)"id,name", (QFilter[])new QFilter("id", "in", Arrays.asList(row.getLong("settlecurrency"), currency)).toArray());
                Map<Long, String> currencyMap = currencies.stream().collect(Collectors.toMap(x -> x.getLong("id"), y -> y.getString("name")));
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u3010%1$s\u3011\u53d6\u4ef7\u5931\u8d25\u3002\u68c0\u6d4b\u5230\u539f\u5e01\u3010%2$s\u3011\u4e0e\u76ee\u6807\u5e01\u3010%3$s\u3011\u4e4b\u95f4\u672a\u7ef4\u62a4\u6c47\u7387\uff0c\u8bf7\u5148\u7ef4\u62a4\u6c47\u7387\uff0c\u518d\u8fdb\u884c\u53d6\u4ef7\u64cd\u4f5c\u3002", (String)"AbstractPurchasePrice_7", (String)"macc-cad-business", (Object[])new Object[0]), rule.getString("name"), currencyMap.get(row.getLong("settlecurrency")), currencyMap.get(currency)));
            }
            amount = amount.multiply(rate).setScale(this.priceprecision, 4);
        }
        return amount.setScale(this.priceprecision, 4);
    }

    public String jointKeyNoEnd(String separate, String ... strs) {
        StringBuilder sb = new StringBuilder();
        for (String str : strs) {
            sb.append(str).append(separate);
        }
        return sb.toString();
    }

    public String jointKey(StringBuilder sb, String separate, String ... strs) {
        for (int i = 0; i < strs.length; ++i) {
            if (i + 1 != strs.length) {
                sb.append(strs[i]).append(separate);
                continue;
            }
            sb.append(strs[i]);
        }
        String s = sb.toString();
        sb.setLength(0);
        return s;
    }

    protected DataSet purOrderMsgByRules(long purOrgId, long ruleId, Set<Long> materials) {
        DynamicObject rule = QueryServiceHelper.queryOne((String)"cad_calcrule", (String)"isrelatedtransaction,quoteday,source,source.resourceunit.id sourceunit", (QFilter[])new QFilter("id", "=", (Object)ruleId).toArray());
        this.sourceId = rule.getLong("source");
        this.isrelatedtransaction = rule.getBoolean("isrelatedtransaction");
        QFilter supplierFilter = this.getSupplierFilter(this.isrelatedtransaction);
        QFilter purorgFilter = new QFilter("org", "=", (Object)purOrgId);
        if (!this.purOrgIds.isEmpty()) {
            purorgFilter = purorgFilter.or("org", "in", this.purOrgIds);
        }
        int dayNum = rule.getInt("quoteday");
        QFilter beginFilter = new QFilter("biztime", ">=", (Object)DateUtils.getPreSeveralBeginDay((Date)TimeServiceHelper.now(), (int)dayNum));
        QFilter endFilter = new QFilter("biztime", "<", (Object)DateUtils.getPreSeveralBeginDay((Date)TimeServiceHelper.now(), (int)-1));
        QFilter billStatusFilter = new QFilter("billstatus", "=", (Object)"C");
        QFilter matFilter = new QFilter("billentry.material.masterid", "in", materials);
        DataSet purOrders = QueryServiceHelper.queryDataSet((String)"AbstractPurchasePrice#purOrderMsgByRules", (String)"pm_purorderbill", (String)"billno,org purorg_order,supplier,settlecurrency,billentry.material.masterid material,billentry.materialversion matversion,billentry.auxpty auxpty,billentry.baseqty qty,billentry.baseunit baseunit,billentry.price price,billentry.amount amount", (QFilter[])new QFilter[]{purorgFilter, matFilter, beginFilter, endFilter, billStatusFilter, supplierFilter}, null);
        purOrders = purOrders.groupBy(new String[]{"supplier", "material", "auxpty", "settlecurrency"}).sum("qty").sum("amount").finish();
        purOrders = purOrders.select("supplier,material,auxpty,settlecurrency,qty,amount,case when qty!=0 then amount/qty else 0 end price");
        return purOrders.orderBy(new String[]{"material", "auxpty", "supplier"});
    }

    protected DataSet purContractMsgByRules(long purOrgId, long ruleId, Set<Long> materials) {
        DynamicObject rule = QueryServiceHelper.queryOne((String)"cad_calcrule", (String)"isrelatedtransaction,quoteday,source,source.resourceunit.id sourceunit", (QFilter[])new QFilter("id", "=", (Object)ruleId).toArray());
        this.sourceId = rule.getLong("source");
        this.isrelatedtransaction = rule.getBoolean("isrelatedtransaction");
        QFilter supplierFilter = this.getSupplierFilter(this.isrelatedtransaction);
        QFilter purorgFilter = new QFilter("org", "=", (Object)purOrgId);
        if (!this.purOrgIds.isEmpty()) {
            purorgFilter = purorgFilter.or("org", "in", this.purOrgIds);
        }
        int dayNum = rule.getInt("quoteday");
        QFilter beginTimeFilter = new QFilter("biztimebegin", "<", (Object)DateUtils.getPreSeveralBeginDay((Date)TimeServiceHelper.now(), (int)-1));
        QFilter endTimeFilter = new QFilter("biztimeend", ">=", (Object)DateUtils.getPreSeveralBeginDay((Date)TimeServiceHelper.now(), (int)dayNum));
        QFilter billStatusFilter = new QFilter("billstatus", "=", (Object)"C");
        billStatusFilter.and("validstatus", "=", (Object)"B");
        billStatusFilter.and("closestatus", "=", (Object)"A");
        billStatusFilter.and("changestatus", "!=", (Object)"B");
        billStatusFilter.and("freezestatus", "=", (Object)"A");
        billStatusFilter.and("terminatestatus", "=", (Object)"A");
        QFilter purQFilter = new QFilter("enable", "=", (Object)"1");
        purQFilter.and("status", "=", (Object)"C");
        purQFilter.and("entryentity.supplyrank", "=", (Object)1);
        purQFilter.and("entryentity.effectdate", "<", (Object)DateUtils.getPreSeveralBeginDay((Date)TimeServiceHelper.now(), (int)-1));
        purQFilter.and("entryentity.expirydate", ">=", (Object)DateUtils.getPreSeveralBeginDay((Date)TimeServiceHelper.now(), (int)dayNum));
        DataSet purquotaDs = QueryServiceHelper.queryDataSet((String)"getpurquota", (String)"pm_purquota", (String)"entryentity.material.masterid material,entryentity.supplier supplier,entryentity.quotarate quotarate", (QFilter[])new QFilter[]{purorgFilter, purQFilter}, null);
        HashSet filterMaterials = new HashSet(16);
        HashSet filterSupplier = new HashSet(16);
        purquotaDs.copy().forEach(s -> {
            filterMaterials.add(s.getLong("material"));
            filterSupplier.add(s.getLong("supplier"));
        });
        materials.retainAll(filterMaterials);
        QFilter matFilter = new QFilter("billentry.material.masterid", "in", materials);
        supplierFilter.and("supplier", "in", filterSupplier);
        DataSet purContracts = QueryServiceHelper.queryDataSet((String)"mm", (String)"conm_purcontract", (String)"org purorg_con,supplier,settlecurrency,billentry.material.masterid material,billentry.auxpty auxpty,billentry.baseqty qty,billentry.amount amount,biztimebegin", (QFilter[])new QFilter[]{purorgFilter, matFilter, beginTimeFilter, endTimeFilter, billStatusFilter, supplierFilter}, (String)"biztimebegin DESC");
        purContracts = purContracts.groupBy(new String[]{"supplier", "material", "auxpty", "settlecurrency"}).sum("qty").sum("amount").finish();
        purContracts = purContracts.select("supplier,material,auxpty,settlecurrency,qty,amount,case when qty!=0 then amount/qty else 0 end price");
        purContracts = purContracts.join(purquotaDs, JoinType.LEFT).on("material", "material").on("supplier", "supplier").select(purContracts.getRowMeta().getFieldNames(), new String[]{"quotarate"}).finish();
        return purContracts.orderBy(new String[]{"material", "auxpty", "supplier"});
    }

    private QFilter getSupplierFilter(Boolean isrelatedtransaction) {
        if (isrelatedtransaction.booleanValue()) {
            return new QFilter("supplier", "!=", (Object)-1L);
        }
        this.relatedSupplierIds = this.getRelatedSupplierIds();
        return new QFilter("supplier", "in", this.relatedSupplierIds);
    }

    private Set<Long> getRelatedSupplierIds() {
        DynamicObjectCollection suppliers = QueryServiceHelper.query((String)"bd_supplier", (String)"id,internal_company", (QFilter[])new QFilter[]{new QFilter("internal_company", "=", (Object)0L)});
        return DynamicObjectHelper.getIdSet((DynamicObjectCollection)suppliers, (String)"id");
    }

    protected Boolean isStartBomRule(Long costTypeId) {
        QFilter filter = new QFilter("costtype", "=", (Object)costTypeId);
        filter.or(new QFilter("costtype", "=", (Object)0L));
        QFilter enableFilter = new QFilter("enable", "=", (Object)true);
        return QueryServiceHelper.exists((String)"cad_bomrulesetting", (QFilter[])new QFilter[]{filter, enableFilter});
    }

    protected Boolean isStartRouteRule(Long costTypeId) {
        QFilter filter = new QFilter("costtype", "=", (Object)costTypeId);
        filter.or(new QFilter("costtype", "=", (Object)0L));
        QFilter enableFilter = new QFilter("enable", "=", (Object)true);
        return QueryServiceHelper.exists((String)"cad_routerulesetting", (QFilter[])new QFilter[]{filter, enableFilter});
    }

    protected List<Long> getInvOrgIds(Long org, List<Long> costTypes) {
        List<Long> invOrgIds = null;
        if (!CadEmptyUtils.isEmpty(costTypes)) {
            Date date = new Date();
            QFilter filter = new QFilter("bizstatus", "=", (Object)"1");
            filter.and("effectdate", "<=", (Object)date);
            filter.and("invaliddate", ">", (Object)date);
            filter.and("costtype", "in", costTypes);
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"cal_bd_costtypeorg", (String)"calorg,storageorgunit", (QFilter[])new QFilter[]{filter});
            invOrgIds = new ArrayList(10);
            for (DynamicObject dynamicObject : dynamicObjects) {
                long invOrg = dynamicObject.getLong("storageorgunit");
                if (CadEmptyUtils.isEmpty((Long)invOrg)) continue;
                invOrgIds.add(invOrg);
            }
            if (CadEmptyUtils.isEmpty(invOrgIds)) {
                invOrgIds = ImportServiceHelper.getUserHasPermOrgs((Long)org, (String)"05");
            }
        } else {
            invOrgIds = ImportServiceHelper.getUserHasPermOrgs((Long)org, (String)"05");
        }
        return invOrgIds;
    }

    public Map<Long, Long> getEleDefaultSubEleMap(Long element, Long defaultSubElement) {
        HashMap<Long, Long> eleDefaultSubEleMap = new HashMap<Long, Long>(16);
        QFilter defSubEleQf = new QFilter("element", "=", (Object)element);
        defSubEleQf.and(new QFilter("subelement.defaultvalue", "=", (Object)true));
        DynamicObject subEleRel = QueryServiceHelper.queryOne((String)"cad_elementdetail", (String)"element, subelement", (QFilter[])new QFilter[]{defSubEleQf});
        if (subEleRel == null) {
            eleDefaultSubEleMap.put(element, defaultSubElement);
        } else {
            eleDefaultSubEleMap.put(subEleRel.getLong("element"), subEleRel.getLong("subelement"));
        }
        return eleDefaultSubEleMap;
    }

    protected Map<Long, Set<String>> getRouteInfoMap(Long orgId, Long costTypeId, List<Long> proOrgIds, Set<Long> materials) {
        Long srcrouteid;
        Long workstation;
        String operationDesc;
        Long operation;
        String operationNo;
        String processSeq;
        Long route;
        Long manuorg;
        Long auxproperty;
        Long material;
        Row row;
        HashMap<Long, Set<String>> routeInfoMap = new HashMap<Long, Set<String>>(16);
        String srcRoute = PriceHelper.getPriceRouteEntity((Long)costTypeId);
        Boolean startRouteRule = this.isStartRouteRule(costTypeId);
        List<Long> routeIds = this.getRouteIds(srcRoute, orgId, costTypeId, proOrgIds, materials, startRouteRule);
        DataSet wxRouteDataSet = BomRuleSettingStdCalcHelper.getWxRouteDataSet((String)srcRoute, routeIds);
        DataSet copyWwDataSet = wxRouteDataSet.copy();
        copyWwDataSet = copyWwDataSet.groupBy(new String[]{"id"}).count("processentryid").finish();
        copyWwDataSet = copyWwDataSet.filter("processentryid=1");
        ArrayList<Long> ids = new ArrayList<Long>(10);
        while (copyWwDataSet.hasNext()) {
            Row row2 = copyWwDataSet.next();
            ids.add(row2.getLong("id"));
        }
        if (CadEmptyUtils.isEmpty(ids)) {
            return routeInfoMap;
        }
        wxRouteDataSet = wxRouteDataSet.filter("id in (" + StringUtils.join((Object[])ids.toArray(new Long[0]), (String)",") + ")");
        DataSet matWxRouteDataSet = wxRouteDataSet.filter("processtype='A'");
        DataSet matGroupWxRouteDataSet = wxRouteDataSet.filter("processtype='B'");
        while (matWxRouteDataSet.hasNext()) {
            row = matWxRouteDataSet.next();
            material = row.getLong("material");
            auxproperty = row.getLong("auxproperty");
            manuorg = row.getLong("manuorg");
            route = row.getLong("id");
            processSeq = row.getString("processseq");
            operationNo = row.getString("operationno");
            operation = row.getLong("operation");
            operationDesc = row.getString("operationdesc");
            workstation = row.getLong("workstation");
            srcrouteid = row.getLong("sourceid");
            routeInfoMap.computeIfAbsent(material, p -> new HashSet()).add(manuorg + "@" + route + "@" + processSeq + "@" + operationNo + "@" + operation + "@" + operationDesc + "@" + workstation + "@" + srcrouteid + "@" + srcRoute);
        }
        if (startRouteRule.booleanValue()) {
            DataSet copyMatGroupWxRouteDataSet = matGroupWxRouteDataSet.copy();
            ArrayList<Long> matGroupIds = new ArrayList<Long>(10);
            while (copyMatGroupWxRouteDataSet.hasNext()) {
                Row row3 = copyMatGroupWxRouteDataSet.next();
                matGroupIds.add(row3.getLong("materialgroup"));
            }
            QFilter mftFilter = new QFilter("mftcontrolentry.materialcontrol.id", "in", matGroupIds);
            QFilter status = new QFilter("status", "=", (Object)"C");
            QFilter enable = new QFilter("enable", "=", (Object)"1");
            DataSet materialMftInfoDataSet = QueryServiceHelper.queryDataSet((String)"getRouteInfoMap", (String)"bd_materialmftinfo", (String)"masterid,0L auxpty,mftcontrolentry.materialcontrol materialcontrol", (QFilter[])new QFilter[]{mftFilter, status, enable}, null);
            matGroupWxRouteDataSet = matGroupWxRouteDataSet.join(materialMftInfoDataSet, JoinType.INNER).on("materialgroup", "materialcontrol").select(matGroupWxRouteDataSet.getRowMeta().getFieldNames(), new String[]{"masterid", "auxpty"}).finish();
        } else {
            QFilter filter = new QFilter("costtype", "=", (Object)costTypeId);
            filter.and(new QFilter("route", "in", routeIds));
            filter.and(new QFilter("routertype", "=", (Object)"B"));
            filter.and("status", "=", (Object)"C");
            filter.and("enable", "=", (Object)"1");
            DataSet processRouteDataSet = QueryServiceHelper.queryDataSet((String)"getRouteInfoMap", (String)"cad_routersetting", (String)"materialentry.material masterid,materialentry.auxpty auxpty,router", (QFilter[])new QFilter[]{filter}, null);
            matGroupWxRouteDataSet = matGroupWxRouteDataSet.join(processRouteDataSet, JoinType.INNER).on("id", "router").select(matGroupWxRouteDataSet.getRowMeta().getFieldNames(), new String[]{"masterid", "auxpty"}).finish();
        }
        while (matGroupWxRouteDataSet.hasNext()) {
            row = matGroupWxRouteDataSet.next();
            material = row.getLong("masterid");
            auxproperty = row.getLong("auxpty");
            manuorg = row.getLong("manuorg");
            route = row.getLong("id");
            processSeq = row.getString("processseq");
            operationNo = row.getString("operationno");
            operation = row.getLong("operation");
            operationDesc = row.getString("operationdesc");
            workstation = row.getLong("workstation");
            srcrouteid = row.getLong("sourceid");
            routeInfoMap.computeIfAbsent(material, p -> new HashSet()).add(manuorg + "@" + route + "@" + processSeq + "@" + operationNo + "@" + operation + "@" + operationDesc + "@" + workstation + "@" + srcrouteid + "@" + srcRoute);
        }
        return routeInfoMap;
    }

    private List<Long> getRouteIds(String srcRoute, Long orgId, Long costTypeId, List<Long> proOrgIds, Set<Long> materials, boolean startRouteRule) {
        ArrayList<Long> routeIds = new ArrayList<Long>(10);
        if (startRouteRule) {
            ArrayList<QFilter> filterList = new ArrayList<QFilter>(10);
            if ("cad_router".equals(srcRoute)) {
                filterList.add(MatBaseDataFilterHelper.getOrgCtrlQfilter(Collections.singletonList(orgId), (String)srcRoute));
            } else {
                filterList.add(MatBaseDataFilterHelper.getOrgCtrlQfilter(proOrgIds, (String)srcRoute));
            }
            QFilter matFilter = new QFilter("material", "in", materials);
            matFilter.or(new QFilter("processtype", "=", (Object)"B"));
            filterList.add(matFilter);
            filterList.add(new QFilter("enable", "=", (Object)"1"));
            filterList.add(new QFilter("status", "=", (Object)"C"));
            filterList.add(new QFilter("processentry.machiningtype", "in", (Object)new String[]{"1002", "1003"}));
            if ("cad_router".equals(srcRoute)) {
                DataSet routeDataSet = QueryServiceHelper.queryDataSet((String)"getRouteIds", (String)srcRoute, (String)"id,manuorg,number,material,processtype,sourceid,synctime,audittime", (QFilter[])filterList.toArray(new QFilter[0]), null);
                routeDataSet = routeDataSet.distinct();
                DataSet syncDataSet = routeDataSet.filter("sourceid>0");
                DataSet newDataSet = routeDataSet.filter("sourceid<=0");
                syncDataSet = syncDataSet.groupBy(new String[]{"sourceid"}).maxP("audittime", "id").finish();
                newDataSet = newDataSet.groupBy(new String[]{"manuorg", "number", "material", "processtype", "sourceid"}).maxP("audittime", "id").finish().select("sourceid,id");
                DataSet dataSet = syncDataSet.union(newDataSet);
                while (dataSet.hasNext()) {
                    Row row = dataSet.next();
                    if (row == null) continue;
                    routeIds.add(row.getLong("id"));
                }
            } else {
                DataSet routeDataSet = QueryServiceHelper.queryDataSet((String)"getRouteIds", (String)srcRoute, (String)"id", (QFilter[])filterList.toArray(new QFilter[0]), null);
                routeDataSet = routeDataSet.distinct();
                while (routeDataSet.hasNext()) {
                    Row row = routeDataSet.next();
                    if (row == null) continue;
                    routeIds.add(row.getLong("id"));
                }
            }
        } else {
            QFilter filter = new QFilter("costtype", "=", (Object)costTypeId);
            filter.and("status", "=", (Object)"C");
            filter.and("enable", "=", (Object)"1");
            QFilter matFilter = new QFilter("materialentry.material", "in", materials);
            matFilter.or(new QFilter("routertype", "=", (Object)"B"));
            DynamicObjectCollection processRoutes = QueryServiceHelper.query((String)"cad_routersetting", (String)"router", (QFilter[])new QFilter[]{filter, matFilter}, null);
            routeIds.addAll(DynamicObjectHelper.getIdList((DynamicObjectCollection)processRoutes, (String)"router"));
        }
        return routeIds;
    }
}

